;read array byte 
iram12_aread:	push	YH
		push	YL
		ldi	YL,0x00
		ldi	YH,0x11
		lds	XH,0x10FF		;page
		cpi	XH,0x30
		brcc	iram12_areadff
		add	YL,tempreg1
		adc	YH,XH
		ld	XL,Y
		pop	YL
		pop	YH
		ldi	XH,0xff
		ret

iram12_areadff:	ldi	XL,0xff
		ldi	XH,0xff
		pop	YL
		pop	YH
		ret

iram12_awrite:	push	YH
		push	YL
		push	XH
		ldi	YL,0x00
		ldi	YH,0x11
		lds	XH,0x10FF		;page
		cpi	XH,0x30
		brcc	iram12_awrite0
		add	YL,tempreg1
		adc	YH,XH
		st	Y,XL
iram12_awrite0:	pop	XH
		pop	YL
		pop	YH
		ret

;read data byte (X+)->r18
iram12_rbyte:	ldi	r18,0xff		;default for no mem
		cpi	XH,0x30			;max 12K
		brcc	iram12_rbyte_1		;read above 0xff
		push	YL
		push	YH
		ldi	YL,0x00
		ldi	YH,0x11
		add	YL,XL
		adc	YH,XH
		ld	r18,Y
		pop	YH
		pop	YL
iram12_rbyte_1:	adiw	XL,1			;inc ptr
		ret

;read data word (X)->r19/r18
iram12_rword:	ldi	r18,0xff		;default for no mem
		ldi	r19,0xff
		cpi	XH,0x30			;max 12K
		brcc	iram12_rword_1		;read above 0xff
		push	YL
		push	YH
		ldi	YL,0x00
		ldi	YH,0x11
		add	YL,XL
		adc	YH,XH
		ld	r18,Y
		pop	YH
		pop	YL
iram12_rword_1:	adiw	XL,1			;inc ptr
		cpi	XH,0x30			;max 12K
		brcc	iram12_rword_2		;read above 0xff
		push	YL
		push	YH
		ldi	YL,0x00
		ldi	YH,0x11
		add	YL,XL
		adc	YH,XH
		ld	r19,Y
		pop	YH
		pop	YL
iram12_rword_2:	adiw	XL,1			;inc ptr
		ret

;write data byte r18->(X+)
iram12_wbyte:	cpi	XH,0x30			;max 12K
		brcc	iram12_wbyte_1		;read above 0xff
		push	YL
		push	YH
		ldi	YL,0x00
		ldi	YH,0x11
		add	YL,XL
		adc	YH,XH
		st	Y,r18
		pop	YH
		pop	YL
iram12_wbyte_1:	adiw	XL,1			;inc ptr
		ret

;write data word r19/r18->(X+)
iram12_wword:	cpi	XH,0x30			;max 12K
		brcc	iram12_wword_1		;read above 0xff
		push	YL
		push	YH
		ldi	YL,0x00
		ldi	YH,0x11
		add	YL,XL
		adc	YH,XH
		st	Y,r18
		pop	YH
		pop	YL
iram12_wword_1:	adiw	XL,1			;inc ptr
		cpi	XH,0x30			;max 12K
		brcc	iram12_wword_2		;read above 0xff
		push	YL
		push	YH
		ldi	YL,0x00
		ldi	YH,0x11
		add	YL,XL
		adc	YH,XH
		st	Y,r19
		pop	YH
		pop	YL
iram12_wword_2:	adiw	XL,1			;inc ptr
		ret

;get last valid xmem address to X
iram12_check:	ldi	XL,0xff			; 12K useable
		ldi	XH,0x2f
		ret

iram12_clear:	ldi	XL,0			; we start at address 0
		ldi	XH,0
		ldi	r18,0
iram12_clear_1:	rcall	iram12_wbyte
		adiw	XL,1
		cpi	XH,0x30
		brne	iram12_clear_1
		ret


