;read array byte 
iram2_aread:	push	YH
		push	YL
		ldi	YL,0x3c
		ldi	YH,0x07
		lds	XH,0x10FF		;page
		cpi	XH,0x08
		brcc	iram2_areadff
		add	YL,tempreg1
		adc	YH,XH
		ld	XL,Y
		pop	YL
		pop	YH
		ldi	XH,0xff
		ret

iram2_areadff:	ldi	XL,0xff
		ldi	XH,0xff
		pop	YL
		pop	YH
		ret

iram2_awrite:	push	YH
		push	YL
		push	XH
		ldi	YL,0x3c
		ldi	YH,0x07
		lds	XH,0x10FF		;page
		cpi	XH,0x08
		brcc	iram2_awrite0
		add	YL,tempreg1
		adc	YH,XH
		st	Y,XL
iram2_awrite0:	pop	XH
		pop	YL
		pop	YH
		ret

;read data byte (X+)->r18
iram2_rbyte:	ldi	r18,0xff		;default for no mem
		cpi	XH,0x08			;max 2K
		brcc	iram2_rbyte_1		;read above 0xff
		push	YL
		push	YH
		ldi	YL,0x3c
		ldi	YH,0x07
		add	YL,XL
		adc	YH,XH
		ld	r18,Y
		pop	YH
		pop	YL
iram2_rbyte_1:	adiw	XL,1			;inc ptr
		ret

;read data word (X)->r19/r18
iram2_rword:	ldi	r18,0xff		;default for no mem
		ldi	r19,0xff
		cpi	XH,0x08			;max 2K
		brcc	iram2_rword_1		;read above 0xff
		push	YL
		push	YH
		ldi	YL,0x3c
		ldi	YH,0x07
		add	YL,XL
		adc	YH,XH
		ld	r18,Y
		pop	YH
		pop	YL
iram2_rword_1:	adiw	XL,1			;inc ptr
		cpi	XH,0x08			;max 2K
		brcc	iram2_rword_2		;read above 0xff
		push	YL
		push	YH
		ldi	YL,0x3c
		ldi	YH,0x07
		add	YL,XL
		adc	YH,XH
		ld	r19,Y
		pop	YH
		pop	YL
iram2_rword_2:	adiw	XL,1			;inc ptr
		ret

;write data byte r18->(X+)
iram2_wbyte:	cpi	XH,0x08			;max 2K
		brcc	iram2_wbyte_1		;read above 0xff
		push	YL
		push	YH
		ldi	YL,0x3c
		ldi	YH,0x07
		add	YL,XL
		adc	YH,XH
		st	Y,r18
		pop	YH
		pop	YL
iram2_wbyte_1:	adiw	XL,1			;inc ptr
		ret

;write data word r19/r18->(X+)
iram2_wword:	cpi	XH,0x08			;max 2K
		brcc	iram2_wword_1		;read above 0xff
		push	YL
		push	YH
		ldi	YL,0x3c
		ldi	YH,0x07
		add	YL,XL
		adc	YH,XH
		st	Y,r18
		pop	YH
		pop	YL
iram2_wword_1:	adiw	XL,1			;inc ptr
		cpi	XH,0x08			;max 2K
		brcc	iram2_wword_2		;read above 0xff
		push	YL
		push	YH
		ldi	YL,0x3c
		ldi	YH,0x07
		add	YL,XL
		adc	YH,XH
		st	Y,r19
		pop	YH
		pop	YL
iram2_wword_2:	adiw	XL,1			;inc ptr
		ret

;get last valid xmem address to X
iram2_check:	ldi	XL,0xff			; 2K useable
		ldi	XH,0x07
		ret

iram2_clear:	ldi	XL,0			; we start at address 0
		ldi	XH,0
		ldi	r18,0
iram2_clear_1:	rcall	iram2_wbyte
		adiw	XL,1
		cpi	XH,0x08
		brne	iram2_clear_1
		ret


