;################################################################################
;#										#
;# mode 7 engine								#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.include	"/usr/local/include/avr/m644Pdef.inc"
.include	"../../system/includes/api_macros.inc"
.include	"../../system/includes/libdef.asm"
.include	"../../system/includes/definitions.asm"

.CSEG
.org	0x7200
;                   "......      N"  
start:		.db " XMEM XRAM64N",0xb3,0xef,0xf1


;icon def
		.db 0xf2,0xf1,0xf1,0xf3
		.db 0xf0,"MX",0xf0
		.db 0xf4,0xf1,0xf1,0xf5

.org	0x720e
		ret				;video, no IO
		ret				;IO ext
		ret				;FKT 00
		rjmp	xram64_aread		;FKT 01 array read [7218]
		rjmp	xram64_awrite		;FKT 02 array write [7219]
		rjmp	xram64_rbyte		;FKT 03 r18=(X+) [721a]
		rjmp	xram64_wbyte		;FKT 04 (X+)=r18 [721b]
		rjmp	xram64_rword		;FKT 05 r18/r19=(X+) [721c]
		rjmp	xram64_wword		;FKT 06 (X+)=r18/r19 [721d]
		rjmp	xram64_check		;FKT 07 X=last memory cell
		rjmp	xram64_clear		;FKT 08 clear memory

.include	"xram64_routines.asm"
