xram64_aread:	out	PORTA,const_1		;read
		cbi	PORTB,1			;strobe = 0, store READ
		lds	YH,0x10FF		;page
		out	PORTA,YH		;out page
		cbi	PORTB,2			;busy = 0, store HADDR
		out	PORTA,tempreg1		;out bytepos as LADDR
		sbi	PORTB,2			;busy = 1, set ADDR
		sbi	PORTB,1			;strobe = 1
		out	DDRA,const_0		;input
		cbi	PORTB,2			;busy = 0, read
		ldi	XH,0xff
		nop
		in	XL,PINA
		sbi	PORTB,2			;busy = 1, inc addr
		out	DDRA,XH			;set to output
		ldi	XH,0x00			;clear XH
		ret

xram64_awrite:	out	PORTA,const_0		;write
		cbi	PORTB,1			;strobe = 0, store READ
		lds	YH,0x10FF		;page
		out	PORTA,YH		;out page
		cbi	PORTB,2			;busy = 0, store HADDR
		out	PORTA,tempreg1		;out bytepos as LADDR
		sbi	PORTB,2			;busy = 1, set ADDR
		sbi	PORTB,1			;strobe = 1
		out	PORTA,XL		;data
		cbi	PORTB,2			;busy = 0, write data
		sbi	PORTB,2			;busy = 1, inc ADDR
		ret

;read data byte (X+)->r18
xram64_rbyte:	out	PORTA,const_1		;read
		cbi	PORTB,1			;strobe = 0, store READ
		out	PORTA,XH		;out HI addr
		cbi	PORTB,2			;busy = 0, store HADDR
		out	PORTA,XL		;out LO addr
		sbi	PORTB,2			;busy = 1, set ADDR
		sbi	PORTB,1			;strobe = 1
		out	DDRA,const_0		;input
		cbi	PORTB,2			;busy = 0, READ
		mov	r0,const_0
		dec	r0
		adiw	XL,1			;inc ptr
		in	r18,PINA
		sbi	PORTB,2			;busy = 1, inc addr
		out	DDRA,r0			;set to output
		ret

;read data word (X)->r19/r18
xram64_rword:	out	PORTA,const_1		;read
		cbi	PORTB,1			;strobe = 0, store READ
		out	PORTA,XH		;out HI addr
		cbi	PORTB,2			;busy = 0, store HADDR
		out	PORTA,XL		;out LO addr
		sbi	PORTB,2			;busy = 1, set ADDR
		sbi	PORTB,1			;strobe = 1
		out	DDRA,const_0		;input
		cbi	PORTB,2			;busy = 0, READ
		adiw	XL,1			;inc ptr
		mov	r0,const_0
		in	r18,PINA		;read low
		sbi	PORTB,2			;busy = 1, inc addr
		cbi	PORTB,2			;busy = 0, READ
		adiw	XL,1			;inc ptr
		dec	r0			;set to 0xff
		in	r19,PINA		;read high
		sbi	PORTB,2			;busy = 1, inc addr
		out	DDRA,r0			;set to output
		ret

;write data byte r18->(X+)
xram64_wbyte:	out	PORTA,const_0		;write
		cbi	PORTB,1			;strobe = 0, store READ
		out	PORTA,XH		;out HI addr
		cbi	PORTB,2			;busy = 0, store HADDR
		out	PORTA,XL		;out LO addr
		sbi	PORTB,2			;busy = 1, set ADDR
		sbi	PORTB,1			;strobe = 1
		out	PORTA,r18		;data
		cbi	PORTB,2			;busy = 0, write data
		adiw	XL,1			;inc ptr
		sbi	PORTB,2			;busy = 1, inc ADDR
		ret

;write data word r19/r18->(X+)
xram64_wword:	out	PORTA,const_0		;write
		cbi	PORTB,1			;strobe = 0, store READ
		out	PORTA,XH		;out HI addr
		cbi	PORTB,2			;busy = 0, store HADDR
		out	PORTA,XL		;out LO addr
		sbi	PORTB,2			;busy = 1, set ADDR
		sbi	PORTB,1			;strobe = 1
		out	PORTA,r18		;LO data
		cbi	PORTB,2			;busy = 0, write data
		adiw	XL,1			;inc ptr
		sbi	PORTB,2			;busy = 1, inc ADDR
		out	PORTA,r19		;HI data
		cbi	PORTB,2			;busy = 0, write data
		adiw	XL,1			;inc ptr
		sbi	PORTB,2			;busy = 1, inc ADDR
		ret

;get last valid xram64 address to X
xram64_check:	ldi	XL,0			; we start at address 0
		ldi	XH,0
xram64_check_1:	ldi	r18,0xa5
		rcall	xram64_wword
		sbiw	XL,1
		rcall	xram64_rword
		cpi	r18,0xa5
		brne	xram64_check_2
		cpi	XH,0
		brne	xram64_check_1
		cpi	XL,0
		brne	xram64_check_1
		sbiw	XL,1			;set to last valid address
		ret

xram64_check_2:	sbiw	XL,1
		breq	xram64_check_3		;return zero if no xram
		sbiw	XL,1			;points to last valid address
xram64_check_3:	ret

xram64_clear:	ldi	XL,0			; we start at address 0
		ldi	XH,0
		ldi	r18,0
xram64_clear_1:	rcall	xram64_wbyte
		adiw	XL,1
		brne	xram64_clear_1
		ret
