;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# cbterm 		 							#
;# copyright (c) 2006-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.CSEG
.include	"/usr/local/include/avr/m644Pdef.inc"
.include	"../../system/includes/api_macros.inc"
.include	"../../system/includes/libdef.asm"
.include	"../../system/includes/definitions.asm"

.org	0x6c00
;                   "......      N"  
start:		.db "CBTerm-mini-N",0xec,0xff,0xff
;icon def
		.db "    "
		.db 0xe3,0x86,0x7f,0xe3
		.db "    "

;dummy data
		.db 0x00,0x00,0x00,0x00

.org	0x6c10

;------------------------------------------------------------------------------
;main screen mask
;------------------------------------------------------------------------------
cbterm_main:	ldi	XL,1
		sts	libmio_channel,const_0	;output to screen
		sts	libmio_vidmode,const_0	;standard video mode
		ldi	XL,0x07			;color scheme (white on black)
		api_setcolor
		ldi	YL,0			;maximal sized box
		ldi	YH,0
		ldi	ZL,29
		ldi	ZH,21
		api_whbox
		ldi	XL,0x71			;color scheme (cyan on black)
		api_setcolor
cbterm_main_1:	api_thistext
		.db 1,2,"CBTerm mini V0.10",0
		ldi	XL,LOW(cbterm_mbar-start)
		ldi	XH,HIGH(cbterm_mbar-start)
		api_dataptr
		clt				;read menu from flash
		api_drawmenu
		rcall	cbterm_nmode
		rcall	cbterm_cursor
		ldi	tempreg1,0xff
		sts	libmio_rcnt,tempreg1
		rjmp	cbterm_mloop

;------------------------------------------------------------------------------
;show mode
;------------------------------------------------------------------------------
cbterm_nmode:	ldi	XL,0x70			;color scheme (black on white)
		api_setcolor
		api_thistext
		.db 1,20,"-normal-",0,0
		rjmp	cbterm_cls

cbterm_dmode:	ldi	XL,0x72			;color scheme (red on white)
		api_setcolor
		api_thistext
		.db 1,20,"-dialog-",0,0
		rjmp	cbterm_cls

;------------------------------------------------------------------------------
;the main loop
;------------------------------------------------------------------------------
cbterm_mloop:	lds	tempreg1,libmio_keycode
		cpi	tempreg1,0x00		;no key
		breq	cbterm_mloop_1
		api_screenshot
		rcall	cbterm_cser		;check serial
		rjmp	cbterm_mloop

cbterm_mloop_1:	api_screenshot
		rcall	cbterm_cser		;check serial
		lds	tempreg1,libmio_keycode
		cpi	tempreg1,0x00		;no key
		breq	cbterm_mloop_1

		cpi	tempreg1,0xed		;ESC
		brne	cbterm_mloop_2
		api_askthis
		.db	0x2f,"Exit Program ?",0
		cpi	tempreg1,0		;no
		breq	cbterm_mloop
		sts	libmio_tcnt,const_0
		ret				;exit program

cbterm_mloop_2:	cpi	tempreg1,0xf1		;F1 = mode
		brne	cbterm_mloop_3
		lds	tempreg1,libmio_vram+51
		cpi	tempreg1,'n'
		brne	cbterm_mloop_d
		rcall	cbterm_dmode
		rjmp	cbterm_mloop_w
cbterm_mloop_d:	rcall	cbterm_nmode

cbterm_mloop_w:	api_nokey
		rcall	cbterm_cursor
		rjmp	cbterm_mloop

cbterm_mloop_3:	cpi	tempreg1,0xf3		;F3 = receive
		brne	cbterm_mloop_4
		rcall	cbterm_rlst
		cpi	tempreg4,0xff		;no program selected
		breq	cbterm_mloop_a
		api_getprog
		cp	tempreg4,ZL
		brne	cbterm_mloop_b
		api_alertthis
		.db	0x2f,"Cannot overwrite!",0
		rjmp	cbterm_mloop

cbterm_mloop_b:	rcall	cbterm_trabor
		mov	ctrl,tempreg4
		sts	libmio_rcnt,const_0
		api_preceive
		api_srestore
		api_nokey
cbterm_mloop_a:	rjmp	cbterm_mloop

cbterm_mloop_4:	cpi	tempreg1,0xf2		;F2 = send
		brne	cbterm_mloop_5
		rcall	cbterm_slst
		cpi	tempreg4,0xff		;no program selected
		breq	cbterm_mloop_a
		rcall	cbterm_trabos
		mov	ctrl,tempreg4
		api_nokey
		sts	libmio_rcnt,const_0
		api_psend
		api_srestore
		api_nokey
		rjmp	cbterm_mloop

cbterm_mloop_5:	cpi	tempreg1,0xf4		;F4 = clear
		brne	cbterm_mloop_6
		rcall	cbterm_cls
		rcall	cbterm_cursor
		ldi	tempreg1,0x0c
		api_psend
		rjmp	cbterm_mloop

cbterm_mloop_6:	cpi	tempreg1,0xea		;ENTER
		brne	cbterm_mloop_7
		api_putsernl
		rcall	cbterm_ochar
		rjmp	cbterm_mloop

cbterm_mloop_7:	cpi	tempreg1,0xec		;BACKSPACE
		brne	cbterm_mloop_8
		rcall	cbterm_rchr		;remove char
		ldi	tempreg1,0x08		;code for BS
		api_putser
		rjmp	cbterm_mloop

cbterm_mloop_8:	cpi	tempreg1,0x80
		brcc	cbterm_mloop_9
		push	tempreg1
		rcall	cbterm_ochar
		pop	tempreg1
		api_putser			;put out char
cbterm_mloop_9:	rjmp	cbterm_mloop

;------------------------------------------------------------------------------
;check serial input
;------------------------------------------------------------------------------
cbterm_cser:	lds	tempreg1,libmio_rcnt
		cpi	tempreg1,0
		breq	cbterm_cser_1
		ret

cbterm_cser_1:	lds	tempreg1,libmio_rdat
		ldi	r16,0xff
		sts	libmio_rcnt,r16
		cpi	tempreg1,0x0c		;clear
		brne	cbterm_cser_2
		rcall	cbterm_cls
		rjmp	cbterm_cursor

cbterm_cser_2:	cpi	tempreg1,0x0a		;newline
		brne	cbterm_cser_3
		lds	r16,libmio_sysconf
		andi	r16,0xc0
		cpi	r16,0x40		;only CR?
		breq	cbterm_cser_v		;display char
		rjmp	cbterm_newl

cbterm_cser_3:	cpi	tempreg1,0x0d		;carriage return
		brne	cbterm_cser_5
		lds	r16,libmio_sysconf
		andi	r16,0xc0
		cpi	r16,0x80		;only LF?
		breq	cbterm_cser_v		;view only
		cpi	r16,0xc0		;CR+LF
		brne	cbterm_cser_4
		ret
cbterm_cser_4:	rjmp	cbterm_newl

cbterm_cser_5:	cpi	tempreg1,0x08		;backspace
		brne	cbterm_cser_v		;no
		rjmp	cbterm_rchr

cbterm_cser_v:	rcall	cbterm_char
		rjmp	cbterm_cursor

;------------------------------------------------------------------------------
;clear text area
;------------------------------------------------------------------------------
cbterm_cls:	ldi	XL,LOW(libmio_vram+91)
		ldi	XH,HIGH(libmio_vram+91)
		ldi	tempreg1,0x20		;space
		ldi	r16,18			;lines
cbterm_cls_1:	ldi	r17,28			;bytes to do
cbterm_cls_2:	st	X+,tempreg1
		dec	r17
		brne	cbterm_cls_2
		adiw	XL,2
		dec	r16
		brne	cbterm_cls_1

		ldi	XL,LOW(libmio_vram+91+690)
		ldi	XH,HIGH(libmio_vram+91+690)
		ldi	tempreg1,0x0f		;white on black
		ldi	r16,18			;lines
cbterm_cls_3:	ldi	r17,28			;bytes to do
cbterm_cls_4:	st	X+,tempreg1
		dec	r17
		brne	cbterm_cls_4
		adiw	XL,2
		dec	r16
		brne	cbterm_cls_3

		clr	r18			;X=0
		clr	r19			;Y=0
		ret

;------------------------------------------------------------------------------
;scroll text area
;------------------------------------------------------------------------------
cbterm_scroll:	ldi	XL,LOW(libmio_vram+91)
		ldi	XH,HIGH(libmio_vram+91)
		ldi	YL,LOW(libmio_vram+121)
		ldi	YH,HIGH(libmio_vram+121)
		ldi	r16,17			;lines
cbterm_scroll1:	ldi	r17,28			;bytes to do
cbterm_scroll2:	ld	tempreg1,Y+
		st	X+,tempreg1
		dec	r17
		brne	cbterm_scroll2
		adiw	XL,2
		adiw	YL,2
		dec	r16
		brne	cbterm_scroll1
		ldi	tempreg1,0x20		;space
		ldi	r17,28			;bytes to do
cbterm_scroll3:	st	X+,tempreg1
		dec	r17
		brne	cbterm_scroll3
	
		ldi	XL,LOW(libmio_vram+91+690)
		ldi	XH,HIGH(libmio_vram+91+690)
		ldi	YL,LOW(libmio_vram+121+690)
		ldi	YH,HIGH(libmio_vram+121+690)
		ldi	r16,17			;lines
cbterm_scroll5:	ldi	r17,28			;bytes to do
cbterm_scroll6:	ld	tempreg1,Y+
		st	X+,tempreg1
		dec	r17
		brne	cbterm_scroll6
		adiw	XL,2
		adiw	YL,2
		dec	r16
		brne	cbterm_scroll5
		ldi	tempreg1,0x0f		;white on black
		ldi	r17,28			;bytes to do
cbterm_scroll7:	st	X+,tempreg1
		dec	r17
		brne	cbterm_scroll7
		ret

;------------------------------------------------------------------------------
;write char
; tempreg1=char
;------------------------------------------------------------------------------
cbterm_char:	ldi	XL,LOW(libmio_vram+91)
		ldi	XH,HIGH(libmio_vram+91)
		ldi	r16,30
		mul	r16,r19			;calc line offset
		add	XL,r0
		adc	XH,r1
		add	XL,r18			;column offset
		adc	XH,const_0
		st	X,tempreg1
		lds	tempreg1,libmio_vram+51
		cpi	tempreg1,'n'
		breq	cbterm_char_1
		ldi	tempreg1,LOW(690)
		add	XL,tempreg1
		ldi	tempreg1,HIGH(690)
		adc	XH,tempreg1
		ldi	tempreg1,0x04		;red
		st	X,tempreg1
cbterm_char_1:	inc	r18			;column+1
		cpi	r18,28
		brcs	cbterm_char_e
		clr	r18
		inc	r19
		cpi	r19,18
		brcs	cbterm_char_e
		dec	r19
		rjmp	cbterm_scroll
cbterm_char_e:	ret

;------------------------------------------------------------------------------
;write own char
; tempreg1=char
;------------------------------------------------------------------------------
cbterm_ochar:	lds	r16,libmio_vram+51
		cpi	r16,'d'
		breq	cbterm_ochar_0
		ret
cbterm_ochar_0:	cpi	tempreg1,0xea		;ENTER
		breq	cbterm_ochar_n
		ldi	XL,LOW(libmio_vram+91)
		ldi	XH,HIGH(libmio_vram+91)
		ldi	r16,30
		mul	r16,r19			;calc line offset
		add	XL,r0
		adc	XH,r1
		add	XL,r18			;column offset
		adc	XH,const_0
		st	X,tempreg1
		ldi	tempreg1,LOW(690)
		add	XL,tempreg1
		ldi	tempreg1,HIGH(690)
		adc	XH,tempreg1
		ldi	tempreg1,0x08		;green
		st	X,tempreg1
cbterm_ochar_1:	inc	r18			;column+1
		cpi	r18,28
		brcs	cbterm_ochar_e
		clr	r18
		inc	r19
		cpi	r19,18
		brcs	cbterm_ochar_e
		dec	r19
		rcall	cbterm_scroll
cbterm_ochar_e:	rjmp	cbterm_cursor

cbterm_ochar_n:

;------------------------------------------------------------------------------
;newline
;------------------------------------------------------------------------------
cbterm_newl:	rcall	cbterm_ncursor
		clr	r18
		inc	r19
		cpi	r19,17
		brcs	cbterm_newl_e
		dec	r19
		rcall	cbterm_scroll
cbterm_newl_e:

;------------------------------------------------------------------------------
;write cursor
;------------------------------------------------------------------------------
cbterm_cursor:	ldi	XL,LOW(libmio_vram+91)
		ldi	XH,HIGH(libmio_vram+91)
		ldi	r16,30
		mul	r16,r19			;calc line offset
		add	XL,r0
		adc	XH,r1
		add	XL,r18			;column offset
		adc	XH,const_0
		ldi	r16,0x10		;cursor
		st	X,r16
		ldi	r16,LOW(690)
		add	XL,r16
		ldi	r16,HIGH(690)
		adc	XH,r16
		ldi	r16,0x0f
		st	X,r16
		ret

;------------------------------------------------------------------------------
;delete cursor
;------------------------------------------------------------------------------
cbterm_ncursor:	ldi	XL,LOW(libmio_vram+91)
		ldi	XH,HIGH(libmio_vram+91)
		ldi	r16,30
		mul	r16,r19			;calc line offset
		add	XL,r0
		adc	XH,r1
		add	XL,r18			;column offset
		adc	XH,const_0
		ldi	r16,0x20		;space
		st	X,r16
		ret

;------------------------------------------------------------------------------
;remove last char
;------------------------------------------------------------------------------
cbterm_rchr:	cpi	r18,0			;at the beginning?
		brne	cbterm_rchr_1
		ret				;do nothing
cbterm_rchr_1:	ldi	XL,LOW(libmio_vram+91)
		ldi	XH,HIGH(libmio_vram+91)
		ldi	r16,30
		mul	r16,r19			;calc line offset
		add	XL,r0
		adc	XH,r1
		add	XL,r18			;column offset
		adc	XH,const_0
		ldi	r16,0x20		;space
		st	X,r16
		ldi	r16,LOW(690)
		add	XL,r16
		ldi	r16,HIGH(690)
		adc	XH,r16
		ldi	r16,0x0f
		st	X,r16
		dec	r18
		rjmp	cbterm_cursor

;------------------------------------------------------------------------------
;show program list
;------------------------------------------------------------------------------
cbterm_slst:	api_sbackup
		ldi	XL,0x40			;color scheme (black on yellow)
		api_setcolor
		ldi	YL,6			;maximal sized box
		ldi	YH,6
		ldi	ZL,24
		ldi	ZH,17
		api_whbox
		ldi	XL,0x04			;color scheme (black on yellow)
		api_setcolor
		api_thistext
		.db 7,8,"Send Program",0,0
		ldi	tempreg3,0x80
		rjmp	cbterm_lst_01

cbterm_rlst:	api_sbackup
		ldi	XL,0x17			;color scheme (black on yellow)
		api_setcolor
		ldi	YL,6			;maximal sized box
		ldi	YH,6
		ldi	ZL,24
		ldi	ZH,17
		api_whbox
		ldi	XL,0x71			;color scheme (black on yellow)
		api_setcolor
		api_thistext
		.db 7,8,"Receive Program",0
		ldi	tempreg3,0x2e


cbterm_lst_01:	ldi	XL,LOW(libmio_vram+8+9*libmio_cols)
		ldi	XH,HIGH(libmio_vram+8+9*libmio_cols)
		ldi	ZL,0
		ldi	ZH,0x90			;start of program area
		ldi	r16,8			;programs to do
cbterm_lst_02:	ldi	r17,12			;bytes per name
		ldi	tempreg1,'P'
		st	X+,tempreg1
		ldi	tempreg1,'9'
		sub	tempreg1,r16
		st	X+,tempreg1
		ldi	tempreg1,':'
		st	X+,tempreg1
		ldi	r17,12			;bytes per name
cbterm_lst_04:	lpm	tempreg1,Z+
		st	X+,tempreg1
		dec	r17
		brne	cbterm_lst_04
		adiw	XL,15			;next line
		subi	ZH,0xf4			;next program
		clr	ZL
		dec	r16
		brne	cbterm_lst_02		;program loop

		ldi	tempreg4,0			;initial position

cbterm_lst_10:	ldi	XL,LOW(libmio_vram+698+9*libmio_cols)
		ldi	XH,HIGH(libmio_vram+698+9*libmio_cols)
		ldi	r16,0
cbterm_lst_12:	mov	tempreg1,tempreg3	;get color
		cp	r16,tempreg4
		brne	cbterm_lst_13
		ldi	tempreg1,0x0c		;black on yellow
cbterm_lst_13:	ldi	r17,15			;bytes per name
cbterm_lst_14:	st	X+,tempreg1
		dec	r17
		brne	cbterm_lst_14
		adiw	XL,15			;next line
		inc	r16
		cpi	r16,8
		brne	cbterm_lst_12		;program loop

cbterm_lst_20:	api_screenshot
		api_waitkey
		cpi	tempreg1,0xed		;esc
		brne	cbterm_lst_22
		ldi	tempreg4,0xff
		api_srestore
		api_nokey
		ret

cbterm_lst_22:	cpi	tempreg1,0xea		;enter
		brne	cbterm_lst_24
		api_srestore
		api_nokey
		ret

cbterm_lst_24:	cpi	tempreg1,0xe4		;up
		brne	cbterm_lst_26
		cpi	tempreg4,0
		breq	cbterm_lst_20
		dec	tempreg4
		rjmp	cbterm_lst_10

cbterm_lst_26:	cpi	tempreg1,0xe5		;down
		brne	cbterm_lst_20
		cpi	tempreg4,7
		breq	cbterm_lst_20
		inc	tempreg4
		rjmp	cbterm_lst_10

;------------------------------------------------------------------------------
;transfer-alertbox
;------------------------------------------------------------------------------
cbterm_trabor:	api_sbackup
		ldi	tempreg1,0x4c		;yellow on red
		sts	libmio_color,tempreg1	;set new color
		ldi	YL,5
		ldi	YH,10
		ldi	ZL,24
		ldi	ZH,12
		api_wbox			;draw window
		api_thistext
		.db 	11,6,"Receive Data...",0
		ret

cbterm_trabos:	api_sbackup
		ldi	tempreg1,0x4c		;yellow on red
		sts	libmio_color,tempreg1	;set new color
		ldi	YL,5
		ldi	YH,10
		ldi	ZL,24
		ldi	ZH,12
		api_wbox			;draw window
		api_thistext
		.db 	11,8,"Send Data... ",0
		ret

;------------------------------------------------------------------------------
;the configpage menubar
;------------------------------------------------------------------------------
		;   "111111222222333333444444555555"
cbterm_mbar:	.db " Exit  Mode  Send  Recv  Clear"



