#!/usr/bin/perl
#################################################################################
#										#
# table generator for libmio							#
# copyright (c) 2006-2015 Joerg Wolfram (joerg@jcwolfram.de)			#
#										#
#										#
# This program is free software; you can redistribute it and/or			#
# modify it under the terms of the GNU General Public License			#
# as published by the Free Software Foundation; either version 3		#
# of the License, or (at your option) any later version.			#
#										#
# This program is distributed in the hope that it will be useful,		#
# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
# General Public License for more details.					#
#										#
# You should have received a copy of the GNU General Public			#
# License along with this library; if not, write to the				#
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
# Boston, MA 02111-1307, USA.							#
#										#
#################################################################################
###############################################################################
# start assembler to generate list file
###############################################################################
$dummy=`avra -l x main_644.asm`;

###############################################################################
# read character cells
###############################################################################
open (RFILE, "x");
open (WFILE, ">api.inc");
print WFILE ";######################################################################\n";
print WFILE ";#                                                                    #\n";
print WFILE ";#    AVR ChipBasic2 API V1.50 API Address definitions                #\n";
print WFILE ";#    (c) 2009-2015 Joerg Wolfram                                     #\n";
print WFILE ";#                                                                    #\n";
print WFILE ";# This program is free software; you can redistribute it and/or      #\n";
print WFILE ";# modify it under the terms of the GNU General Public License        #\n";
print WFILE ";# as published by the Free Software Foundation; either version 3     #\n";
print WFILE ";# of the License, or (at your option) any later version.             #\n";
print WFILE ";#                                                                    #\n";
print WFILE ";# This program is distributed in the hope that it will be useful,    #\n";
print WFILE ";# but WITHOUT ANY WARRANTY; without even the implied warranty of     #\n";
print WFILE ";# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU    #\n";
print WFILE ";# General Public License for more details.                           #\n";
print WFILE ";#                                                                    #\n";
print WFILE ";# You should have received a copy of the GNU General Public          #\n";
print WFILE ";# License along with this library; if not, write to the              #\n";
print WFILE ";# Free Software Foundation, Inc., 59 Temple Place - Suite 330,       #\n";
print WFILE ";# Boston, MA 02111-1307, USA.                                        #\n";
print WFILE ";#                                                                    #\n";
print WFILE ";######################################################################\n";

open (MFILE, ">api_macros.inc");
print MFILE ";######################################################################\n";
print MFILE ";#                                                                    #\n";
print MFILE ";#    AVR ChipBasic2 API V1.50 API Macros                             #\n";
print MFILE ";#    (c) 2009-2015 Joerg Wolfram                                     #\n";
print MFILE ";#                                                                    #\n";
print MFILE ";# This program is free software; you can redistribute it and/or      #\n";
print MFILE ";# modify it under the terms of the GNU General Public License        #\n";
print MFILE ";# as published by the Free Software Foundation; either version 3     #\n";
print MFILE ";# of the License, or (at your option) any later version.             #\n";
print MFILE ";#                                                                    #\n";
print MFILE ";# This program is distributed in the hope that it will be useful,    #\n";
print MFILE ";# but WITHOUT ANY WARRANTY; without even the implied warranty of     #\n";
print MFILE ";# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU    #\n";
print MFILE ";# General Public License for more details.                           #\n";
print MFILE ";#                                                                    #\n";
print MFILE ";# You should have received a copy of the GNU General Public          #\n";
print MFILE ";# License along with this library; if not, write to the              #\n";
print MFILE ";# Free Software Foundation, Inc., 59 Temple Place - Suite 330,       #\n";
print MFILE ";# Boston, MA 02111-1307, USA.                                        #\n";
print MFILE ";#                                                                    #\n";
print MFILE ";######################################################################\n";

while(<RFILE>)
{
    $z=$_;
    chomp($z);
    if ($z =~ /api_/) 
    {
	$z=$';
	$a=$`;
	$z =~ /:/;
	$z = $`;
	if (($a !~ /br/) && ($a !~ /call/) && ($a !~ /jmp/) && ($z !~ /getbase_/))
	{
	    print WFILE ".equ\tapi_".$z."\t";
	    if (length($z)<4)
	    {
		print WFILE "\t";
	    }
	    $a =~ s/C:00/0x/;
	    $a =~ / /;
	    $a=$`;
	    print WFILE "= ".$a."\n";

	    print MFILE ".macro api_".$z."\n";
	    if (($z =~ /pop/) || ($z =~ /vm0/))
	    {
		print MFILE "\tjmp\t".$a."\n";
	    }
	    else
	    {
		print MFILE "\tcall\t".$a."\n";
	    }	    
	    print MFILE ".endm\n\n";
	}
    }
}
close(MFILE);
close(WFILE);
close(RFILE);
#$dummy=`mkdir -p ../BUILD/SOURCE/API`;
#$dummy=`cp api.inc ../BUILD/SOURCE/API`;
#$dummy=`cp api_macros.inc ../BUILD/SOURCE/API`;
$dummy=`cp api.inc includes/api.inc`;
$dummy=`cp api_macros.inc includes/api_macros.inc`;

$dummy=`rm -f x`;
