;################################################################################
;#										#
;# single chip basic computer with ATmega644/1284P				#
;# copyright (c) 2006-2015 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License as		#
;# published by the Free Software Foundation; either version 3 of		#
;# the License, or (at your option) any later version.				#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################
.CSEG

.include	"/usr/local/include/avr/m1284Pdef.inc"
.include	"includes/libdef.asm"

.equ		libmio_palette	= 0x0100	;16 bytes video palette
.equ		bas_mta		= 0x0110	;4 bytes basic multitasking
.equ		libmio_ram	= 0x0114	;84 bytes libmio system RAM
.equ		bas_ram		= 0x0168	;16 bytes basic system RAM
.equ		bas_partab	= 0x0178	;16 bytes basic parameter
.equ		bcopy_buffer	= 0x0188	;bcopy line buffer uses the input space
.equ		bas_inbuf	= 0x0188	;40 bytes input buffer
.equ		bas_linebuf	= 0x01b0	;40 bytes line buffer
.equ		libmio_vram	= 0x01d8	;690 bytes of video RAM (pixel)
.equ		libmio_vram_a	= 0x048a	;690 bytes of video RAM (attributes)

.equ		mon_bpage	= 0x073c	;690 bytes backup page (pixel)
.equ		mon_bpage_a	= 0x09ee	;690 bytes backup page (attributes)

.equ		varspace	= 0x0ca0	;52 bytes basic variables
.equ		expar_ros	= 0x0cfa	;38 bytes calculator stack
.equ		bas_stacks	= 0x0cfc	;55 bytes basic stacks
.equ		bas_values	= 0x0d2e	;14 Bytes parameters and return values
.equ		bas_array	= 0x0d3c	;768 Bytes Array
.equ		libdfl_buffer	= 0x0f3c	;libdfl uses a part of the array
.equ		libi2c_buffer	= 0x0f30	;libi2c uses a part of the array

.equ		libdfl_ram	= 0x103c	;16 Bytes libdfl system RAM
.equ		stack		= 0x10ef	;60 bytes stack

.include	"modules/definitions.asm"
.include	"libmio/definitions.asm"
.include	"libeep/definitions.asm"
.include	"libi2c/definitions.asm"
.include	"macros.inc"

.set		bas_lines=95
.set		bas_stackdepth = 10
.set		bas_maxprog = 8
.set		ptype = 1284

.org 0x0000
		rjmp	start
.org 0x0004
		.db 2,14			;System/version
.org OC1Aaddr
		libmio_vint			;video interrupt
.org OC1Baddr
		libmio_bint			;border-end-interrupt

.org 0x001e

.include	"api.asm"
start:		cli
		ldi	XL,0x00
		mov	const_0,XL
		ldi	XL,0x01
		mov	const_1,XL
		ldi	XL,HIGH(stack)
		out	SPH,XL
		ldi	XL,LOW(stack)
		out	SPL,XL
		sts	xram_page,const_0

		libmio_init
		libi2c_init
		call	mem_getconf
		call	mem_getconf
		libmio_sysconf

;call driver setup if parport will be disabled
		call	sys_extsearch
		lds	ZH,prg_vdrv
		ldi	ZH,0xff
		ldi	ZL,vdrv_startup
		sbrs	ZH,7
		icall

		sts	libmio_vidmode,const_0
		clr	XL
		libmio_setvmode


		libmio_clrscr
		ldi	XL,0xff
		sts	bas_mta,XL
		sts	libmio_serio,XL
		sts	libmio_lastmenu,const_0	;reset menu
		sts	libmio_seqspeed,const_0
wloop4:		clr	ereg
		sts	libmio_kflags,const_0
		sts	libmio_keycode,const_0
		sei

loop:		jmp	intro_main		;main menu

loop2:		swap	tempreg1
		dec	tempreg1
		sts	libmio_lastmenu,tempreg1
		ldi	XL,0x07
		libmio_setcolor
		clr	XL
		libmio_setborder
		libmio_clrscr
		call	menu_runprog		;run program
		rjmp	start			;run again

popxyz:		pop	XL
		pop	XH
		pop	YL
		pop	YH
		pop	ZL
		pop	ZH
		ret

pushxyz:	pop	r0
		pop	r1
		push	ZH
		push	ZL
		push	YH
		push	YL
		push	XH
		push	XL
		push	r1
		push	r0
		ret

.macro pop_ptr
		jmp	popxyz
.endm

.macro push_ptr
		call	pushxyz
.endm

popxyzr:	pop	tempreg4
		pop	tempreg3
		pop	tempreg2
		pop	tempreg1
		rjmp	popxyz
		
pushxyzr:	pop	r0
		pop	r1
		push	ZH
		push	ZL
		push	YH
		push	YL
		push	XH
		push	XL
		push	tempreg1
		push	tempreg2
		push	tempreg3
		push	tempreg4
		push	r1
		push	r0
		ret

.macro pop_regs
		jmp	popxyzr
.endm

.macro push_regs
		call	pushxyzr
.endm

.include	"modules/intro.asm"
.include	"modules/menu.asm"
.include	"modules/editor.asm"
.include	"modules/exparser.asm"
.include	"modules/runtime.asm"
.include	"modules/spi.asm"
.include	"modules/array.asm"
.include	"modules/compress_line.asm"
.include	"modules/expand_line.asm"
.include	"modules/monitor.asm"
.include	"modules/fileman.asm"
.include	"modules/filesys.asm"
.include	"modules/configpage.asm"
.include	"modules/infopage.asm"
.include	"modules/xm.asm"

.include	"modules/tokentable.inc"
.include	"libmio/vint_o.asm"

.include	"libmio/vidm_tvc.asm"
.include	"libmio/vidm_tvg.asm"
.include	"libmio/vidm_tvm.asm"
.include	"libmio/vidm_tvs.asm"
.include	"libmio/vidm_tvu.asm"
.include	"libs.inc"

bas_sintab:
.include	"modules/sintable.inc"

.org	0x4400
libmio_ktables:
.include	"libmio/keytable_de.inc"

.org	0x4500
libmio_costab:	
.include	"libmio/costab.inc"

.org	0x4580
.include	"libmio/soundtables.inc"

.org	0x4700
libmio_ctable1:
.include	"libmio/ctable_f1.inc"

.include	"includes/version.inc"

end_system:

.org	0x4800
bas_programs:
;program 1 4800-4dff
.org	0x4800
		.db "            B",0xff,0xff,0xff
		.db 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
		.db 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff

;program 2 4e00-53ff
.org	0x4e00
		.db "            B",0xff,0xff,0xff
		.db 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
		.db 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff

;program 3 5400-59ff
.org	0x5400
		.db "            B",0xff,0xff,0xff
		.db 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
		.db 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff

;program 4 5a00-5fff
.org	0x5a00
		.db "            B",0xff,0xff,0xff
		.db 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
		.db 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
;		.db 0xc0,0x22,"123456789012345678901234",0x22,":",0x86

;program 5 6000-65ff
.org	0x6000
.include	"prog/loader.asm"

;program 6 6600-6bff
.org	0x6600
		.db "            B",0xff,0xff,0xff
		.db 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
		.db 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff

;program 7 6c00-71ff
.org	0x6c00
		.db "            B",0xff,0xff,0xff
		.db 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
		.db 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff

;program 8 7200-77ff
.org	0x7200
		.db "            B",0xff,0xff,0xff
		.db 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
		.db 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff

.org	0x7980
libmio_kstab:
.include	"libmio/kstable.inc"

.org	0x7a00
libmio_ctable:
.include	"libmio/ctable_f0.inc"

;---------------------------------------------------------------------------------
;start of nrww-section
;---------------------------------------------------------------------------------
.org	0xf800
.include	"libmio/bootvid.asm"
.include	"modules/memory.asm"
.include	"modules/extsearch.asm"

