;################################################################################
;#										#
;# single chip basic computer with ATmega644	remote loader			#
;# copyright (c) 2006-2015 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License as 		#
;# published by the Free Software Foundation; either version 3 of		#
;# the License, or (at your option) any later version.				#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################
		.db "SerialLoaderL",0xea,0xff,0xff	;red, run disabled
		.db 0x00,0xe6,0xe7,0x00,0x00,0xe8,0xe9,0x00
		.db "1.51",0xff,0xff,0xff,0xff
		ldi	ZL,8
		ldi	ZH,0
		lpm	tempreg1,Z+
		cpi	tempreg1,2
		brne	sload_nosys
		lpm	tempreg1,Z+
		cpi	tempreg1,14
		brne	sload_nosys
		rjmp	sload_start

sload_nosys:	ret

sload_start:	libmio_clrscr
		libmio_thistext
		.db 0,0,"ChipBasic2 serial loader V1.51",0,0
		libmio_thistext
		.db 2,0,"trying to connect via ",0,0

		call	mem_getconf
		in	r18,GPIOR0
		in	r19,GPIOR1
		lds	tempreg3,PCMSK0
		sbrs	r18,2
		ori	r18,0x01			;no P-type

		ldi	ZL,LOW(sload_sertxt*2)
		ldi	ZH,HIGH(sload_sertxt*2)
		sbrc	r18,0			;ser1 / ser2
		adiw	ZL,20
		sbrc	tempreg3,0			;speed select
		adiw	ZL,10
		libmio_romtext			;output text

		sts	libmio_channel,const_1
		libmio_thistext
		.db 255,0x0c,"Press space to start!",0x0d,0x0a,0x00
		sbis	GPIOR0,0
		rjmp	sload_40
sload_00:	lds	XL,libmio_rcnt
		cpi	XL,0
		brne	sload_00
		ldi	tempreg4,100			;loops to do
		dec	XL
		sts	libmio_rcnt,XL
sload_01:	libmio_sync
		lds	XL,libmio_rcnt
		cpi	XL,0
		breq	sload_02
		dec	tempreg4
		brne	sload_01
		ret

sload_40:	ldi	tempreg4,100			;loops to do
		lds	tempreg1,UDR1
sload_41:	lds	tempreg1,UCSR1A
		sbrc	tempreg1,7
		rjmp	sload_42
		libmio_sync
		dec	tempreg4
		brne	sload_41
		ret

sload_42:	lds	tempreg1,UDR1
		cpi	tempreg1,' '
		breq	sload_03
		ret

sload_02:	lds	tempreg1,libmio_rdat
		cpi	tempreg1,' '
		breq	sload_03
		ret

sload_03:	sts	libmio_channel,const_0
		ldi	XL,0x80
		sts	libmio_color,XL
		libmio_thistext
		.db 4,9," connected ",0
		sts	libmio_channel,const_1
sload_loop:	libmio_thistext
		.db 255,0x0c,"----------------------------",0x0d,0x0a,0,0
		libmio_thistext
		.db 255,"  ChipBasic2 Serial Loader",0x0d,0x0a,0x00
		libmio_thistext
		.db 255,"----------------------------",0x0d,0x0a,0x00
		libmio_thistext
		.db 255," S = Show Status",0x0d,0x0a,0
		libmio_thistext
		.db 255," B = Binary Upload (XMODEM)",0x0d,0x0a,0,0
		libmio_thistext
		.db 255," T = Text Upload (ASCII)",0x0d,0x0a,0
		libmio_thistext
		.db 255," A = Set Autostart",0x0d,0x0a,0
		libmio_thistext
		.db 255," C = Config Hardware",0x0d,0x0a,0
		libmio_thistext
		.db 255," Q = Quit",0x0d,0x0a,0,0

;		libmio_thistext
;		.db 255,0x0d,0x0a,"Space returns to main menu",0

sload_04:	libmio_sysget
		cpi	tempreg1,'S'
		breq	sload_s00
		cpi	tempreg1,'s'
		breq	sload_s00
		cpi	tempreg1,'C'
		breq	sload_h00
		cpi	tempreg1,'c'
		breq	sload_h00
		cpi	tempreg1,'B'
		breq	sload_b00
		cpi	tempreg1,'b'
		breq	sload_b00
		cpi	tempreg1,'T'
		breq	sload_t00
		cpi	tempreg1,'t'
		breq	sload_t00
		cpi	tempreg1,'A'
		breq	sload_a00
		cpi	tempreg1,'a'
		breq	sload_a00
		cpi	tempreg1,'Q'
		breq	sload_q00
		cpi	tempreg1,'q'
		breq	sload_q00
		rjmp	sload_04

sload_q00:	rjmp	sload_quit

sload_b00:	rjmp	sload_btrans

sload_t00:	rjmp	sload_ttrans

sload_h00:	rjmp	sload_hard

sload_a00:	rjmp	sload_auto

sload_s00:	rjmp	sload_stat

;-------------------------------------------------------------------------------
;view status
;-------------------------------------------------------------------------------
sload_stat:
		libmio_thistext
		.db 255,0x0c,"----------------------------",0x0d,0x0a,0,0
		libmio_thistext
		.db 255,"          Status",0x0d,0x0a,0x00
		libmio_thistext
		.db 255,"----------------------------",0x0d,0x0a,0x00
		rcall	sload_plist
		call	sys_extsearch
		libmio_thistext
		.db 255,0x0d,0x0a,"Press any key!",0
		libmio_sysget
		rjmp	sload_loop		;jump to menu

;-------------------------------------------------------------------------------
;set autostart
;-------------------------------------------------------------------------------
sload_auto:
		libmio_thistext
		.db 255,0x0c,"----------------------------",0x0d,0x0a,0,0
		libmio_thistext
		.db 255,"         Autostart",0x0d,0x0a,0x00
		libmio_thistext
		.db 255,"----------------------------",0x0d,0x0a,0x00
		rcall	sload_plist

sload_auto_1:	libmio_thistext
		.db 255,0x0d,0x0a,"Select Autostart (1..7, 0=off) :",0
sload_auto_2:	libmio_sysget
		libmio_sysput
		cpi	tempreg1,' '
		breq	sload_auto_e
		cpi	tempreg1,'0'
		brcs	sload_auto_1
		cpi	tempreg1,'8'
		brcc	sload_auto_1
		subi	tempreg1,'0'
		andi	tempreg1,0x07
		mov	r16,tempreg1
		dec	r16
		ldi	ZL,0x0c
		ldi	ZH,0x90
		ldi	r17,12
		mul	r17,r16
		add	ZH,r0
		lpm	r17,Z
		cpi	r17,'L'
		brne	sload_auto_3
		libmio_thistext
		.db 255,0x0d,0x0a,"Cannot autostart loader !!!",0x0d,0x0a,0,0
		rjmp	sload_auto_1

sload_auto_3:	in	tempreg2,GPIOR1
		swap	tempreg1
		andi	tempreg1,0x70
		andi	tempreg2,0x8f
		or	tempreg2,tempreg1
		out	GPIOR1,tempreg2
		call	mem_setconf
		rjmp	sload_auto

sload_auto_e:	rjmp	sload_loop

;-------------------------------------------------------------------------------
;transfer program via XMODEM
;-------------------------------------------------------------------------------
sload_btrans:
		libmio_thistext
		.db 255,0x0c,"----------------------------",0x0d,0x0a,0,0
		libmio_thistext
		.db 255,"       XModem Upload",0x0d,0x0a,0x00
		libmio_thistext
		.db 255,"----------------------------",0x0d,0x0a,0x00
		rcall	sload_plist

sload_trans_0:	libmio_thistext
		.db 255,0x0d,0x0a,"Select Program (1..8) :",0,0
sload_trans_1:	libmio_sysget
		libmio_sysput
		cpi	tempreg1,' '
		brne	sload_trans_1a
		rjmp	sload_auto_e
sload_trans_1a:	cpi	tempreg1,'1'
		brcs	sload_trans_0
		cpi	tempreg1,'9'
		brcc	sload_trans_0
		subi	tempreg1,'1'
		ldi	ZL,0x0c
		ldi	ZH,0x90
		ldi	r17,12
		mul	r17,tempreg1
		add	ZH,r0
		lpm	r17,Z
		cpi	r17,'L'
		brne	sload_trans_o
		libmio_thistext
		.db 255,0x0d,0x0a,"Overwrite loader ? (y/n)",0
sload_trans_l1:	libmio_sysget
		cpi	tempreg1,'n'
		brne	sload_trans_l2
		rjmp	sload_btrans
sload_trans_l2:	cpi	tempreg1,'y'
		brne	sload_trans_l1

sload_trans_l3:	mov	ctrl,tempreg1
		libmio_thistext
		.db 255,0x0c,"--> transfer starts in 10s ",0
		ldi	r17,250
sload_trans_l4:	libmio_sync
		dec	r17
		brne	sload_trans_l4
		ldi	r17,250
sload_trans_l5:	libmio_sync
		dec	r17
		brne	sload_trans_l5
		push	const_0
		push	const_0
		jmp	recv_prog_a


sload_trans_o:	mov	ctrl,tempreg1
		libmio_thistext
		.db 255,0x0c,"--> transfer starts in 10s ",0
		ldi	r17,250
sload_trans_2:	libmio_sync
		dec	r17
		brne	sload_trans_2
		ldi	r17,250
sload_trans_3:	libmio_sync
		dec	r17
		brne	sload_trans_3
		call	recv_prog_a
		rjmp	sload_btrans

;-------------------------------------------------------------------------------
;Configuration
;-------------------------------------------------------------------------------
sload_hard:	call	mem_getconf
		in	r18,GPIOR0
		in	r19,GPIOR1
		lds	tempreg3,PCMSK0
		sbrs	r18,2
		ori	r18,0x01			;no P-type


sload_hard_0:	libmio_thistext
		.db 255,0x0c,"----------------------------",0x0d,0x0a,0,0
		libmio_thistext
		.db 255,"  ChipBasic2 Configuration",0x0d,0x0a,0x00
		libmio_thistext
		.db 255,"----------------------------",0x0d,0x0a,0x00

;show data
slsd_view:	libmio_thistext
		.db 255,"(1) Serial speed: ",0

		ldi	ZL,LOW(sload_sertxt*2)
		ldi	ZH,HIGH(sload_sertxt*2)

		sbrc	r18,0			;ser1 / ser2
		adiw	ZL,20
		sbrc	tempreg3,0			;speed select
		adiw	ZL,10
		libmio_romtext			;output text

		libmio_thistext
		.db 255,0x0d,0x0a,"(2) I2C speed   : ",0
		sbrc	r18,4
		rjmp	slsd_twitype1
		libmio_thistext
		.db 255,"100 kHz",0,0
		rjmp	slsd_twitype2
slsd_twitype1:	libmio_thistext
		.db 255,"400 kHz",0,0
slsd_twitype2:

		libmio_thistext
		.db 255,0x0d,0x0a,"(3) SPI speed   : ",0
		sbrc	r18,3
		rjmp	slsd_spitype1
		libmio_thistext
		.db 255,"5 MHz  ",0,0
		rjmp	slsd_spitype2
slsd_spitype1:	libmio_thistext
		.db 255,"156 kHz",0,0
slsd_spitype2:

		libmio_thistext
		.db 255,0x0d,0x0a,"(4) EEPROM addr : ",0
		mov	tempreg1,r19
		andi	tempreg1,0x07
		subi	tempreg1,0xd0
		libmio_outchar

		libmio_thistext
		.db 255,0x0d,0x0a,"(5) Line end    : ",0
		mov	tempreg4,r18
		andi	tempreg4,0xc0
slsd_lintype1:	cpi	tempreg4,0x80
		brne	slsd_lintype2
		libmio_thistext
		.db 255,"only LF",0,0
		rjmp	slsd_lintype9
slsd_lintype2:	cpi	tempreg4,0x40
		brne	slsd_lintype3
		libmio_thistext
		.db 255,"only CR",0,0
		rjmp	slsd_lintype9
slsd_lintype3:	libmio_thistext
		.db 255,"CR+LF  ",0,0
slsd_lintype9:

		libmio_thistext
		.db 255,0x0d,0x0a,"(6) Serial I/O  : ",0
		sbrc	r18,1
		rjmp	slsd_sintype1
		libmio_thistext
		.db 255,"simple  ",0
		rjmp	slsd_sintype2
slsd_sintype1:	libmio_thistext
		.db 255,"standard",0
slsd_sintype2:

		libmio_thistext
		.db 255,0x0d,0x0a,"(7) Serial Input: ",0
		sbrs	r18,5
		rjmp	slsd_sinput1
		libmio_thistext
		.db 255,"PD3",0,0
		rjmp	slsd_sinput2
slsd_sinput1:	libmio_thistext
		.db 255,"PD1",0,0
slsd_sinput2:
		libmio_thistext
		.db 255,0x0d,0x0a,"(8) Store & Reboot",0x0d,0x0a,0
		libmio_thistext
		.db 255,0x0d,0x0a,"Space returns to main menu",0x0d,0x0a,0
slsd_ask:	libmio_thistext
		.db 255,0x0d,0x0a,"Select Parameter (1..8) :",0,0
slsd_ask_1:	libmio_sysget
		libmio_sysput
		cpi	tempreg1,' '
		breq	slsd_end
		cpi	tempreg1,'1'
		brcs	slsd_ask
		cpi	tempreg1,'9'
		brcc	slsd_ask
		cpi	tempreg1,'8'
		brne	slsd_ask_2
		rjmp	slsd_reboot

slsd_ask_2:	cpi	tempreg1,'1'
		brne	slsd_ask_3
		eor	tempreg3,const_1
		sbrs	tempreg3,0
		eor	r18,const_1
		sbrs	r18,2
		ori	r18,0x01			;no P-type
		rjmp	sload_hard_0

slsd_ask_3:	cpi	tempreg1,'2'
		brne	slsd_ask_4
		ldi	r16,0x10
		eor	r18,r16
		rjmp	sload_hard_0

slsd_ask_4:	cpi	tempreg1,'3'
		brne	slsd_ask_5
		ldi	r16,0x08
		eor	r18,r16
		rjmp	sload_hard_0

slsd_ask_5:	cpi	tempreg1,'4'
		brne	slsd_ask_6
		mov	r16,r19
		inc	r16
		andi	r16,0x07
		andi	r19,0xf8
		or	r19,r16
		rjmp	sload_hard_0

slsd_ask_6:	cpi	tempreg1,'5'
		brne	slsd_ask_7
		subi	r18,0xc0
		brcs	slsd_ask_6a
		ori	r18,0x40
slsd_ask_6a:	rjmp	sload_hard_0

slsd_ask_7:	cpi	tempreg1,'6'
		brne	slsd_ask_8
		ldi	r16,0x02
		eor	r18,r16
		rjmp	sload_hard_0

slsd_ask_8:	cpi	tempreg1,'7'
		brne	slsd_ask_9
		ldi	r16,0x20
		eor	r18,r16
		rjmp	sload_hard_0

slsd_ask_9:

slsd_end:	rjmp	sload_loop

slsd_reboot:	out	GPIOR0,r18
		out	GPIOR1,r19
		sts	PCMSK0,tempreg3
		call	mem_setconf
		libmio_thistext
		.db 255,0x0c,"----------------------------",0x0d,0x0a,0,0
		libmio_thistext
		.db 255,"  ChipBasic2 reboots now",0x0d,0x0a,0x00
		libmio_thistext
		.db 255,"----------------------------",0x0d,0x0a,0x00
		libmio_sync
		libmio_sync
		jmp	0


sload_quit:	libmio_thistext
		.db 255,0x0c,"----------------------------",0x0d,0x0a,0,0
		libmio_thistext
		.db 255,"  Serial Loader Quit",0x0d,0x0a,0x00
		libmio_thistext
		.db 255,"----------------------------",0x0d,0x0a,0x00
		ret

;-------------------------------------------------------------------------------
;transfer program via ASCII
;-------------------------------------------------------------------------------
sload_ttrans:
		libmio_thistext
		.db 255,0x0c,"----------------------------",0x0d,0x0a,0,0
		libmio_thistext
		.db 255,"       Text Upload",0x0d,0x0a,0x00
		libmio_thistext
		.db 255,"----------------------------",0x0d,0x0a,0x00
		rcall	sload_plist

sload_ttrans_0:	libmio_thistext
		.db 255,0x0d,0x0a,"Select Program (1..8) :",0,0
sload_ttrans_1:	libmio_sysget
		libmio_sysput
		cpi	tempreg1,' '
		brne	sload_ttrans_2
		rjmp	sload_auto_e
sload_ttrans_2:	cpi	tempreg1,'1'
		brcs	sload_ttrans_0
		cpi	tempreg1,'9'
		brcc	sload_ttrans_0
		subi	tempreg1,'1'
		ldi	ZL,0x0c
		ldi	ZH,0x90
		ldi	r17,12
		mul	r17,tempreg1
		add	ZH,r0
		lpm	r17,Z
		cpi	r17,'L'
		brne	sload_ttrans_o
		libmio_thistext
		.db 255,0x0d,0x0a,"Cannot overwrite loader !!!",0x0d,0x0a,0,0
		rjmp	sload_ttrans_0

sload_ttrans_o:	sts	libmio_lastmenu,tempreg1
		libmio_thistext
		.db 255,0x0c,"--> send file now ",0x0d,0x0a,0,0
		call	edit_lread		;read text into buffer
		call	mem_save		;save to flash
		rjmp	sload_ttrans

;-------------------------------------------------------------------------------
;show status
;-------------------------------------------------------------------------------
sload_plist:	ldi	r16,0			;first PRG
sload_plist_01:	libmio_thistext
		.db 255,"P",0,0
		ldi	tempreg1,0x31		;'1'
		add	tempreg1,r16
		libmio_sysput			;output program number
		libmio_thistext
		.db 255,": ",0
		ldi	ZH,0x90
		ldi	ZL,0x00
		ldi	r17,12
sload_plist_02:	mul	r17,r16
		add	ZH,r0
sload_plist_04:	lpm	tempreg1,Z+
		libmio_sysput
		dec	r17
		brne	sload_plist_04
		lpm	tempreg1,Z
		cpi	tempreg1,'N'
		brne	sload_plist_10
		libmio_thistext
		.db 255," BINARY ",0
		rjmp	sload_plist_90

sload_plist_10:	cpi	tempreg1,'L'
		brne	sload_plist_20
		libmio_thistext
		.db 255," LOADER ",0
		rjmp	sload_plist_90

sload_plist_20:	libmio_thistext
		.db 255," BASIC  ",0
		rjmp	sload_plist_90

sload_plist_90:	in	r17,GPIOR1
		swap	r17
		andi	r17,0x07
		cpi	r17,0x00
		breq	sload_plist_92
		dec	r17
		cp	r16,r17
		brne	sload_plist_92
		libmio_thistext
		.db 255,"(A)",0,0

sload_plist_92:	libmio_thistext
		.db 255,0x0d,0x0a,0x00
		inc	r16			;loop counter
		cpi	r16,8
		breq	sload_plist_99		;no loop
		rjmp	sload_plist_01		;loop
sload_plist_99:	
		libmio_thistext
		.db 255,0x0d,0x0a,"Space returns to main menu",0x0d,0x0a,0
		ret


sload_sertxt:	.db "9600 (2)",0,0			;mode 0
		.db "38k4 (2)",0,0			;mode 1
		.db "1200 (1)",0,0			;mode 2
		.db "2400 (1)",0,0			;mode 3
