;################################################################################
;#										#
;# mode 7 engine 40x24 text							#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.macro vchar0
		out	PORTC,tempreg1			;1 output pix 7
		mov	tempreg2,tempreg1		;1 copy for pix 3
		lsl	tempreg1			;1 prepare pix 6

		out	PORTC,tempreg1			;1 output pix 6
		lsl	tempreg1			;1 prepare pix 5
		swap	tempreg2			;1 prepare pix 3

		out	PORTC,tempreg1			;1 output pix 5
		lsl	tempreg1			;1 prepare pix 4

		out	PORTC,tempreg1			;1 output pix 4
		ld	ZL,X+				;2 get next char

		out	PORTC,tempreg2			;1 output pix 3
		lsl	tempreg2			;1 prepare pix 2
		swap	tempreg1			;1 prepare pix 0

		out	PORTC,tempreg2			;1 output pix 2
		lsl	tempreg2			;1 prepare pix 1
		bld	ZL,7				;1 set charset line 

		out	PORTC,tempreg2			;1 output pix 1
		ld	tempreg2,Z			;2 get next pixline

		out	PORTC,tempreg1			;1 output pix 0
.endm

.macro vchar1
		out	PORTC,tempreg2			;1 output pix 7
		mov	tempreg1,tempreg2		;1 copy for pix 3
		lsl	tempreg2			;1 prepare pix 6

		out	PORTC,tempreg2			;1 output pix 6
		lsl	tempreg2			;1 prepare pix 5
		swap	tempreg1			;1 prepare pix 3

		out	PORTC,tempreg2			;1 output pix 5
		lsl	tempreg2			;1 prepare pix 4

		out	PORTC,tempreg2			;1 output pix 4
		ld	ZL,X+				;2 get next char

		out	PORTC,tempreg1			;1 output pix 3
		lsl	tempreg1			;1 prepare pix 2
		swap	tempreg2			;1 prepare pix 0

		out	PORTC,tempreg1			;1 output pix 2
		lsl	tempreg1			;1 prepare pix 1
		bld	ZL,7				;1 set charset line 

		out	PORTC,tempreg1			;1 output pix 1
		ld	tempreg1,Z			;2 get next pixline

		out	PORTC,tempreg2			;1 output pix 0
.endm


.include	"/usr/local/include/avr/m644Pdef.inc"
.include	"../../system/includes/api_macros.inc"
.include	"../../system/includes/libdef.asm"
.include	"../../system/includes/definitions.asm"

.equ		libmio_ctable	= 0x7b00

.equ		lcd320_switch	= libmio_vram+1100
.equ		lcd320_cline	= libmio_vram+1101
.equ		lcd320_pline	= libmio_vram+1102
.equ		lcd320_rampos_l	= libmio_vram+1103
.equ		lcd320_rampos_h	= libmio_vram+1104
.equ		lcd320_smode	= libmio_vram+1105
.equ		lcd320_start	= libmio_vram+1106

.CSEG

.org	0x7200
;                   "......      N"
start:		.db "NOXMEML24*40N",0x93,0xa9,0x00

;icon def
		.db 0xf2,0xf1,0xf1,0xf3
		.db 0xf0,"LC",0xf0
		.db 0xf4,0xf1,0xf1,0xf5

.org	0x720e
		rjmp	inex			;input ext
		rjmp	outex			;output ext
		ret				;FKT 00 startup
		rjmp	vidmode_init		;FKT 01 init
		rjmp	vidmode_clear		;FKT 02 clear screen
		rjmp	vidmode_char		;FKT 03 output char
		rjmp	vidmode_gxy		;FKT 04 set cursor
		rjmp	vidmode_plot		;FKT 05 plot
		rjmp	vidmode_newl		;FKT 06 NL
		rjmp	vidmode_vid		;FKT 07 video display

;-------------------------------------------------------------------------------
; set cursor
;-------------------------------------------------------------------------------
vidmode_gxy:	movw	libmio_cur_x,XL
		ret

;-------------------------------------------------------------------------------
; input expansion
;-------------------------------------------------------------------------------
inex:		cpi	XH,0x09
		brne	inex_10

inex_01:	cpi	XL,0x00
		brne	inex_err
		lds	XL,lcd320_switch
		clr	XH
		ret

inex_err:	ldi	ereg,40			;no IO driver
		ret

inex_10:	cpi	XH,0x0a
		brne	inex_err
		mov	r17,XL
		mov	r16,XL
		swap	r16
		andi	r17,0x0f		;pixline
		cpi	r17,0x0a
		brcc	inex_err		;is beyond 9
		andi	r16,0x0f		;char
		ldi	XL,0x80			;pixline offset
		mul	XL,r17
		ldi	XH,0x07			;start of table
		ldi	XL,0x00			;user chars
		add	XL,r0			;add pixline offset
		adc	XH,r1
		add	XL,r16			;add char offset
		adc	XH,const_0
		ld	XL,X			;get pixline
		clr	XH
		ret

;-------------------------------------------------------------------------------
; output expansion
;-------------------------------------------------------------------------------
outex:		cpi	YH,9
		brne	outex_10

outex_02:	cpi	YL,0x00
		brne	outex_err
		api_sync
		sts	lcd320_pline,const_0	;2 init counters
		sts	lcd320_cline,const_0	;2
		sts	lcd320_start,const_0	;2 startup counter
		sts	lcd320_switch,XL
		ldi	XL,LOW(libmio_vram)
		sts	lcd320_rampos_l,XL	;store new RAM pos
		ldi	XL,HIGH(libmio_vram)
		sts	lcd320_rampos_h,XL
		ret

outex_err:	ldi	ereg,40			;no IO driver
		ret

outex_10:	cpi	YH,0x0a
		brne	inex_err
		mov	r17,YL
		mov	r16,YL
		swap	r16
		andi	r17,0x0f		;pixline
		cpi	r17,0x0a
		brcc	outex_err		;is beyond 9
		andi	r16,0x0f		;char
		ldi	YL,0x80			;pixline offset
		mul	YL,r17
		ldi	YH,0x07			;start of table
		ldi	YL,0x00			;user chars
		add	YL,r0			;add pixline offset
		adc	YH,r1
		add	YL,r16			;add char offset
		adc	YH,const_0
		st	Y,XL			;store pixline
		ret


;-------------------------------------------------------------------------------
; init mode
;-------------------------------------------------------------------------------
vidmode_init:	brtc	vidmode_exit		;exit
		ldi	XL,0			;all zero
		out	PORTA,XL
		ldi	XL,0xff			;all output
		out	DDRA,XL
		ldi	XL,0
		out	PORTC,XL
		ldi	XL,0x80			;enable only green
		out	DDRC,XL
		sbi	PORTB,2
		sbi	DDRB,2
		rcall	vidmode_cset		;copy charset from PRG7
		rcall	vidmode_clear
		sts	lcd320_switch,const_0	;CRT
		ldi	XL,50
		sts	libmio_clipx2,XL
		sts	libmio_clipy2,XL
		ldi	XL,0			;visible lines (all)
		ret

vidmode_exit:	push	XL
		ldi	XL,0			;enable all video outputs
		out	PORTC,XL
		ldi	XL,0xff			;all output
		out	DDRA,XL
		ldi	XL,0x10
		out	PORTA,XL
		ldi	XL,0xf0
		out	DDRC,XL
		pop	XL
		sbi	PORTB,2			;disable VEE
		ret

;-------------------------------------------------------------------------------
; copy charset from PRG7
;-------------------------------------------------------------------------------
vidmode_cset:	api_pushxyz
		lsl	ZH,prg_font
		lsl	ZH
		inc	ZH
		ldi	ZL,0
		ldi	YH,0x07
		ldi	YL,0x00
		ldi	XH,10			;10 lines
vidmode_cset_1:	ldi	XL,128			;chars per set
vidmode_cset_2:	lpm	r0,Z+
		st	Y+,r0
		dec	XL
		brne	vidmode_cset_2
		adiw	ZL,32			;skip next 128 chars
		adiw	ZL,32
		adiw	ZL,32
		adiw	ZL,32
		dec	XH
		brne	vidmode_cset_1
		api_popxyz

;-------------------------------------------------------------------------------
; clear screen
;-------------------------------------------------------------------------------
vidmode_clear:	lds	ZL,libmio_color
		clr	ZH
		sbrs	ZL,1
		ldi	ZH,0xff
		ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	XH,LOW(24)
		ldi	tempreg1,0x20
vidmode_clear1:	ldi	XL,5
vidmode_clear2:	st	Y+,ZH			;attr
		dec	XL
		brne	vidmode_clear2
		ldi	XL,40
vidmode_clear3:	st	Y+,tempreg1		;chars
		dec	XL
		brne	vidmode_clear3
		dec	XH
		brne	vidmode_clear1
vidmode_ret:	ret

vidmode_novid:	set			;sync
		ret

;-------------------------------------------------------------------------------
; video output (24 lines a 40 chars)
;-------------------------------------------------------------------------------
vidmode_vid:	lds	XL,lcd320_switch	;CRT/LCD
		sbrc	XL,0
		rjmp	vidmode_lcd
		sbrc	vline_h,0
		rjmp	vidmode_novid
		mov	XL,vline_l
		cpi	XL,241
		brcc	vidmode_novid

;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------
vid_iss:	lds	XL,TCNT1L		;1 get timer
		cpi	XL,libmio_hstart+83 	;1
		brcs	vid_iss			;1 loop
vid_iss_01:	cpi	XL,libmio_hstart+84
		brcs	vid_iss_02
vid_iss_02:	cpi	XL,libmio_hstart+85
		brcs	vid_iss_03
vid_iss_03:	cpi	XL,libmio_hstart+86
		brcs	vid_iss_03a
vid_iss_03a:	cpi	XL,libmio_hstart+87
		brcs	vid_iss_04
vid_iss_04:

		lds	XL,libmio_rampos_l
		lds	XH,libmio_rampos_h
		ldi	ZH,0x07			;start of table
		lds	ZL,libmio_cline
		bst	ZL,0
		lsr	ZL
		add	ZH,ZL
		ld	YL,X+			;get attributes
		ld	YH,X+
		ld	tempreg3,X+
		ld	r0,X+
		ld	r1,X+

		ld	ZL,X+			;get char 1
		bld	ZL,7			;set bit 7 to cline lsb
		ld	tempreg1,Z		;get pixline
;char 0..7
		sbrc	YL,0
		com	tempreg1
		vchar0
		sbrc	YL,1
		com	tempreg2
		vchar1
		sbrc	YL,2
		com	tempreg1
		vchar0
		sbrc	YL,3
		com	tempreg2
		vchar1
		sbrc	YL,4
		com	tempreg1
		vchar0
		sbrc	YL,5
		com	tempreg2
		vchar1
		sbrc	YL,6
		com	tempreg1
		vchar0
		sbrc	YL,7
		com	tempreg2
		vchar1

;char 8..15
		sbrc	YH,0
		com	tempreg1
		vchar0
		sbrc	YH,1
		com	tempreg2
		vchar1
		sbrc	YH,2
		com	tempreg1
		vchar0
		sbrc	YH,3
		com	tempreg2
		vchar1
		sbrc	YH,4
		com	tempreg1
		vchar0
		sbrc	YH,5
		com	tempreg2
		vchar1
		sbrc	YH,6
		com	tempreg1
		vchar0
		sbrc	YH,7
		com	tempreg2
		vchar1

;char 16..23
		sbrc	tempreg3,0
		com	tempreg1
		vchar0
		sbrc	tempreg3,1
		com	tempreg2
		vchar1
		sbrc	tempreg3,2
		com	tempreg1
		vchar0
		sbrc	tempreg3,3
		com	tempreg2
		vchar1
		sbrc	tempreg3,4
		com	tempreg1
		vchar0
		sbrc	tempreg3,5
		com	tempreg2
		vchar1
		sbrc	tempreg3,6
		com	tempreg1
		vchar0
		sbrc	tempreg3,7
		com	tempreg2
		vchar1


;char 24..31
		sbrc	r0,0
		com	tempreg1
		vchar0
		sbrc	r0,1
		com	tempreg2
		vchar1
		sbrc	r0,2
		com	tempreg1
		vchar0
		sbrc	r0,3
		com	tempreg2
		vchar1
		sbrc	r0,4
		com	tempreg1
		vchar0
		sbrc	r0,5
		com	tempreg2
		vchar1
		sbrc	r0,6
		com	tempreg1
		vchar0
		sbrc	r0,7
		com	tempreg2
		vchar1

;char 32..39
		sbrc	r1,0
		com	tempreg1
		vchar0
		sbrc	r1,1
		com	tempreg2
		vchar1
		sbrc	r1,2
		com	tempreg1
		vchar0
		sbrc	r1,3
		com	tempreg2
		vchar1
		sbrc	r1,4
		com	tempreg1
		vchar0
		sbrc	r1,5
		com	tempreg2
		vchar1
		sbrc	r1,6
		com	tempreg1
		vchar0
		sbrc	r1,7
		com	tempreg2
		vchar1

		lds	tempreg3,libmio_border
		out	PORTC,tempreg3
		ld	ZL,-X
		lds	ZL,libmio_cline
		inc	ZL
		cpi	ZL,10
		brne	vidmode_vid1
		clr	ZL
		sts	libmio_rampos_l,XL
		sts	libmio_rampos_h,XH
vidmode_vid1:	sts	libmio_cline,ZL
		sbi	PORTB,2			;disable VEE
		clt
		ret				;no sync


;-------------------------------------------------------------------------------
; LCD output
;-------------------------------------------------------------------------------
vidmode_lcd:	push	tempreg4
		push	r16
		ldi	tempreg4,0x80
		lds	XL,lcd320_rampos_l	;RAM pointer
		lds	XH,lcd320_rampos_h
		ldi	ZH,0x07			;start of charset
		lds	ZL,lcd320_pline		;recent pixline
		bst	ZL,0			;LSB of cline -> T
		lsr	ZL
		add	ZH,ZL
;get attribute bytes
		ld	YL,X+			;char 0..7
		ld	YH,X+
		ld	tempreg3,X+
		ld	r0,X+
		ld	r1,X+

;char 0..7
lcd320_int_2:	ldi	r16,8			;1 chars per block
lcd320_bk0:	ld	ZL,X+			;2 get char
		bld	ZL,7			;1 set bit 7 to cline lsb
		ld	tempreg1,Z		;2 get pixline
		lsr	YL			;1 attr bit
		brcc	lcd320_bk0_1		;1
		com	tempreg1		;1
lcd320_bk0_1:	mov	ZL,tempreg1		;1 copy value
		swap	ZL			;1
		andi	ZL,0x0f			;1
		out	PORTA,ZL		;1 first nibble
		out	PINA,tempreg4		;1 CP
		andi	tempreg1,0x0f		;1
		out	PINA,tempreg4		;1 /CP
		out	PORTA,tempreg1		;1 second nibble
		out	PINA,tempreg4		;1 CP
		dec	r16			;1 loop counter
		out	PINA,tempreg4		;1 /CP
		brne	lcd320_bk0		;2 loop

;char 8..15
		ldi	r16,8			;1 chars per block
lcd320_bk1:	ld	ZL,X+			;2 get char
		bld	ZL,7			;1 set bit 7 to cline lsb
		ld	tempreg1,Z		;2 get pixline
		lsr	YH			;1 attr bit
		brcc	lcd320_bk1_1		;1
		com	tempreg1		;1
lcd320_bk1_1:	mov	ZL,tempreg1		;1 copy value
		swap	ZL			;1
		andi	ZL,0x0f			;1
		out	PORTA,ZL		;1 first nibble
		out	PINA,tempreg4		;1 CP
		andi	tempreg1,0x0f		;1
		out	PINA,tempreg4		;1 /CP
		out	PORTA,tempreg1		;1 second nibble
		out	PINA,tempreg4		;1 CP
		dec	r16			;1 loop counter
		out	PINA,tempreg4		;1 /CP
		brne	lcd320_bk1

;char 16..23
		ldi	r16,8			;1 chars per block
lcd320_bk2:	ld	ZL,X+			;2 get char
		bld	ZL,7			;1 set bit 7 to cline lsb
		ld	tempreg1,Z		;2 get pixline
		lsr	tempreg3		;1 attr bit
		brcc	lcd320_bk2_1		;1
		com	tempreg1		;1
lcd320_bk2_1:	mov	ZL,tempreg1		;1 copy value
		swap	ZL			;1
		andi	ZL,0x0f			;1
		out	PORTA,ZL		;1 first nibble
		out	PINA,tempreg4		;1 CP
		andi	tempreg1,0x0f		;1
		out	PINA,tempreg4		;1 /CP
		out	PORTA,tempreg1		;1 second nibble
		out	PINA,tempreg4		;1 CP
		dec	r16			;1 loop counter
		out	PINA,tempreg4		;1 /CP
		brne	lcd320_bk2

;char 24..31
		ldi	r16,8			;1 chars per block
lcd320_bk3:	ld	ZL,X+			;2 get char
		bld	ZL,7			;1 set bit 7 to cline lsb
		ld	tempreg1,Z		;2 get pixline
		lsr	r0			;1 attr bit
		brcc	lcd320_bk3_1		;1
		com	tempreg1		;1
lcd320_bk3_1:	mov	ZL,tempreg1		;1 copy value
		swap	ZL			;1
		andi	ZL,0x0f			;1
		out	PORTA,ZL		;1 first nibble
		out	PINA,tempreg4		;1 CP
		andi	tempreg1,0x0f		;1
		out	PINA,tempreg4		;1 /CP
		out	PORTA,tempreg1		;1 second nibble
		out	PINA,tempreg4		;1 CP
		dec	r16			;1 loop counter
		out	PINA,tempreg4		;1 /CP
		brne	lcd320_bk3

;char 32..39
		ldi	r16,8			;1 chars per block
lcd320_bk4:	ld	ZL,X+			;2 get char
		bld	ZL,7			;1 set bit 7 to cline lsb
		ld	tempreg1,Z		;2 get pixline
		lsr	r1			;1 attr bit
		brcc	lcd320_bk4_1		;1
		com	tempreg1		;1
lcd320_bk4_1:	mov	ZL,tempreg1		;1 copy value
		swap	ZL			;1
		andi	ZL,0x0f			;1
		out	PORTA,ZL		;1 first nibble
		out	PINA,tempreg4		;1 CP
		andi	tempreg1,0x0f		;1
		out	PINA,tempreg4		;1 /CP
		out	PORTA,tempreg1		;1 second nibble
		out	PINA,tempreg4		;1 CP
		dec	r16			;1 loop counter
		out	PINA,tempreg4		;1 /CP
		brne	lcd320_bk4

lcd320_int_x:	pop	r16
		pop	tempreg4
		lds	tempreg1,lcd320_pline	;2 pixel line
		lds	tempreg2,lcd320_cline	;2 character line
;		rjmp	lcd320_int_te		;debug

		mov	tempreg3,tempreg1	;check for first for FLM
		or	tempreg3,tempreg2
		brne	lcd320_int_4
		sbi	PORTA,5			;FLM
lcd320_int_4:	sbi	PORTA,6			;LD
		cbi	PORTA,6
		cbi	PORTA,5

;set counters to next pixline
		inc	tempreg1		;1 pline +1
		cpi	tempreg1,10		;1 max
		brcs	lcd320_int_10		;1/2
		clr	tempreg1		;1 pixline=0
		inc	tempreg2		;1 cline + 1
		cpi	tempreg2,24		;1
		brcs	lcd320_int_08		;1/2
		clr	tempreg2		;1
		ldi	XL,LOW(libmio_vram)	;set ptr to start
		ldi	XH,HIGH(libmio_vram)
		cbi	PORTB,2			;enable VEE
lcd320_int_08:	sts	lcd320_rampos_l,XL	;store new RAM pos
		sts	lcd320_rampos_h,XH
lcd320_int_10:	sts	lcd320_pline,tempreg1	;2 new counters
		sts	lcd320_cline,tempreg2	;2


lcd320_int_te:	ldi	YL,LOW(libmio_ram)
		ldi	YH,HIGH(libmio_ram)
		in	ZL,GPIOR2
		sbrc	vline_h,0
		rjmp	lcd320_sync
		mov	XL,vline_l
		cpi	XL,240
		brcc	lcd320_sync
		clt				;disable sync
		ret

lcd320_sync:	set				;enable sync
		ret

;-------------------------------------------------------------------------------
; plot  XL=X XH=Y
;-------------------------------------------------------------------------------
vidmode_plot:	api_pushregs
		push	libmio_cur_x
		push	libmio_cur_y
		cpi	XL,80			;max X +1
		brcc	plot_os			;off screen
		cpi	XH,48			;max Y +1
		brcc	plot_os			;off screen

plot_0:		ldi	tempreg2,1		;bit left top
		sbrc	XH,0
		lsl	tempreg2
		sbrc	XH,0
		lsl	tempreg2
		sbrc	XL,0
		lsl	tempreg2		;tempreg2 = bitmask
		lsr	XH			;Y/2
		lsr	XL			;X/2
		movw	libmio_cur_x,XL		;this position

		lds	YH,libmio_color
		sbrs	YH,1
		rjmp	plot_r

		rcall	rdata			;get data
		or	tempreg1,tempreg2	;set pix
plot_e:		rcall	wdata

plot_os:	pop	libmio_cur_y
		pop	libmio_cur_x
		api_popregs

plot_r:		rcall	rdata
		com	tempreg2
		and	tempreg1,tempreg2		;clear pix
		rjmp	plot_e


;-------------------------------------------------------------------------------
; output a single char
;-------------------------------------------------------------------------------
vidmode_newl:	api_pushxyz
		movw	XL,libmio_cur_x
		rjmp	libmio_chr_nl
vidmode_char:	api_pushxyz
		movw	XL,libmio_cur_x
		sbrc	ctrl,6
		rjmp	bigchar
		cpi	XL,40
		brcc	vidmode_chr_os		;out of screen
		cpi	XH,24
		brcc	vidmode_chr_os		;out of screen
		lds	YL,libmio_color
		com	YL
		bst	YL,1
		rcall	wdata_1
;move cursor
libmio_chr_m:	movw	XL,libmio_cur_x
		inc	XL
		cpi	XL,40
		brcs	vidmode_chr_m1
libmio_chr_nl:	clr	XL
		inc	XH
		cpi	XH,24
		brcs	vidmode_chr_m1
		in	ZL,GPIOR2		;scrollmode
		sbrs	ZL,7
		rjmp	lcd320_scroll
		clr	XH			;WRAP
vidmode_chr_m1:	movw	libmio_cur_x,XL
vidmode_chr_os:	api_popxyz

lcd320_scroll:	rcall	scroll_up
		ldi	XL,0
		ldi	XH,23
		rjmp	vidmode_chr_m1


;-------------------------------------------------------------------------------
; scroll up
;-------------------------------------------------------------------------------
scroll_up:	ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	ZL,LOW(libmio_vram+45)
		ldi	ZH,HIGH(libmio_vram+45)
		ldi	XH,23
scroll0:	ldi	XL,45
scroll1:	ld	r0,Z+
		st	Y+,r0
		dec	XL
		brne	scroll1
		dec	XH
		brne	scroll0
		lds	ZL,libmio_color
		clr	ZH
		sbrs	ZL,1
		ldi	ZH,0xff
		ldi	XL,5
scroll2:	st	Y+,ZH
		dec	XL
		brne	scroll2
		ldi	XH,0x20			;space
		ldi	XL,40
scroll3:	st	Y+,XH
		dec	XL
		brne	scroll3
		ret

bigchar_no:	api_popxyz			;no print

bigchar:	brts	bigchar_no		;NL ist not supported
		cpi	XL,77
		brcc	bigchar_no
		cpi	XH,43
		brcc	bigchar_no
		push	tempreg5		;byte 1
		push	tempreg6		;byte 2
		push 	tempreg7		;byte 3
		push	tempreg8		;for stroring T-bit
		bld	tempreg8,0		;store T
		push	tempreg2		;temp value
		push	tempreg4

bigchar_0:	mov	ZL,tempreg1		;char
		ldi	ZH,HIGH(libmio_ctable*2)	;start char ROM
		ldi	tempreg4,5		;10 char lines

bigchar_1:	clr	tempreg2		;clear temp value

		lpm	XL,Z			;get pixel line
		sbrc	XL,7			;pixel 0
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg5,0
		sbrc	XL,6
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg5,1
		sbrc	XL,5
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg6,0
		sbrc	XL,4
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg6,1
		sbrc	XL,3
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg7,0
		sbrc	XL,2
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg7,1

		inc	ZH			;next line
		clr	tempreg2		;clear temp value

		lpm	XL,Z			;get pixel line
		sbrc	XL,7			;pixel 0
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg5,2
		sbrc	XL,6
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg5,3
		sbrc	XL,5
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg6,2
		sbrc	XL,4
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg6,3
		sbrc	XL,3
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg7,2
		sbrc	XL,2
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg7,3
		inc	ZH

bigchar_d:	push	ZH
		push	ZL
		lds	tempreg2,libmio_color
		movw	XL,libmio_cur_x
		mov	tempreg1,tempreg5	;char1
		sbrs	tempreg2,1
		com	tempreg1
		rcall	wdata
		inc	XL
		mov	tempreg1,tempreg6	;char2
		sbrs	tempreg2,1
		com	tempreg1
		rcall	wdata
		inc	XL
		mov	tempreg1,tempreg7	;char2
		sbrs	tempreg2,1
		com	tempreg1
		rcall	wdata
		subi	XL,2
		inc	XH
		movw	libmio_cur_x,XL
		pop	ZL
		pop	ZH
		dec	tempreg4
		brne	bigchar_1x
		subi	XL,0xfd
		subi	XH,0x05
		movw	libmio_cur_x,XL

bigchar_e:	pop	tempreg4
		pop	tempreg2
		bst	tempreg8,0		;restore T
		pop	tempreg8
		pop	tempreg7
		pop	tempreg6
		pop	tempreg5
		rjmp	bigchar_no

bigchar_1x:	rjmp	bigchar_1
;-------------------------------------------------------------------------------
;char schreiben mit attr
;wdata for plot etc.
;wdata_1 - T=invert flag
;-------------------------------------------------------------------------------
wdata:		bst	tempreg1,3		;the inv bit
		sbrc	tempreg1,3
		com	tempreg1
		andi	tempreg1,0x07
		ori	tempreg1,0x10
wdata_1:	ldi	YL,LOW(libmio_vram+5)
		ldi	YH,HIGH(libmio_vram+5)
		ldi	ZL,45
		mul	ZL,XH
		add	YL,r0
		adc	YH,r1
		add	YL,XL
		adc	YH,const_0		;Y is now char pos
		st	Y,tempreg1		;store char

		ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	ZL,45
		mul	ZL,XH
		add	YL,r0
		adc	YH,r1
		mov	ZL,XL
		lsr	ZL
		lsr	ZL
		lsr	ZL
		add	YL,ZL			;byte offset
		adc	YH,const_0		;Y is now attr pos
		ld	tempreg1,Y		;get attr byte
		mov	ZL,XL
		andi	ZL,0x07
		ldi	ZH,0x01			;mask for char 0
wdata_2:	subi	ZL,1
		brcs	wdata_3
		lsl	ZH
		rjmp	wdata_2
wdata_3:	brtc	wdata_4
		or	tempreg1,ZH
		st	Y,tempreg1
		ret
wdata_4:	com	ZH
		and	tempreg1,ZH
		st	Y,tempreg1
		ret

;-------------------------------------------------------------------------------
;plot-char lesen mit
;rdata for plot etc.
;XH:XL = coords, tempreg1=char
;-------------------------------------------------------------------------------
rdata:		ldi	YL,LOW(libmio_vram+5)
		ldi	YH,HIGH(libmio_vram+5)
		ldi	ZL,45
		mul	ZL,XH
		add	YL,r0
		adc	YH,r1
		add	YL,XL
		adc	YH,const_0		;Y is now char pos
		ld	tempreg1,Y		;get char

		ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	ZL,45
		mul	ZL,XH
		add	YL,r0
		adc	YH,r1
		mov	ZL,XL
		lsr	ZL
		lsr	ZL
		lsr	ZL
		add	YL,ZL			;byte offset
		adc	YH,const_0		;Y is now attr pos
		ld	YL,Y			;get attr byte
		mov	ZL,XL
		andi	ZL,0x07
rdata_1:	cpi	ZL,0
		breq	rdata_2
		lsr	YL
		dec	ZL
		rjmp	rdata_1
rdata_2:	sbrc	YL,0
		com	tempreg1
		bst	YL,0
		andi	tempreg1,0x07		;mask bits
		bld	tempreg1,3
		ret
