;################################################################################
;#										#
;# mode 7 engine Y*X text (generic text out)					#
;# copyright (c) 2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################



;-------------------------------------------------------------------------------
; plot  XL=X XH=Y
;-------------------------------------------------------------------------------
vidmode_plot:	api_pushregs
		push	libmio_cur_x
		push	libmio_cur_y
		cpi	XL,vidmode_cols*2	;max X +1
		brcc	plot_os			;off screen
		cpi	XH,vidmode_rows*2		;max Y +1
		brcc	plot_os			;off screen

plot_0:		ldi	tempreg2,1		;bit left top
		sbrc	XH,0
		lsl	tempreg2
		sbrc	XH,0
		lsl	tempreg2
		sbrc	XL,0
		lsl	tempreg2		;tempreg2 = bitmask
		lsr	XH			;Y/2
		lsr	XL			;X/2

		ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	ZL,vidmode_cols
		mul	ZL,XH
		add	YL,r0
		adc	YH,r1
		add	YL,XL
		adc	YH,const_0		;Y is now char pos
		ld	tempreg1,Y		;get char
		andi	tempreg1,0x0f

		lds	ZH,libmio_color
		sbrs	ZH,1
		rjmp	plot_r

		or	tempreg1,tempreg2	;set pix
plot_e:		st	Y,tempreg1

plot_os:	pop	libmio_cur_y
		pop	libmio_cur_x
		api_popregs

plot_r:		com	tempreg2
		and	tempreg1,tempreg2		;clear pix
		rjmp	plot_e


;-------------------------------------------------------------------------------
; output a single char
;-------------------------------------------------------------------------------
vidmode_newl:	api_pushxyz
		movw	XL,libmio_cur_x
		rjmp	libmio_chr_nl

vidmode_char:	api_pushxyz
		movw	XL,libmio_cur_x
		sbrc	ctrl,6
		rjmp	bigchar
		cpi	XL,vidmode_cols
		brcc	vidmode_chr_os		;out of screen
		cpi	XH,vidmode_rows
		brcc	vidmode_chr_os		;out of screen

		ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	ZL,vidmode_cols
		mul	ZL,XH
		add	YL,r0
		adc	YH,r1
		add	YL,XL
		adc	YH,const_0		;Y is now char pos
		lds	ZH,libmio_color
		mov	ZL,tempreg1
		sbrs	ZH,1
		subi	ZL,0x80
		st	Y,ZL			;store char

;move cursor
libmio_chr_m:	movw	XL,libmio_cur_x
		inc	XL
		cpi	XL,vidmode_cols
		brcs	vidmode_chr_m1
libmio_chr_nl:	clr	XL
		inc	XH
		cpi	XH,vidmode_rows
		brcs	vidmode_chr_m1
		in	ZL,GPIOR2		;scrollmode
		sbrs	ZL,7
		rjmp	vidmode_scroll
		clr	XH			;WRAP
vidmode_chr_m1:	movw	libmio_cur_x,XL
vidmode_chr_os:	api_popxyz

vidmode_scroll:	ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	ZL,LOW(libmio_vram+vidmode_cols)
		ldi	ZH,HIGH(libmio_vram+vidmode_cols)
		ldi	XH,vidmode_rows-1
scroll0:	ldi	XL,vidmode_cols
scroll1:	ld	r0,Z+
		st	Y+,r0
		dec	XL
		brne	scroll1
		dec	XH
		brne	scroll0
		lds	ZL,libmio_color
		ldi	ZH,0x20
		sbrs	ZL,1
		ldi	ZH,0xA0
		ldi	XL,vidmode_cols
scroll2:	st	Y+,ZH
		dec	XL
		brne	scroll2
		ldi	XL,0
		ldi	XH,23
		rjmp	vidmode_chr_m1


;-------------------------------------------------------------------------------
; output a big char
;-------------------------------------------------------------------------------
bigchar_no:	api_popxyz			;no print

bigchar:	cpi	XL,vidmode_cols*2-3
		brcc	bigchar_no
		cpi	XH,vidmode_rows*2-5
		brcc	bigchar_no
		push	tempreg5		;byte 1
		push	tempreg6		;byte 2
		push	tempreg7		;byte 3
		push	tempreg8		;for storing T-bit
		bld	tempreg8,0		;store T
		push	tempreg2		;temp value
		push	tempreg4

bigchar_0:	mov	ZL,tempreg1			;char
		ldi	ZH,HIGH(libmio_ctable*2)	;start char ROM (system only)
		ldi	tempreg4,5		;10 char lines

bigchar_1:	clr	tempreg2		;clear temp value

		lpm	XL,Z			;get pixel line
		sbrc	XL,7			;pixel 0
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg5,0
		sbrc	XL,6
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg5,1
		sbrc	XL,5
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg6,0
		sbrc	XL,4
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg6,1
		sbrc	XL,3
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg7,0
		sbrc	XL,2
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg7,1

		inc	ZH			;next line
		clr	tempreg2		;clear temp value

		lpm	XL,Z			;get pixel line
		sbrc	XL,7			;pixel 0
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg5,2
		sbrc	XL,6
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg5,3
		sbrc	XL,5
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg6,2
		sbrc	XL,4
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg6,3
		sbrc	XL,3
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg7,2
		sbrc	XL,2
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg7,3
		inc	ZH

bigchar_d:	push	ZH
		push	ZL
		lds	tempreg2,libmio_color
		movw	XL,libmio_cur_x
		ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	ZL,vidmode_cols
		mul	ZL,XH
		add	YL,r0
		adc	YH,r1
		add	YL,XL
		adc	YH,const_0		;Y is now char pos
		mov	tempreg1,tempreg5	;char1
		andi	tempreg1,0x0f
		sbrs	tempreg2,1
		subi	tempreg1,0x80
		st	Y+,tempreg1
		inc	XL
		mov	tempreg1,tempreg6	;char2
		andi	tempreg1,0x0f
		sbrs	tempreg2,1
		subi	tempreg1,0x80
		st	Y+,tempreg1
		inc	XL
		mov	tempreg1,tempreg7	;char2
		andi	tempreg1,0x0f
		sbrs	tempreg2,1
		subi	tempreg1,0x80
		st	Y+,tempreg1
		subi	XL,2
		inc	XH
		movw	libmio_cur_x,XL
		pop	ZL
		pop	ZH
		dec	tempreg4
		brne	bigchar_1x
		subi	XL,0xfd
		subi	XH,0x05
		movw	libmio_cur_x,XL

bigchar_e:	pop	tempreg4
		pop	tempreg2
		bst	tempreg8,0		;restore T
		pop	tempreg8
		pop	tempreg7
		pop	tempreg6
		pop	tempreg5
		rjmp	bigchar_no

bigchar_1x:	rjmp	bigchar_1

;-------------------------------------------------------------------------------
; clear screen
;-------------------------------------------------------------------------------
vidmode_clear:	lds	ZL,libmio_color
		ldi	tempreg1,0x20
		sbrc	ZL,1
		ldi	tempreg1,0xa0
		ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	XH,vidmode_rows
		ldi	tempreg1,0x20
vidmode_clear1:ldi	XL,vidmode_cols
vidmode_clear2:	st	Y+,tempreg1		;chars
		dec	XL
		brne	vidmode_clear2
		dec	XH
		brne	vidmode_clear1
		mov	libmio_cur_x,const_0
		mov	libmio_cur_y,const_0
		ret

