;################################################################################
;#										#
;# mode 7 engine (8 channel PWM)						#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.include	"/usr/local/include/avr/m644Pdef.inc"
.include	"../../system/includes/api_macros.inc"
.include	"../../system/includes/libdef.asm"
.include	"../../system/includes/definitions.asm"

.equ		libmio_palette	= 0x0100		;palette
.equ		bas_mta		= 0x0110		;basic multitasking
.equ		libmio_etable	= 0x4680		;envelope table
.equ		libmio_ctable	= 0x7b00		;chartable font 0

.CSEG

.org	0x7200
;                   "......      N"  
start:		.db " PWM   4x8  N",0xb3,0xfe,0xb0

;icon def
		.db 0xf2,0xf1,0xf1,0xf3
		.db 0xf0,0x8d,0x8d,0xf0
		.db 0xf4,0xf1,0xf1,0xf5

.org	0x720e
		rjmp	inex			;input ext
		rjmp	outex			;output ext
		ret				;FKT 00
		rjmp	pwm4x8_init		;FKT 01 init
		rjmp	pwm4x8_cls		;FKT 02 clear screen
		rjmp	pwm4x8_char		;FKT 03 output char
		rjmp	pwm4x8_gxy		;FKT 04 set cursor
		rjmp	pwm4x8_plot		;FKT 05 plot
		rjmp	pwm4x8_nl		;FKT 06 newline
		rjmp	pwm4x8_vid		;FKT 07 video display
		ret

;-------------------------------------------------------------------------------
; use video mode 0 routines
;-------------------------------------------------------------------------------
pwm4x8_cls:	api_vm0cls

pwm4x8_char:	api_vm0char

pwm4x8_nl:	api_vm0newline

pwm4x8_gxy:	api_vm0gotoxy

pwm4x8_plot:	api_vm0plot

;-------------------------------------------------------------------------------
; i/o
;-------------------------------------------------------------------------------

.include	"inout.asm"

;-------------------------------------------------------------------------------
; init mode
;-------------------------------------------------------------------------------
pwm4x8_init:	brtc	pwm4x8_exit		;exit
		cbi	PORTA,4
		cbi	PORTA,5
		cbi	PORTA,6
		cbi	PORTA,7
		sbi	DDRA,4
		sbi	DDRA,5
		sbi	DDRA,6
		sbi	DDRA,7
		rcall	pwm_cls
		rcall	pwm4x8_clear
		ldi	XL,0			;force ext routine
		ret

pwm4x8_exit:	cbi	PORTA,4			;set to zero
		cbi	PORTA,5
		cbi	PORTA,6
		cbi	PORTA,7
		ret

;-------------------------------------------------------------------------------
; clear screen
;-------------------------------------------------------------------------------
pwm_cls:	ldi	tempreg1,0x20		;space
		ldi	YH,HIGH(libmio_vram)	;home position
		ldi	YL,LOW(libmio_vram)	;home position
		ldi	XL,libmio_rows
pwm_cls_01:	ldi	XH,libmio_cols
pwm_cls_02:	st	Y+,tempreg1		;write to RAM
		dec	XH			;decrement counter
		brne	pwm_cls_02		;loop
		dec	XL			;decrement counter
		brne	pwm_cls_01		;loop
		lds	tempreg1,libmio_color
		ldi	XL,libmio_rows
pwm_cls_05:	ldi	XH,libmio_cols
pwm_cls_06:	st	Y+,tempreg1		;write to RAM
		dec	XH			;decrement counter
		brne	pwm_cls_06		;loop
		dec	XL			;decrement counter
		brne	pwm_cls_05		;loop
		ret

;-------------------------------------------------------------------------------
; clear pwm data
;-------------------------------------------------------------------------------
pwm4x8_clear:	ldi	XL,LOW(libmio_vram+2000)
		ldi	XH,HIGH(libmio_vram+2000)
		ldi	tempreg1,16
pwm4x8_clear1:	st	X+,const_0
		dec	tempreg1
		brne	pwm4x8_clear1
		ldi	tempreg1,8
		ldi	tempreg2,0x00
pwm4x8_clear2:	st	X+,tempreg2
		subi	tempreg2,0xe0			;+0x20
		dec	tempreg1
		brne	pwm4x8_clear2
		ret

;-------------------------------------------------------------------------------
; reduced video output (23 lines a 24 chars)
;-------------------------------------------------------------------------------
pwm4x8_vid:	in	XL,PORTA			;current value
		andi	XL,0x0f
		lds	tempreg1,libmio_vram+2028	;output value
		andi	tempreg1,0xf0
		or	tempreg1,XL
		out	PORTA,tempreg1			;out

;-------------------------------------------------------------------------------
; set pointer for code saving
;-------------------------------------------------------------------------------
		mov	XL,vline_l
		sbrc	vline_h,0
		rjmp	pwm4x8_novid
		cpi	XL,235
		brcc	pwm4x8_novid
		cpi	XL,5
		brcs	pwm4x8_novid

;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------
pwm4x8_stc_00:	lds	XL,TCNT1L		;1 get timer
		cpi	XL,libmio_hstart+93 	;1
		brcs	pwm4x8_stc_00		;1 loop
pwm4x8_stc_01:	cpi	XL,libmio_hstart+94
		brcs	pwm4x8_stc_02
pwm4x8_stc_02:	cpi	XL,libmio_hstart+95
		brcs	pwm4x8_stc_03
pwm4x8_stc_03:	cpi	XL,libmio_hstart+96
		brcs	pwm4x8_stc_04
pwm4x8_stc_04:	cpi	XL,libmio_hstart+97
		brcs	pwm4x8_stc_05

pwm4x8_stc_05:	rcall	pwm4x8_tvc
		clt					;disable sync
		rjmp	pwm4x8_pwm

pwm4x8_novid:	set					;enable sync
		rjmp	pwm4x8_pwm

;channel 4
pwm4x8_pwm:	lds	XL,libmio_vram+2020		;counter for channel 1
		inc	XL				;+1
		cpi	XL,0xff				;end
		brne	pwm4x8_pwm_41			;no zero
		lds	XH,libmio_vram+2000		;get control value
		sts	libmio_vram+2012,XH		;write to compare register
		ldi	XL,0x00				;set counter
		ori	tempreg1,0x10			;set channel 1
pwm4x8_pwm_41:	sts	libmio_vram+2020,XL		;store counter

		lds	YL,libmio_vram+2012		;get compare register
		cp	YL,XL				;compare
		brne	pwm4x8_pwm_50			;not equal
		andi	tempreg1,0xef			;clear channel 1

;channel 5
pwm4x8_pwm_50:	lds	XL,libmio_vram+2021		;counter for channel 1
		inc	XL				;+1
		cpi	XL,0xff				;end
		brne	pwm4x8_pwm_51			;no zero
		lds	XH,libmio_vram+2001		;get control value
		sts	libmio_vram+2013,XH		;write to compare register
		ldi	XL,0x00				;set counter
		ori	tempreg1,0x20			;set channel 1
pwm4x8_pwm_51:	sts	libmio_vram+2021,XL		;store counter

		lds	YL,libmio_vram+2013		;get compare register
		cp	YL,XL				;compare
		brne	pwm4x8_pwm_60			;not equal
		andi	tempreg1,0xdf			;clear channel 1

;channel 6
pwm4x8_pwm_60:	lds	XL,libmio_vram+2022		;counter for channel 1
		inc	XL				;+1
		cpi	XL,0xff				;end
		brne	pwm4x8_pwm_61			;no zero
		lds	XH,libmio_vram+2002		;get control value
		sts	libmio_vram+2014,XH		;write to compare register
		ldi	XL,0x00				;set counter
		ori	tempreg1,0x40			;set channel 1
pwm4x8_pwm_61:	sts	libmio_vram+2022,XL		;store counter

		lds	YL,libmio_vram+2014		;get compare register
		cp	YL,XL				;compare
		brne	pwm4x8_pwm_70			;not equal
		andi	tempreg1,0xbf			;clear channel 1

;channel 7
pwm4x8_pwm_70:	lds	XL,libmio_vram+2023		;counter for channel 1
		inc	XL				;+1
		cpi	XL,0xff				;end
		brne	pwm4x8_pwm_71			;no zero
		lds	XH,libmio_vram+2003		;get control value
		sts	libmio_vram+2015,XH		;write to compare register
		ldi	XL,0x00				;set counter
		ori	tempreg1,0x80			;set channel 1
pwm4x8_pwm_71:	sts	libmio_vram+2023,XL		;store counter

		lds	YL,libmio_vram+2015		;get compare register
		cp	YL,XL				;compare
		brne	pwm4x8_pwm_80			;not equal
		andi	tempreg1,0x7f			;clear channel 1

pwm4x8_pwm_80:	sts	libmio_vram+2028,tempreg1
		ret

.include	"vline_m0.asm"
