;################################################################################
;#										#
;# mode 7 engine (4 channel PWM)						#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
; no input function available
;-------------------------------------------------------------------------------
inex:		cpi	YH,9
		breq	inex_90
		cpi	YH,8
		brne	inex_err

inex_10:	cpi	YL,0x08			;strobe
		brne	inex_12
		in	XL,PINB
		lsr	XL
		andi	XL,0x01
		clr	XH
		ret

inex_12:	cpi	YL,0x09			;busy
		brne	inex_err
		in	XL,PINB
		lsr	XL
		lsr	XL
		andi	XL,0x01
		clr	XH
		ret

inex_err:	ldi	ereg,40			;no IO driver
		ret

inex_90:	cpi	YL,8
		brcc	inex_err
		lsl	YL
		mov	XL,YL
		ldi	YL,LOW(libmio_vram+2000)
		ldi	YH,HIGH(libmio_vram+2000)
		add	YL,XL
		adc	YH,const_0
		ld	XL,Y+
		ld	XH,Y+
		ret

;-------------------------------------------------------------------------------
; output from 0x900 .. 0x9ff
;-------------------------------------------------------------------------------
outex:		cpi	YH,8
		breq	outex_10

outex_100:	cpi	YH,0x09
		brne	inex_err
		cpi	YL,8
		brcc	inex_err
		lsl	YL
		mov	r0,YL
		ldi	YL,LOW(libmio_vram+2000)
		ldi	YH,HIGH(libmio_vram+2000)
		add	YL,r0
		adc	YH,const_0
		st	Y+,XL
		st	Y+,XH
		ret

outex_10:
outex_18:	cpi	YL,0x08			;strobe
		brne	outex_20
		sbrc	XL,0
		sbi	PORTB,1
		sbrs	XL,0
		cbi	PORTB,1
		ret
outex_20:	cpi	YL,0x09			;busy
		brne	outex_50
		sbrc	XL,0
		sbi	PORTB,2
		sbrs	XL,0
		cbi	PORTB,2
		ret


outex_50:
outex_58:	cpi	YL,0x18			;strobe
		brne	outex_60
		sbrc	XL,0
		sbi	DDRB,1
		sbrs	XL,0
		cbi	DDRB,1
		ret
outex_60:	cpi	YL,0x19			;busy
		brne	outex_err
		sbrc	XL,0
		sbi	DDRB,2
		sbrs	XL,0
		cbi	DDRB,2
		ret

outex_err:	ldi	ereg,40			;no IO driver
		ret

