;################################################################################
;#										#
;# mode 7 engine (8 channel PWM)						#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.include	"/usr/local/include/avr/m644Pdef.inc"
.include	"../../system/includes/api_macros.inc"
.include	"../../system/includes/libdef.asm"
.include	"../../system/includes/definitions.asm"

.equ		libmio_palette	= 0x0100		;palette
.equ		bas_mta		= 0x0110		;basic multitasking
.equ		libmio_etable	= 0x4680		;envelope table
.equ		libmio_ctable	= 0x7b00		;chartable font 0

.CSEG

.org	0x7200
;                   "......      N"  
start:		.db " PWM   8x8  N",0xb3,0xfe,0xb1

;icon def
		.db 0xf2,0xf1,0xf1,0xf3
		.db 0xf0,0x8d,0x8d,0xf0
		.db 0xf4,0xf1,0xf1,0xf5

.org	0x720e
		rjmp	inex			;input ext
		rjmp	outex			;output ext
		ret				;FKT 00
		rjmp	pwm8x8_init		;FKT 01 init
		rjmp	pwm8x8_cls		;FKT 02 clear screen
		rjmp	pwm8x8_char		;FKT 03 output char
		rjmp	pwm8x8_gxy		;FKT 04 set cursor
		rjmp	pwm8x8_plot		;FKT 05 plot
		rjmp	pwm8x8_nl		;FKT 06 newline
		rjmp	pwm8x8_vid		;FKT 07 video display

;-------------------------------------------------------------------------------
; use video mode 0 routines
;-------------------------------------------------------------------------------
pwm8x8_cls:	api_vm0cls

pwm8x8_char:	api_vm0char

pwm8x8_nl:	api_vm0newline

pwm8x8_gxy:	api_vm0gotoxy

pwm8x8_plot:	api_vm0plot

;-------------------------------------------------------------------------------
; init mode
;-------------------------------------------------------------------------------
pwm8x8_init:	brtc	pwm8x8_exit		;exit
		out	PORTA,const_0
		ldi	XL,0xff
		out	DDRA,XL
		rcall	pwm_cls
		rcall	pwm8x8_clear
		ldi	XL,0			;force ext routine
		ret

pwm8x8_exit:	out	PORTA,const_0		;no pullup
		ret

;-------------------------------------------------------------------------------
; clear screen
;-------------------------------------------------------------------------------
pwm_cls:	ldi	tempreg1,0x20		;space
		ldi	YH,HIGH(libmio_vram)	;home position
		ldi	YL,LOW(libmio_vram)	;home position
		ldi	XL,libmio_rows
pwm_cls_01:	ldi	XH,libmio_cols
pwm_cls_02:	st	Y+,tempreg1		;write to RAM
		dec	XH			;decrement counter
		brne	pwm_cls_02		;loop
		dec	XL			;decrement counter
		brne	pwm_cls_01		;loop
		lds	tempreg1,libmio_color
		ldi	XL,libmio_rows
pwm_cls_05:	ldi	XH,libmio_cols
pwm_cls_06:	st	Y+,tempreg1		;write to RAM
		dec	XH			;decrement counter
		brne	pwm_cls_06		;loop
		dec	XL			;decrement counter
		brne	pwm_cls_05		;loop
		ret

;-------------------------------------------------------------------------------
; clear pwm data
;-------------------------------------------------------------------------------
pwm8x8_clear:	ldi	XL,LOW(libmio_vram+2000)
		ldi	XH,HIGH(libmio_vram+2000)
		ldi	tempreg1,16
pwm8x8_clear1:	st	X+,const_0
		dec	tempreg1
		brne	pwm8x8_clear1
		ldi	tempreg1,8
		ldi	tempreg2,0x00
pwm8x8_clear2:	st	X+,tempreg2
		subi	tempreg2,0xe0			;+0x20
		dec	tempreg1
		brne	pwm8x8_clear2
		ret

;-------------------------------------------------------------------------------
; reduced video output (23 lines a 24 chars)
;-------------------------------------------------------------------------------
pwm8x8_vid:	lds	tempreg1,libmio_vram+2028	;output value
		out	PORTA,tempreg1			;out

;-------------------------------------------------------------------------------
; set pointer for code saving
;-------------------------------------------------------------------------------
		mov	XL,vline_l
		sbrc	vline_h,0
		rjmp	pwm8x8_novid
		cpi	XL,235
		brcc	pwm8x8_novid
		cpi	XL,5
		brcs	pwm8x8_novid

;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------
pwm8x8_stc_00:	lds	XL,TCNT1L		;1 get timer
		cpi	XL,libmio_hstart+89 	;1
		brcs	pwm8x8_stc_00		;1 loop
pwm8x8_stc_01:	cpi	XL,libmio_hstart+90
		brcs	pwm8x8_stc_02
pwm8x8_stc_02:	cpi	XL,libmio_hstart+91
		brcs	pwm8x8_stc_03
pwm8x8_stc_03:	cpi	XL,libmio_hstart+92
		brcs	pwm8x8_stc_04
pwm8x8_stc_04:	cpi	XL,libmio_hstart+93
		brcs	pwm8x8_stc_05

pwm8x8_stc_05:	rcall	pwm8x8_tvc
		clt				;disable sync
		rjmp	pwm8x8_pwm

pwm8x8_novid:	set				;disable sync
		rjmp	pwm8x8_pwm



;channel 0
pwm8x8_pwm:	lds	tempreg1,libmio_vram+2028	;current output value
		lds	XL,libmio_vram+2016		;counter for channel 0
		inc	XL				;+1
		cpi	XL,0xff				;end
		brne	pwm8x8_pwm_01			;no zero
		lds	XH,libmio_vram+2000		;get control value
		sts	libmio_vram+2008,XH		;write to compare register
		ldi	XL,0x00				;set counter
		ori	tempreg1,0x01			;set channel 0
pwm8x8_pwm_01:	sts	libmio_vram+2016,XL		;store counter

		lds	YL,libmio_vram+2008		;get compare register
		cp	YL,XL				;compare
		brne	pwm8x8_pwm_10			;not equal
		andi	tempreg1,0xfe			;clear channel 0

;channel 1
pwm8x8_pwm_10:	lds	XL,libmio_vram+2017		;counter for channel 1
		inc	XL				;+1
		cpi	XL,0xff				;end
		brne	pwm8x8_pwm_11			;no zero
		lds	XH,libmio_vram+2001		;get control value
		sts	libmio_vram+2009,XH		;write to compare register
		ldi	XL,0x00				;set counter
		ori	tempreg1,0x02			;set channel 1
pwm8x8_pwm_11:	sts	libmio_vram+2017,XL		;store counter

		lds	YL,libmio_vram+2009		;get compare register
		cp	YL,XL				;compare
		brne	pwm8x8_pwm_20			;not equal
		andi	tempreg1,0xfd			;clear channel 1

;channel 2
pwm8x8_pwm_20:	lds	XL,libmio_vram+2018		;counter for channel 1
		inc	XL				;+1
		cpi	XL,0xff				;end
		brne	pwm8x8_pwm_21			;no zero
		lds	XH,libmio_vram+2002		;get control value
		sts	libmio_vram+2010,XH		;write to compare register
		ldi	XL,0x00				;set counter
		ori	tempreg1,0x04			;set channel 1
pwm8x8_pwm_21:	sts	libmio_vram+2018,XL		;store counter

		lds	YL,libmio_vram+2010		;get compare register
		cp	YL,XL				;compare
		brne	pwm8x8_pwm_30			;not equal
		andi	tempreg1,0xfb			;clear channel 1

;channel 3
pwm8x8_pwm_30:	lds	XL,libmio_vram+2019		;counter for channel 1
		inc	XL				;+1
		cpi	XL,0xff				;end
		brne	pwm8x8_pwm_31			;no zero
		lds	XH,libmio_vram+2003		;get control value
		sts	libmio_vram+2011,XH		;write to compare register
		ldi	XL,0x00				;set counter
		ori	tempreg1,0x08			;set channel 1
pwm8x8_pwm_31:	sts	libmio_vram+2019,XL		;store counter

		lds	YL,libmio_vram+2011		;get compare register
		cp	YL,XL				;compare
		brne	pwm8x8_pwm_40			;not equal
		andi	tempreg1,0xf7			;clear channel 1

;channel 4
pwm8x8_pwm_40:	lds	XL,libmio_vram+2020		;counter for channel 1
		inc	XL				;+1
		cpi	XL,0xff				;end
		brne	pwm8x8_pwm_41			;no zero
		lds	XH,libmio_vram+2004		;get control value
		sts	libmio_vram+2012,XH		;write to compare register
		ldi	XL,0x00				;set counter
		ori	tempreg1,0x10			;set channel 1
pwm8x8_pwm_41:	sts	libmio_vram+2020,XL		;store counter

		lds	YL,libmio_vram+2012		;get compare register
		cp	YL,XL				;compare
		brne	pwm8x8_pwm_50			;not equal
		andi	tempreg1,0xef			;clear channel 1

;channel 5
pwm8x8_pwm_50:	lds	XL,libmio_vram+2021		;counter for channel 1
		inc	XL				;+1
		cpi	XL,0xff				;end
		brne	pwm8x8_pwm_51			;no zero
		lds	XH,libmio_vram+2005		;get control value
		sts	libmio_vram+2013,XH		;write to compare register
		ldi	XL,0x00				;set counter
		ori	tempreg1,0x20			;set channel 1
pwm8x8_pwm_51:	sts	libmio_vram+2021,XL		;store counter

		lds	YL,libmio_vram+2013		;get compare register
		cp	YL,XL				;compare
		brne	pwm8x8_pwm_60			;not equal
		andi	tempreg1,0xdf			;clear channel 1

;channel 6
pwm8x8_pwm_60:	lds	XL,libmio_vram+2022		;counter for channel 1
		inc	XL				;+1
		cpi	XL,0xff				;end
		brne	pwm8x8_pwm_61			;no zero
		lds	XH,libmio_vram+2006		;get control value
		sts	libmio_vram+2014,XH		;write to compare register
		ldi	XL,0x00				;set counter
		ori	tempreg1,0x40			;set channel 1
pwm8x8_pwm_61:	sts	libmio_vram+2022,XL		;store counter

		lds	YL,libmio_vram+2014		;get compare register
		cp	YL,XL				;compare
		brne	pwm8x8_pwm_70			;not equal
		andi	tempreg1,0xbf			;clear channel 1

;channel 7
pwm8x8_pwm_70:	lds	XL,libmio_vram+2023		;counter for channel 1
		inc	XL				;+1
		cpi	XL,0xff				;end
		brne	pwm8x8_pwm_71			;no zero
		lds	XH,libmio_vram+2007		;get control value
		sts	libmio_vram+2015,XH		;write to compare register
		ldi	XL,0x00				;set counter
		ori	tempreg1,0x80			;set channel 1
pwm8x8_pwm_71:	sts	libmio_vram+2023,XL		;store counter

		lds	YL,libmio_vram+2015		;get compare register
		cp	YL,XL				;compare
		brne	pwm8x8_pwm_80			;not equal
		andi	tempreg1,0x7f			;clear channel 1

pwm8x8_pwm_80:	sts	libmio_vram+2028,tempreg1
		ret


.include	"vline_m0.asm"

.include	"inout.asm"
