;################################################################################
;#										#
;# mode 7 engine (8 channel PWM)						#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.include	"/usr/local/include/avr/m644Pdef.inc"
.include	"../../system/includes/api_macros.inc"
.include	"../../system/includes/libdef.asm"
.include	"../../system/includes/definitions.asm"

.equ		libmio_palette	= 0x0100		;palette
.equ		bas_mta		= 0x0110		;basic multitasking
.equ		libmio_etable	= 0x4680		;envelope table
.equ		libmio_ctable	= 0x7b00		;chartable font 0
.equ		libmio_kstab	= 0x7a80		;key and serial table

.CSEG

.org	0x7200
;                   "......      N"
start:		.db "NOXMEMPWM+2SN",0xb3,0xfe,0xb2

;icon def
		.db 0xf2,0xf1,0xf1,0xf3
		.db 0xf0,0x8d,0x8d,0xf0
		.db 0xf4,0xf1,0xf1,0xf5

.org	0x720e
		rjmp	inex			;input ext
		rjmp	outex			;output ext
		ret				;FKT 00
		rjmp	servo_init		;FKT 01 init
		rjmp	servo_cls		;FKT 02 clear screen
		rjmp	servo_char		;FKT 03 output char
		rjmp	servo_gxy		;FKT 04 set cursor
		rjmp	servo_plot		;FKT 05 plot
		rjmp	servo_nl		;FKT 06 newline
		rjmp	servo_vid		;FKT 07 video display

;-------------------------------------------------------------------------------
; use video mode 0 routines
;-------------------------------------------------------------------------------
servo_cls:	api_vm0cls

servo_char:	api_vm0char

servo_nl:	api_vm0newline

servo_gxy:	api_vm0gotoxy

servo_plot:	api_vm0plot

;-------------------------------------------------------------------------------
; i/o
;-------------------------------------------------------------------------------

.include	"inout.asm"

;-------------------------------------------------------------------------------
; init mode
;-------------------------------------------------------------------------------
servo_init:	brtc	servo_exit		;exit
		cbi	PORTA,4
		cbi	PORTA,5
		cbi	PORTA,6
		cbi	PORTA,7
		sbi	DDRA,4
		sbi	DDRA,5
		sbi	DDRA,6
		sbi	DDRA,7
		rcall	pwm_cls
		rcall	servo_clear
		ldi	XL,0			;force ext routine
		ret

servo_exit:	cbi	PORTA,4			;set to zero
		cbi	PORTA,5
		cbi	PORTA,6
		cbi	PORTA,7
		ret

;-------------------------------------------------------------------------------
; clear screen
;-------------------------------------------------------------------------------
pwm_cls:	ldi	tempreg1,0x20		;space
		ldi	YH,HIGH(libmio_vram)	;home position
		ldi	YL,LOW(libmio_vram)	;home position
		ldi	XL,libmio_rows
pwm_cls_01:	ldi	XH,libmio_cols
pwm_cls_02:	st	Y+,tempreg1		;write to RAM
		dec	XH			;decrement counter
		brne	pwm_cls_02		;loop
		dec	XL			;decrement counter
		brne	pwm_cls_01		;loop
		lds	tempreg1,libmio_color
		ldi	XL,libmio_rows
pwm_cls_05:	ldi	XH,libmio_cols
pwm_cls_06:	st	Y+,tempreg1		;write to RAM
		dec	XH			;decrement counter
		brne	pwm_cls_06		;loop
		dec	XL			;decrement counter
		brne	pwm_cls_05		;loop
		ret

;-------------------------------------------------------------------------------
; clear pwm data
;-------------------------------------------------------------------------------
servo_clear:	ldi	XL,LOW(libmio_vram+2000)
		ldi	XH,HIGH(libmio_vram+2000)
		ldi	tempreg1,16
servo_clear1:	st	X+,const_0
		dec	tempreg1
		brne	servo_clear1
		ldi	tempreg1,8
		ldi	tempreg2,0x00
servo_clear2:	st	X+,tempreg2
		subi	tempreg2,0xe0			;+0x20
		dec	tempreg1
		brne	servo_clear2
		ret

;-------------------------------------------------------------------------------
; reduced video output (23 lines a 24 chars)
;-------------------------------------------------------------------------------
servo_vid:	in	XL,PORTA			;current value
		andi	XL,0x3f
		lds	tempreg1,libmio_vram+2028	;output value
		andi	tempreg1,0xc0			;only two pwm channels (6+7)
		or	tempreg1,XL
		out	PORTA,tempreg1			;out

;-------------------------------------------------------------------------------
; check what to do
;-------------------------------------------------------------------------------
		mov	XL,vline_l
		sbrc	vline_h,0
		rjmp	servo_nvid			;>255
		cpi	XL,5
		brcs	servo_nvid			;upper border
		cpi	XL,205
		brcs	servo_stc_00			;display
		brne	servo_nvid			;after pulse
		rjmp	pulse_out

;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------
servo_stc_00:	lds	XL,TCNT1L			;1 get timer
		cpi	XL,libmio_hstart+93		;1
		brcs	servo_stc_00			;1 loop
servo_stc_01:	cpi	XL,libmio_hstart+94
		brcs	servo_stc_02
servo_stc_02:	cpi	XL,libmio_hstart+95
		brcs	servo_stc_03
servo_stc_03:	cpi	XL,libmio_hstart+96
		brcs	servo_stc_04
servo_stc_04:	cpi	XL,libmio_hstart+97
		brcs	servo_stc_05

servo_stc_05:	rcall	servo_tvc

;channel 6 is normal PWM 1
servo_vid_40:	lds	tempreg1,libmio_vram+2028
		lds	XL,libmio_vram+2020		;counter for channel 1
		inc	XL				;+1
		cpi	XL,0xff				;end
		brne	servo_vid_41			;no zero
		lds	XH,libmio_vram+2004		;get control value
		sts	libmio_vram+2021,XH		;write to compare register
		ldi	XL,0x00				;set counter
		ori	tempreg1,0x40			;set channel 1
servo_vid_41:	sts	libmio_vram+2020,XL		;store counter

		lds	YL,libmio_vram+2021		;get compare register
		cp	YL,XL				;compare
		brne	servo_vid_50			;not equal
		andi	tempreg1,0xbf			;clear channel 1

;channel 7 is normal PWM 2
servo_vid_50:	lds	XL,libmio_vram+2022		;counter for channel 1
		inc	XL				;+1
		cpi	XL,0xff				;end
		brne	servo_vid_51			;no zero
		lds	XH,libmio_vram+2006		;get control value
		sts	libmio_vram+2023,XH		;write to compare register
		ldi	XL,0x00				;set counter
		ori	tempreg1,0x80			;set channel 1
servo_vid_51:	sts	libmio_vram+2022,XL		;store counter

		lds	YL,libmio_vram+2023		;get compare register
		cp	YL,XL				;compare
		brne	servo_vid_80			;not equal
		andi	tempreg1,0x7f			;clear channel 1

servo_vid_80:	sts	libmio_vram+2028,tempreg1
		clt					;disable sync
		ret

;NO VIDEO
;channel 6 is normal PWM 1
servo_nvid:	lds	tempreg1,libmio_vram+2028
		lds	XL,libmio_vram+2020		;counter for channel 1
		inc	XL				;+1
		cpi	XL,0xff				;end
		brne	servo_nvid_41			;no zero
		lds	XH,libmio_vram+2004		;get control value
		sts	libmio_vram+2021,XH		;write to compare register
		ldi	XL,0x00				;set counter
		ori	tempreg1,0x40			;set channel 1
servo_nvid_41:	sts	libmio_vram+2020,XL		;store counter

		lds	YL,libmio_vram+2021		;get compare register
		cp	YL,XL				;compare
		brne	servo_nvid_50			;not equal
		andi	tempreg1,0xbf			;clear channel 1

;channel 7 is normal PWM 2
servo_nvid_50:	lds	XL,libmio_vram+2022		;counter for channel 1
		inc	XL				;+1
		cpi	XL,0xff				;end
		brne	servo_nvid_51			;no zero
		lds	XH,libmio_vram+2006		;get control value
		sts	libmio_vram+2023,XH		;write to compare register
		ldi	XL,0x00				;set counter
		ori	tempreg1,0x80			;set channel 1
servo_nvid_51:	sts	libmio_vram+2022,XL		;store counter

		lds	YL,libmio_vram+2023		;get compare register
		cp	YL,XL				;compare
		brne	servo_nvid_80			;not equal
		andi	tempreg1,0x7f			;clear channel 1

servo_nvid_80:	sts	libmio_vram+2028,tempreg1
		set					;enable sync
		ret


;-------------------------------------------------------------------------------
;
;--------------------------------------------------------------------------------
pulse_out:
.include	"pulse.asm"

.include	"vline_m0.asm"
