;################################################################################
;#										#
;# mode 7 engine (LCD 20x2)							#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.include	"/usr/local/include/avr/m644Pdef.inc"
.include	"../../system/includes/api_macros.inc"
.include	"../../system/includes/libdef.asm"
.include	"../../system/includes/definitions.asm"

.equ		lcd_charmap	= libmio_vram
.equ		lcd_sys		= libmio_vram+192
.equ		lcd_cgmap	= libmio_vram+320	;CG RAM viewed buffer
.equ		lcd_charset	= libmio_vram+256

.equ		lcd_enable	= lcd_sys		;enable update
.equ		lcd_colcount	= lcd_sys+1		;col counter
.equ		lcd_rowcount	= lcd_sys+2		;row counter
.equ		lcd_datavalid	= lcd_sys+3		;no write
.equ		lcd_databyte	= lcd_sys+4		;data to write
.equ		lcd_linedoubler	= lcd_sys+5		;for TV line doubling
.equ		lcd_pixline	= lcd_sys+6		;pixline in char
.equ		lcd_cgptr	= lcd_sys+8		;CG counter
.equ		lcd_keys	= lcd_sys+9		;key state
.equ		lcd_cmap_l	= lcd_sys+10		;low address of charmap
.equ		lcd_cmap_h	= lcd_sys+11		;high address of charmap

