;################################################################################
;#										#
;# mode 7 engine (LCD 20x2)							#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################


;-------------------------------------------------------------------------------
; input expansion
;-------------------------------------------------------------------------------
inex:		cpi	XH,0x08			;I/O
		brne	inex_100

inex_10:	cpi	XL,0x04
		brne	inex_12
		lds	XH,lcd_keys
		bst	XH,4
inex_kin:	clr	XL
		bld	XL,0
		clr	XH
		ret

inex_12:	cpi	XL,0x05
		brne	inex_14
		lds	XH,lcd_keys
		bst	XH,5
		rjmp	inex_kin

inex_14:	cpi	XL,0x06
		brne	inex_16
		lds	XH,lcd_keys
		bst	XH,6
		rjmp	inex_kin

inex_16:	cpi	XL,0x07
		brne	inex_err
		lds	XH,lcd_keys
		bst	XH,7
		rjmp	inex_kin

inex_100:	cpi	XH,0x0a			;CG RAM
		brne	inex_err
		cpi	XL,0x40
		brcc	inex_err
		mov	r16,XL
		ldi	XL,LOW(lcd_charset)
		ldi	XH,HIGH(lcd_charset)
		add	XL,r16
		add	XH,const_0
		ld	XL,X
		clr	XH
		ret

inex_err:	ldi	ereg,40			;no IO driver
		ret

;-------------------------------------------------------------------------------
; output expansion
;-------------------------------------------------------------------------------
outex:		cpi	YH,8
		brne	outex_100

outex_10:	cpi	YL,0x00
		brne	outex_12
		sbrc	XL,0
		sbi	PORTA,0
		sbrs	XL,0
		cbi	PORTA,0
		ret
outex_12:	cpi	YL,0x01
		brne	outex_14
		sbrc	XL,0
		sbi	PORTA,1
		sbrs	XL,0
		cbi	PORTA,1
		ret
outex_14:	cpi	YL,0x02
		brne	outex_16
		sbrc	XL,0
		sbi	PORTA,2
		sbrs	XL,0
		cbi	PORTA,2
		ret
outex_16:	cpi	YL,0x03
		brne	outex_50
		sbrc	XL,0
		sbi	PORTA,3
		sbrs	XL,0
		cbi	PORTA,3
		ret

outex_50:	cpi	YL,0x10
		brne	outex_52
		sbrc	XL,0
		sbi	DDRA,0
		sbrs	XL,0
		cbi	DDRA,0
		ret
outex_52:	cpi	YL,0x11
		brne	outex_54
		sbrc	XL,0
		sbi	DDRA,1
		sbrs	XL,0
		cbi	DDRA,1
		ret
outex_54:	cpi	YL,0x12
		brne	outex_56
		sbrc	XL,0
		sbi	DDRA,2
		sbrs	XL,0
		cbi	DDRA,2
		ret
outex_56:	cpi	YL,0x13
		brne	outex_80
		sbrc	XL,0
		sbi	DDRA,3
		sbrs	XL,0
		cbi	DDRA,3
		ret

outex_80:	rjmp	outex_err

outex_100:	cpi	YH,0x0a			;CG RAM
		brne	outex_err
		cpi	YL,0x40
		brcc	outex_err
		mov	XH,YL
		ldi	YL,LOW(lcd_charset)
		ldi	YH,HIGH(lcd_charset)
		add	YL,XH
		add	YH,const_0
		st	Y,XL
		ret

outex_err:	ldi	ereg,40			;no IO driver
		ret

get_keys:	in	XL,PORTA		;enable pull-up
		ori	XL,0xf0
		out	PORTA,XL
		in	XL,DDRA			;set D4-7 as input
		andi	XL,0x0f
		out	DDRA,XL
		nop
		nop
		ori	XL,0xf0
		in	XH,PINA			;get state
		out	DDRA,XL			;set D4-7 as output
		sts	lcd_keys,XH
		ret
