;################################################################################
;#										#
;# mode 7 engine (LCD 20x2)							#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.include	"definitions.asm"

.equ		lcd_rows	= 4			;rows on LCD
.equ		lcd_cols	= 20			;columns on LCD
.equ		lcd_colbyte	= 0x80			;color for dual display
.equ		lcd_dclocks	= 35			;dummy clocks = (27-cols) * 5
.equ		lcd_ystart	= 55
.equ		lcd_yend	= 128
.equ		linesort	= 4

.CSEG

.org	0x7200
;                   "......      N"  
start:		.db "LC4*20P4BIT2N",0xb3,0xfe,0xa3

;icon def
		.db 0xf2,0xf1,0xf1,0xf3
		.db 0xf0,"LC",0xf0
		.db 0xf4,0xf1,0xf1,0xf5

.org	0x720e
		rjmp	inex			;video, no IO
		rjmp	outex			;IO ext
		ret				;FKT 00
		rjmp	lcd_init		;FKT 01 init
		rjmp	lcd_cls			;FKT 02 clear screen
		rjmp	lcd_char		;FKT 03 output char
		rjmp	lcd_gxy			;FKT 04 set cursor
		ret				;FKT 05 plot
		rjmp	lcd_newl		;FKT 06 NL
		rjmp	lcd_vid			;FKT 07 video display

;-------------------------------------------------------------------------------
; I/O expansion
;-------------------------------------------------------------------------------
.include	"io.asm"
.include	"routines.asm"
.include	"video_20.asm"

lcd_ctable:
.include	"ctable.inc"

