;------------------------------------------------------------------------------
; 0x27		DA	A
;------------------------------------------------------------------------------
emu_code_27:	mov	r16,reg_a		;1 copy A
		andi	r16,0x0f		;1 mask lower bits
		sbic	GPIOR0,0		;1 skip if add was last
		rjmp	emu_code_27s		;2 last was sub

		ldi	r19,0x06		;1 add value start
		cpi	r16,0x0a		;1 check if we must add
		sbrs	reg_f,aflag_h		;1 skip if H set
		brcs	emu_code_27a		;1/2
		add	reg_a,r19		;1 +6
emu_code_27a:	ldi	r19,0x60
		cpi	reg_a,0xa0
		sbrs	reg_f,aflag_c		;1 skip if H set
		brcs	emu_code_27b		;1/2
		add	reg_a,r19
		ori	reg_f,1			;set carry
emu_code_27b:	rjmp	emu_code_27x		;2 end of command

emu_code_27s:	sbrc	reg_f,aflag_h		;1 skip if no H flag
		subi	reg_a,0x06		;1
		sbrc	reg_f,aflag_c		;1/2 skip if no carry
		subi	reg_a,0x60		;1
emu_code_27x:	mov	ZL,reg_a		;1
		bst	reg_f,aflag_c
		ldi	ZH,HIGH(emu_flags_log*2);1
		lpm	reg_f,Z			;1
		bld	reg_f,aflag_c
		rjmp	emu_loop		;2

