;################################################################################
;#										#
;# libmio - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.macro vchar
		out	VPORT,YL		;1 pix 0
		mov	YH,YL			;1 copy for pix 4
		lsl	YL			;1

		out	VPORT,YL		;1 pix 1
		lsl	YL			;1
		swap	YH			;1 prepare pix 4

		out	VPORT,YL		;1 pix 2
		mov	r20,YL			;1 copy for pix 6
		lsl	YL			;1

		out	VPORT,YL		;1 pix 3
		ld	ZL,X+			;2 get char

		out	VPORT,YH		;1 pix 4
		lsl	YH			;1
		swap	r20			;1 prepare pix 6

		out	VPORT,YH		;1 pix 5
		lpm	YL,Z			;2 get pixline

		out	VPORT,r20		;1 pix 6
		lsl	r20			;1
		nop				;1

		out	VPORT,r20		;1 pix 7
		sbrc	ZL,6			;1/2
		rjmp	libmio_tvout_e
.endm

;-------------------------------------------------------------------------------
;video-interrupt (no registers destroyed, stack=13)
;save registers (25c)
;-------------------------------------------------------------------------------
libmio_aisr:	push	ZH			;2 save Z-register
		push	ZL			;2 save Z-register
		push	YL			;2 save Y-register
		push	XH			;2 save Y-register
		push	XL			;2 save Y-register
		in	ZH,SREG			;1 save status
		push	ZH			;2

		ldi	XL,15
vint_w1:	dec	XL
		brne	vint_w1

;-------------------------------------------------------------------------------
;count line up and set border (9c)
;-------------------------------------------------------------------------------
		add	vline_l,const_1		;1
		adc	vline_h,const_0		;1
		lds	ZL,libmio_sborder	;2
		out	VPORT,ZL		;1
		sei				;1 enable border interrupt

;-------------------------------------------------------------------------------
;check if line is image
;-------------------------------------------------------------------------------
libmio_vism0:	sbrc	vline_h,0		;1 skip if less than 256
		rjmp	libmio_tis_02		;2 no visible line
		ldi	ZH,192
libmio_vism1:	cp	vline_l,ZH		;1 max lines
		brcc	libmio_tis_02		;2 goto no image-line
libmio_vism2:	rjmp	libmio_viss		;2 goto image line

;-------------------------------------------------------------------------------
;no image line
;-------------------------------------------------------------------------------
libmio_tis_02:	lds	ZL,libmio_sysconf	;2 configuration

libmio_tis_04:	ldi	ZH,libmio_vstart_p	;1 vstart pal
		sbrs	ZL,0			;1 pal/ntsc bit
		ldi	ZH,libmio_vstart_n	;1 vstart ntsc
		cp	vline_l,ZH
		brne	libmio_tis_09		;no vsync start
		cbi	VSPORT,VSPIN
		sbrs	ZL,2			;csync bit
		rjmp	libmio_tis_15
		ldi	XH,0x82			;invert CSYNC
		sts	TCCR1A,XH
libmio_tis_05:	rjmp	libmio_tis_15

libmio_tis_09:	ldi	ZH,libmio_vstop_p	;1 vstop pal
		sbrs	ZL,0			;1 pal/ntsc bit
		ldi	ZH,libmio_vstop_n	;1 vstop ntsc
		cp	vline_l,ZH
		brne	libmio_tis_10		;no vsync stop
		sbi	VSPORT,VSPIN
		sbrs	ZL,2			;csync bit
		rjmp	libmio_tis_15
		ldi	XH,0xc2			;normal CSYNC
		sts	TCCR1A,XH
		rjmp	libmio_tis_15

libmio_tis_10:	ldi	ZH,libmio_bstart_p	;1 border start pal
		sbrs	ZL,0			;1 pal/ntsc bit
		ldi	ZH,libmio_bstart_n	;1 border start ntsc
		cp	vline_l,ZH
		brne	libmio_tis_11		;no border start
		ldi	ZL,0x80
		sts	libmio_sborder,ZL
		rjmp	libmio_tis_15

libmio_tis_11:	ldi	ZH,libmio_bstop_p	;1 border stop pal
		sbrs	ZL,0			;1 pal/ntsc bit
		ldi	ZH,libmio_bstop_n	;1 border stop ntsc
		cp	vline_l,ZH
		brne	libmio_tis_13		;no border stop
		sts	libmio_sborder,const_0
		rjmp	libmio_tis_15

libmio_tis_13:	ldi	ZH,56			;1 maxlines pal
		sbrs	ZL,0			;1 pal/ntsc bit
		ldi	ZH,6			;1 maxlines ntsc
		cp	vline_l,ZH
		breq	libmio_tis_14		;2 end of frame
		rjmp	libmio_tis_15

libmio_tis_14:	ldi	XL,0xff
		mov	vline_l,XL		;line_l=0
		mov	vline_h,XL		;line_h=0
;decrement frame counter
		ldi	ZL,0x19			;set margin
		sts	zx_ram+0x28,ZL
		lds	ZL,zx_ram+0x34
		lds	ZH,zx_ram+0x35
		mov	XH,ZH
		lds	YL,libmio_nmi
		sbrc	YL,0
		sbiw	ZL,1
		andi	XH,0x80
		or	ZH,XH
		sts	zx_ram+0x34,ZL
		sts	zx_ram+0x35,ZH
libmio_tisf1:	lds	XL,zx_ram+0x0c		;DFILE addr
		lds	XH,zx_ram+0x0d

		andi	XH,0x3f			;max 16K
		subi	XH,0xfe			;start at 0x0200

libmio_tisf2:	adiw	XL,1			;skip first HALT
		sts	libmio_rampos_l,XL
		sts	libmio_rampos_h,XH

		lds	ZL,libmio_keycode
		ldi	ZH,HIGH(libmio_zktable)
		lsl	ZL
		rol	ZH
		lpm	XL,Z+
		lpm	XH,Z+
		lds	ZL,libmio_kbdstate
		sbrc	ZL,2
		ori	XH,0x01
		sts	zx_ram+0x25,XL
		sts	zx_ram+0x26,XH
		cpi	XL,0xff
		breq	libmio_teset

		lds	ZL,zx_ram+0x3b
		ori	ZL,0x80			;set slow
		sts	zx_ram+0x3b,ZL

		lds	ZL,libmio_kwait
		sbrs	ZL,0
		rjmp	libmio_teset

		lds	XL,zx_ram+0x3b
		ori	XL,0x01
		sts	zx_ram+0x3b,XL
		sts	libmio_kwait,const_0

libmio_teset:	lds	ZL,libmio_keycode
		cpi	ZL,0xe9
		brne	libmio_tesetn
		lds	ZL,libmio_kbdstate
		sbrs	ZL,2
		rjmp	libmio_tesetn
		sbrs	ZL,4
		rjmp	libmio_tesetn
		jmp	0

libmio_tesetn:	rjmp	libmio_tis_15

;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------
libmio_viss:	lds	XL,zx_ram+0x3b
		sbrs	XL,7
		rjmp	libmio_tis_15		;FAST
		lds	XL,TCNT1L		;1 get timer
		lds	XL,TCNT1H		;1 get timer
		cpi	XL,1			;1
		brne	libmio_viss		;1 loop

libmio_viss0:	lds	XL,TCNT1L		;1 get timer
		cpi	XL,30			;1
		brcs	libmio_viss0		;1 loop
libmio_viss_01:	cpi	XL,31
		brcs	libmio_viss_02
libmio_viss_02:	cpi	XL,32
		brcs	libmio_viss_03
libmio_viss_03:	cpi	XL,33
		brcs	libmio_viss_03a
libmio_viss_03a:	cpi	XL,34
		brcs	libmio_viss_04

libmio_viss_04:	push	r20		;2
		push	r21
		push	YH

libmio_tvout:	lds	XL,libmio_rampos_l	;get RAM position
		lds	XH,libmio_rampos_h

		mov	ZL,vline_l		;
		andi	ZL,0x07
		ldi	ZH,HIGH(libmio_ctable*2)
		add	ZH,ZL

		ldi	r21,0x80		;border

		ld	ZL,X+			;2 get char
		sbrc	ZL,6			;skip if no bit 6
		rjmp	libmio_tvout_e		;2 branch to end
		lpm	YL,Z			;2 get pixline
		ldi	ZL,0x10
		out	MCUCR,ZL		;2 disable Pullup

		vchar				;24 char 0
		vchar				;24 char 1
		vchar				;24 char 2
		vchar				;24 char 3
		vchar				;24 char 4
		vchar				;24 char 5
		vchar				;24 char 6
		vchar				;24 char 7
		vchar				;24 char 8
		vchar				;24 char 9

		vchar				;24 char 10
		vchar				;24 char 11
		vchar				;24 char 12
		vchar				;24 char 13
		vchar				;24 char 14
		vchar				;24 char 15
		vchar				;24 char 16
		vchar				;24 char 17
		vchar				;24 char 18
		vchar				;24 char 19

		vchar				;24 char 20
		vchar				;24 char 21
		vchar				;24 char 22
		vchar				;24 char 23
		vchar				;24 char 24
		vchar				;24 char 25
		vchar				;24 char 26
		vchar				;24 char 27
		vchar				;24 char 28
		vchar				;24 char 29

		vchar				;24 char 30
		vchar				;24 char 31
		vchar				;24 char 32 (debug)
		vchar				;24 char 33 (debug)

libmio_tvout_e:	out	VPORT,r21		;set to border
		out	MCUCR,const_0		;2 enable Pullup
		mov	ZL,vline_l		;
		andi	ZL,0x07
		cpi	ZL,0x07
		brne	libmio_tvout_x
		sts	libmio_rampos_l,XL
		sts	libmio_rampos_h,XH
libmio_tvout_x:	pop	YH
		pop	r21
		pop	r20
libmio_tis_15:
		rjmp	libmio_keyb


