;################################################################################
;#										#
;# AX81 computer with ATmega644/1284						#
;# copyright (c) 2010-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License as		#
;# published by the Free Software Foundation; either version 3 of		#
;# the License, or (at your option) any later version.				#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.def	const_0 = r2
.def	const_1 = r3

.include "config.asm"

.if MCU == 1284
	.include "/usr/local/include/avr/m1284Pdef.inc"
.else
	.include "/usr/local/include/avr/m644Pdef.inc"
.endif

.equ		libmio_ram	= 0x0100	;24 bytes libmio system RAM
.equ		z80emu_ram	= 0x0118	;32 bytes shadow register etc.
.equ		fileio_ram	= 0x0138	;40 bytes fileio ram
.equ		stack		= 0x01ff	;160 bytes stack
.equ		zx_ram		= 0x0200	;start of ZX memory

.equ		T_ERR		= 0x1c		;"T" error

.include	"libmio/definitions.asm"

.if MCU == 1284
	.set bl_buffer = 0x3f
	.set STACKA = 0x3f
.else
	.set bl_buffer = 0x0f
	.set STACKA = 0x0f
.endif

.include	"libmio/timing.asm"
.include	"filesys/fconfig.asm"

.include	"emulator/emu_defs.asm"
.include	"emulator/mem_macros.asm"
.include	"emulator/emacros.asm"

.CSEG

.org 0x0000
		jmp	start
.org 0x0004
		.db 0,1				;System/version
.org OC1Aaddr
		jmp	libmio_aisr		;video interrupt CHA
.org OC1Baddr
		jmp	libmio_bisr		;video interrupt CHB
.org OVF1addr
		jmp	libmio_oisr		;video interrupt OV

start:		cli				;disable video after jmp 0
		ldi	XL,0x00
		mov	const_0,XL
		ldi	XL,0x01
		mov	const_1,XL

		ldi	XL,HIGH(stack)
		out	SPH,XL
		ldi	XL,LOW(stack)
		out	SPL,XL
		out	SPCR,const_0		;disable SPI

.if MCU == 1284
		out	RAMPZ,const_1
.endif

		call	bl_init			;

		call	libmio_init			;activate video

		call	intro			;intro screen

loop:		jmp	emu_start		;start emulator
		rjmp	loop

.include	"emulator/emulator.asm"
.include	"emulator/emulator_cb.asm"
.include	"emulator/emulator_dd.asm"
.include	"emulator/emulator_ddcb.asm"
.include	"emulator/emulator_fd.asm"
.include	"emulator/emulator_fdcb.asm"
.include	"emulator/emulator_ed.asm"
.include	"emulator/emulator_io.asm"

.include	"libmio/init.asm"
.include	"libmio/vint_lcd1.asm"
.include	"libmio/vint_tv1.asm"
.include	"libmio/vint_vga1.asm"
.include	"keyboard/kint.asm"

.include	"filesys/fsys.asm"
.include	"filesys/dataflash.asm"
.include	"filesys/sd_card.asm"
.include	"filesys/zxsave.asm"

.include	"modules/intro.asm"
.include	"modules/bootloader.asm"

.org	0x5780
libmio_kstab:
.include	"keyboard/kstable.inc"

.org 0x5800
libmio_ktables:
.include	"keyboard/keytable_de.inc"
libmio_zktable:
.include	"keyboard/zxkeys.inc"

.org 0x5a00
zxmap:
.if MCU == 1284
	.include	"emulator/memmap_15K75_6000.asm"
.else
	.include	"emulator/memmap_3K75_6000.asm"
.endif

.include	"emulator/flags.asm"

.org 0x5b80
libmio_ctable:
.include	"libmio/zx81cset.inc"

.org 0x5F80
.include	"emulator/eblock.inc"
.org 0x6000
.include	"emulator/zx81rom.inc"

