;################################################################################
;#										#
;# copyright (c) 2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.equ		SO_PORT = PORTD
.equ		SO_DDR = DDRD
.equ		SO_PIN = PIND
.equ		SO_PNR = 4

.equ		SI_PORT = PORTD
.equ		SI_DDR = DDRD
.equ		SI_PIN = PIND
.equ		SI_PNR = 1

.equ		CHP_PORT = PORTB
.equ		CHP_DDR = DDRB
.equ		CHP_PIN = PINB
.equ		CHP_PNR = 3

bl_init:
		in	XL,MCUSR
		sbrs	XL,0
		ret
		out	MCUSR,const_0

		sbi	SO_DDR,SO_PNR		;SOUT
		sbi	SO_PORT,SO_PNR

		cbi	SI_DDR,SI_PNR		;SIN1
		sbi	SI_PORT,SI_PNR

		cbi	CHP_DDR,SI_PNR		;chargepump
		sbi	CHP_PORT,SI_PNR

		sbi	DDRB,3			;charge pump
		ldi	XL,0x42			;ctc output at cannel A
		out	TCCR0A,XL
		ldi	XL,0x01
		out	TCCR0B,XL
		ldi	XL,49			;ca. 200KHz
		out	OCR0A,XL

		ldi	XL,0x00
		ldi	XH,0x00
bl_init_1:	sbiw	XL,1
		brne	bl_init_1

		sbis	SI_PIN,SI_PNR
		rjmp	bl_main
bl_check_end:	ret				;no serial active

;------------------------------------------------------------------------------
; the bootloader main loop
;------------------------------------------------------------------------------
bl_main:	call	fsys_init
		lds	XL,fileio_ram+36
		sbrs	XL,3
		ret
		sts	fileio_ram+32,const_0	;sel tape
		sts	fileio_ram+33,const_0	;sel file
		cli				;disable interrupts
		lds	XL,libmio_sysconf
		andi	XL,0x03
		cpi	XL,1
		brne	bl_loop			;no LCD
		ldi	XL,0x10
		out	DPORT,XL		;switch display off

bl_loop:	ldi	r16,0x0c		;FF (clear)
		rcall	send_byte		;send
bl_dloop:	ldi	ZL,LOW(bltext1*2)
		ldi	ZH,HIGH(bltext1*2)
		rcall	bl_text
		lds	r17,fileio_ram+32	;tape
		rcall	bl_outdez3
		rcall	bl_newline
		rcall	bl_newline
		rcall	bl_flist
		rcall	bl_newline
		ldi	ZL,LOW(bltext2*2)
		ldi	ZH,HIGH(bltext2*2)
		rcall	bl_text
		rcall	bl_scanline
;		cpi	r17,0
;		brne	bl_end			;error->exit

		ldi	YL,LOW(fileio_ram)
		ldi	YH,HIGH(fileio_ram)
		ld	r16,Y+
		cpi	r16,'Q'
		breq	bl_end
		clr	r17			;initial value
		ldi	XL,10			;multiplicator

bl_findval:	ld	XH,Y+			;get char
		cpi	XH,0x00
		breq	bl_findval_e
		cpi	XH,0x30
		brcs	bl_findval
		cpi	XH,0x3a
		brcc	bl_findval
		subi	XH,0x30
		mul	r17,XL
		mov	r17,r0
		add	r17,XH
		rjmp	bl_findval
bl_findval_e:
		cpi	r16,'T'
		brne	bl_loop_2
		rjmp	bl_tsel
bl_loop_2:	cpi	r16,'W'
		brne	bl_loop_3
		rjmp	bl_write
bl_loop_3:	cpi	r16,'R'
		brne	bl_dloop
		rjmp	bl_read
bl_end:
		ret

;------------------------------------------------------------------------------
; send one byte with 38,4K
; data byte= r16, destroyed r18,r19
;------------------------------------------------------------------------------
send_byte:	ldi	r18,8			;no of bits

		cbi	SO_PORT,SO_PNR		;2	start bit
		ldi	r19,173			;1
send_byte_0:	dec	r19			;173
		brne	send_byte_0		;345

send_byte_1:	sbrc	r16,0			;1/2
		sbi	SO_PORT,SO_PNR		;2	bit = 1
		sbrs	r16,0			;1/2
		cbi	SO_PORT,SO_PNR		;2	bit = 0

;+5
		lsr	r16			;1
		ldi	r19,170			;1
send_byte_2:	dec	r19			;170
		brne	send_byte_2		;339

		dec	r18			;1
		nop				;1
		nop				;1
		brne	send_byte_1		;2

		sbi	SO_PORT,SO_PNR		;2	stop bit

		ldi	r19,0			;1
send_byte_3:	dec	r19			;256
		nop
		brne	send_byte_3		;511
		ret

;------------------------------------------------------------------------------
; receive one byte with 38,4K
; data byte= r16, result code= r17, destroyed r18,r19
;------------------------------------------------------------------------------
recv_byte:
recv_byte_1:	sbis	SI_PIN,SI_PNR		;2/1
		rjmp	recv_byte_1		;0/2

recv_byte_3:	ldi	r19,86			;1

recv_byte_4:	dec	r19			;86
		brne	recv_byte_4		;171
		clr	r17			;clear error flag

		ldi	r18,8			;8 bits
		ldi	r16,0			;data byte

recv_byte_5:	lsr	r16			;1
		ldi	r19,171			;1
recv_byte_6:	dec	r19			;171
		brne	recv_byte_6		;341
		sbis	SI_PIN,SI_PNR		;2/1
		ori	r16,0x80		;1
		nop				;1
		nop				;1
		dec	r18			;1
		brne	recv_byte_5		;2

		ldi	r19,171			;1 wait for stop bit
recv_byte_7:	dec	r19			;171
		brne	recv_byte_7		;341
		sbic	SI_PIN,SI_PNR		;2/1
		ldi	r17,0x02		;1 frame error
		ret

;------------------------------------------------------------------------------
; output text, Z=pointer in flash
;------------------------------------------------------------------------------
bl_text:	lpm	r16,Z+
		cpi	r16,0x00
		breq	bl_text_1
		rcall	send_byte
		rjmp	bl_text
bl_text_1:	ret

;------------------------------------------------------------------------------
; output text, Z=pointer in flash
;------------------------------------------------------------------------------
bl_newline:	ldi	r16,0x0d
		rcall	send_byte
		ldi	r16,0x0a
		rjmp	send_byte

;------------------------------------------------------------------------------
; output decimal, r17=data
;------------------------------------------------------------------------------
bl_outdez3:	ldi	r16,0x2f		;"0"-1
bl_outdez3_1:	inc	r16
		subi	r17,0x64		;-100
		brcc	bl_outdez3_1
		rcall	send_byte
		subi	r17,0x9c		;+100
bl_outdez2:	ldi	r16,0x2f		;"0"-1
bl_outdez2_1:	inc	r16
		subi	r17,0x0a		;-10
		brcc	bl_outdez2_1
		rcall	send_byte
		subi	r17,0xf6		;+10
bl_outdez1:	subi	r17,0xd0		;+0x30
		mov	r16,r17
		rjmp	send_byte


;------------------------------------------------------------------------------
; file list
;------------------------------------------------------------------------------
bl_flist:	sts	fileio_ram+33,const_0	;start with file 0
bl_flist_1:	lds	r17,fileio_ram+33	;get file no
		rcall	bl_outdez2
		ldi	r16,0x20		;space
		rcall	send_byte
		call	fsys_rname
		ldi	YL,LOW(fileio_ram+16)
		ldi	YH,HIGH(fileio_ram+16)
		ld	XL,Y
		sbrc	XL,7
		rcall	bl_outnname
		sbrs	XL,7
		rcall	bl_outname
		lds	XL,fileio_ram+33
		inc	XL
		cpi	XL,32
		breq	bl_newline
		sts	fileio_ram+33,XL
		sbrc	XL,0
		rcall	bl_spaces
		sbrs	XL,0
		rcall	bl_newline
		rjmp	bl_flist_1


bl_outnname:	ldi	ZL,LOW(bltext3*2)
		ldi	ZH,HIGH(bltext3*2)
		rjmp	bl_text	

bl_spaces:	ldi	r17,10
bl_spaces_1:	ldi	r16,0x20
		rcall	send_byte
		dec	r17
		brne	bl_spaces_1
		ret

bl_outname:	ldi	XH,10
bl_outname_1:	ldi	ZL,LOW(bl_conv*2)
		ldi	ZH,HIGH(bl_conv*2)
		ld	r0,Y+
		add	ZL,r0
		adc	ZH,const_0
		lpm	r16,Z
		rcall	send_byte
		dec	XH
		brne	bl_outname_1
		ret

;------------------------------------------------------------------------------
; scan line
;------------------------------------------------------------------------------
bl_scanline:	ldi	YL,LOW(fileio_ram)
		ldi	YH,HIGH(fileio_ram)
		ldi	XL,0			;max chars
		st	Y,const_0		;line end

bl_scanline_1:	rcall	recv_byte		;get byte
		cpi	r17,1
		breq	bl_scanline_e		;timeout
		cpi	r16,0x0a
		breq	bl_scanline_e		;LF
		cpi	r16,0x0d
		breq	bl_scanline_e		;LF
		cpi	r16,0x08
		breq	bl_scanline_2		;BS
		cpi	r16,0x20
		brcs	bl_scanline_1
		cpi	r16,0x61
		brcs	bl_scanline_1a
		subi	r16,0x20
bl_scanline_1a:	cpi	XL,16
		breq	bl_scanline_1
		inc	XL
		st	Y,r16
		adiw	YL,1
		st	Y,const_0		;new text end
		rcall	send_byte
		rjmp	bl_scanline_1

bl_scanline_2:	cpi	XL,0			;first pos
		breq	bl_scanline_1		;ignore
		dec	XL
		sbiw	YL,1
		st	Y,const_0		;new text end
		rcall	send_byte
		rjmp	bl_scanline_1

bl_scanline_e:	rjmp	bl_newline

;------------------------------------------------------------------------------
; select tape
;------------------------------------------------------------------------------
bl_tsel:	sts	fileio_ram+32,r17
bl_tsel_e:	rjmp	bl_loop

;------------------------------------------------------------------------------
; read file
;------------------------------------------------------------------------------
bl_read:	cpi	r17,32
		brcc	bl_read_e
		sts	fileio_ram+33,r17
		call	fsys_rname
		ldi	YL,LOW(fileio_ram+16)
		ldi	YH,HIGH(fileio_ram+16)
		ld	XL,Y
		sbrc	XL,7
		rjmp	bl_dloop
		ldi	ZL,LOW(bltext4*2)
		ldi	ZH,HIGH(bltext4*2)
		rcall	bl_text
		rcall	recv_byte
		cpi	r17,0x00
		brne	bl_read_e
		cpi	r16,0x15
		brne	bl_read_e
		ldi	XH,0
		ldi	r21,1			;XM block number
bl_read_1:	sts	fileio_ram+35,XH	;block
		rcall	fsys_rblock
		ldi	YL,0
		ldi	YH,bl_buffer
		ldi	ZL,4
bl_read_2:	rcall	xm_sendblock
		dec	ZL
		brne	bl_read_2
		lds	XH,fileio_ram+35
		inc	XH
		cpi	XH,32
		brne	bl_read_1
		ldi	r16,0x04		;EOT
		rcall	send_byte		;send
		rcall	recv_byte		;get ACK
bl_read_e:	rjmp	bl_write_e

;------------------------------------------------------------------------------
; write file
;------------------------------------------------------------------------------
bl_write:	cpi	r17,32
		brcc	bl_write_e
		sts	fileio_ram+33,r17
		ldi	ZL,LOW(bltext5*2)
		ldi	ZH,HIGH(bltext5*2)
		rcall	bl_text
		ldi	ZL,0
		ldi	ZH,0
bl_write_1:	ldi	XL,0x00
		ldi	XH,0x05
bl_write_2:	sbiw	XL,1			;2
		brne	bl_write_2
		sbiw	ZL,1
		brne	bl_write_1
		ldi	r16,0x15
		rcall	send_byte
		ldi	XH,0
bl_write_3:	sts	fileio_ram+35,XH	;block
		ldi	YL,0
		ldi	YH,bl_buffer
		ldi	ZL,4			;xmodem blocks per file block
bl_write_4:	rcall	xm_recvblock
		dec	ZL
		breq	bl_write_5
		ldi	r16,0x06		;ACK
		rcall	send_byte
		rjmp	bl_write_4
bl_write_5:	call	fsys_wblock
		ldi	r16,0x06		;ACK
		rcall	send_byte
		lds	XH,fileio_ram+35
		inc	XH
		cpi	XH,32
		brne	bl_write_3
		rcall	recv_byte		;get EOT
		ldi	r16,0x06		;send ack
		rcall	send_byte

bl_write_e:	ldi	ZL,0x80
bl_write_e1:	ldi	XL,0x00
		ldi	XH,0x00
bl_write_e2:	sbiw	XL,1			;2
		brne	bl_write_e2
		dec	ZL
		brne	bl_write_e1
		rjmp	bl_loop

;------------------------------------------------------------------------------
; send one XMODEM block
;------------------------------------------------------------------------------
xm_sendblock:	ldi	r16,0x01		;SOH
		rcall	send_byte
		mov	r16,r21			;block number
		rcall	send_byte
		mov	r16,r21			;block number
		com	r16
		rcall	send_byte
		clr	r20			;checksum
		ldi	ZH,0x80
xm_sendblock_1:	ld	r16,Y+
		add	r20,r16
		rcall	send_byte
		dec	ZH
		brne	xm_sendblock_1
		mov	r16,r20
		rcall	send_byte		;send CRC
		rcall	recv_byte		;ack/nak
		cpi	r16,0x06		;ack
		brne	xm_sendblock		;repeat block
xm_sendblock_e:	inc	r21
		ret

;------------------------------------------------------------------------------
; receive one XMODEM block (error conditions ignored)
;------------------------------------------------------------------------------
xm_recvblock:	rcall	recv_byte		;SOH
		cpi	r16,0x01
		brne	xm_recvblock
		rcall	recv_byte		;(dummy) block number
		rcall	recv_byte		;(dummy) complemented block number
		ldi	ZH,0x80
xm_recvblock_1:	rcall	recv_byte
		st	Y+,r16
		dec	ZH
		brne	xm_recvblock_1
		rcall	recv_byte		;csum
xm_recvblock_e:	ret


bltext1:	.db	"AX81 Bootloader V0.25 TAPE ",0
bltext2:	.db	"CMD (Q/T/W/R): ",0
bltext3:	.db	"----------",0,0
bltext4:	.db	0x0d,0x0a,"Start XMODEM download now!",0,0
bltext5:	.db	0x0d,0x0a,"starting transfer in 10 seconds...",0,0

;convert table ZX char => ASCII char
bl_conv:	.db	0x20,0x5f,0x5f,0x5f,0x5f,0x5f,0x5f,0x5f,0x5f,0x5f,0x5f,0x22,0x26,0x24,0x3a,0x3f
		.db	0x28,0x29,0x3e,0x3c,0x3d,0x2b,0x2d,0x2a,0x2f,0x3b,0x2c,0x2e,0x30,0x31,0x32,0x33
		.db	0x34,0x35,0x36,0x37,0x38,0x39,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a
		.db	0x4b,0x4c,0x4d,0x4e,0x4f,0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a

