
intro:		ldi	r19,0x08
		rcall	intro_clear		;clear screen
		ldi	XL,0
		ldi	XH,4
		ldi	r20,38+128		;'A'
		rcall	bigchar		;clear screen
		ldi	r20,61+128		;'X'
		rcall	bigchar		;clear screen
		ldi	r20,0x24		;'8'
		rcall	bigchar		;clear screen
		ldi	r20,0x1d		;'1'
		rcall	bigchar		;clear screen

		ldi	XL,5
		ldi	XH,13
		ldi	ZL,LOW(intro_text*2)
		ldi	ZH,HIGH(intro_text*2)
		rcall	intro_flashtext

		call	fsys_init
		rjmp	intro_2


intro_2:	sts	libmio_nmi,const_1
		sts	libmio_keycode,const_0
		ldi	XL,240
		sts	zx_ram+0x34,XL
		sts	zx_ram+0x35,const_0
introloop:	lds	XL,libmio_keycode
		cpi	XL,0x00
		brne	introloop_exit
		lds	XL,zx_ram+0x34
		cpi	XL,0x00
		brne	introloop
introloop_exit:	ret

introloop_fsys:	ret


		;generate an empty screen
intro_clear:	cli
		ldi	YH,HIGH(zx_ram+0x7d)	;video mem
		ldi	YL,LOW(zx_ram+0x7d)
		ldi	r16,0x76		;halt
		st	Y+,r16
		ldi	XH,24
intro_vclear_1:	ldi	XL,32
intro_vclear_2:	st	Y+,r19
		dec	XL
		brne	intro_vclear_2
		st	Y+,r16
		dec	XH
		brne	intro_vclear_1
		ldi	XL,0x7d
		ldi	XH,0x40
		sts	zx_ram+0x0c,XL
		sts	zx_ram+0x0d,XH
		ldi	XL,0xc0			;slow
		sts	zx_ram+0x3b,XL
		sei
		ret


		;write char r19 (X=coords)
char:		cpi	XL,32
		brcs	char_0
		clr	XL
		inc	XH
char_0:	cpi	XH,24
		brcs	char_1
		clr	XH
char_1:	ldi	YL,0x7e
		ldi	YH,HIGH(zx_ram)
		ldi	r16,33
		mul	r16,XH
		add	YL,r0
		adc	YH,r1
		add	YL,XL
		adc	YH,const_0
		st	Y,r19
		inc	XL			;next X
char_2:	sts	libmio_xpos,XL
		sts	libmio_ypos,XH
		ret


		;write a bit 6 terminated string from flash to screen
intro_flashtext:	lpm	r19,Z+
		sbrc	r19,6
		ret
		rcall	char			;write to screen
		rjmp	intro_flashtext



		;write a bit 7 terminated string from ram to screen
intro_ramtext:	ld	r19,Z
		andi	r19,0x3f
		rcall	char			;write to screen
		ld	r19,Z+
		sbrc	r19,7
		ret
		rjmp	intro_ramtext

nchar:		push	XL
		push	XH
		push	YL
		push	YH
		push	r16
		push	r19
		push	r0
		push	r1
		lds	XL,libmio_xpos
		lds	XH,libmio_ypos
		mov	r19,r20
		andi	r19,0xbf
		rcall	char
		pop	r1
		pop	r0
		pop	r19
		pop	r16
		pop	YH
		pop	YL
		pop	XH
		pop	XL
		ret


		;write a big char to screen, r20=char
bigchar:	ldi	ZH,HIGH(libmio_ctable*2)
		mov	ZL,r20
		andi	ZL,0xbf			;limit to 0..63 / 128..191
		ldi	r21,8			;lines
bigchar_1:	lpm	r23,Z			;get pixline
		com	r23
		ldi	r22,8			;8 pix
bigchar_2:	clr	r19
		lsl	r23
		ror	r19
		rcall	char
		dec	r22
		brne	bigchar_2
		inc	ZH			;next pixline
		subi	XL,8
		inc	XH
		dec	r21
		brne	bigchar_1
		subi	XH,8
		subi	XL,0xf8
		ret


intro_text:	.db	0x08,0x00,0x3b,0x1c,0x1b,0x1e,0x23,0x00
		.db	0x10,0x28,0x11,0x00,0x2f,0x1b
		.db	0x3c,0x34,0x31,0x2b,0x37,0x26,0x32,0x00
		.db	0x08,0xff

