--------------------------------------------------------------------------------
-- Company: 
-- Engineer:		Joerg Wolfram
--
-- Create Date:    	16.02.2006
-- Design Name:    
-- Module Name:    	lpdecoder_01
-- Project Name:   
-- Target Device:   
-- Tool versions:  
-- Description:		ASCII-Decoder for 0-9 A-F a-f * +
--
-- Revision:		1.0
-- License:		GPL
--------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity decoder1 is
    port ( lpbits : in std_logic_vector(6 downto 0);
    zahl,store : out std_logic;
    nvalue : out std_logic_vector(3 downto 0));
end entity decoder1;

architecture version1 of decoder1 is

begin
    process (lpbits) is
    begin
	case lpbits is
	    when "0110000" => nvalue <= "0000"; zahl <= '1';
	    when "0110001" => nvalue <= "0001"; zahl <= '1';
	    when "0110010" => nvalue <= "0010"; zahl <= '1';
	    when "0110011" => nvalue <= "0011"; zahl <= '1';
	    when "0110100" => nvalue <= "0100"; zahl <= '1';
	    when "0110101" => nvalue <= "0101"; zahl <= '1';
	    when "0110110" => nvalue <= "0110"; zahl <= '1';
	    when "0110111" => nvalue <= "0111"; zahl <= '1';
	    when "0111000" => nvalue <= "1000"; zahl <= '1';
	    when "0111001" => nvalue <= "1001"; zahl <= '1';
	    when "1000001" => nvalue <= "1010"; zahl <= '1';
	    when "1000010" => nvalue <= "1011"; zahl <= '1';
	    when "1000011" => nvalue <= "1100"; zahl <= '1';
	    when "1000100" => nvalue <= "1101"; zahl <= '1';
	    when "1000101" => nvalue <= "1110"; zahl <= '1';
	    when "1000110" => nvalue <= "1111"; zahl <= '1';
	    when "1100001" => nvalue <= "1010"; zahl <= '1';
	    when "1100010" => nvalue <= "1011"; zahl <= '1';
	    when "1100011" => nvalue <= "1100"; zahl <= '1';
	    when "1100100" => nvalue <= "1101"; zahl <= '1';
	    when "1100101" => nvalue <= "1110"; zahl <= '1';
	    when "1100110" => nvalue <= "1111"; zahl <= '1';
	    when others => nvalue <= "----" ; zahl <= '0';	    
	end case;
	 
	--- "*" and "+" differs only in bit 0  so this bit can be ignored	
	
	case lpbits(6 downto 1) is
	    when "010101" =>  store <= '1';
	    when others => store <= '0';
	end case;

    end process;

end architecture version1;
