--------------------------------------------------------------------------------
-- Company: 
-- Engineer:		Joerg Wolfram
--
-- Create Date:    	16.02.2006
-- Design Name:    
-- Module Name:    
-- Project Name:  	parout16 
-- Target Device:  	XC9536  
-- Tool versions:  
-- Description:		16-Channel async/sync LPT-Output
--
-- Revision:		1.0
-- License:		GPL
--------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;


entity mylogik is
    
port ( 	lpdata : in std_logic_vector(6 downto 0);
	strobe : in std_logic;
	dreset : in std_logic;
	trigger: in std_logic;
	busy   : out std_logic;
	relais : inout std_logic_vector(15 downto 0));
	   
end entity mylogik;


architecture version1 of mylogik is

signal nummer,setout : std_logic;
signal nibble : std_logic_vector(3 downto 0);
signal d1,d2,d3,d4 : std_logic_vector(3 downto 0);


component datareg is
    port ( lpstrobe : in std_logic;
    zahl : in std_logic;
    invalue : inout std_logic_vector(3 downto 0);
    da1 : inout std_logic_vector(3 downto 0);
    da2 : inout std_logic_vector(3 downto 0);
    da3 : inout std_logic_vector(3 downto 0);
    da4 : inout std_logic_vector(3 downto 0));
end component datareg;

component decoder1 is
    port ( lpbits : in std_logic_vector(6 downto 0);
    zahl,store : inout std_logic;
    nvalue : inout std_logic_vector(3 downto 0));
end component decoder1;   


begin
    I1:	decoder1 port map (lpbits => lpdata, nvalue => nibble, zahl => nummer, store => setout);
    I2: datareg port map (lpstrobe => strobe, zahl => nummer, invalue => nibble, da1 => d1, da2 => d2, da3 => d3, da4 => d4);

    process(strobe,dreset,setout) is
    begin
	if (falling_edge(strobe) and setout = '1' and dreset='1')
	then
	    relais(0) <= d1(0);
	    relais(1) <= d1(1);
	    relais(2) <= d1(2);
	    relais(3) <= d1(3);
	    relais(4) <= d2(0);
	    relais(5) <= d2(1);
	    relais(6) <= d2(2);
	    relais(7) <= d2(3);
	    relais(8) <= d3(0);
	    relais(9) <= d3(1);
	    relais(10) <= d3(2);
	    relais(11) <= d3(3);
	    relais(12) <= d4(0);
	    relais(13) <= d4(1);
	    relais(14) <= d4(2);
	    relais(15) <= d4(3);
	 end if;
	 if (dreset='0')
	 then
	  relais <= "1111111111111111";
	 end if; 
    end process;    
    
    process(strobe,trigger,lpdata,dreset) is
    begin
	if (strobe='0' and setout='1' and lpdata(0)='1')
        then
    	    busy <='1';
        elsif (dreset='0')
        then
    	    busy <='0';
        elsif (rising_edge(trigger))
        then
    	    busy <='0';
    	end if;  
    end process;

end architecture version1;    


configuration main of mylogik is
    for version1
    end for;
end configuration main;

