;################################################################################
;#										#
;# AX81 computer with ATmega644/1284						#
;# copyright (c) 2010-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License as		#
;# published by the Free Software Foundation; either version 3 of		#
;# the License, or (at your option) any later version.				#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;--------------------------------------------------------------------------------
; common definitions
;--------------------------------------------------------------------------------
.def	const_0 = r2
.def	const_1 = r3
.def	mmap_base = r12

.include "/usr/local/include/avr/m1284Pdef.inc"

.equ		vsys_kbuf	= 0x0100	;16 bytes keyboard buffer
.equ		vsys_ram	= 0x0110	;48 bytes vsys system RAM
.equ		z80emu_ram	= 0x0140	;32 bytes shadow register etc.
.equ		fsys_ram	= 0x0160	;64 bytes filesystem ram
.equ		mon_ram		= 0x01a0	;16 bytes monitor RAM
.equ		stack		= 0x01ff	;stack
.equ		zx_ram		= 0x0200	;start of ZX memory

.equ		sys_dfile	= 0x3e		;system dfile high address
.equ		fsys_buffer	= 0x3f00	;filesystem buffer

.equ		T_ERR		= 0x1c		;"T" error for ZX81

.include	"config.inc"


;--------------------------------------------------------------------------------
; module specific definitions
;--------------------------------------------------------------------------------
.include	"emulator/definitions.inc"
.include	"vsys/definitions.inc"
.if clock_freq < 20
	.include	"vsys/speed1/timing.inc"
	.include	"vsys/speed1/timing_vgadummy.inc"
.endif
.if clock_freq == 20
	.include	"vsys/speed2/timing.inc"
	.include	"vsys/speed2/timing_tvdummy.inc"
.endif
.if clock_freq > 20
	.include	"vsys/speed3/timing.inc"
.endif

.include	"modules/definitions.inc"

;--------------------------------------------------------------------------------
; macro definitions
;--------------------------------------------------------------------------------
.include	"memory/macros.asm"
.include	"emulator/macros.asm"


.CSEG
;--------------------------------------------------------------------------------
; here starts the code
;--------------------------------------------------------------------------------

.org 0x0000
		jmp	start
.org 0x0004
		.db 1,0				;System/version

.org OC2Baddr
		jmp	vint_bstart		;border start

.org OVF2addr
		jmp	vint_bstop		;border end

.org OC1Baddr
		jmp	vint_vstart		;video interrupt VGA/TV

start:		cli				;disable video after jmp 0
		ldi	XL,0x00
		mov	const_0,XL
		ldi	XL,0x01
		mov	const_1,XL

		ldi	XL,0x08
		sts	WDTCSR,XL		;enable watchdog

		ldi	XL,HIGH(stack)
		out	SPH,XL
		ldi	XL,LOW(stack)
		out	SPL,XL
		out	SPCR,const_0		;disable SPI

		out	RAMPZ,const_1		;set for elpm

		sts	mon_view,const_0

		ldi	ZL,0
		ldi	ZH,0
start_wl1:	wdr
		sbiw	ZL,1
		brne	start_wl1

		ldi	YL,0xaa
		ldi	YH,0x01
		call	eeprom_read

		ldi	YL,0xff
		ldi	YH,0x0f
		call	eeprom_read
		sbrs	r16,7
		rjmp	start_wl2
		clr	r16
		call	eeprom_write

start_wl2:	call	vsys_init		;activate video
		sts	sys_autostart,const_1

		call	intro			;intro screen
		ldi	YL,0xff
		ldi	YH,0x0f
		call	eeprom_read
		sts	vsys_mode,r16

		cbi	GPIOR0,2		;FAST
		sbrs	r16,5
		sbi	GPIOR0,2		;STD

		rcall	sys_msel

loop:		jmp	emu_start		;start emulator
		rjmp	loop


sys_msel:	lds	r16,vsys_mode		;get mode
		andi	r16,0x0f		;possible memory maps
		mov	mmap_base,r16
		ldi	r17,0x88
		add	mmap_base,r17

		out	RAMPZ,const_1
		ldi	r17,0x05
		cpse	r16,r17			;SPEC
		ldi	XL,0x40
		cpi	r16,0x04		;jupiter ACE loacates < 0x8000
		brne	no_ace
		ldi	XL,0x3c
		out	RAMPZ,const_0

no_ace:		sts	mon_dump_h,XL
		cbi	PORTB,7			;disable break flag
		ldi	XL,HIGH(emu_jtab)
		lds	r17,vsys_mode
		cpi	r16,0x04
		brcc	start_setjump
		sbrc	r17,4			;skip if max speed
		ldi	XL,HIGH(emu_jbtab)
start_setjump:	out	OCR0B,XL
		ret

;--------------------------------------------------------------------------------
; the emulator engine
;--------------------------------------------------------------------------------
.include	"emulator/emulator.asm"
.include	"emulator/emulator_cb.asm"
.include	"emulator/emulator_xd.asm"
.include	"emulator/emulator_xdcb.asm"
.include	"emulator/emulator_ed.asm"
.include	"emulator/emulator_io.asm"
.include	"emulator/emulator_int.asm"
.include	"emulator/emulator_res.asm"
.include	"emulator/emulator_brake.asm"

;--------------------------------------------------------------------------------
; video routines
;--------------------------------------------------------------------------------
.if clock_freq < 20
	.include	"vsys/speed1/vint_tv0_rom.asm"
	.include	"vsys/speed1/vint_tv1_ram.asm"
	.include	"vsys/speed1/vint_tv2_ram.asm"
	.include	"vsys/speed1/vint_tv3_zx80.asm"
	.include	"vsys/speed1/vint_tv4_ace.asm"
	.include	"vsys/speed1/vint_tv5_specm.asm"
	.include	"vsys/speed1/vint_tv8_mon.asm"
	.include	"vsys/speed1/vint_vgadummy.asm"
.endif

.if clock_freq == 20
	.include	"vsys/speed2/vint_vga0_rom.asm"
	.include	"vsys/speed2/vint_vga1_ram.asm"
	.include	"vsys/speed2/vint_vga2_ram.asm"
	.include	"vsys/speed2/vint_vga3_zx80.asm"
	.include	"vsys/speed2/vint_vga4_ace.asm"
	.include	"vsys/speed2/vint_vga5_specm.asm"
	.include	"vsys/speed2/vint_vga8_mon.asm"
	.include	"vsys/speed2/vint_tvdummy.asm"
.endif

.if clock_freq > 20
	.include	"vsys/speed3/vint_vga0_rom.asm"
	.include	"vsys/speed3/vint_vga1_ram.asm"
	.include	"vsys/speed3/vint_vga2_ram.asm"
	.include	"vsys/speed3/vint_vga3_zx80.asm"
	.include	"vsys/speed3/vint_vga4_ace.asm"
	.include	"vsys/speed3/vint_vga5_specm.asm"
	.include	"vsys/speed3/vint_vga8_mon.asm"
.endif

;--------------------------------------------------------------------------------
; tables area
;--------------------------------------------------------------------------------
.org 0x4280
.include	"tables/csconf_zx81.inc"

.org 0x4300
zxdec:
.if kbd_type == 1
.include	"tables/zxdecode_de.inc"
.endif
.if kbd_type == 2
.include	"tables/zxdecode_uk.inc"
.endif

vsys_kstab:
.include	"tables/kstable.inc"

.org 0x4400
.include	"memory/memmap_zx81_std.asm"
.include	"memory/memmap_zx81_udg.asm"
.include	"memory/memmap_zx81_chrs.asm"
.include	"memory/memmap_zx80.asm"
.include	"memory/memmap_jace.asm"
.include	"memory/memmap_spec.asm"
.include	"memory/memmap_dummy.asm"
.include	"memory/memmap_dummy.asm"

.include	"memory/memmap_zx81_std_io.asm"
.include	"memory/memmap_zx81_udg_io.asm"
.include	"memory/memmap_zx81_chrs_io.asm"
.include	"memory/memmap_zx80_io.asm"
.include	"memory/memmap_jace_io.asm"
.include	"memory/memmap_spec_io.asm"
.include	"memory/memmap_dummy.asm"
.include	"memory/memmap_dummy.asm"



.org 0x4d00
vsys_ktables:
.if kbd_type == 1
.include	"tables/keytable_de.inc"
.endif
.if kbd_type == 2
.include	"tables/keytable_uk.inc"
.endif

vsys_zktable:
.if kbd_type == 1
.include	"tables/zxkeys_de.inc"
.endif
.if kbd_type == 2
.include	"tables/zxkeys_uk.inc"
.endif


.include	"tables/pktab.inc"
.include	"tables/flagconv.inc"
.include	"emulator/flags.asm"

.org 0x5180
;empty (0xff) for jace nomem read

.org 0x5200
.include	"tables/spec_attr.inc"
.include	"tables/spec_pixel.inc"


.org 0x5400
vsys_ctable:
.include	"tables/cset_zx81.inc"
vsys_ctable80:
.include	"tables/cset_zx80.inc"


.org 0x5c00
.if kbd_type == 1
kmatrix_zx81:
.include	"tables/kmatrix_zx81_de.inc"
kmatrix_zx80:
.include	"tables/kmatrix_zx80_de.inc"
kmatrix_jace:
.include	"tables/kmatrix_jace_de.inc"
kmatrix_spec:
.include	"tables/kmatrix_spec_de.inc"
.endif
.if kbd_type == 2
kmatrix_zx81:
.include	"tables/kmatrix_zx81_uk.inc"
kmatrix_zx80:
.include	"tables/kmatrix_zx80_uk.inc"
kmatrix_jace:
.include	"tables/kmatrix_jace_uk.inc"
kmatrix_spec:
.include	"tables/kmatrix_spec_uk.inc"
.endif

.org 0x6c00
.include	"tables/romdata_jupiterace.inc"

vsys_sctable:
.include	"tables/cset_sys.inc"


.org 0x8000
;.include	"tables/csconf_zx81.inc"
.include	"modules/intro.asm"
.include	"modules/monitor.asm"
.include	"modules/sysfunc.asm"
.include	"modules/fsys.asm"
.include	"modules/fsys_zx81.asm"
.include	"modules/fsys_zx80.asm"
.include	"modules/fsys_jace.asm"
.include	"modules/fsys_spec.asm"
.include	"modules/llist.asm"
.include	"modules/eeprom.asm"

;--------------------------------------------------------------------------------
; video system / keyboard
;--------------------------------------------------------------------------------
.include	"vsys/init.asm"
.include	"vsys/substitution.asm"
.include	"vsys/vint_main.asm"
.include	"vsys/vint_frame.asm"
.include	"vsys/vint_keyboard.asm"


.if clock_freq > 20
	.include	"vsys/speed3/vint_tv0_rom.asm"
	.include	"vsys/speed3/vint_tv1_ram.asm"
	.include	"vsys/speed3/vint_tv2_ram.asm"
	.include	"vsys/speed3/vint_tv3_zx80.asm"
	.include	"vsys/speed3/vint_tv4_ace.asm"
	.include	"vsys/speed3/vint_tv5_specm.asm"
	.include	"vsys/speed3/vint_tv8_mon.asm"
.endif

.if clock_freq > 19
	.include	"vsys/vint_lcd3_zx80.asm"
	.include	"vsys/vint_lcd4_ace.asm"
	.include	"vsys/vint_lcd5_specm.asm"
	.include	"vsys/vint_lcd8_mon.asm"
	.include	"vsys/vint_lcd0_rom.asm"
	.include	"vsys/vint_lcd1_ram.asm"
	.include	"vsys/vint_lcd2_ram.asm"
.endif
.if clock_freq < 20
	.include	"vsys/speed1/vint_lcd3_zx80.asm"
	.include	"vsys/speed1/vint_lcd4_ace.asm"
	.include	"vsys/speed1/vint_lcd5_specm.asm"
	.include	"vsys/speed1/vint_lcd8_mon.asm"
	.include	"vsys/speed1/vint_lcd0_rom.asm"
	.include	"vsys/speed1/vint_lcd1_ram.asm"
	.include	"vsys/speed1/vint_lcd2_ram.asm"
.endif


.org 0xa000
snapshot:


.org 0xc000
.include	"tables/romdata_spectrum.inc"

.org 0xe000
.include	"tables/romdata_zx81.inc"

.org 0xf000
.include	"tables/romdata_zx80.inc"

.org 0xf800
.include	"tables/bench.inc"

.org 0xfe00
.include	"modules/memory.asm"

