;################################################################################
;#										#
;# fsys - file system library							#
;# copyright (c) 2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU  General Public				#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU  General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

fsys_check81:	lds	XL,fsys_status
		sbrc	XL,7
		ret
		ldi	XL,T_ERR
		sts	zx_ram,XL
		pop	r0
		pop	r0
		ret

;------------------------------------------------------------------------------
; save a file
;------------------------------------------------------------------------------
fsys_save_81:	call	fsys_check81

		ldi	YL,LOW(fsys_buf1)	;filename from request
		ldi	YH,HIGH(fsys_buf1)
		ldi	r16,10
		ldi	XL,' '
fsys_s81_1:	st	Y+,XL			;space
		dec	r16
		brne	fsys_s81_1
		lds	ZL,0x214		;4014 in ZX RAM
		lds	ZH,0x215		;4015 in ZX RAM
		subi	ZL,0x09
		sbci	ZH,0x40
		adiw	ZL,1			;store incl
		st	Y+,ZL
		st	Y+,ZH

fsys_s81_2:	movw	XL,reg_l
		andi	XH,0x3f			;limit to 16K
		subi	XH,0xfe			;sys offset
		ldi	YL,LOW(fsys_buf1)	;filename from request
		ldi	YH,HIGH(fsys_buf1)
		ldi	ZH,HIGH(cs81_conv*2)
		ldi	r16,10
fsys_s81_3:	ld	ZL,X+			;name char
		mov	r0,ZL			;save for end test
		ori	ZL,0x80			;conv direction is TO ASCII
		lpm	ZL,Z
		st	Y+,ZL
		sbrc	r0,7
		rjmp	fsys_s81_4
		dec	r16
		brne	fsys_s81_3
fsys_s81_4:	ldi	ZL,2			;SAVE
		call	fsys_llist
		cpi	ZL,1
		brne	fsys_s81_5
		jmp	fsys_wf81
fsys_s81_5:	ret				;exit with ESC


;------------------------------------------------------------------------------
; load a file
;------------------------------------------------------------------------------
fsys_load_81:	call	fsys_check81

		ldi	YL,LOW(fsys_buf1)	;filename from request
		ldi	YH,HIGH(fsys_buf1)
		ldi	r16,10
		ldi	XL,' '
fsys_l81_1:	st	Y+,XL			;space
		dec	r16
		brne	fsys_l81_1

fsys_l81_2:	movw	XL,reg_l
		sbrc	XH,7
		rjmp	fsys_l81_5		; LOAD "" opens file manager
		andi	XH,0x3f
		subi	XH,0xfe
		ldi	YL,LOW(fsys_buf1)	;filename from request
		ldi	YH,HIGH(fsys_buf1)
		ldi	ZH,HIGH(cs81_conv*2)
		ldi	r16,10
fsys_l81_3:	ld	ZL,X+			;name char
		mov	r0,ZL
		ori	ZL,0x80
		lpm	ZL,Z
		st	Y+,ZL
		sbrc	r0,7
		rjmp	fsys_l81_4
		dec	r16
		brne	fsys_l81_3
fsys_l81_4:	jmp	fsys_rf81
		ret

fsys_l81_5:	ldi	ZL,0x01			;LOAD
		call	fsys_llist
		cpi	ZL,1
		breq	fsys_rf81_04
		ret				;exit with ESC

;------------------------------------------------------------------------------
; read file
; fsys_tapenr	= tape
; fsys_filenr	= file
;------------------------------------------------------------------------------
fsys_rf81:	call	fsys_ff81		;find file
		cpi	ZL,0xff			;is "not found" code?
		brne	fsys_rf81_03		;branch if found
fsys_rf81_01:	ldi	XL,T_ERR-1
		sts	zx_ram,XL
		ret				;file not found

fsys_rf81_03:	sts	fsys_filenr,ZL		;file number
fsys_rf81_04:	sts	fsys_sectnr,const_0	;calc sector addr
		ldi	YL,LOW(fsys_buf2)
		ldi	YH,HIGH(fsys_buf2)
		ldi	XH,17			;read block
		call	fsys_xcmd		;send CMD
		call	fsys_waitsbt		;wait for start block token
		ldi	XH,12			;fname length + len
fsys_rf81_1:	call	fsys_write_ff
		st	Y+,XL
		dec	XH
		brne	fsys_rf81_1

		ldi	XH,251			;rest of 512 bytes
fsys_rf81_1a:	call	fsys_write_ff2
		dec	XH
		brne	fsys_rf81_1a

		lds	ZL,fsys_buf2
		cpi	ZL,0x80
		brcc	fsys_rf81_e		;empty file
		lds	ZL,(fsys_flen2_l)	;LEN LOW
		lds	ZH,(fsys_flen2_h)	;LEN HIGH
		ldi	YL,0x09			;start at 0x4009 in Z80 adr space
		ldi	YH,0x02
		sts	fsys_sectnr,const_0	;start data at sector 1-1

fsys_rf81_2:	lds	XL,fsys_sectnr		;next sector
		inc	XL
		sts	fsys_sectnr,XL
		ldi	XH,17			;read block
		call	fsys_xcmd		;send CMD
		call	fsys_waitsbt		;wait for start block token
		clr	r0
		ldi	XL,2
		mov	r1,XL			;512 bytes/sector

fsys_rf81_3:	call	fsys_write_ff		;get data byte
		cp	ZL,const_0
		cpc	ZH,const_0
		breq	fsys_rf81_4		;we must do a dummy read
		st	Y+,XL			;store data byte in RAM
		sbiw	ZL,1			;to-do bytes -1
fsys_rf81_4:	sub	r0,const_1
		sbc	r1,const_0
		brne	fsys_rf81_3
		call	fsys_write_ff2		;get CRC bytes
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive

		cp	ZL,const_0		;all done?
		cpc	ZH,const_0
		breq	fsys_rf81_e		;yes, we can exit
		rjmp	fsys_rf81_2

fsys_rf81_e:	ret				;all done


;------------------------------------------------------------------------------
; write file
; fsys_tapenr	= tape
; fsys_filenr	= file
;------------------------------------------------------------------------------
fsys_wf81:	sts	fsys_sectnr,const_0	;calc sector addr
		ldi	XH,24			;write block
		call	fsys_xcmd		;send CMD
		ldi	XL,0xfe			;start block token
		call	fsys_wspi		;send
		ldi	YL,LOW(fsys_buf1)
		ldi	YH,HIGH(fsys_buf1)
		ldi	XH,12			;fname length + len
fsys_wf81_1:	ld	XL,Y+
		call	fsys_wspi		;send
		dec	XH
		brne	fsys_wf81_1

		ldi	XH,251			;rest of 512 bytes + CRC
fsys_wf81_1a:	call	fsys_write_ff2		;send
		dec	XH
		brne	fsys_wf81_1a
fsys_wf81_1b:	call	fsys_write_ff		;put dummy byte
		cpi	XL,0xff
		brne	fsys_wf81_1b
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive

		lds	ZL,(fsys_flen1_l)	;LEN LOW
		lds	ZH,(fsys_flen1_h)	;LEN HIGH
		ldi	YL,0x09			;start at 0x4009 in Z80 adr space
		ldi	YH,0x02

fsys_wf81_2:	lds	XL,fsys_sectnr		;next sector
		inc	XL
		sts	fsys_sectnr,XL

		ldi	XH,24			;write block
		call	fsys_xcmd		;send CMD
		ldi	XL,0xfe			;start block token
		call	fsys_wspi		;send

		clr	r0
		ldi	XL,2
		mov	r1,XL			;512 bytes/sector

fsys_wf81_3:	ldi	XL,0xaa			;dummy byte
		mov	XH,ZL
		or	XH,ZH
		breq	fsys_wf81_4		;we must do a dummy byte write
		ld	XL,Y+			;get next data byte from RAM
		sbiw	ZL,1			;decrement TODO counter

fsys_wf81_4:	call	fsys_wspi		;send
		sub	r0,const_1
		sbc	r1,const_0
		brne	fsys_wf81_3		;sector is not full

		call	fsys_write_ff2		;put dummy CRC bytes
fsys_wf81_5:	call	fsys_write_ff		;put dummy byte
		cpi	XL,0xff
		brne	fsys_wf81_5
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive

		mov	XH,ZL
		or	XH,ZH
		brne	fsys_wf81_2		;not all done
		ret

;------------------------------------------------------------------------------
; find file
;------------------------------------------------------------------------------
fsys_ff81:	ldi	r16,0x00		;we start with file 0
		ldi	ZL,0xff			;file number
fsys_ff81_1:	sts	fsys_filenr,r16		;store file number
		call	fsys_rname		;get name
		ldi	YL,LOW(fsys_buf2)	;filename from file
		ldi	YH,HIGH(fsys_buf2)
		ldi	XL,LOW(fsys_buf1)	;filename from request
		ldi	XH,HIGH(fsys_buf1)

		ldi	r19,10			;chars to compare
fsys_ff81_2:	ld	r17,Y+			;from file
		cpi	r17,0x61
		brcs	fsys_ff81_3
		subi	r17,0x20

fsys_ff81_3:	ld	r18,X+			;from req
		cp	r17,r18
		brne	fsys_ff81_4		;not this file
		dec	r19
		brne	fsys_ff81_2
		lds	ZL,fsys_filenr		;found
		ret

fsys_ff81_4:	lds	r16,fsys_filenr
		inc	r16
		cpi	r16,32
		brne	fsys_ff81_1
		ldi	ZL,0xff			;not found
		ret

