
;-----------------------------------------------------------------------------------
; clear system screen
; R19=char
;-----------------------------------------------------------------------------------
sys_clear:	push	XL
		push	XH
		push	YL
		push	YH
		push	ZL
		ldi	YH,sys_dfile		;video mem
		ldi	YL,0
		ldi	XH,24
sys_vclear_1:	ldi	XL,32
sys_vclear_2:	st	Y+,r19
		dec	XL
		brne	sys_vclear_2
		dec	XH
		brne	sys_vclear_1
		pop	ZL
		pop	YH
		pop	YL
		pop	XH
		pop	XL
		ret

;-----------------------------------------------------------------------------------
; set write coords
; XL=X   XH=Y
;-----------------------------------------------------------------------------------
sys_gotoxy:	sts	vsys_xpos,XL
		sts	vsys_ypos,XH
		ret

sys_space:	ldi	r19,0x20

		;write char r19
sys_char:	push	XL
		push	XH
		push	YL
		push	YH
		push	ZL
		push	r19
		lds	XL,vsys_xpos
		lds	XH,vsys_ypos
		cpi	XL,32
		brcs	sys_char_0
		clr	XL
		inc	XH
sys_char_0:	cpi	XH,24
		brcs	sys_char_1
		clr	XH
sys_char_1:	ldi	YL,0
		ldi	YH,sys_dfile
		ldi	ZL,32
		mul	ZL,XH
		add	YL,r0
		adc	YH,r1
		add	YL,XL
		adc	YH,const_0
		andi	r19,0x7f
		lds	ZL,vsys_color
		andi	ZL,0x38
		cpi	ZL,0x10
		brcs	sys_char_2
		ori	r19,0x80		;invert
sys_char_2:	st	Y+,r19
		inc	XL			;next X
		sts	vsys_xpos,XL
		sts	vsys_ypos,XH
		pop	r19
		pop	ZL
		pop	YH
		pop	YL
		pop	XH
		pop	XL
		ret


		;write a bit 6 terminated string from flash to screen
sys_textxy:	rcall	sys_gotoxy
sys_flashtext:	push	XL
		in	XL,RAMPZ
		out	RAMPZ,const_1
sys_ftext_0:	elpm	r19,Z+
		cpi	r19,0x00
		breq	sys_ftext_1
		rcall	sys_char		;write to screen
		rjmp	sys_ftext_0
sys_ftext_1:	out	RAMPZ,XL
		pop	XL
		ret


sys_hexout:	push	r16
		push	r19
		mov	r19,r16
		swap	r19
		andi	r19,0x0f
		subi	r19,0xd0
		cpi	r19,0x3a
		brcs	sys_hexout_1
		subi	r19,0xf9
sys_hexout_1:	rcall	sys_char
		mov	r19,r16
		andi	r19,0x0f
		subi	r19,0xd0
		cpi	r19,0x3a
		brcs	sys_hexout_2
		subi	r19,0xf9
sys_hexout_2:	rcall	sys_char
		pop	r19
		pop	r16
		ret


