;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.macro	vchar_tv_ram1
	ld	ZL,X+		;2 get char
	mov	YL,ZL		;1 copy
	ldi	ZH,0x3c		;1 RAM BASE (UDG)
	lsl	ZL		;1 shift out inv bit
	lsl	ZL		;1
	lsl	ZL		;1 shift out bit 5
	adc	ZH,const_0	;1
	add	ZL,YH		;1 add vline (and 0x07) 
	ld	ZL,Z		;2
	sbrs	YL,7		;1 inv bit
	com	ZL		;1
	nop			;1
	sts	UDR1,ZL		;2
.endm	

vint_tv1_fl:	lds	ZL,vsys_field
		inc	ZL
		sts	vsys_field,ZL
		sbrc	ZL,0
		add	vline_l,const_1
		rjmp	vint_tv1_end

;-------------------------------------------------------------------------------
;video-interrupt (no registers destroyed, stack=13)
;-------------------------------------------------------------------------------
vint_tv1:	sbrc	vline_h,0		;1 skip if less than 256
		rjmp	vint_tv1_01		;2 no visible line
		ldi	ZH,192
		cp	vline_l,ZH		;1 max lines
		breq	vint_tv1_fl
		brcc	vint_tv1_01		;2 goto no image-line
		rjmp	vint_tv1_10		;2 goto image line

;-------------------------------------------------------------------------------
;no image line
;-------------------------------------------------------------------------------
vint_tv1_01:	ldi	ZH,vsys_vstart_p	;1 vstart pal
		sbis	GPIOR0,5		;1 pal/ntsc bit
		ldi	ZH,vsys_vstart_n	;1 vstart ntsc
		cp	vline_l,ZH
		brne	vint_tv1_02		;no vsync start
		cbi	VSPORT,VSPIN
		sbis	GPIOR0,7		;csync bit
		rjmp	vint_tv1_end
		ldi	XH,0x82			;invert CSYNC
		sts	TCCR1A,XH
		rjmp	vint_tv1_end

vint_tv1_02:	ldi	ZH,vsys_vstop_p	;1 vstop pal
		sbis	GPIOR0,5		;1 pal/ntsc bit
		ldi	ZH,vsys_vstop_n	;1 vstop ntsc
		cp	vline_l,ZH
		brne	vint_tv1_03		;no vsync stop
		sbi	VSPORT,VSPIN
		sbis	GPIOR0,7		;csync bit
		rjmp	vint_tv1_end
		ldi	XH,0xc2			;normal CSYNC
		sts	TCCR1A,XH
		rjmp	vint_tv1_end

vint_tv1_03:	ldi	ZH,vsys_vbstart_p	;1 border start pal
		sbis	GPIOR0,5		;1 pal/ntsc bit
		ldi	ZH,vsys_vbstart_n	;1 border start ntsc
		cp	vline_l,ZH
		brne	vint_tv1_04		;no border start
		sbi	GPIOR0,4
		rjmp	vint_tv1_end

vint_tv1_04:	ldi	ZH,vsys_vbstop_p	;1 border stop pal
		sbis	GPIOR0,5		;1 pal/ntsc bit
		ldi	ZH,vsys_vbstop_n	;1 border stop ntsc
		cp	vline_l,ZH
		brne	vint_tv1_05		;no border stop
		sbic	GPIOR0,fast_flag
		rjmp	vint_tv1_end
		cbi	GPIOR0,4
		rjmp	vint_tv1_end

vint_tv1_05:	ldi	ZH,LOW(vsys_vlines_p-1)	;1 maxlines pal
		sbis	GPIOR0,5		;1 pal/ntsc bit
		ldi	ZH,LOW(vsys_vlines_n-1)	;1 maxlines ntsc
		cp	vline_l,ZH
		breq	vint_tv1_06		;2 end of frame
		rjmp	vint_tv1_end

vint_tv1_06:	jmp	vint_frame

;-------------------------------------------------------------------------------
;image line
;-------------------------------------------------------------------------------
vint_tv1_10:	sbic	GPIOR0,fast_flag
		rjmp	vint_tv1_end

vint_tv1_11:	lds	YL,TCNT1L		;1 get timer
		sbrs	YL,0
		rjmp	vint_tv1_12
vint_tv1_12:	sbrs	YL,1
		lpm	r13,Z

vint_tv1_16:	ldi	ZL,0x18
		sts	UCSR1B,ZL
		mov	YH,vline_l		;
		andi	YH,0x07
		lds	XL,vsys_rampos_l	;get RAM position
		lds	XH,vsys_rampos_h

		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1

		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1

		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1

		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1
		vchar_tv_ram1

vint_tv1_22:	sts	UCSR1B,const_0
		cpi	YH,0x07
		breq	vint_tv1_24

		out	SREG,r15		;1 put back
		pop	XL			;2 restore Y-register
		pop	XH			;2 restore Y-register
		pop	YL			;2 restore Y-register
		pop	YH			;2 restore Y-register
		pop	ZL			;2 restore Z-register
		pop	ZH			;2 restore Z-register
		reti				;4 thats all

vint_tv1_24:	adiw	XL,1			;skip next halt
		sts	vsys_rampos_l,XL
		sts	vsys_rampos_h,XH

vint_tv1_end:	jmp	vsys_keyb

