;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.macro	vchar_vga_ram2
	ld	ZL,X+		;2 get char
	ldi	ZH,0x3a		;1 RAM BASE chr$128
	sbrc	ZL,7		;1
	ldi	ZH,0x3c		;1
	lsl	ZL		;1 shift out inv bit
	lsl	ZL		;1
	lsl	ZL		;1 shift out bit 5
	adc	ZH,const_0	;1
	add	ZL,YH		;1 add vline (and 0x07)
	ld	ZL,Z		;2
	sbrc	ZH,1		;1
	com	ZL		;1
	sts	UDR1,ZL		;2
.endm	


;-------------------------------------------------------------------------------
;check if line is image
;-------------------------------------------------------------------------------
vint_vg2:	movw	XL,vline_l
		lsr	XH
		ror	XL
		ldi	YL,0x18
		cpi	XL,200			;1 max lines
		sbrs	XH,0			;1 skip if less than 256
		brcs	vint_vg2_10

;-------------------------------------------------------------------------------
;no image line
;-------------------------------------------------------------------------------
vint_vg2_01:	cpi	XL,vsys_vstart_v
		brne	vint_vg2_02		;no vsync start
		cbi	VSPORT,VSPIN
		rjmp	vint_vg2_end

vint_vg2_02:	cpi	XL,vsys_vstop_v
		brne	vint_vg2_05		;no vsync stop
		sbi	VSPORT,VSPIN
		rjmp	vint_vg2_end

vint_vg2_05:	cpi	XL,7
		breq	vint_vg2_06		;2 end of frame
		rjmp	vint_vg2_end

vint_vg2_06:	jmp	vint_frame


vint_vg2_bo_0:	nop
		nop
vint_vg2_bo:	ldi	YL,3
vint_vg2_bo_1:	dec	YL
		brne	vint_vg2_bo_1
		nop
		nop
		ldi	YH,0x18
		sts	UCSR1B,YH
		ldi	YL,128
vint_vg2_bo_2:	nop
		dec	YL
		brne	vint_vg2_bo_2
		rjmp	vint_vg2_23

;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------
vint_vg2_10:	sbic	GPIOR0,fast_flag
		rjmp	vint_vg2_end

vint_vg2_11:	lds	YH,TCNT1L		;1 get timer
		sbrs	YH,0
		rjmp	vint_vg2_12
vint_vg2_12:	sbrs	YH,1
		lpm	r13,Z

vint_vg2_16:	subi	XL,4
		brcs	vint_vg2_bo_0
		cpi	XL,192
		brcc	vint_vg2_bo
		mov	YH,XL
		andi	YH,0x07
		lds	XL,vsys_rampos_l	;get RAM position
		lds	XH,vsys_rampos_h

		ld	ZL,X+		;2 get char
		ldi	ZH,0x3a		;1 RAM BASE chr$128
		sbrc	ZL,7		;1
		ldi	ZH,0x3c		;1
		lsl	ZL		;1 shift out inv bit
		lsl	ZL		;1
		sts	UCSR1B,YL	;2
		lsl	ZL		;1 shift out bit 5
		adc	ZH,const_0	;1
		add	ZL,YH		;1 add vline (and 0x07)
		ld	ZL,Z		;2
		sbrc	ZH,1		;1
		com	ZL		;1
		sts	UDR1,ZL		;2

		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2

		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2

		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2

		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2
		vchar_vga_ram2

vint_vg2_22:	mov	YH,vline_l		;
		andi	YH,0x0f
		cpi	YH,0x07
		nop
		nop
		nop
		nop
		nop
		breq	vint_vg2_24

vint_vg2_23:	out	SREG,r15		;1 put back
		nop
		nop
		nop
		pop	XL			;2 restore Y-register
		pop	XH			;2 restore Y-register
		pop	YL			;2 restore Y-register
		pop	YH			;2 restore Y-register
		pop	ZL			;2 restore Z-register
		pop	ZH			;2 restore Z-register
		sts	UCSR1B,const_0		;2 video off
		reti				;4 thats all

vint_vg2_24:	nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		adiw	XL,1			;skip next halt
		sts	vsys_rampos_l,XL
		sts	vsys_rampos_h,XH
		sts	UCSR1B,const_0		;2 video off
vint_vg2_end:	jmp	vsys_keyb

