;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
;check if line is image
;-------------------------------------------------------------------------------
vint_vg3:	movw	XL,vline_l
		lsr	XH
		ror	XL
		sbrc	XH,0			;1 skip if less than 256
		rjmp	vint_vg3_01		;2 no visible line
		cpi	XL,200			;1 max lines
		brcs	vint_vg3_10

;-------------------------------------------------------------------------------
;no image line
;-------------------------------------------------------------------------------
vint_vg3_01:	cpi	XL,vsys_vstart_v
		brne	vint_vg3_02		;no vsync start
		cbi	VSPORT,VSPIN
		rjmp	vint_vg3_end

vint_vg3_02:	cpi	XL,vsys_vstop_v
		brne	vint_vg3_05		;no vsync stop
		sbi	VSPORT,VSPIN
		rjmp	vint_vg3_end

vint_vg3_05:	cpi	XL,7
		breq	vint_vg3_06		;2 end of frame
		rjmp	vint_vg3_end

vint_vg3_06:	jmp	vint_frame

vint_vg3_bo_0:	nop
		nop
vint_vg3_bo:	ldi	YL,2
vint_vg3_bo_1:	dec	YL
		brne	vint_vg3_bo_1
		nop
		ldi	YH,0x18
		sts	UCSR1B,YH
		ldi	YL,128
vint_vg3_bo_2:	nop
		dec	YL
		brne	vint_vg3_bo_2
		rjmp	vint_vg3_23

;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------
vint_vg3_10:	sbic	GPIOR0,fast_flag
		rjmp	vint_vg3_end
		nop
		nop
		nop
		nop


vint_vg3_11:	lds	YL,TCNT1L		;1 get timer
		sbrs	YL,0
		rjmp	vint_vg3_12
vint_vg3_12:	sbrs	YL,1
		lpm	r13,Z

vint_vg3_16:	subi	XL,4
		brcs	vint_vg3_bo_0
		cpi	XL,192
		brcc	vint_vg3_bo
		andi	XL,0x07			;pixlines per char
		ldi	ZH,HIGH(vsys_ctable80*2)
		add	ZH,XL
		lds	XL,vsys_rampos_l	;get RAM position
		lds	XH,vsys_rampos_h
		ldi	YL,32			;chars to do
		ldi	YH,0x18
		sts	UCSR1B,YH
		ld	ZL,X+			;2
		sbrc	ZL,6			;1
		rjmp	vint_vg3_21		;1/2
		lpm	ZL,Z			;3
		sts	UDR1,ZL			;2 char 0
		ldi	YL,31			;1

vint_vg3_18:	ld	ZL,X+			;2
		sbrc	ZL,6			;1
		rjmp	vint_vg3_20		;1/2
vint_vg3_19:	nop				;1
		nop				;1
		lpm	ZL,Z			;3
		nop				;1
		sts	UDR1,ZL			;2
		nop				;1
		dec	YL			;1
		brne	vint_vg3_18		;2
		adiw	XL,1			;2 skip next halt

vint_vg3_20:	cpi	YL,0			;1
		breq	vint_vg3_22		;1/2
		nop				;1
		ldi	ZL,0xff			;1
		sts	UDR1,ZL			;2
vint_vg3_21:	nop				;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		dec	YL			;1
		brne	vint_vg3_20		;2

vint_vg3_22:	mov	ZL,vline_l
		andi	ZL,0x0f
		cpi	ZL,0x07
		breq	vint_vg3_24

vint_vg3_23:	out	SREG,r15		;1 put back
		nop
		nop
		nop
		pop	XL			;2 restore Y-register
		pop	XH			;2 restore Y-register
		pop	YL			;2 restore Y-register
		pop	YH			;2 restore Y-register
		pop	ZL			;2 restore Z-register
		pop	ZH			;2 restore Z-register
		sts	UCSR1B,const_0		;disable
		reti				;4 thats all

vint_vg3_24:	sts	vsys_rampos_l,XL
		sts	vsys_rampos_h,XH
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		sts	UCSR1B,const_0		;disable

vint_vg3_end:	jmp	vsys_keyb

