;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.macro	vchar_vga_ace
	ld	ZL,X+		;2 get char
	mov	YL,ZL		;1
	ldi	ZH,0x0d		;1 (0x34 / 4)
	lsl	ZL		;1
	lsl	ZL		;1
	rol	ZH		;1
	lsl	ZL		;1
	rol	ZH		;1
	add	ZL,YH		;1 add vline (and 0x07)
	ld	ZL,Z		;2
	sbrs	YL,7		;1
	com	ZL		;1
	sts	UDR1,ZL		;2
.endm

;-------------------------------------------------------------------------------
;check if line is image
;-------------------------------------------------------------------------------
vint_vg4:	movw	XL,vline_l
		lsr	XH
		ror	XL
		sbrc	XH,0			;1 skip if less than 256
		rjmp	vint_vg4_01
		cpi	XL,200			;1 max lines
		brcs	vint_vg4_10

;-------------------------------------------------------------------------------
;no image line
;-------------------------------------------------------------------------------
vint_vg4_01:	cpi	XL,vsys_vstart_v
		brne	vint_vg4_02		;no vsync start
		cbi	VSPORT,VSPIN
		rjmp	vint_vg4_end

vint_vg4_02:	cpi	XL,vsys_vstop_v
		brne	vint_vg4_04		;no vsync stop
		sbi	VSPORT,VSPIN
		rjmp	vint_vg4_end

vint_vg4_04:	cpi	XL,vsys_vbstop_v
		brne	vint_vg4_05		;no border stop
		sbi	GPIOR0,int_flag
		ldi	XL,HIGH(emu_jitab)
		out	OCR0A,XL
		rjmp	vint_vg4_end

vint_vg4_05:	cpi	XL,7
		breq	vint_vg4_06		;2 end of frame
		rjmp	vint_vg4_end

vint_vg4_06:	jmp	vint_frame

vint_vg4_bo_0:	nop
		nop
vint_vg4_bo:	ldi	YL,3
vint_vg4_bo_1:	dec	YL
		brne	vint_vg4_bo_1
		nop
		nop
		ldi	YH,0x18
		sts	UCSR1B,YH
		ldi	YL,128
vint_vg4_bo_2:	nop
		dec	YL
		brne	vint_vg4_bo_2
		nop
		nop
		nop
		rjmp	vint_vg4_23

;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------
vint_vg4_10:	ldi	YL,0x18
		mov	r14,YL
		nop

		lds	YL,TCNT1L		;1 get timer
		sbrs	YL,0
		rjmp	vint_vg4_12
vint_vg4_12:	sbrs	YL,1
		lpm	r13,Z

vint_vg4_16:	subi	XL,4
		brcs	vint_vg4_bo_0
		cpi	XL,192
		brcc	vint_vg4_bo
		mov	YH,XL		;
		andi	YH,0x07
		lds	XL,vsys_rampos_l	;get RAM position
		lds	XH,vsys_rampos_h

		ld	ZL,X+		;2 get char
		mov	YL,ZL		;1
		ldi	ZH,0x0d		;1 (0x34 / 4)
		lsl	ZL		;1
		lsl	ZL		;1
		rol	ZH		;1
		sts	UCSR1B,r14	;2
		lsl	ZL		;1
		rol	ZH		;1
		add	ZL,YH		;1 add vline (and 0x07)
		ld	ZL,Z		;2
		sbrs	YL,7		;1
		com	ZL		;1
		sts	UDR1,ZL		;2

		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace

		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace

		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace

		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace
		vchar_vga_ace

vint_vg4_22:	mov	YH,vline_l		;
		subi	YH,8
		andi	YH,0x0f
		cpi	YH,0x0f
		breq	vint_vg4_24
		nop
		nop
		nop
		nop
		nop
		nop
		nop

vint_vg4_23:	out	SREG,r15		;1 put back
		pop	XL			;2 restore Y-register
		pop	XH			;2 restore Y-register
		pop	YL			;2 restore Y-register
		pop	YH			;2 restore Y-register
		pop	ZL			;2 restore Z-register
		pop	ZH			;2 restore Z-register
		sts	UCSR1B,const_0
		reti				;4 thats all

vint_vg4_24:	sts	vsys_rampos_l,XL
		sts	vsys_rampos_h,XH
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		sts	UCSR1B,const_0
vint_vg4_end:	jmp	vsys_keyb

