;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
;check if line is image
;-------------------------------------------------------------------------------
vint_vg5:	movw	XL,vline_l
		lsr	XH
		ror	XL
		sbrc	XH,0			;1 skip if less than 256
		rjmp	vint_vg5_01		;2 no visible line
		cpi	XL,200			;1 max lines
		brcs	vint_vg5_10

;-------------------------------------------------------------------------------
;no image line
;-------------------------------------------------------------------------------
vint_vg5_01:	cpi	XL,vsys_vstart_v
		brne	vint_vg5_02		;no vsync start
		cbi	VSPORT,VSPIN
		rjmp	vint_vg5_end

vint_vg5_02:	cpi	XL,vsys_vstop_v
		brne	vint_vg5_04		;no vsync stop
		sbi	VSPORT,VSPIN
		rjmp	vint_vg5_end

vint_vg5_04:	cpi	XL,vsys_vbstop_v
		brne	vint_vg5_05		;no border stop
		sbi	GPIOR0,int_flag
		ldi	XL,HIGH(emu_jitab)
		out	OCR0A,XL
		rjmp	vint_vg5_end

vint_vg5_05:	cpi	XL,7
		breq	vint_vg5_06		;2 end of frame
		rjmp	vint_vg5_end

vint_vg5_06:	jmp	vint_frame


vint_vg5_bo_0:	nop
		nop
vint_vg5_bo:	ldi	YL,3
vint_vg5_bo_1:	dec	YL
		brne	vint_vg5_bo_1
		nop
		nop
		ldi	YH,0x18
		sts	UCSR1B,YH
		ldi	YL,128
vint_vg5_bo_2:	nop
		dec	YL
		brne	vint_vg5_bo_2
		nop
		rjmp	vint_vg5_22


;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------
vint_vg5_10:	nop
		ldi	ZH,0x18		;1
		nop

vint_vg5_11:	lds	YL,TCNT1L		;1 get timer
		sbrs	YL,0
		rjmp	vint_vg5_12
vint_vg5_12:	sbrs	YL,1
		lpm	r13,Z

vint_vg5_16:	subi	XL,4
		brcs	vint_vg5_bo_0
		cpi	XL,192
		brcc	vint_vg5_bo
		lds	XL,vsys_rampos_l	;pixel pos
		lds	XH,vsys_rampos_h
		lds	YL,vsys_apos_l		;attr pos
		lds	YH,vsys_apos_h
		lds	r14,vsys_specinvert

		nop
		ld	ZL,X+		;2 get pixline
		sts	UCSR1B,ZH	;2
		ld	r13,Y+		;2 get attr
		sbrs	r13,2		;1
		com	ZL		;1
		sbrc	r13,7		;1
		eor	ZL,r14		;1
		nop			;1
		sts	UDR1,ZL		;2 char 0

		push	r0		;2
		push	r1		;2
		movw	ZL,vline_l	;2

		ld	r0,X+		;2 get pixline
		ld	r13,Y+		;2 get attr
		sbrs	r13,2		;1
		com	r0		;1
		sbrc	r13,7		;1
		eor	r0,r14		;1
		sts	UDR1,r0		;2 char 1

		adiw	ZL,1		;2
		lsr	ZH		;1
		ror	ZL		;1
		subi	ZL,4		;1
		mov	r1,ZL		;1

		ld	r0,X+		;2 get pixline
		ld	r13,Y+		;2 get attr
		sbrs	r13,2		;1
		com	r0		;1
		sbrc	r13,7		;1
		eor	r0,r14		;1
		sts	UDR1,r0		;2 char 2

		ldi	ZH,HIGH(spec_attr)	;1
		lsl	ZL		;1
		rol	ZH		;1
		nop			;1
		nop			;1
		nop			;1

		ld	r0,X+		;2 get pixline
		ld	r13,Y+		;2 get attr
		sbrs	r13,2		;1
		com	r0		;1
		sbrc	r13,7		;1
		eor	r0,r14		;1
		sts	UDR1,r0		;2 char 3

		lpm	r0,Z+		;3
		sts	vsys_apos_l,r0	;2
		nop			;1

		ld	r0,X+		;2 get pixline
		ld	r13,Y+		;2 get attr
		sbrs	r13,2		;1
		com	r0		;1
		sbrc	r13,7		;1
		eor	r0,r14		;1
		sts	UDR1,r0		;2 char 4

		lpm	r0,Z+		;3
		sts	vsys_apos_h,r0	;2
		nop			;1

		ld	r0,X+		;2 get pixline
		ld	r13,Y+		;2 get attr
		sbrs	r13,2		;1
		com	r0		;1
		sbrc	r13,7		;1
		eor	r0,r14		;1
		sts	UDR1,r0		;2 char 5

		ldi	ZH,HIGH(spec_pix)	;1
		mov	ZL,r1		;1
		lsl	ZL		;1
		rol	ZH		;1
		nop			;1
		nop			;1

		ld	r0,X+		;2 get pixline
		ld	r13,Y+		;2 get attr
		sbrs	r13,2		;1
		com	r0		;1
		sbrc	r13,7		;1
		eor	r0,r14		;1
		sts	UDR1,r0		;2 char 6

		lpm	r0,Z+		;3
		sts	vsys_rampos_l,r0	;2
		nop			;1

		ld	r0,X+		;2 get pixline
		ld	r13,Y+		;2 get attr
		sbrs	r13,2		;1
		com	r0		;1
		sbrc	r13,7		;1
		eor	r0,r14		;1
		sts	UDR1,r0		;2 char 7

		lpm	r0,Z+		;3
		sts	vsys_rampos_h,r0	;2
		ldi	ZL,23		;1 rest

		ld	r0,X+		;2 get pixline
		ld	r13,Y+		;2 get attr
		sbrs	r13,2		;1
		com	r0		;1
		sbrc	r13,7		;1
		eor	r0,r14		;1
		sts	UDR1,r0		;2 char 8

		clr	r1		;1
		lds	ZH,vsys_wait	;2
		sbrc	ZH,4		;1
		dec	r1		;1
		nop			;1

vsys_vg5_18:	ld	r0,X+		;2 get pixline
		ld	r13,Y+		;2 get attr
		sbrs	r13,2		;1
		com	r0		;1
		sbrc	r13,7		;1
		eor	r0,r14		;1
		sts	UDR1,r0		;2 char 9..
		nop			;1
		nop			;1
		nop			;1
		dec	ZL		;1
		brne	vsys_vg5_18	;2

		sts	vsys_specinvert,r1	;2
		pop	r1		;2
		pop	r0		;2

vint_vg5_22:	nop
		mov	YH,vline_l		;
		andi	YH,0x0f
		cpi	YH,0x08
		breq	vint_vg5_end
		nop
		out	SREG,r15		;1 put back
		pop	XL			;2 restore Y-register
		pop	XH			;2 restore Y-register
		pop	YL			;2 restore Y-register
		pop	YH			;2 restore Y-register
		sts	UCSR1B,const_0
		pop	ZL			;2 restore Z-register
		pop	ZH			;2 restore Z-register
		reti				;4 thats all

vint_vg5_end:	nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		sts	UCSR1B,const_0
		jmp	vsys_keyb

