;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
;check if line is image
;-------------------------------------------------------------------------------
vint_vg5:	movw	XL,vline_l
		lsr	XH
		ror	XL
		sbrc	XH,0			;1 skip if less than 256
		rjmp	vint_vg5_01		;2 no visible line
		cpi	XL,192			;1 max lines
		brcs	vint_vg5_10

;-------------------------------------------------------------------------------
;no image line
;-------------------------------------------------------------------------------
vint_vg5_01:	cpi	XL,vsys_vstart_v
		brne	vint_vg5_02		;no vsync start
		cbi	VSPORT,VSPIN
		rjmp	vint_vg5_end

vint_vg5_02:	cpi	XL,vsys_vstop_v
		brne	vint_vg5_03		;no vsync stop
		sbi	VSPORT,VSPIN
		rjmp	vint_vg5_end

vint_vg5_03:	cpi	XL,vsys_vbstart_v
		brne	vint_vg5_04		;no border start
		sbi	GPIOR0,4
		rjmp	vint_vg5_end

vint_vg5_04:	cpi	XL,vsys_vbstop_v
		brne	vint_vg5_05		;no border stop
		cbi	GPIOR0,4
		sbi	GPIOR0,int_flag
		ldi	XL,HIGH(emu_jitab)
		out	OCR0A,XL
		rjmp	vint_vg5_end

vint_vg5_05:	cpi	XL,7
		breq	vint_vg5_06		;2 end of frame
		rjmp	vint_vg5_end

vint_vg5_06:	jmp	vint_frame

;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------
vint_vg5_10:
vint_vg5_11:	lds	YL,TCNT1L		;1 get timer
		sbrs	YL,0
		rjmp	vint_vg5_12
vint_vg5_12:	sbrs	YL,1
		lpm	r13,Z

vint_vg5_16:	ldi	ZL,0x18
		sts	UCSR1B,ZL
		mov	ZL,XL			;vline
		ldi	ZH,HIGH(spec_attr)
		lsl	ZL
		rol	ZH
		lpm	YL,Z+			;vline start
		lpm	YH,Z+

		mov	ZL,XL			;vline
		ldi	ZH,HIGH(spec_pix)
		lsl	ZL
		rol	ZH
		lpm	XL,Z+			;vline start
		lpm	XH,Z+

		ldi	ZH,32
		push	r16
		clr	r16
		lds	ZL,vsys_wait
		sbrc	ZL,4
		ldi	r16,0xff

vint_vg5_17:	ld	ZL,X+		;2 get pixline
		ld	r13,Y+		;2 get attr
		sbrs	r13,2		;1
		com	ZL		;1
		sbrc	r13,7		;1
		eor	ZL,r16		;1
		sts	UDR1,ZL		;2
		nop			;1
		nop			;1
		nop			;1
		dec	ZH		;1
		brne	vint_vg5_17	;2
		pop	r16

vint_vg5_22:	sts	UCSR1B,const_0
		mov	YH,vline_l		;
		andi	YH,0x0f
		cpi	YH,0x0f
		breq	vint_vg5_end

		out	SREG,r15		;1 put back
		pop	XL			;2 restore Y-register
		pop	XH			;2 restore Y-register
		pop	YL			;2 restore Y-register
		pop	YH			;2 restore Y-register
		pop	ZL			;2 restore Z-register
		pop	ZH			;2 restore Z-register
		reti				;4 thats all

vint_vg5_end:	jmp	vsys_keyb

