//###############################################################################
//#										#
//#										#
//#										#
//# copyright (c) 2010-2017 Joerg Wolfram (joerg@jcwolfram.de)			#
//#										#
//#										#
//# This program is free software; you can redistribute it and/or		#
//# modify it under the terms of the GNU General Public License			#
//# as published by the Free Software Foundation; either version 2		#
//# of the License, or (at your option) any later version.			#
//#										#
//# This program is distributed in the hope that it will be useful,		#
//# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
//# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
//# General Public License for more details.					#
//#										#
//# You should have received a copy of the GNU General Public			#
//# License along with this library// if not, write to the			#
//# Free Software Foundation, Inc., 59 Temple Place - Suite 330,		#
//# Boston, MA 02111-1307, USA.							#
//#										#
//###############################################################################

#include <main.h>

void print_la1m_error(int errc)
{
	printf("\n");
	switch(errc)
	{
		case 0:		set_error("OK",errc);
				break;

		default:	set_error("(unexpected error)",errc);
	}
	print_error();
}

int prog_la(int divider,int lcmd)
{
	int errc;
	unsigned char trigger_mask,trigger_polarity,signal_mask;
	unsigned short trigger_count;
	char hexbyte[5];
	char *parptr;
	int start_la,i,j,kstat;
	unsigned long samples=0;
	unsigned long presamples=0;

	if((strstr(cmd,"help")) && ((strstr(cmd,"help") - cmd) == 1))
	{
		printf("-- 5V       -- set VDD to 5V\n");
		printf("-- sig:mm   -- set signal mask\n");
		printf("-- trg:mmpp -- set trigger mask and polarity\n");
		printf("-- cnt:cccc -- set trigger count (hex)\n");
		return 0;
	}

	errc=0;

	trigger_mask=0x01;
	trigger_polarity=0x01;
	trigger_count=1;
	signal_mask=1;

	if(file_found < 1)
	{
		printf("##Error, no file name\n");
		goto LA1M_END;	
	}


	if((strstr(cmd,"trg:")) && ((strstr(cmd,"trg:") - cmd) % 2 == 1))
	{
		parptr=strstr(cmd,"trg:");
		strncpy(&hexbyte[0],parptr + 4 * sizeof(char),2);
		hexbyte[2]=0;
		sscanf(hexbyte,"%x",&trigger_mask);
		strncpy(&hexbyte[0],parptr + 6 * sizeof(char),2);
		hexbyte[2]=0;
		sscanf(hexbyte,"%x",&trigger_polarity);
	}


	if((strstr(cmd,"cnt:")) && ((strstr(cmd,"cnt:") - cmd) % 2 == 1))
	{
		parptr=strstr(cmd,"cnt:");
		strncpy(&hexbyte[0],parptr + 4 * sizeof(char),4);
		hexbyte[4]=0;
		sscanf(hexbyte,"%x",&trigger_count);
	}

	if((strstr(cmd,"sig:")) && ((strstr(cmd,"sig:") - cmd) % 2 == 1))
	{
		parptr=strstr(cmd,"sig:");
		strncpy(&hexbyte[0],parptr + 4 * sizeof(char),2);
		hexbyte[2]=0;
		sscanf(hexbyte,"%x",&signal_mask);
	}


	if(find_cmd("5v"))
	{
		errc=prg_comm(0xfb,0,0,0,0,0,0,0,0);	//5V mode
		printf("## using 5V VDD\n");
	}

	


	printf("## Signal mask:   %02X\n",signal_mask);
	printf("## Trigger mask:  %02X\n",trigger_mask);
	printf("## Trigger pol:   %02X\n",trigger_polarity);
	printf("## Trigger count: %02X\n",trigger_count);

	memory[0]=signal_mask;

	errc=prg_comm(lcmd,1,0,0,0,
			(trigger_count) & 0xff,
			(trigger_count >> 8) & 0xff,
			trigger_mask,
			trigger_polarity);	//start


	kstat=abortkey();

//	waitkey();

	prg_comm(0x12e,0,3584,0,ROFFSET,0,0,0,0);	//stop

	if((memory[ROFFSET]==0x55) && (memory[ROFFSET+1]==0xAA))
	{
		printf("!! Aborted, no data written !!\n");
		goto LA1M_END;
	}

	errc=writelist_open();
	
	writeblock_list(0,3584);	

	writeblock_close();

	for(i=0;i<128;i++)
	{
		if(memory[ROFFSET+2*i+1] != 0xff)
		{
			j=memory[ROFFSET+2*i];
			if(j==0) j=256;
			presamples+=j;
		}
	}	

	for(i=128;i<1792;i++)
	{
		if(memory[ROFFSET+2*i+1] != 0xff)
		{
			j=memory[ROFFSET+2*i];
			if(j==0) j=256;
			samples+=j;
		}
	}	

	printf("presample time: %d us\n",presamples*divider);
	printf("sample time:    %d us\n",samples*divider);

LA1M_END:
	
	prg_comm(0x1f,0,0,0,0,0,0,0,0);	//exit

	print_la1m_error(errc);
	return errc;
}

int prog_la1m(void)
{
	return(prog_la(1,0x190));
}

int prog_la100k(void)
{
	return(prog_la(10,0x192));
}


int prog_la10k(void)
{
	return(prog_la(100,0x193));
}



