;################################################################################
;#										#
;# Z80 emulator		 							#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

emu6_loopns:	z80_setnflag			;set N
emu6_loop:
		getpcbyte_m1 ZL			;12/13
		ldi	ZH,HIGH(emu_jtab)	;1
		ijmp				;2

emu6_sel:
.if align_mode == 1
		getpcbyte ZL			;12/13
		ldi	ZH,HIGH(emu6_jtab)	;1
		ijmp				;2
.else
		getpcbyte r16
		ldi	ZH,HIGH(emu6_jtab)	;1
		ldi	ZL,LOW(emu6_jtab)	;1
		add	ZL,r16
		adc	ZH,const_0
		ijmp				;2
.endif

; the level2 jump table
;------------------------------------------------------------------------------
.if align_mode == 1
.org (pc+255) & 0xff00
.endif

emu6_jtab:	rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
.if zxe_mode == 1
		rjmp	emu6_pause			;ED 0B pause
		rjmp	emu6_save			;ED 0C save routine
		rjmp	emu6_load			;ED 0D load routine
		rjmp	emu6_restart			;ED 0E restart
.else
		rjmp	emu6_nocode			;ED 0B not implemented
		rjmp	emu6_nocode			;ED 0C not implemented
		rjmp	emu6_nocode			;ED 0D not implemented
		rjmp	emu6_nocode			;ED 0E not implemented
.endif
		rjmp	emu6_nocode

		rjmp	emu6_nocode
		rjmp	emu6_nocode
.if zxe_mode == 1
		rjmp	emu6_code12
		rjmp	emu6_code13
		rjmp	emu6_code14
.else
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
.endif
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode

		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode

		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode

		rjmp	emu6_code_40
		rjmp	emu6_code_41
		rjmp	emu6_code_42
		rjmp	emu6_code_43
		rjmp	emu6_code_44
		rjmp	emu6_code_45
		rjmp	emu6_code_46
		rjmp	emu6_code_47
		rjmp	emu6_code_48
		rjmp	emu6_code_49
		rjmp	emu6_code_4a
		rjmp	emu6_code_4b
		rjmp	emu6_code_44		;mirror of NEG
		rjmp	emu6_code_4d
		rjmp	emu6_nocode
		rjmp	emu6_code_4f

		rjmp	emu6_code_50
		rjmp	emu6_code_51
		rjmp	emu6_code_52
		rjmp	emu6_code_53
		rjmp	emu6_code_44		;mirror of NEG
		rjmp	emu6_code_45		;mirror of RETN
		rjmp	emu6_code_56
		rjmp	emu6_code_57
		rjmp	emu6_code_58
		rjmp	emu6_code_59
		rjmp	emu6_code_5a
		rjmp	emu6_code_5b
		rjmp	emu6_code_44		;mirror of NEG
		rjmp	emu6_code_4d		;mirror of RETI
		rjmp	emu6_code_5e
		rjmp	emu6_code_5f

		rjmp	emu6_code_60
		rjmp	emu6_code_61
		rjmp	emu6_code_62
		rjmp	emu6_nocode
		rjmp	emu6_code_44		;mirror of NEG
		rjmp	emu6_code_45		;mirror of RETN
		rjmp	emu6_nocode
		rjmp	emu6_code_67
		rjmp	emu6_code_68
		rjmp	emu6_code_69
		rjmp	emu6_code_6a
		rjmp	emu6_nocode
		rjmp	emu6_code_44		;mirror of NEG
		rjmp	emu6_code_4d		;mirror of RETI
		rjmp	emu6_nocode
		rjmp	emu6_code_6f

		rjmp	emu6_code_70
		rjmp	emu6_nocode
		rjmp	emu6_code_72
		rjmp	emu6_code_73
		rjmp	emu6_code_44		;mirror of NEG
		rjmp	emu6_code_45		;mirror of RETN
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_code_78
		rjmp	emu6_code_79
		rjmp	emu6_code_7a
		rjmp	emu6_code_7b
		rjmp	emu6_code_44		;mirror of NEG
		rjmp	emu6_code_4d		;mirror of RETI
		rjmp	emu6_nocode
		rjmp	emu6_nocode

		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode

		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode

		rjmp	emu6_code_a0
		rjmp	emu6_code_a1
		rjmp	emu6_code_a2
		rjmp	emu6_code_a3
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_code_a8
		rjmp	emu6_code_a9
		rjmp	emu6_code_aa
		rjmp	emu6_code_ab
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode

		rjmp	emu6_code_b0
		rjmp	emu6_code_b1
		rjmp	emu6_code_b2
		rjmp	emu6_code_b3
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_code_b8
		rjmp	emu6_code_b9
		rjmp	emu6_code_ba
		rjmp	emu6_code_bb
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode

		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode

		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode

		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode

		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode
		rjmp	emu6_nocode

.if zxe_mode == 1
emu6_pause:	sbrc	reg_h,7
		rjmp	emu6_pause_2
		cli
		sts	zx_ram+0x34,reg_l
		sts	zx_ram+0x35,reg_h
		sei
		sts	libmio_keycode,const_0
emu6_pause_1:	lds	r16,zx_ram+0x35
		sbrc	r16,7
		rjmp	emu6_loop
		lds	r16,libmio_keycode
		cpi	r16,0
		breq	emu6_pause_1
		ldi	r16,0xff
		sts	zx_ram+0x35,r16
		rjmp	emu6_loop
emu6_pause_2:	lds	r16,libmio_keycode
		cpi	r16,0
		breq	emu6_pause_2
		ldi	r16,0xff
		sts	zx_ram+0x35,r16
		rjmp	emu6_loop


emu6_save:	call	fsys_save
		rjmp	emu6_loop

emu6_load:	call	fsys_load
		rjmp	emu6_loop


emu6_code12:	call	fsys_lli
		rjmp	emu6_loop

emu6_code13:	call	fsys_nli
		rjmp	emu6_loop

emu6_code14:	call	fsys_lchar
		rjmp	emu6_loop

emu6_restart:	movw	reg_l,reg_c
		sts	zreg_i,const_0
		sts	zreg_r,const_0
		sts	libmio_nmi,const_0
		ldi	XL,0x80
		sts	zx_ram+0x3b,XL
		rjmp	emu6_loop


.endif

;------------------------------------------------------------------------------
; 0xed 0xnn		no used code
;------------------------------------------------------------------------------
emu6_nocode:	rjmp	emu6_loop

;------------------------------------------------------------------------------
; 0xed 0x40		IN B
;------------------------------------------------------------------------------
emu6_code_40:	movw	r18,reg_c
		call	emu_in
		mov	reg_b,r16
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x41		OUT B
;------------------------------------------------------------------------------
emu6_code_41:	movw	r18,reg_c
		mov	r16,reg_b
		call	emu_out
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x42		SBC HL,BC
;------------------------------------------------------------------------------
emu6_code_42:	lsr	reg_f			;shift out carry
		sez
		sbc	reg_l,reg_c
		sbc	reg_h,reg_b
		in	reg_f,SREG
		rjmp	emu6_loopns		;2

;------------------------------------------------------------------------------
; 0xed 0x43		ld (nnnn),BC
;------------------------------------------------------------------------------
emu6_code_43:	getpcword XL,XH
		putmemword reg_c,reg_b,XL,XH
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x44		NEG
;------------------------------------------------------------------------------
emu6_code_44:	neg	reg_a
		in	reg_f,SREG
		z80_setnflag
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x45		RETN
;------------------------------------------------------------------------------
emu6_code_45:	set
		jmp	emu_rets		;2

;------------------------------------------------------------------------------
; 0xed 0x46		IM 0
;------------------------------------------------------------------------------
emu6_code_46:	sts	z80_imode,const_0
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x47		LD I,A
;------------------------------------------------------------------------------
emu6_code_47:	sts	zreg_i,reg_a
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x48		IN C
;------------------------------------------------------------------------------
emu6_code_48:	movw	r18,reg_c
		call	emu_in
		mov	reg_c,r16
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x49		OUT C
;------------------------------------------------------------------------------
emu6_code_49:	movw	r18,reg_c
		mov	r16,reg_c
		call	emu_out
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x4a		ADC HL,BC
;------------------------------------------------------------------------------
emu6_code_4a:	lsr	reg_f			;shift carry
		adc	reg_l,reg_c
		adc	reg_h,reg_b
		in	reg_f,SREG
		z80_clrnflag
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x4b		LD BC,(nnnn)
;------------------------------------------------------------------------------
emu6_code_4b:	getpcword XL,XH
		getmemword reg_c,reg_b,XL,XH
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x4d		RETI
;------------------------------------------------------------------------------
emu6_code_4d:	set
		jmp	emu_rets		;2

;------------------------------------------------------------------------------
; 0xed 0x4f		ld R,A
;------------------------------------------------------------------------------
emu6_code_4f:	sts	zreg_r,reg_a
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x50		IN D
;------------------------------------------------------------------------------
emu6_code_50:	movw	r18,reg_c
		call	emu_in
		mov	reg_d,r16
		rjmp	emu6_loop		;2


;------------------------------------------------------------------------------
; 0xed 0x51		OUT D
;------------------------------------------------------------------------------
emu6_code_51:	movw	r18,reg_c
		mov	r16,reg_d
		call	emu_out
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x52		SBC HL,DE
;------------------------------------------------------------------------------
emu6_code_52:	lsr	reg_f
		sez
		sbc	reg_l,reg_e
		sbc	reg_h,reg_d
		in	reg_f,SREG
		rjmp	emu6_loopns		;2

;------------------------------------------------------------------------------
; 0xed 0x53		LD (nnnn),DE
;------------------------------------------------------------------------------
emu6_code_53:	getpcword XL,XH
		putmemword reg_e,reg_d,XL,XH
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x56		IM 1
;------------------------------------------------------------------------------
emu6_code_56:	sts	z80_imode,const_1
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x57		ld A,I
;------------------------------------------------------------------------------
emu6_code_57:	lds reg_a,zreg_i
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x58		IN E
;------------------------------------------------------------------------------
emu6_code_58:	movw	r18,reg_c
		call	emu_in
		mov	reg_e,r16
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x59		OUT E
;------------------------------------------------------------------------------
emu6_code_59:	movw	r18,reg_c
		mov	r16,reg_e
		call	emu_out
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x5a		ADC HL,DE
;------------------------------------------------------------------------------
emu6_code_5a:	lsr	reg_f
		adc	reg_l,reg_e
		adc	reg_h,reg_d
		in	reg_f,SREG
		z80_clrnflag
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x5b		LD DE,(nnnn)
;------------------------------------------------------------------------------
emu6_code_5b:	getpcword XL,XH
		getmemword reg_e,reg_d,XL,XH
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x5e		IM 2
;------------------------------------------------------------------------------
emu6_code_5e:	ldi	r16,2
		sts	z80_imode,r16
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x5f		LD A,R
;------------------------------------------------------------------------------
emu6_code_5f:	lds reg_a,zreg_r
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x60		IN H
;------------------------------------------------------------------------------
emu6_code_60:	movw	r18,reg_c
		call	emu_in
		mov	reg_h,r16
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x61		OUT H
;------------------------------------------------------------------------------
emu6_code_61:	movw	r18,reg_c
		mov	r16,reg_h
		call	emu_out
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x62		SBC HL,HL
;------------------------------------------------------------------------------
emu6_code_62:	lsr	reg_f
		sez
		sbc	reg_l,reg_l
		sbc	reg_h,reg_h
		in	reg_f,SREG
		rjmp	emu6_loopns		;2

;------------------------------------------------------------------------------
; 0xed 0x67		RRD
;------------------------------------------------------------------------------
emu6_code_67:	getmembyte r16,reg_l,reg_h
		mov	r17,reg_a
		andi	reg_a,0xf0
		mov	r18,r16
		andi	r18,0x0f
		or	reg_a,r18
		swap	r16
		andi	r16,0x0f
		andi	r17,0x0f
		swap	r17
		or	r16,r17
		putmembyte r16,reg_l,reg_h
		mov	ZL,reg_a
		ldi	ZH,HIGH(emu_flags_log*2)
		lpm	reg_f,Z
		z80_clrnflag
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x68		IN L
;------------------------------------------------------------------------------
emu6_code_68:	movw	r18,reg_c
		call	emu_in
		mov	reg_l,r16
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x69		OUT L
;------------------------------------------------------------------------------
emu6_code_69:	movw	r18,reg_c
		mov	r16,reg_l
		call	emu_out
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x6a		ADC HL,HL
;------------------------------------------------------------------------------
emu6_code_6a:	lsr	reg_f
		adc	reg_l,reg_l
		adc	reg_h,reg_h
		in	reg_f,SREG
		z80_clrnflag
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x6f		RLD
;------------------------------------------------------------------------------
emu6_code_6f:	getmembyte r16,reg_l,reg_h
		mov	r17,reg_a
		andi	reg_a,0xf0
		mov	r18,r16
		swap	r18
		andi	r18,0x0f
		or	reg_a,r18
		swap	r16
		andi	r16,0xf0
		andi	r17,0x0f
		or	r16,r17
		putmembyte r16,reg_l,reg_h
		mov	ZL,reg_a
		ldi	ZH,HIGH(emu_flags_log*2)
		lpm	reg_f,Z
		z80_clrnflag
		rjmp	emu6_loop		;2


;------------------------------------------------------------------------------
; 0xed 0x70		IN F
;------------------------------------------------------------------------------
emu6_code_70:	movw	r18,reg_c
		call	emu_in
		mov	reg_f,r16
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x72		SBC HL,SP
;------------------------------------------------------------------------------
emu6_code_72:	lsr	reg_f
		sez
		sbc	reg_l,SP_L
		sbc	reg_h,SP_H
		in	reg_f,SREG
		rjmp	emu6_loopns		;2

;------------------------------------------------------------------------------
; 0xed 0x73		LD (nnnn),SP
;------------------------------------------------------------------------------
emu6_code_73:	getpcword XL,XH
		putmemword SP_L,SP_H,XL,XH
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x78		IN A
;------------------------------------------------------------------------------
emu6_code_78:	movw	r18,reg_c
		call	emu_in
		mov	reg_a,r16
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x79		OUT A
;------------------------------------------------------------------------------
emu6_code_79:	movw	r18,reg_c
		mov	r16,reg_a
		call	emu_out
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x7a		ADC HL,SP
;------------------------------------------------------------------------------
emu6_code_7a:	lsr	reg_f			;shift out carry
		adc	reg_l,SP_L
		adc	reg_h,SP_H
		in	reg_f,SREG
		z80_clrnflag
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x7b		LD SP,(nnnn)
;------------------------------------------------------------------------------
emu6_code_7b:	getpcword XL,XH
		getmemword SP_L,SP_H,XL,XH
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xa0		LDI
;------------------------------------------------------------------------------
emu6_code_a0:
.if copy_mode == 1
		getmembyte r16,reg_l,reg_h	;get (HL)
		putmembyte r16,reg_e,reg_d	;put (DE)
.endif
.if copy_mode == 2
		rcall	emu6_copybyte
.endif
		add	reg_l,const_1		;HL++
		adc	reg_h,const_0
		add	reg_e,const_1		;DE++
		adc	reg_d,const_0
		andi	reg_f,0xd7		;clear H + PV
		z80_clrnflag			;clear N
		sub	reg_c,const_1		;BC--
		sbc	reg_b,const_0
		breq	emu6_code_a01
		ori	reg_f,0x08		;set PV
emu6_code_a01:	rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xa1		CPI
;------------------------------------------------------------------------------
emu6_code_a1:	getmembyte r16,reg_l,reg_h	;get M
		cp	reg_a,r16		;compare
		in	reg_f,SREG
		add	reg_l,const_1
		sbc	reg_h,const_0
		ori	reg_f,0x08		;set PV
		z80_setnflag			;set N
		sub	reg_c,const_1
		sbc	reg_b,const_0
		brne	emu6_code_a11
		andi	reg_f,0xf7		;clear PV
emu6_code_a11:	rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xa2		INI
;------------------------------------------------------------------------------
emu6_code_a2:	movw	r18,reg_c		;LOW address
		call	emu_in
		putmembyte r16,reg_l,reg_h
		add	reg_l,const_1		;HL++
		adc	reg_h,const_0
		z80_setnflag			;set N
		andi	reg_f,0xfd		;clear Z
		sub	reg_b,const_1		;B--
		brne	emu6_code_a21
		ori	reg_f,0x02		;set Z
emu6_code_a21:	rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xa3		OUTI
;------------------------------------------------------------------------------
emu6_code_a3:	getmembyte r16,reg_l,reg_h
		movw	r18,reg_c		;LOW address
		call	emu_out
		add	reg_l,const_1		;HL++
		adc	reg_h,const_0
		z80_setnflag			;set N
		andi	reg_f,0xfd		;clear Z
		sub	reg_b,const_1		;B--
		brne	emu6_code_a31
		ori	reg_f,0x02		;set Z
emu6_code_a31:	rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xa8		LDD
;------------------------------------------------------------------------------
emu6_code_a8:
.if copy_mode == 1
		getmembyte r16,reg_l,reg_h	;get (HL)
		putmembyte r16,reg_e,reg_d	;put (DE)
.endif
.if copy_mode == 2
		rcall	emu6_copybyte
.endif
		sub	reg_l,const_1
		sbc	reg_h,const_0
		sub	reg_e,const_1
		sbc	reg_d,const_0
		andi	reg_f,0xd7		;clear H + PV
		z80_setnflag			;set N
		sub	reg_c,const_1
		sbc	reg_b,const_0
		breq	emu6_code_a81
		ori	reg_f,0x08		;set PV
emu6_code_a81:	rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xa9		CPD
;------------------------------------------------------------------------------
emu6_code_a9:	getmembyte r16,reg_l,reg_h	;get M
		cp	reg_a,r16		;compare
		in	reg_f,SREG
		sub	reg_l,const_1
		sbc	reg_h,const_0
		ori	reg_f,0x08		;set PV
		z80_setnflag			;set N
		sub	reg_c,const_1
		sbc	reg_b,const_0
		brne	emu6_code_a91
		andi	reg_f,0xf7		;clear PV
emu6_code_a91:	rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xaa		IND
;------------------------------------------------------------------------------
emu6_code_aa:	movw	r18,reg_c		;LOW address
		call	emu_in
		putmembyte r16,reg_l,reg_h
		sub	reg_l,const_1		;HL--
		sbc	reg_h,const_0
		z80_setnflag			;set N
		andi	reg_f,0xfd		;clear Z
		sub	reg_b,const_1		;B--
		brne	emu6_code_aa1
		ori	reg_f,0x02		;set Z
emu6_code_aa1:	rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xab		OUTD
;------------------------------------------------------------------------------
emu6_code_ab:	getmembyte r16,reg_l,reg_h
		movw	r18,reg_c		;LOW address
		call	emu_out
		sub	reg_l,const_1		;HL--
		sbc	reg_h,const_0
		z80_setnflag			;set N
		andi	reg_f,0xfd		;clear Z
		sub	reg_b,const_1		;B--
		brne	emu6_code_ab1
		ori	reg_f,0x02		;set Z
emu6_code_ab1:	rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xb0		LDIR
;------------------------------------------------------------------------------
emu6_code_b0:
.if copy_mode == 1
		getmembyte r16,reg_l,reg_h	;get (HL)
		putmembyte r16,reg_e,reg_d	;put (DE)
.endif
.if copy_mode == 2
		rcall	emu6_copybyte
.endif
		add	reg_l,const_1		;HL++
		adc	reg_h,const_0
		add	reg_e,const_1		;DE++
		adc	reg_d,const_0
		sub	reg_c,const_1		;BC--
		sbc	reg_b,const_0
		brne	emu6_code_b0
		andi	reg_f,0xd7		;clear H + PV
		z80_clrnflag			;clear N
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xb1		CPIR
;------------------------------------------------------------------------------
emu6_code_b1:	bst	reg_f,aflag_c		;save C flag

emu6_code_b11:	getmembyte r16,reg_l,reg_h	;get M
		cp	reg_a,r16		;compare
		in	reg_f,SREG
		bld	reg_f,aflag_c		;restore C flag
		ori	reg_f,0x08		;set PV
		add	reg_l,const_1		;HL++
		adc	reg_h,const_0
		sub	reg_c,const_1		;BC--
		sbc	reg_b,const_0
		sbrs	reg_f,aflag_z		;skip if found
		brne	emu6_code_b11		;loop

		mov	r16,reg_b
		or	r16,reg_c
		brne	emu6_code_b12
		andi	reg_f,0xf7		;clear PV
emu6_code_b12:	rjmp	emu6_loopns		;2

;------------------------------------------------------------------------------
; 0xed 0xb2		INIR
;------------------------------------------------------------------------------
emu6_code_b2:	movw	r18,reg_c		;LOW address
		call	emu_in
		putmembyte r16,reg_l,reg_h
		add	reg_l,const_1		;HL++
		adc	reg_h,const_0
		sub	reg_b,const_1		;B--
		brne	emu6_code_b2
		ori	reg_f,0x02		;set Z
		rjmp	emu6_loopns		;2

;------------------------------------------------------------------------------
; 0xed 0xb3		OTIR
;------------------------------------------------------------------------------
emu6_code_b3:	getmembyte r16,reg_l,reg_h
		movw	r18,reg_c		;LOW address
		call	emu_out
		add	reg_l,const_1		;HL++
		adc	reg_h,const_0
		sub	reg_b,const_1		;B--
		brne	emu6_code_b3
		ori	reg_f,0x02		;set Z
		rjmp	emu6_loopns		;2

;------------------------------------------------------------------------------
; 0xed 0xb8		LDDR
;------------------------------------------------------------------------------
emu6_code_b8:
.if copy_mode == 1
		getmembyte r16,reg_l,reg_h	;get (HL)
		putmembyte r16,reg_e,reg_d	;put (DE)
.endif
.if copy_mode == 2
		rcall	emu6_copybyte
.endif
		sub	reg_l,const_1		;HL--
		sbc	reg_h,const_0
		sub	reg_e,const_1		;DE--
		sbc	reg_d,const_0
		sub	reg_c,const_1		;BC--
		sbc	reg_b,const_0
		brne	emu6_code_b8
		andi	reg_f,0xd7		;clear H + PV
		z80_clrnflag			;clear N
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xb9		CPDR
;------------------------------------------------------------------------------
emu6_code_b9:	bst	reg_f,aflag_c		;save C flag

emu6_code_b91:	getmembyte r16,reg_l,reg_h	;get M
		cp	reg_a,r16		;compare
		in	reg_f,SREG
		bld	reg_f,aflag_c		;restore C flag
		ori	reg_f,0x08		;set PV
		sub	reg_l,const_1		;HL--
		sbc	reg_h,const_0
		sub	reg_c,const_1		;BC--
		sbc	reg_b,const_0
		sbrs	reg_f,aflag_z		;skip if found
		brne	emu6_code_b91		;loop

		mov	r16,reg_b
		or	r16,reg_c
		brne	emu6_code_b92
		andi	reg_f,0xf7		;clear PV
emu6_code_b92:	rjmp	emu6_loopns		;2

;------------------------------------------------------------------------------
; 0xed 0xba		INDR
;------------------------------------------------------------------------------
emu6_code_ba:	movw	r18,reg_c		;LOW address
		call	emu_in
		putmembyte r16,reg_l,reg_h
		sub	reg_l,const_1		;HL--
		sbc	reg_h,const_0
		sub	reg_b,const_1		;B--
		brne	emu6_code_ba
		ori	reg_f,0x02		;set Z
		rjmp	emu6_loopns		;2

;------------------------------------------------------------------------------
; 0xed 0xbb		OTDR
;------------------------------------------------------------------------------
emu6_code_bb:	getmembyte r16,reg_l,reg_h
		movw	r18,reg_c		;LOW address
		call	emu_out
		sub	reg_l,const_1		;HL--
		sbc	reg_h,const_0
		sub	reg_b,const_1		;B--
		brne	emu6_code_bb
		ori	reg_f,0x02		;set Z
		rjmp	emu6_loopns		;2

.if copy_mode == 2
emu6_copybyte:	getmembyte r16,reg_l,reg_h
		putmembyte r16,reg_e,reg_d
		ret
.endif