;################################################################################
;#										#
;# fsys - file system library							#
;# copyright (c) 2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU  General Public				#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU  General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
; init dataflash and determine type
;------------------------------------------------------------------------------
dffs_init:	ldi	XL,0x5c			;config SPI for DF
		out	SPCR,XL

		rcall	fsys_write_ff2
		rcall	fsys_write_ff2
dffs_init_1:	cbi	SPI_SPORT,SPI_SPIN	;CS active
		ldi	r17,0xd7		;flag
		rcall	dffs_out		;output command
		rcall	dffs_write_00
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive
;		mov	r21,XL
;		rcall	fsys_hexout

		andi	r17,0x3c
		cpi	r17,0x24
		breq	dffs_init_2
		cpi	r17,0x1c
		brne	dffs_init_e

		ldi	XL,0x88			;512K dflash
		sts	fileio_ram+36,XL
		ret
dffs_init_2:	ldi	XL,0x89			;1M dflash
		sts	fileio_ram+36,XL
dffs_init_e:	ret

;------------------------------------------------------------------------------
; send dataflash byte (r17)
;------------------------------------------------------------------------------
dffs_write_00:	clr	r17
dffs_out:	out	SPDR,r17
dffs_out1:	in	r17,SPSR
		sbrs	r17,SPIF
		rjmp	dffs_out1
		in	r17,SPDR
		ret

;output dummy bytes
dffs_write_004:	rcall	dffs_write_00
dffs_write_003:	rcall	dffs_write_00
dffs_write_002:	rcall	dffs_write_00
		rjmp	dffs_write_00		;get byte


dffs_fpage0:	sts	fileio_ram+33,r16
dffs_fpage:	lds	r0,fileio_ram+32	;tape number
		lds	r16,fileio_ram+33	;file number
		andi	r16,0x1f		;limit to 32
		sbrc	r0,0
		ori	r16,0x20		;second tape
		ldi	XL,128			;pages per program*2
		mul	XL,r16
		movw	XL,r0			;this is now the first page
		andi	r16,0x1f		;limit to 32
		ret

;------------------------------------------------------------------------------
; wait for Dataflash ready status and write size
; get size to r17 0x08/0x10
; T is 1 if OK
;------------------------------------------------------------------------------
dffs_stat:	cbi	SPI_SPORT,SPI_SPIN
		ldi	r17,0xd7		;command
		rcall	dffs_out		;output command
		rcall	dffs_write_00
		sbi	SPI_SPORT,SPI_SPIN	;de-select
		sbrs	r17,7
		rjmp	dffs_stat
		ret				;thats all

;------------------------------------------------------------------------------
; read block X to buffer 1
;------------------------------------------------------------------------------
dffs_bread1:	rcall	dffs_stat		;wait for ready
		cbi	SPI_SPORT,SPI_SPIN
		ldi	r17,0x53
dffs_breadx:	rcall	dffs_out
		mov	r17,XH
		rcall	dffs_out		;out high
		mov	r17,XL
		rcall	dffs_out		;out low
		rcall	dffs_write_00		;00=byte in page
		sbi	SPI_SPORT,SPI_SPIN	;de-select
		rjmp	dffs_stat		;wait for ready

;------------------------------------------------------------------------------
; write block X from buffer 1
;------------------------------------------------------------------------------
dffs_bwrite1:	rcall	dffs_stat		;wait for ready
		cbi	SPI_SPORT,SPI_SPIN
		ldi	r17,0x83
		rjmp	dffs_breadx

;------------------------------------------------------------------------------
; read DATA r18 data bytes of buf 1 to (Y+)
;------------------------------------------------------------------------------
dffs_rd1:	rcall	dffs_stat		;wait for ready
		cbi	SPI_SPORT,SPI_SPIN
		ldi	r17,0xd4		;Buffer 1 Read
		rcall	dffs_out		;output command
		rcall	dffs_write_004		;ADDR + dummy byte
dffs_rd1_1:	rcall	dffs_write_00		;read byte
		st	Y+,r17
		dec	r18
		brne	dffs_rd1_1
		sbi	SPI_SPORT,SPI_SPIN	;de-select
		ret

;------------------------------------------------------------------------------
; set buffer 1 to 0xff
;------------------------------------------------------------------------------
dffs_cl1:	rcall	dffs_stat		;wait for ready
		cbi	SPI_SPORT,SPI_SPIN
		ldi	r17,0x84		;Buffer 1 Write
dffs_cl1_0:	rcall	dffs_out		;output command
		rcall	dffs_write_003		;ADDR
		clr	r0
dffs_cl1_1:	ldi	r17,0xff
		rcall	dffs_out		;write data
		dec	r0
		brne	dffs_cl1_1
		sbi	SPI_SPORT,SPI_SPIN	;de-select
		ret

;------------------------------------------------------------------------------
; write DATA r18 data bytes (Y+) to buf 1
;------------------------------------------------------------------------------
dffs_wd1:	rcall	dffs_stat		;wait for ready
		cbi	SPI_SPORT,SPI_SPIN
		ldi	r17,0x84		;Buffer 1 Write
		rcall	dffs_out		;output command
		rcall	dffs_write_003		;ADDR
dffs_wd1_1:	ld	r17,Y+
		rcall	dffs_out		;write data
		dec	r18
		brne	dffs_wd1_1
dffs_wd1_3:	sbi	SPI_SPORT,SPI_SPIN	;de-select
		ret

;------------------------------------------------------------------------------
; read name of file r16 to (Y+)
;------------------------------------------------------------------------------
dffs_rname:	rcall	dffs_stat
		cpi	r17,0
		brne	dffs_rname_5
		ldi	r18,10
		ldi	r16,0x16		;"-"
		ldi	YL,LOW(fileio_ram+16)
		ldi	YH,HIGH(fileio_ram+16)
dffs_rname_1:	st	Y+,r16
		dec	r18
		brne	dffs_rname_1
		ret

dffs_rname_5:	rcall	dffs_fpage
;		clr	XL
;		clr	XH
		rcall	dffs_bread1
		ldi	YL,LOW(fileio_ram+16)
		ldi	YH,HIGH(fileio_ram+16)
		ldi	r18,12			;read 12 bytes
		rjmp	dffs_rd1

;------------------------------------------------------------------------------
; find file
;------------------------------------------------------------------------------
dffs_ffile:	ldi	r16,0x1f		;we start with file 31
		ldi	ZL,0xff			;file number
		ldi	ZH,0xff			;free file
dffs_ffile_1:	push	r16
		rcall	dffs_rname		;get name
		pop	r16
		ldi	YL,LOW(fileio_ram+16)	;filename from file
		ldi	YH,HIGH(fileio_ram+16)
		ldi	XL,LOW(fileio_ram)	;filename from request
		ldi	XH,HIGH(fileio_ram)

		ldi	r19,10			;chars to compare
dffs_ffile_2:	ld	r17,Y+			;from file
		cpi	r17,0xff		;empty
		brne	dffs_ffile_3		;branch if not
		mov	ZH,r16			;set free file
		rjmp	dffs_ffile_4

dffs_ffile_3:	ld	r18,X+			;from req
		cp	r17,r18
		brne	dffs_ffile_4
		dec	r19
		brne	dffs_ffile_2
		mov	ZL,r16
		ret

dffs_ffile_4:	sub	r16,const_1
		brcc	dffs_ffile_1
		ret


;------------------------------------------------------------------------------
; write file
;------------------------------------------------------------------------------
dffs_wfile:	rcall	dffs_ffile		;find file
		cpi	ZL,0xff
		breq	dffs_wfile_1		;not found
		mov	r16,ZL			;this is our file to write
		rjmp	dffs_wfile_3		;start write
dffs_wfile_1:	cpi	ZH,0xff
		brne	dffs_wfile_2		;empty found
		rjmp	dffs_file_err

dffs_wfile_2:	mov	r16,ZH			;write o this empty file
		;now write
dffs_wfile_3:	rcall	dffs_fpage0
		rcall	dffs_cl1		;clear page
		ldi	YL,LOW(fileio_ram)	;filename from request
		ldi	YH,HIGH(fileio_ram)
		ldi	r18,12
		rcall	dffs_wd1		;write data to buffer
		rcall	dffs_bwrite1		;write buffer to flash array

		sbiw	YL,2
		ld	ZL,Y+			;file length
		ld	ZH,Y+
		ldi	YL,0x09			;start in RAM
		ldi	YH,0x02

		adiw	XL,2			;next page

dffs_wfile_4:	cpi	ZH,0			;full page
		breq	dffs_wfile_5		;branch if not
		ldi	r18,0			;full page
		rcall	dffs_wd1		;write data to buffer
		rcall	dffs_bwrite1		;write buffer to flash array
		adiw	XL,2
		dec	ZH
		rjmp	dffs_wfile_4

dffs_wfile_5:	cpi	ZL,0
		breq	dffs_wfile_6
		mov	r18,ZL			;full page
		rcall	dffs_wd1		;write data to buffer
		rcall	dffs_bwrite1		;write buffer to flash array

dffs_wfile_6:	set				;OK
		ret


dffs_file_err:	ldi	XL,T_ERR
		sts	0x200,XL
		ret

;------------------------------------------------------------------------------
; read file
;------------------------------------------------------------------------------
dffs_rfile:	rcall	dffs_ffile		;find file
		cpi	ZL,0xff
		breq	dffs_rfile_1		;not found
		mov	r16,ZL			;this is our file to write
		rjmp	dffs_rfile_02		;start write
dffs_rfile_1:	set
		ret				;file not found

dffs_rfile_02:	rcall	dffs_fpage0
		ldi	YL,LOW(fileio_ram)	;filename from request
		ldi	YH,HIGH(fileio_ram)
		rcall	dffs_bread1		;read buffer 1 from flash array
		ldi	r18,12
		rcall	dffs_rd1		;write data to buffer
		sbiw	YL,2
		ld	ZL,Y+			;file length
		ld	ZH,Y+
		ldi	YL,0x09			;start in RAM
		ldi	YH,0x02	

		adiw	XL,2			;next page

dffs_rfile_4:	cpi	ZH,0			;full page
		breq	dffs_rfile_5		;branch if not
		rcall	dffs_bread1		;read buffer 1 from flash array
		ldi	r18,0			;full page
		rcall	dffs_rd1		;write data to buffer
		adiw	XL,2
		dec	ZH
		rjmp	dffs_rfile_4

dffs_rfile_5:	cpi	ZL,0
		breq	dffs_rfile_6
		rcall	dffs_bread1		;read buffer 1 from flash array
		mov	r18,ZL			;full page
		rcall	dffs_rd1		;write data to buffer

dffs_rfile_6:	set				;OK
		ret

;------------------------------------------------------------------------------
; delete file
;------------------------------------------------------------------------------
dffs_dfile:	lds	r17,fileio_ram+33	;file number
		lds	r16,fileio_ram+32	;tape
		andi	r17,0x1f
		sbrc	r16,0
		ori	r17,0x20		;second tape
		ldi	XL,64			;pages per program
		mul	XL,r17
		movw	XL,r0			;this is now the first page
		rcall	dffs_cl1		;clear buffer
		rcall	dffs_bwrite1		;write buffer to flash array
		ret

;read block (bootloader)
dffs_rblock:	rcall	dffs_fpage
		lds	r16,fileio_ram+35	;page in file
		add	XL,r16
		adc	XH,const_0
		add	XL,r16
		adc	XH,const_0
		rcall	dffs_bread1		;read page to block
		clr	r18
		ldi	YL,0
		ldi	YH,bl_buffer
		rcall	dffs_rd1
		adiw	XL,2
		rcall	dffs_bread1		;read page to block
		clr	r18
		rjmp	dffs_rd1

;write block (bootloader)
dffs_wblock:	rcall	dffs_fpage		;calc X=page
		lds	r16,fileio_ram+35	;page in file
		add	XL,r16			;add 2x
		adc	XH,const_0
		add	XL,r16
		adc	XH,const_0
		ldi	YL,0
		ldi	YH,bl_buffer
		clr	r18
		rcall	dffs_wd1
		rcall	dffs_bwrite1
		adiw	XL,2
		clr	r18
		rcall	dffs_wd1
		rjmp	dffs_bwrite1
