;################################################################################
;#										#
;# fsys - file system library							#
;# copyright (c) 2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU  General Public				#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU  General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
; init filesystem and write messages
;------------------------------------------------------------------------------
fsys_init:	ldi	XL,0
		ldi	XH,0
		out	SPCR,const_0
		sbi	SPI_SPORT,SPI_SPIN	;set port pins
		sbi	SPI_SDDR,SPI_SPIN
		sbi	MOSI_DDR,MOSI_PIN
		sbi	SCK_DDR,SCK_PIN
		sbi	MDDR,MPIN		;for ZX-Save
		cbi	MPORT,MPIN		;set to zero
		sts	fileio_ram+32,const_0	;start with tape 0
		sts	fileio_ram+36,const_0	;card not available

fsys_init_1:	nop
		nop
		nop
		sbiw	XL,1
		brne	fsys_init_1

		rcall	sdfs_init		;check for SD card
		ldi	XL,11
		ldi	XH,16
		sts	libmio_xpos,XL
		sts	libmio_ypos,XH
		lds	XL,fileio_ram+36	;status
		sbrs	XL,7			;no card
		rjmp	fsys_init_df

		rcall	fsys_pstat		;view type
		lds	XL,fileio_ram+36	;status
		sbrs	XL,7
		ret				;no format check

		rcall	sdfs_fimage		;find image
		ldi	XL,11
		ldi	XH,18
		sts	libmio_xpos,XL
		sts	libmio_ypos,XH
		rcall	fsys_fstat		;format status
;		lds	r21,fileio_ram+36
;		rcall	fsys_hexout
		ret

fsys_init_df:	rcall	dffs_init
		ldi	XL,11
		ldi	XH,17
		sts	libmio_xpos,XL
		sts	libmio_ypos,XH
		rcall	fsys_pstat		;DF status (DF has no format)
		ret


fsys_rname:	lds	XL,fileio_ram+36
		sbrs	XL,3
		rjmp	sdfs_rname
		rjmp	dffs_rname

fsys_rfile:	lds	XL,fileio_ram+36
		sbrs	XL,3
		rjmp	sdfs_rfile
		rjmp	dffs_rfile

fsys_rfile_02:	lds	XL,fileio_ram+36
		sbrs	XL,3
		rjmp	sdfs_rfile_02
		rjmp	dffs_rfile_02


fsys_wfile:	lds	XL,fileio_ram+36
		sbrs	XL,3
		rjmp	sdfs_wfile
		rjmp	dffs_wfile


fsys_dfile:	lds	XL,fileio_ram+36
		sbrs	XL,3
		rjmp	sdfs_dfile
		rjmp	dffs_dfile

fsys_rblock:	lds	XL,fileio_ram+36
		sbrs	XL,3
		ret
		rjmp	dffs_rblock


fsys_wblock:	lds	XL,fileio_ram+36
		sbrs	XL,3
		ret
		rjmp	dffs_wblock

;------------------------------------------------------------------------------
; wait for SPI is ready for next data
; write XL to SPI
;------------------------------------------------------------------------------
fsys_write_ff2:	rcall	fsys_write_ff
fsys_write_ff:	ldi	XL,0xff			;dummy data
fsys_wspi:	out	SPDR,XL
fsys_wait:	in	XL,SPSR
		sbrs	XL,SPIF
		rjmp	fsys_wait
		in	XL,SPDR
		ret

fsys_write_00:	clr	XL
		rjmp	fsys_wspi


;------------------------------------------------------------------------------
; print out filesystem status
;------------------------------------------------------------------------------
fsys_pstat:	lds	XL,fileio_ram+36
		ldi	ZL,LOW(fsys_txt1*2)
		ldi	ZH,HIGH(fsys_txt1*2)
		cpi	XL,0x01				;card error
		breq	fsys_ppstat
		adiw	ZL,10
		cpi	XL,0x81				;MMC
		breq	fsys_ppstat
		adiw	ZL,10
		cpi	XL,0x82				;SDV1
		breq	fsys_ppstat
		adiw	ZL,10
		cpi	XL,0x83				;SDV2
		breq	fsys_ppstat
		adiw	ZL,10
		cpi	XL,0x84				;SDHC
		breq	fsys_ppstat
		adiw	ZL,10
		cpi	XL,0x88				;DFL 512K
		breq	fsys_ppstat
		adiw	ZL,10
		cpi	XL,0x89				;DFL 1024K
		breq	fsys_ppstat
		adiw	ZL,10
		cpi	XL,0x8a				;DFL 2048K
		breq	fsys_ppstat
		adiw	ZL,10
		cpi	XL,0x8b				;DFL 4096K
		breq	fsys_ppstat
		adiw	ZL,10
		cpi	XL,0x8c				;DFL 8192K
		breq	fsys_ppstat
		adiw	ZL,10
		cpi	XL,0x02				;ACMD41 ERR
		breq	fsys_ppstat
		adiw	ZL,10
		cpi	XL,0x03				;CMD1 ERR
		breq	fsys_ppstat
		adiw	ZL,10
		cpi	XL,0x04				;PATTERN ERROR
		breq	fsys_ppstat
		adiw	ZL,10
fsys_ppstat:	lpm	r20,Z+
		cpi	r20,0x76
		breq	fsys_pstat_e
		call	nchar
		rjmp	fsys_ppstat
fsys_pstat_e:	ret


fsys_txt1:	.db 0x28,0x26,0x37,0x29,0x00,0x2a,0x37,0x37,0x00,0x76	;CARD ERR
		.db 0x32,0x32,0x28,0x16,0x28,0x26,0x37,0x29,0x00,0x76	;MMC-CARD
		.db 0x38,0x29,0x3b,0x1d,0x16,0x28,0x26,0x37,0x29,0x76	;SDV1-CARD
		.db 0x38,0x29,0x3b,0x1e,0x16,0x28,0x26,0x37,0x29,0x76	;SDV2-CARD
		.db 0x38,0x29,0x2d,0x28,0x16,0x28,0x26,0x37,0x29,0x76	;SDHC-CARD
		.db 0x29,0x2b,0x31,0x16,0x21,0x1d,0x1e,0x30,0x00,0x76	;DFL-512K
		.db 0x29,0x2b,0x31,0x16,0x1d,0x1c,0x1e,0x20,0x30,0x76	;DFL-1024K
		.db 0x29,0x2b,0x31,0x16,0x1e,0x1c,0x20,0x24,0x30,0x76	;DFL-2048K
		.db 0x29,0x2b,0x31,0x16,0x20,0x1c,0x25,0x22,0x30,0x76	;DFL-4096K
		.db 0x29,0x2b,0x31,0x16,0x24,0x1d,0x25,0x1e,0x30,0x76	;DFL-8192K
		.db 0x2a,0x16,0x26,0x28,0x32,0x29,0x20,0x1d,0x00,0x76	;E-ACMD41
		.db 0x2a,0x16,0x28,0x32,0x29,0x1d,0x00,0x76,0x76,0x76	;E-CMD1
		.db 0x2a,0x16,0x28,0x32,0x29,0x24,0x00,0x76,0x76,0x76	;E-CMD8
		.db 0x00,0x33,0x34,0x00,0x28,0x26,0x37,0x29,0x00,0x76	;NO CARD



;------------------------------------------------------------------------------
; print out filesystem status2
;------------------------------------------------------------------------------
fsys_fstat:	lds	XL,fileio_ram+36
		ldi	ZL,LOW(fsys_txt2*2)
		ldi	ZH,HIGH(fsys_txt2*2)
		sbrs	XL,7
		adiw	ZL,10
		rjmp	fsys_ppstat

fsys_txt2:	.db 0x2b,0x34,0x37,0x32,0x26,0x39,0x39,0x2a,0x29,0x76	;FORMATTED
		.db 0x33,0x34,0x00,0x2e,0x32,0x26,0x2c,0x2a,0x76,0x76	;NO IMAGE


fsys_check:	lds	XL,fileio_ram+36
		sbrc	XL,7
		ret
		ldi	XL,T_ERR
		sts	0x200,XL		;error
		pop	r0			;killlast stack entry
		pop	r0
		ret				;file not found

;------------------------------------------------------------------------------
; LLIST init (ED12)
;------------------------------------------------------------------------------
fsys_lli:	sts	fileio_ram+33,const_0		;file
		sts	fileio_ram+34,const_0		;char
		clr	r16
		lds	r0,fileio_ram+32		;tape number
		call	fsys_rname			;read name
		ret

;------------------------------------------------------------------------------
; LLIST nextfile (ED13)
;------------------------------------------------------------------------------
fsys_nli:	sts	fileio_ram+34,const_0		;char
		lds	r16,fileio_ram+33		;next file
		inc	r16
		sts	fileio_ram+33,r16
		call	fsys_rname			;read name
		ret

;------------------------------------------------------------------------------
; save a file
;------------------------------------------------------------------------------
fsys_save:
		ldi	YL,LOW(fileio_ram)	;filename from request
		ldi	YH,HIGH(fileio_ram)
		ldi	r16,10
fsys_save_1:	st	Y+,const_0		;space
		dec	r16
		brne	fsys_save_1
		lds	ZL,0x214		;4014 in ZX RAM
		lds	ZH,0x215		;4015 in ZX RAM
		subi	ZL,0x09
		sbci	ZH,0x40
		adiw	ZL,1			;store incl
		st	Y+,ZL
		st	Y+,ZH

fsys_save_2:	movw	ZL,reg_l
		andi	ZH,0x3f			;limit to 16K
		subi	ZH,0xfe			;sys offset
		ldi	YL,LOW(fileio_ram)	;filename from request
		ldi	YH,HIGH(fileio_ram)
		ld	r16,Z
		cpi	r16,0x16		;"-"
		breq	fsys_delx_1
		cpi	r16,0x00		;space
		brne	fsys_save_2a
		jmp	save_prg
fsys_save_2a:	rcall	fsys_check
		ldi	r16,10
		rjmp	fsys_save_3
fsys_delx_1:	rcall	fsys_check
		rjmp	fsys_delete_1


fsys_save_3:	ld	r17,Z+			;name char
		mov	r0,r17
		andi	r17,0x3f
		st	Y+,r17
		sbrc	r0,7
		rjmp	fsys_save_4
		dec	r16
		brne	fsys_save_3
fsys_save_4:	jmp	fsys_wfile

fsys_delete_1:	adiw	ZL,1
		ld	r16,Z+			;char 1
		andi	r16,0x3f
		cpi	r16,0x26
		breq	fsys_del5x
		subi	r16,0x1c
		ldi	r17,10
		mul	r16,r17
		ld	r17,Z+			;char 2
		andi	r17,0x3f
		subi	r17,0x1c
		add	r17,r0
		cpi	r17,0x20
		brcc	fsys_delex
		sts	fileio_ram+33,r17	;file number
		jmp	fsys_dfile
fsys_del5x:	rjmp	fsys_delete_5
fsys_delex:	rjmp	fsys_delete_e


fsys_delete_e:	ldi	XL,T_ERR
		sts	0x200,XL
fsys_delete_x:	ret

fsys_delete_5:	ld	r16,Z+			;char 2
		andi	r16,0x3f
		cpi	r16,0x31
		brne	fsys_delete_e

		ld	r16,Z+			;char 3
		andi	r16,0x3f
		cpi	r16,0x31
		brne	fsys_delete_e

		sts	fileio_ram+33,const_0	;file number
fsys_delete_6:	call	fsys_dfile
		lds	r16,fileio_ram+33	;get file number
		inc	r16
		cpi	r16,0x20
		brcc	fsys_delete_x
		sts	fileio_ram+33,r16
		rjmp	fsys_delete_6


;------------------------------------------------------------------------------
; load a file
;------------------------------------------------------------------------------
fsys_load:	rcall	fsys_check

		ldi	YL,LOW(fileio_ram)	;filename from request
		ldi	YH,HIGH(fileio_ram)
		ldi	r16,10
fsys_load_1:	st	Y+,const_0		;space
		dec	r16
		brne	fsys_load_1

fsys_load_2:	mov	ZH,reg_h
		mov	ZL,reg_l
		sbrc	ZH,7
		rjmp	fsys_load_5		; LOAD "" is ignored
		andi	ZH,0x3f
		subi	ZH,0xfe
		ldi	YL,LOW(fileio_ram)	;filename from request
		ldi	YH,HIGH(fileio_ram)
		ldi	r16,10
fsys_load_3:	ld	r17,Z+			;name char
		mov	r0,r17
		andi	r17,0x3f
		cpi	r17,0x0d		;"$"
		breq	fsys_load_6		;direct load
		st	Y+,r17
		sbrc	r0,7
		rjmp	fsys_load_4
		dec	r16
		brne	fsys_load_3
fsys_load_4:	jmp	fsys_rfile
fsys_load_5:	ret

fsys_load_6:	ld	r16,Z+
		sbrc	r16,7
		rjmp	fsys_delete_e		;only 1 digit
		subi	r16,0x1c
		ldi	r17,10
		mul	r16,r17
		ld	r17,Z+			;char 2
		sbrs	r17,7
fsys_load_7:	rjmp	fsys_delete_e		;more than 2 digits
		andi	r17,0x3f
		subi	r17,0x1c
		add	r17,r0
		cpi	r17,0x20
		brcc	fsys_load_7
		mov	r16,r17
		mov	ZL,r17
		sts	fileio_ram+33,ZL
		call	fsys_rname
		lds	r0,fileio_ram+16
		sbrs	r0,7
		jmp	fsys_rfile_02		;load direct
		rjmp	fsys_delete_e		;error


;------------------------------------------------------------------------------
; LLIST char(ED14)
;------------------------------------------------------------------------------
fsys_lchar:	lds	r16,fileio_ram+34		;char no

fsys_lchar_01:	cpi	r16,2
		brcc	fsys_lchar_10
		mov	r17,r16
		lds	r16,fileio_ram+33		;file
		ldi	reg_a,0x9c			;invers "0"
fsys_lchar_02:	subi	r16,10
		brcs	fsys_lchar_03
		inc	reg_a
		rjmp	fsys_lchar_02
fsys_lchar_03:	subi	r16,0x5a			;+10+128
		sbrc	r17,0
		mov	reg_a,r16
fsys_lchar_nxt:	lds	r16,fileio_ram+34		;char no
		inc	r16
		sts	fileio_ram+34,r16		;next position
		ret

fsys_lchar_10:	cpi	r16,12
		brcc	fsys_lchar_s			;force space
		lds	r17,fileio_ram+36
		ldi	reg_a,0x16			;"-"
		sbrs	r17,7
		rjmp	fsys_lchar_nxt
		rjmp	fsys_lchar_1


fsys_lchar_1:	ldi	YL,LOW(fileio_ram+14)
		ldi	YH,HIGH(fileio_ram+14)
		add	YL,r16
		adc	YH,const_0
		ld	r16,Y				;get char
		st	Y,const_1
		cpi	r16,0x40
		brcc	fsys_lchar_s			;force space
		mov	reg_a,r16
		rjmp	fsys_lchar_nxt

fsys_lchar_s:	clr	reg_a
		rjmp	fsys_lchar_nxt



