;################################################################################
;#										#
;# fsys - file system library							#
;# copyright (c) 2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU  General Public				#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU  General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################


;------------------------------------------------------------------------------
; write command XH to SPI
; XL=return byte (FF=time out)
;------------------------------------------------------------------------------
sdfs_cmd0:	clr	r16			;clear address field
		clr	r17
		movw	r18,r16

sdfs_cmd:	cbi	SPI_SPORT,SPI_SPIN	;CS active
		rcall	fsys_write_ff2		;16 dummy clocks
		andi	XH,0x3f			;limit
		ori	XH,0x40			;set bit 6
		out	SPDR,XH			;CMD
		andi	XH,0x3f			;clear bit 6
		rcall	fsys_wait
		out	SPDR,r19		;address MSB
		rcall	fsys_wait
		out	SPDR,r18
		rcall	fsys_wait
		out	SPDR,r17
		rcall	fsys_wait
		out	SPDR,r16		;address LSB
		rcall	fsys_wait
		ldi	XL,0x95			;dummy checksum
		cpi	XH,0x08
		brne	sdfs_cmd_01
		ldi	XL,0x87
sdfs_cmd_01:	rcall	fsys_wspi
		clr	r0

sdfs_cmd_resp:	rcall	fsys_write_ff		;write 0xff and read data
		cpi	XL,0xff
		brne	sdfs_cmd_end
		dec	r0
		brne	sdfs_cmd_resp
sdfs_cmd_end:	ret

;------------------------------------------------------------------------------
; wait for start block mtoken
;------------------------------------------------------------------------------
fsys_waitsbt:	push	ZL
		push	ZH
		ldi	ZL,0			;timeout
		ldi	ZH,0

fsys_waitsbt1:	cpi	XL,0xfe			;start block token
		brne	fsys_waitsbt2
		pop	ZH
		pop	ZL
		ret				;SBT found

fsys_waitsbt2:	sbiw	ZL,1			;timeout counter
		breq	fsys_waitsbt3		;branch if timeout is reached
		rcall	fsys_write_ff
		rjmp	fsys_waitsbt1		;next try

fsys_waitsbt3:	pop	ZH
		pop	ZL
		pop	r0			;kill last stack entry
		pop	r0
		sts	fileio_ram+36,const_1	;error
		rjmp	sdfs_dfile_e

;------------------------------------------------------------------------------
; init SD card and determine type
;------------------------------------------------------------------------------
sdfs_init:	;init SPI to f/128
		ldi	XL,0x53			;f/128
		out	SPCR,XL
		ldi	XL,0x04			;timeout factor
		sts	fileio_ram+40,XL

		;80 dummy pulses with CS=HI
sdfs_init_00:	ldi	XH,10
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive
sdfs_init_01:	rcall	fsys_write_ff		;128 clock pulses
		dec	XH
		brne	sdfs_init_01

		ldi	YL,0x00			;CMD0 retries
		ldi	YH,0x10

sdfs_init_02:	ldi	XH,0			;CMD0
		rcall	sdfs_cmd0		;send CMD0
		cpi	XL,0xff
		breq	sdfs_init_02a
		sbrc	XL,0			;skip if idle state
		rjmp	sdfs_init_03		;yes->OK
sdfs_init_02a:	sbiw	YL,1			;retry counter
		brne	sdfs_init_02		;retry CMD 0

sdfs_init_err:	sts	fileio_ram+36,const_0	;card not available
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive
		ret				;exit

		;check for SDv2 with CMD8
sdfs_init_03:	ldi	r16,0xaa		;test pattern
		ldi	r17,0x01
		clr	r18
		clr	r19
		ldi	XH,8			;CMD8
		rcall	sdfs_cmd		;send CMD8
		sbrc	XL,2			;illegal?
		rjmp	sdfs_init_04		;yes
		rcall	fsys_write_ff2
		rcall	fsys_write_ff2
		cpi	XL,0xaa			;test pattern
		brne	sdfs_init_err1		;fail
		ldi	XL,0x90			;SDv2
		sts	fileio_ram+36,XL	;write status
		rjmp	sdfs_init_05		;goto wait idle

		;check for MMC / SD
sdfs_init_04:	ldi	XH,55			;CMD55
		rcall	sdfs_cmd0		;send CMD55
		ldi	XH,1			;ACMD41
		rcall	sdfs_cmd0		;send ACMD41
		sbrc	XL,2			;illegal?
		rjmp	sdfs_init_20		;MMC
		ldi	XL,0x82			;SDv1
		sts	fileio_ram+36,XL	;write status

		;wait for card ready
sdfs_init_05:	ldi	YL,0
		ldi	YH,0x80

sdfs_init_06:	ldi	XH,55			;CMD55
		rcall	sdfs_cmd0		;send CMD55
		lds	XL,fileio_ram+36	;get stat
		sbrc	XL,4			;check V2
		ldi	r19,0x40
		ldi	XH,1			;ACMD41
		rcall	sdfs_cmd		;send ACMD41
		sbrs	XL,0			;skip if idle state
		rjmp	sdfs_init_10		;yes->OK
		sbiw	YL,1			;loops
		brne	sdfs_init_06

sdfs_init_07:	ldi	r16,0x02		;ACMD41 err
		sts	fileio_ram+36,r16
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive
		ret

sdfs_init_err1:	ldi	XL,0x04
		sts	fileio_ram+36,XL	;card error
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive
		ret				;exit

sdfs_init_10:	lds	XL,fileio_ram+36	;get stat
		sbrs	XL,4			;
		rjmp	sdfs_init_end		;SDv1 card
		ldi	XL,0x83			;set SDv2
		sts	fileio_ram+36,XL	;write status

		;now check for SDHC or V2
		ldi	XH,58			;CMD58
		rcall	sdfs_cmd0		;send CMD58
		rcall	fsys_write_ff
		push	XL
		rcall	fsys_write_ff
		rcall	fsys_write_ff
		rcall	fsys_write_ff
		pop	XL
		sbrs	XL,6
		rjmp	sdfs_init_end		;is SDv2 card
		ldi	XL,0x84			;SDHC card
		sts	fileio_ram+36,XL	;write status

sdfs_init_end:	clr	r16			;512 Bytes block size
		ldi	r17,2
		clr	r18
		clr	r19
		ldi	XH,16			;CMD16
		rcall	sdfs_cmd		;send CMD16
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive
		ldi	XL,0x50			;f/4
		out	SPCR,XL
		ret				;exit

sdfs_init_20:	ldi	YL,0
		ldi	YH,0x80

sdfs_init_21:	ldi	XH,1			;CMD1
		rcall	sdfs_cmd0		;send CMD1
		sbrs	XL,0			;skip if idle state
		rjmp	sdfs_init_22		;yes->OK
		sbiw	YL,1			;loops
		brne	sdfs_init_21		
		ldi	r16,0x03		;CMD1 err
		sts	fileio_ram+36,r16
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive
		ret

sdfs_init_22:	ldi	XL,0x81			;MMC card
		sts	fileio_ram+36,XL	;write status
		rjmp	sdfs_init_end

;------------------------------------------------------------------------------
; find image on SD-Card
;------------------------------------------------------------------------------
sdfs_fimage:	ldi	r17,0x00		;start position
		ldi	r18,0x00
		ldi	r19,0x01
		ldi	PC_H,HIGH(1026)		;loops to go
		ldi	PC_L,LOW(1026)

sdfs_fimage_1:	ldi	r16,2			;next page
		add	r17,r16
		adc	r18,const_0
		adc	r19,const_0
		sbiw	PC_L,1
		brne	sdfs_fimage_2
		rjmp	sdfs_fimage_n		;exit, format not found

sdfs_fimage_2:	clr	r16
		lds	XL,fileio_ram+36
		sbrs	XL,2
		rjmp	sdfs_fimage_2a		;no SDHC card
		;set SDHC mod
		lsr	r19
		ror	r18
		ror	r17
		mov	r16,r17
		mov	r17,r18
		mov	r18,r19
		clr	r19
sdfs_fimage_2a:	ldi	XH,17			;read single block
		rcall	sdfs_cmd		;send CMD
		rcall	fsys_waitsbt		;wait for start block token
		lds	XL,fileio_ram+36
		sbrs	XL,2
		rjmp	sdfs_fimage_2b		;no SDHC card
		;remove SDHC mod
		lsl	r16
		rol	r17
		rol	r18
		mov	r19,r18
		mov	r18,r17
		mov	r17,r16
		clr	r16
sdfs_fimage_2b:	ldi	XH,12			;fname length + len
		ldi	YL,LOW(fileio_ram+16)
		ldi	YH,HIGH(fileio_ram+16)

sdfs_fimage_4:	rcall	fsys_write_ff
		st	Y+,XL
		dec	XH
		brne	sdfs_fimage_4
		ldi	XH,251			;(510/2)+2CRC
sdfs_fimage_5:	rcall	fsys_write_ff2
		dec	XH
		brne	sdfs_fimage_5
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive

		ldi	YL,LOW(fileio_ram+16)
		ldi	YH,HIGH(fileio_ram+16)
		ldi	ZL,LOW(sdfs_hdat*2)
		ldi	ZH,HIGH(sdfs_hdat*2)
		ldi	XH,10			;10 chars to compare
sdfs_fimage_6:	ld	r0,Y+
		lpm	r1,Z+
		cp	r0,r1
		brne	sdfs_fimage_1
		dec	XH
		brne	sdfs_fimage_6
		;we habe found tape
		ld	XH,Y+			;this is our tape number

		ldi	ZL,LOW(2114)		;offset in 256 byte units
		ldi	ZH,HIGH(2114)

sdfs_fimage_7:	cpi	XH,0
		breq	sdfs_fimage_8
		sub	r17,ZL
		sbc	r18,ZH
		sbc	r19,const_0
		dec	XH
		rjmp	sdfs_fimage_7

sdfs_fimage_8:	ldi	r16,2			;skip first sector
		add	r17,r16
		adc	r18,const_0
		adc	r19,const_0
		sts	fileio_ram+37,r17
		sts	fileio_ram+38,r18
		sts	fileio_ram+39,r19
;		mov	r21,r19
;		rcall	fsys_hexout
;		mov	r21,r18
;		rcall	fsys_hexout
;		mov	r21,r17
;		rcall	fsys_hexout
;		mov	r21,const_0
;		rcall	fsys_hexout
;		clr	r20
;		call	nchar
		ret

sdfs_fimage_n:	sts	fileio_ram+36,const_0	;not valid format
		ret

sdfs_hdat:	.db	0xa6,0xbd,0x26,0x3d,0x24,0x1d,0xb9,0xa6,0xb5,0xaa

fsys_hexout:	mov	r20,r21
		swap	r20
		andi	r20,0x0f
		subi	r20,0xe4
		call	nchar
		mov	r20,r21
		andi	r20,0x0f
		subi	r20,0xe4
		call	nchar
		ret

;------------------------------------------------------------------------------
; calc sector address to r16..r19
; fileio_ram+32	= tape
; fileio_ram+33	= file
; fileio_ram+35	= sector
;------------------------------------------------------------------------------
sdfs_sectaddr0:	sts	fileio_ram+35,const_0	;first sector
sdfs_sectaddr:	lds	r17,fileio_ram+37	;offset of filesystem
		lds	r18,fileio_ram+38
		lds	r19,fileio_ram+39
		;add tape offset
		lds	XL,fileio_ram+32	;tape number
		ldi	XH,LOW(2114)		;tape size low
		mul	XL,XH
		add	r17,r0
		adc	r18,r1
		adc	r19,const_0
		ldi	XH,HIGH(2114)		;tape size high
		mul	XL,XH
		add	r18,r0
		adc	r19,r1
		;now add file offset
		lds	XL,fileio_ram+33	;file in tape
		andi	XL,0x1f
		ldi	XH,66			;66 * 256 bytes /file
		mul	XL,XH
		add	r17,r0
		adc	r18,r1
		adc	r19,const_0
		;at least add sector offset
		lds	r16,fileio_ram+35	;sector
		lsl	r16			;*2
		add	r17,r16
		adc	r18,const_0
		adc	r19,const_0
		clr	r16
		lds	XH,fileio_ram+36	;type
		sbrs	XH,2
		ret
		;set SDHC mod
		lsr	r19
		ror	r18
		ror	r17
		mov	r16,r17
		mov	r17,r18
		mov	r18,r19
		clr	r19
		ret

;------------------------------------------------------------------------------
; read name
; fileio_ram+32	= tape
; fileio_ram+33	= file
;------------------------------------------------------------------------------
sdfs_rname:	ldi	YL,LOW(fileio_ram+16)
		ldi	YH,HIGH(fileio_ram+16)

		lds	XL,fileio_ram+36
		sbrs	XL,7
		rjmp	sdfs_dname		;dummy name

		rcall	sdfs_sectaddr0		;calc sector addr
		ldi	XH,17			;read block
		rcall	sdfs_cmd		;send CMD
		rcall	fsys_waitsbt		;wait for start block token
		ldi	XH,12			;fname length + len
sdfs_rname_1:	rcall	fsys_write_ff
		st	Y+,XL
		dec	XH
		brne	sdfs_rname_1
		ldi	XH,251			;(510/2)+2CRC
sdfs_rname_2:	rcall	fsys_write_ff2
		dec	XH
		brne	sdfs_rname_2
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive
		ret

sdfs_dname:	ldi	XH,10
		ldi	XL,0x16
sdfs_dname_1:	st	Y+,XL
		dec	XH
		brne	sdfs_dname_1
		ret

;------------------------------------------------------------------------------
; read file
; fileio_ram+32	= tape
; fileio_ram+33	= file
;------------------------------------------------------------------------------
sdfs_rfile:	rcall	sdfs_ffile		;find file
		cpi	ZL,0xff			;is "not found" code?
		brne	sdfs_rfile_03		;not found
sdfs_rfile_01:	ldi	XL,T_ERR-1
		sts	0x200,XL		;error
		ret				;file not found

sdfs_rfile_02:

sdfs_rfile_03:	sts	fileio_ram+33,ZL	;file number
		rcall	sdfs_sectaddr0		;calc sector addr
		ldi	YL,LOW(fileio_ram+16)
		ldi	YH,HIGH(fileio_ram+16)
		ldi	XH,17			;read block
		rcall	sdfs_cmd		;send CMD
		rcall	fsys_waitsbt		;wait for start block token
		ldi	XH,12			;fname length + len
sdfs_rfile_1:	rcall	fsys_write_ff
		st	Y+,XL
		dec	XH
		brne	sdfs_rfile_1

		ldi	XH,251			;rest of 512 bytes
sdfs_rfile_1a:	rcall	fsys_write_ff2
		dec	XH
		brne	sdfs_rfile_1a

		lds	ZL,(fileio_ram+26)	;LEN LOW
		lds	ZH,(fileio_ram+27)	;LEN HIGH
		ldi	YL,0x09			;start at 0x4009 in Z80 adr space
		ldi	YH,0x02
		sts	fileio_ram+35,const_0	;start data at sector 1-1

sdfs_rfile_2:	lds	XL,fileio_ram+35	;next sector
		inc	XL
		sts	fileio_ram+35,XL
		rcall	sdfs_sectaddr		;calc sector addr
		ldi	XH,17			;read block
		rcall	sdfs_cmd		;send CMD
		rcall	fsys_waitsbt		;wait for start block token
		clr	r0
		ldi	XL,2
		mov	r1,XL			;512 bytes/sector

sdfs_rfile_3:	rcall	fsys_write_ff		;get data byte
		cp	ZL,const_0
		cpc	ZH,const_0
		breq	sdfs_rfile_4		;we must do a dummy read
		st	Y+,XL			;store data byte in RAM
		sbiw	ZL,1			;to-do bytes -1
sdfs_rfile_4:	sub	r0,const_1
		sbc	r1,const_0
		brne	sdfs_rfile_3
		rcall	fsys_write_ff2		;get CRC bytes
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive

		cp	ZL,const_0		;all done?
		cpc	ZH,const_0
		breq	sdfs_rfile_e		;yes, we can exit
		rjmp	sdfs_rfile_2

sdfs_rfile_e:	ret				;all done


;------------------------------------------------------------------------------
; write file
; fileio_ram+32	= tape
; fileio_ram+33	= file
;------------------------------------------------------------------------------
sdfs_wfile:	rcall	sdfs_ffile		;find file
		cpi	ZL,0xff
		breq	sdfs_wfile_01		;not found
		mov	r16,ZL			;this is our file to write
		rjmp	sdfs_wfile_03		;start write
sdfs_wfile_01:	cpi	ZH,0xff
		brne	sdfs_wfile_02		;empty found
		rjmp	sdfs_dfile_e

sdfs_wfile_02:	mov	r16,ZH			;write to this empty file

sdfs_wfile_03:	sts	fileio_ram+33,r16	;store file number
		sts	fileio_ram+35,const_0	;start with sector 0

sdfs_wfile_0:	rcall	sdfs_sectaddr		;calc sector addr
		ldi	XH,24			;write block
		rcall	sdfs_cmd		;send CMD
		ldi	XL,0xfe			;start block token
		rcall	fsys_wspi		;send
		ldi	YL,LOW(fileio_ram)
		ldi	YH,HIGH(fileio_ram)
		ldi	XH,12			;fname length + len
sdfs_wfile_1:	ld	XL,Y+
		rcall	fsys_wspi		;send
		dec	XH
		brne	sdfs_wfile_1

		ldi	XH,251			;rest of 512 bytes
sdfs_wfile_1a:	rcall	fsys_write_ff2		;send
		dec	XH
		brne	sdfs_wfile_1a
		rcall	fsys_write_ff2		;put CRC bytes
sdfs_wfile_1b:	rcall	fsys_write_ff		;put dummy byte
		cpi	XL,0xff
		brne	sdfs_wfile_1b
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive

		lds	ZL,(fileio_ram+10)	;LEN LOW
		lds	ZH,(fileio_ram+11)	;LEN HIGH
		ldi	YL,0x09			;start at 0x4009 in Z80 adr space
		ldi	YH,0x02

sdfs_wfile_2:	lds	XL,fileio_ram+35	;next sector
		inc	XL
		sts	fileio_ram+35,XL
		rcall	sdfs_sectaddr

		ldi	XH,24			;write block
		rcall	sdfs_cmd		;send CMD
		ldi	XL,0xfe			;start block token
		rcall	fsys_wspi		;send

		clr	r0
		ldi	XL,2
		mov	r1,XL			;512 bytes/sector

sdfs_wfile_3:	ldi	XL,0xff
		cp	ZL,const_0
		cpc	ZH,const_0
		breq	sdfs_wfile_4		;we must do a dummy byte write
		ld	XL,Y+			;store data byte in RAM
		sbiw	ZL,1

sdfs_wfile_4:	rcall	fsys_wspi		;send
		sub	r0,const_1
		sbc	r1,const_0
		brne	sdfs_wfile_3
		rcall	fsys_write_ff2		;put dummy CRC bytes
sdfs_wfile_5:	rcall	fsys_write_ff		;put dummy byte
		cpi	XL,0xff
		brne	sdfs_wfile_5
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive

		cp	ZL,const_0		;all done?
		cpc	ZH,const_0
		brne	sdfs_wfile_2		;not all done
		rjmp	sdfs_rfile_e

;------------------------------------------------------------------------------
; find file
;------------------------------------------------------------------------------
sdfs_ffile:	ldi	r16,0x1f		;we start with file 31
		ldi	ZL,0xff			;file number
		ldi	ZH,0xff			;free file
sdfs_ffile_1:	sts	fileio_ram+33,r16	;store file number
		rcall	sdfs_rname		;get name
		ldi	YL,LOW(fileio_ram+16)	;filename from file
		ldi	YH,HIGH(fileio_ram+16)
		ldi	XL,LOW(fileio_ram)	;filename from request
		ldi	XH,HIGH(fileio_ram)

		ldi	r19,10			;chars to compare
sdfs_ffile_2:	ld	r17,Y+			;from file
		cpi	r17,0xff		;empty
		brne	sdfs_ffile_3		;branch if not
		lds	ZH,fileio_ram+33	;set free file

sdfs_ffile_3:	ld	r18,X+			;from req
		cp	r17,r18
		brne	sdfs_ffile_4
		dec	r19
		brne	sdfs_ffile_2
		lds	ZL,fileio_ram+33	;found
		ret

sdfs_ffile_4:	lds	r16,fileio_ram+33
		sub	r16,const_1
		brcc	sdfs_ffile_1
		ret


; delete file
sdfs_dfile:	rcall	sdfs_sectaddr0		;calc sector addr
		ldi	XH,24			;write block
		rcall	sdfs_cmd		;send CMD
		ldi	XL,0xfe			;start block token
		rcall	fsys_wspi		;send
		ldi	XH,0x00			;complete sector
sdfs_dfile_1:	rcall	fsys_write_ff2		;send
		dec	XH
		brne	sdfs_dfile_1
		rcall	fsys_write_ff2		;put dummy CRC bytes
sdfs_dfile_4:	rcall	fsys_write_ff		;put dummy byte
		cpi	XL,0xff
		brne	sdfs_dfile_4
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive
		ret

sdfs_dfile_e:	ldi	XL,T_ERR
		sts	0x200,XL
		ret

