;################################################################################
;#										#
;# libmio - multi i/o for ATMega644						#
;# init sequence								#
;# copyright (c) 2005-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
;port konfiguration for port A ... D
;-------------------------------------------------------------------------------
libmio_init:	ldi	r16,128
		ldi	XL,LOW(libmio_ram)
		ldi	XH,HIGH(libmio_ram)
libmio_init_r:	st	X+,const_0
		dec	r16
		brne	libmio_init_r

		ldi	XL,0
		ldi	XH,0x02
libmio_init_v:	st	X+,const_0
		cpi	XH,0x05
		brne	libmio_init_v

		ldi	XL,0x00			;input
		out	DDRA,XL
		ldi	XL,0x00
		out	PORTA,XL

		ldi	XL,0x00			;port direction (+SPI)
		out	DDRB,XL
		ldi	XL,0x00
		out	PORTB,XL

		ldi	XL,0x00			;port direction
		out	DDRC,XL
		ldi	XL,0x00
		out	PORTC,XL

		ldi	XL,0x00			;set pin 3-7 as output
		out	DDRD,XL
		ldi	XL,0x00
		out	PORTD,XL

		clr	XL
		sbic	CONFPORT_0,CONFPIN_0
		ori	XL,0x01
		sbic	CONFPORT_1,CONFPIN_1
		ori	XL,0x02
		sbic	CONFPORT_2,CONFPIN_2
		ori	XL,0x04
		sts	libmio_sysconf,XL

		sbi	VSDDR,VSPIN
		sbi	HSDDR,HSPIN

;-------------------------------------------------------------------------------
;usart configuration (synchronous for keyboard)
;-------------------------------------------------------------------------------
libmio_t2i:	sts	UCSR0A,const_0
		ldi	XL,0x10
		sts	UCSR0B,XL
		ldi	XL,0x66
		sts	UCSR0C,XL

		lds	XL,libmio_sysconf
		sbrc	XL,1
		rjmp	init_tv
		sbrc	XL,0
		rjmp	init_lcd


;-------------------------------------------------------------------------------
;timer configuration for VGA
;-------------------------------------------------------------------------------
init_vga:	ldi	XH,0xc2			;FAST-PWM-Mode 14 (PWM channel B)
		sts	TCCR1A,XH
		ldi	XH,0x19			;FAST-PWM-Mode (no prescaler)
		sts	TCCR1B,XH
		ldi	ZH,HIGH(libmio_counter_v)
		ldi	ZL,LOW(libmio_counter_v)
		sts	ICR1H,ZH
		sts	ICR1L,ZL

		ldi	ZH,libmio_vga_hslen	;1 hsync length VGA
		sts	OCR1AH,const_0		;we use only 8 bits
		sts	OCR1AL,ZH

		ldi	ZH,libmio_vga_int	;video start for VGA
		sts	OCR1BH,const_0		;we use only 8 bits
		sts	OCR1BL,ZH

		ldi	XL,0x04
		sts	TIMSK1,XL		;enable CHB INT

		cbi	MODEPORT,MODEPIN

		sts	UBRR1H,const_0
		sts	UBRR1L,const_0
		ldi	XL,0x18
		sts	UCSR1B,XL
		ldi	XL,0xc2
		sts	UCSR1C,XL
		sts	UBRR1H,const_0
		sts	UBRR1L,const_0

		cbi	VODDR,VOPIN

		ret

;-------------------------------------------------------------------------------
;timer configuration for LCD
;-------------------------------------------------------------------------------
init_lcd:	ldi	XL,0x10
		out	DPORT,XL		;VEE disabled
		ldi	XL,0xFF
		out	DDDR,XL

		ldi	XH,0xc2			;FAST-PWM-Mode 14 (PWM channel B)
		sts	TCCR1A,XH
		ldi	XH,0x19			;FAST-PWM-Mode (no prescaler)
		sts	TCCR1B,XH
		ldi	ZH,HIGH(1388)
		ldi	ZL,LOW(1388)
		sts	ICR1H,ZH
		sts	ICR1L,ZL

		ldi	ZH,72			;1 hsync length VGA
		sts	OCR1AH,const_0		;we use only 8 bits
		sts	OCR1AL,ZH

		ldi	XL,0x01
		sts	TIMSK1,XL		;enable TOV INT
		ret

;-------------------------------------------------------------------------------
;timer configuration for TV
;-------------------------------------------------------------------------------
init_tv:	ldi	XH,0xc2			;FAST-PWM-Mode 14 (PWM channel B)
		sts	TCCR1A,XH
		ldi	XH,0x19			;FAST-PWM-Mode (no prescaler)
		sts	TCCR1B,XH
		ldi	ZH,HIGH(libmio_counter_p-1)
		sbrs	XL,0			;1 pal/ntsc bit
		ldi	ZH,HIGH(libmio_counter_n-1)
		sts	ICR1H,ZH
		ldi	ZH,LOW(libmio_counter_p-1)
		sbrs	XL,0			;1 pal/ntsc bit
		ldi	ZH,LOW(libmio_counter_n-1)
		sts	ICR1L,ZH

		sts	OCR1AH,const_0		;we use only 8 bits
		ldi	ZH,libmio_hslen		;1 hsync length pal
		sts	OCR1AL,ZH

		ldi	ZH,HIGH(libmio_bend)	;border end Interrupt
		sts	OCR1BH,ZH
		ldi	ZH,LOW(libmio_bend)	;1 hor position pal
		sts	OCR1BL,ZH

		ldi	XL,0x06
		sts	TIMSK1,XL		;enable compare OC1A/OC1B int

		sbi	MODEPORT,MODEPIN	;INT mode

		sbi	VDDR,7
		ret

;------------------------------------------------------------------------------
;wait for a key
;------------------------------------------------------------------------------
libmio_waitkey:	sts	libmio_lastkey,const_0
libmio_wkey1:	lds	r16,libmio_lastkey
		cpi	r16,0
		breq	libmio_wkey1
		ret
