/*
 * This declarations of the PIC16F1829 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2014.
 *
 * This file is generated automatically by the cinc2h.pl, 2014-03-09 13:32:26 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16F1829_H__
#define __PIC16F1829_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF0_ADDR              0x0000
#define INDF1_ADDR              0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR0_ADDR               0x0004
#define FSR0L_ADDR              0x0004
#define FSR0H_ADDR              0x0005
#define FSR1_ADDR               0x0006
#define FSR1L_ADDR              0x0006
#define FSR1H_ADDR              0x0007
#define BSR_ADDR                0x0008
#define WREG_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PORTA_ADDR              0x000C
#define PORTB_ADDR              0x000D
#define PORTC_ADDR              0x000E
#define PIR1_ADDR               0x0011
#define PIR2_ADDR               0x0012
#define PIR3_ADDR               0x0013
#define PIR4_ADDR               0x0014
#define TMR0_ADDR               0x0015
#define TMR1_ADDR               0x0016
#define TMR1L_ADDR              0x0016
#define TMR1H_ADDR              0x0017
#define T1CON_ADDR              0x0018
#define T1GCON_ADDR             0x0019
#define TMR2_ADDR               0x001A
#define PR2_ADDR                0x001B
#define T2CON_ADDR              0x001C
#define CPSCON0_ADDR            0x001E
#define CPSCON1_ADDR            0x001F
#define TRISA_ADDR              0x008C
#define TRISB_ADDR              0x008D
#define TRISC_ADDR              0x008E
#define PIE1_ADDR               0x0091
#define PIE2_ADDR               0x0092
#define PIE3_ADDR               0x0093
#define PIE4_ADDR               0x0094
#define OPTION_REG_ADDR         0x0095
#define PCON_ADDR               0x0096
#define WDTCON_ADDR             0x0097
#define OSCTUNE_ADDR            0x0098
#define OSCCON_ADDR             0x0099
#define OSCSTAT_ADDR            0x009A
#define ADRES_ADDR              0x009B
#define ADRESL_ADDR             0x009B
#define ADRESH_ADDR             0x009C
#define ADCON0_ADDR             0x009D
#define ADCON1_ADDR             0x009E
#define LATA_ADDR               0x010C
#define LATB_ADDR               0x010D
#define LATC_ADDR               0x010E
#define CM1CON0_ADDR            0x0111
#define CM1CON1_ADDR            0x0112
#define CM2CON0_ADDR            0x0113
#define CM2CON1_ADDR            0x0114
#define CMOUT_ADDR              0x0115
#define BORCON_ADDR             0x0116
#define FVRCON_ADDR             0x0117
#define DACCON0_ADDR            0x0118
#define DACCON1_ADDR            0x0119
#define SRCON0_ADDR             0x011A
#define SRCON1_ADDR             0x011B
#define APFCON0_ADDR            0x011D
#define APFCON1_ADDR            0x011E
#define ANSELA_ADDR             0x018C
#define ANSELB_ADDR             0x018D
#define ANSELC_ADDR             0x018E
#define EEADR_ADDR              0x0191
#define EEADRL_ADDR             0x0191
#define EEADRH_ADDR             0x0192
#define EEDAT_ADDR              0x0193
#define EEDATL_ADDR             0x0193
#define EEDATH_ADDR             0x0194
#define EECON1_ADDR             0x0195
#define EECON2_ADDR             0x0196
#define RCREG_ADDR              0x0199
#define TXREG_ADDR              0x019A
#define SPBRG_ADDR              0x019B
#define SPBRGL_ADDR             0x019B
#define SPBRGH_ADDR             0x019C
#define RCSTA_ADDR              0x019D
#define TXSTA_ADDR              0x019E
#define BAUDCON_ADDR            0x019F
#define WPUA_ADDR               0x020C
#define WPUB_ADDR               0x020D
#define WPUC_ADDR               0x020E
#define SSP1BUF_ADDR            0x0211
#define SSPBUF_ADDR             0x0211
#define SSP1ADD_ADDR            0x0212
#define SSPADD_ADDR             0x0212
#define SSP1MSK_ADDR            0x0213
#define SSPMSK_ADDR             0x0213
#define SSP1STAT_ADDR           0x0214
#define SSPSTAT_ADDR            0x0214
#define SSP1CON1_ADDR           0x0215
#define SSPCON_ADDR             0x0215
#define SSPCON1_ADDR            0x0215
#define SSP1CON2_ADDR           0x0216
#define SSPCON2_ADDR            0x0216
#define SSP1CON3_ADDR           0x0217
#define SSPCON3_ADDR            0x0217
#define SSP2BUF_ADDR            0x0219
#define SSP2ADD_ADDR            0x021A
#define SSP2MSK_ADDR            0x021B
#define SSP2STAT_ADDR           0x021C
#define SSP2CON1_ADDR           0x021D
#define SSP2CON2_ADDR           0x021E
#define SSP2CON3_ADDR           0x021F
#define CCPR1_ADDR              0x0291
#define CCPR1L_ADDR             0x0291
#define CCPR1H_ADDR             0x0292
#define CCP1CON_ADDR            0x0293
#define PWM1CON_ADDR            0x0294
#define CCP1AS_ADDR             0x0295
#define ECCP1AS_ADDR            0x0295
#define PSTR1CON_ADDR           0x0296
#define CCPR2_ADDR              0x0298
#define CCPR2L_ADDR             0x0298
#define CCPR2H_ADDR             0x0299
#define CCP2CON_ADDR            0x029A
#define PWM2CON_ADDR            0x029B
#define CCP2AS_ADDR             0x029C
#define PSTR2CON_ADDR           0x029D
#define CCPTMRS_ADDR            0x029E
#define CCPR3_ADDR              0x0311
#define CCPR3L_ADDR             0x0311
#define CCPR3H_ADDR             0x0312
#define CCP3CON_ADDR            0x0313
#define CCPR4_ADDR              0x0318
#define CCPR4L_ADDR             0x0318
#define CCPR4H_ADDR             0x0319
#define CCP4CON_ADDR            0x031A
#define INLVLA_ADDR             0x038C
#define INLVLB_ADDR             0x038D
#define INLVLC_ADDR             0x038E
#define IOCAP_ADDR              0x0391
#define IOCAN_ADDR              0x0392
#define IOCAF_ADDR              0x0393
#define IOCBP_ADDR              0x0394
#define IOCBN_ADDR              0x0395
#define IOCBF_ADDR              0x0396
#define CLKRCON_ADDR            0x039A
#define MDCON_ADDR              0x039C
#define MDSRC_ADDR              0x039D
#define MDCARL_ADDR             0x039E
#define MDCARH_ADDR             0x039F
#define TMR4_ADDR               0x0415
#define PR4_ADDR                0x0416
#define T4CON_ADDR              0x0417
#define TMR6_ADDR               0x041C
#define PR6_ADDR                0x041D
#define T6CON_ADDR              0x041E
#define STATUS_SHAD_ADDR        0x0FE4
#define WREG_SHAD_ADDR          0x0FE5
#define BSR_SHAD_ADDR           0x0FE6
#define PCLATH_SHAD_ADDR        0x0FE7
#define FSR0L_SHAD_ADDR         0x0FE8
#define FSR0H_SHAD_ADDR         0x0FE9
#define FSR1L_SHAD_ADDR         0x0FEA
#define FSR1H_SHAD_ADDR         0x0FEB
#define STKPTR_ADDR             0x0FED
#define TOSL_ADDR               0x0FEE
#define TOSH_ADDR               0x0FEF

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF0;
extern __at(0x0001) __sfr INDF1;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned NOT_PD               : 1;
  unsigned NOT_TO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10

//==============================================================================

extern __at(0x0004) __sfr FSR0;
extern __at(0x0004) __sfr FSR0L;
extern __at(0x0005) __sfr FSR0H;
extern __at(0x0006) __sfr FSR1;
extern __at(0x0006) __sfr FSR1L;
extern __at(0x0007) __sfr FSR1H;

//==============================================================================
//        BSR Bits

extern __at(0x0008) __sfr BSR;

typedef union
  {
  struct
    {
    unsigned BSR0               : 1;
    unsigned BSR1               : 1;
    unsigned BSR2               : 1;
    unsigned BSR3               : 1;
    unsigned BSR4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BSR                : 5;
    unsigned                    : 3;
    };
  } __BSRbits_t;

extern __at(0x0008) volatile __BSRbits_t BSRbits;

#define _BSR0                   0x01
#define _BSR1                   0x02
#define _BSR2                   0x04
#define _BSR3                   0x08
#define _BSR4                   0x10

//==============================================================================

extern __at(0x0009) __sfr WREG;
extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned IOCIF              : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned IOCIE              : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _IOCIE                  0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x000C) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 6;
    unsigned                    : 2;
    };
  } __PORTAbits_t;

extern __at(0x000C) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x000D) __sfr PORTB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x000D) volatile __PORTBbits_t PORTBbits;

#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x000E) __sfr PORTC;

typedef struct
  {
  unsigned RC0                  : 1;
  unsigned RC1                  : 1;
  unsigned RC2                  : 1;
  unsigned RC3                  : 1;
  unsigned RC4                  : 1;
  unsigned RC5                  : 1;
  unsigned RC6                  : 1;
  unsigned RC7                  : 1;
  } __PORTCbits_t;

extern __at(0x000E) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20
#define _RC6                    0x40
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0011) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned CCP1IF               : 1;
  unsigned SSP1IF               : 1;
  unsigned TXIF                 : 1;
  unsigned RCIF                 : 1;
  unsigned ADIF                 : 1;
  unsigned TMR1GIF              : 1;
  } __PIR1bits_t;

extern __at(0x0011) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSP1IF                 0x08
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0012) __sfr PIR2;

typedef struct
  {
  unsigned CCP2IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BCL1IF               : 1;
  unsigned EEIF                 : 1;
  unsigned C1IF                 : 1;
  unsigned C2IF                 : 1;
  unsigned OSFIF                : 1;
  } __PIR2bits_t;

extern __at(0x0012) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01
#define _BCL1IF                 0x08
#define _EEIF                   0x10
#define _C1IF                   0x20
#define _C2IF                   0x40
#define _OSFIF                  0x80

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0013) __sfr PIR3;

typedef struct
  {
  unsigned                      : 1;
  unsigned TMR4IF               : 1;
  unsigned                      : 1;
  unsigned TMR6IF               : 1;
  unsigned CCP3IF               : 1;
  unsigned CCP4IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR3bits_t;

extern __at(0x0013) volatile __PIR3bits_t PIR3bits;

#define _TMR4IF                 0x02
#define _TMR6IF                 0x08
#define _CCP3IF                 0x10
#define _CCP4IF                 0x20

//==============================================================================


//==============================================================================
//        PIR4 Bits

extern __at(0x0014) __sfr PIR4;

typedef struct
  {
  unsigned SSP2IF               : 1;
  unsigned BCL2IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR4bits_t;

extern __at(0x0014) volatile __PIR4bits_t PIR4bits;

#define _SSP2IF                 0x01
#define _BCL2IF                 0x02

//==============================================================================

extern __at(0x0015) __sfr TMR0;
extern __at(0x0016) __sfr TMR1;
extern __at(0x0016) __sfr TMR1L;
extern __at(0x0017) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0018) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0018) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _NOT_T1SYNC             0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0019) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO              : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0019) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO                  0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================

extern __at(0x001A) __sfr TMR2;
extern __at(0x001B) __sfr PR2;

//==============================================================================
//        T2CON Bits

extern __at(0x001C) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x001C) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================


//==============================================================================
//        CPSCON0 Bits

extern __at(0x001E) __sfr CPSCON0;

typedef union
  {
  struct
    {
    unsigned T0XCS              : 1;
    unsigned CPSOUT             : 1;
    unsigned CPSRNG0            : 1;
    unsigned CPSRNG1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CPSRM              : 1;
    unsigned CPSON              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CPSRNG             : 2;
    unsigned                    : 4;
    };
  } __CPSCON0bits_t;

extern __at(0x001E) volatile __CPSCON0bits_t CPSCON0bits;

#define _T0XCS                  0x01
#define _CPSOUT                 0x02
#define _CPSRNG0                0x04
#define _CPSRNG1                0x08
#define _CPSRM                  0x40
#define _CPSON                  0x80

//==============================================================================


//==============================================================================
//        CPSCON1 Bits

extern __at(0x001F) __sfr CPSCON1;

typedef union
  {
  struct
    {
    unsigned CPSCH0             : 1;
    unsigned CPSCH1             : 1;
    unsigned CPSCH2             : 1;
    unsigned CPSCH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CPSCH              : 4;
    unsigned                    : 4;
    };
  } __CPSCON1bits_t;

extern __at(0x001F) volatile __CPSCON1bits_t CPSCON1bits;

#define _CPSCH0                 0x01
#define _CPSCH1                 0x02
#define _CPSCH2                 0x04
#define _CPSCH3                 0x08

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x008C) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISA              : 6;
    unsigned                    : 2;
    };
  } __TRISAbits_t;

extern __at(0x008C) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x008D) __sfr TRISB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x008D) volatile __TRISBbits_t TRISBbits;

#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x008E) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x008E) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0091) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned CCP1IE               : 1;
  unsigned SSP1IE               : 1;
  unsigned TXIE                 : 1;
  unsigned RCIE                 : 1;
  unsigned ADIE                 : 1;
  unsigned TMR1GIE              : 1;
  } __PIE1bits_t;

extern __at(0x0091) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSP1IE                 0x08
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0092) __sfr PIE2;

typedef struct
  {
  unsigned CCP2IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BCL1IE               : 1;
  unsigned EEIE                 : 1;
  unsigned C1IE                 : 1;
  unsigned C2IE                 : 1;
  unsigned OSFIE                : 1;
  } __PIE2bits_t;

extern __at(0x0092) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01
#define _BCL1IE                 0x08
#define _EEIE                   0x10
#define _C1IE                   0x20
#define _C2IE                   0x40
#define _OSFIE                  0x80

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0093) __sfr PIE3;

typedef struct
  {
  unsigned                      : 1;
  unsigned TMR4IE               : 1;
  unsigned                      : 1;
  unsigned TMR6IE               : 1;
  unsigned CCP3IE               : 1;
  unsigned CCP4IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE3bits_t;

extern __at(0x0093) volatile __PIE3bits_t PIE3bits;

#define _TMR4IE                 0x02
#define _TMR6IE                 0x08
#define _CCP3IE                 0x10
#define _CCP4IE                 0x20

//==============================================================================


//==============================================================================
//        PIE4 Bits

extern __at(0x0094) __sfr PIE4;

typedef struct
  {
  unsigned SSP2IE               : 1;
  unsigned BCL2IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE4bits_t;

extern __at(0x0094) volatile __PIE4bits_t PIE4bits;

#define _SSP2IE                 0x01
#define _BCL2IE                 0x02

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0095) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned TMR0SE             : 1;
    unsigned TMR0CS             : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_WPUEN          : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0095) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _TMR0SE                 0x10
#define _T0SE                   0x10
#define _TMR0CS                 0x20
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_WPUEN              0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x0096) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned NOT_RI               : 1;
  unsigned NOT_RMCLR            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned STKUNF               : 1;
  unsigned STKOVF               : 1;
  } __PCONbits_t;

extern __at(0x0096) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02
#define _NOT_RI                 0x04
#define _NOT_RMCLR              0x08
#define _STKUNF                 0x40
#define _STKOVF                 0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0097) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCONbits_t;

extern __at(0x0097) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10
#define _WDTPS4                 0x20

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0098) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TUN                : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x0098) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0099) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned                    : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IRCF3              : 1;
    unsigned SPLLEN             : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned IRCF               : 4;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0099) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IRCF0                  0x08
#define _IRCF1                  0x10
#define _IRCF2                  0x20
#define _IRCF3                  0x40
#define _SPLLEN                 0x80

//==============================================================================


//==============================================================================
//        OSCSTAT Bits

extern __at(0x009A) __sfr OSCSTAT;

typedef struct
  {
  unsigned HFIOFS               : 1;
  unsigned LFIOFR               : 1;
  unsigned MFIOFR               : 1;
  unsigned HFIOFL               : 1;
  unsigned HFIOFR               : 1;
  unsigned OSTS                 : 1;
  unsigned PLLR                 : 1;
  unsigned T1OSCR               : 1;
  } __OSCSTATbits_t;

extern __at(0x009A) volatile __OSCSTATbits_t OSCSTATbits;

#define _HFIOFS                 0x01
#define _LFIOFR                 0x02
#define _MFIOFR                 0x04
#define _HFIOFL                 0x08
#define _HFIOFR                 0x10
#define _OSTS                   0x20
#define _PLLR                   0x40
#define _T1OSCR                 0x80

//==============================================================================

extern __at(0x009B) __sfr ADRES;
extern __at(0x009B) __sfr ADRESL;
extern __at(0x009C) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x009D) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADGO               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __ADCON0bits_t;

extern __at(0x009D) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _ADGO                   0x02
#define _GO                     0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _CHS4                   0x40

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x009E) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned ADNREF             : 1;
    unsigned                    : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCS               : 3;
    unsigned                    : 1;
    };
  } __ADCON1bits_t;

extern __at(0x009E) volatile __ADCON1bits_t ADCON1bits;

#define _ADPREF0                0x01
#define _ADPREF1                0x02
#define _ADNREF                 0x04
#define _ADCS0                  0x10
#define _ADCS1                  0x20
#define _ADCS2                  0x40
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x010C) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned                      : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LATAbits_t;

extern __at(0x010C) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA4                  0x10
#define _LATA5                  0x20

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x010D) __sfr LATB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x010D) volatile __LATBbits_t LATBbits;

#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x010E) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x010E) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x0111) __sfr CM1CON0;

typedef struct
  {
  unsigned C1SYNC               : 1;
  unsigned C1HYS                : 1;
  unsigned C1SP                 : 1;
  unsigned                      : 1;
  unsigned C1POL                : 1;
  unsigned C1OE                 : 1;
  unsigned C1OUT                : 1;
  unsigned C1ON                 : 1;
  } __CM1CON0bits_t;

extern __at(0x0111) volatile __CM1CON0bits_t CM1CON0bits;

#define _C1SYNC                 0x01
#define _C1HYS                  0x02
#define _C1SP                   0x04
#define _C1POL                  0x10
#define _C1OE                   0x20
#define _C1OUT                  0x40
#define _C1ON                   0x80

//==============================================================================


//==============================================================================
//        CM1CON1 Bits

extern __at(0x0112) __sfr CM1CON1;

typedef union
  {
  struct
    {
    unsigned C1NCH0             : 1;
    unsigned C1NCH1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned C1PCH0             : 1;
    unsigned C1PCH1             : 1;
    unsigned C1INTN             : 1;
    unsigned C1INTP             : 1;
    };

  struct
    {
    unsigned C1NCH              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned C1PCH              : 2;
    unsigned                    : 2;
    };
  } __CM1CON1bits_t;

extern __at(0x0112) volatile __CM1CON1bits_t CM1CON1bits;

#define _C1NCH0                 0x01
#define _C1NCH1                 0x02
#define _C1PCH0                 0x10
#define _C1PCH1                 0x20
#define _C1INTN                 0x40
#define _C1INTP                 0x80

//==============================================================================


//==============================================================================
//        CM2CON0 Bits

extern __at(0x0113) __sfr CM2CON0;

typedef struct
  {
  unsigned C2SYNC               : 1;
  unsigned C2HYS                : 1;
  unsigned C2SP                 : 1;
  unsigned                      : 1;
  unsigned C2POL                : 1;
  unsigned C2OE                 : 1;
  unsigned C2OUT                : 1;
  unsigned C2ON                 : 1;
  } __CM2CON0bits_t;

extern __at(0x0113) volatile __CM2CON0bits_t CM2CON0bits;

#define _C2SYNC                 0x01
#define _C2HYS                  0x02
#define _C2SP                   0x04
#define _C2POL                  0x10
#define _C2OE                   0x20
#define _C2OUT                  0x40
#define _C2ON                   0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x0114) __sfr CM2CON1;

typedef union
  {
  struct
    {
    unsigned C2NCH0             : 1;
    unsigned C2NCH1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned C2PCH0             : 1;
    unsigned C2PCH1             : 1;
    unsigned C2INTN             : 1;
    unsigned C2INTP             : 1;
    };

  struct
    {
    unsigned C2NCH              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned C2PCH              : 2;
    unsigned                    : 2;
    };
  } __CM2CON1bits_t;

extern __at(0x0114) volatile __CM2CON1bits_t CM2CON1bits;

#define _C2NCH0                 0x01
#define _C2NCH1                 0x02
#define _C2PCH0                 0x10
#define _C2PCH1                 0x20
#define _C2INTN                 0x40
#define _C2INTP                 0x80

//==============================================================================


//==============================================================================
//        CMOUT Bits

extern __at(0x0115) __sfr CMOUT;

typedef struct
  {
  unsigned MC1OUT               : 1;
  unsigned MC2OUT               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CMOUTbits_t;

extern __at(0x0115) volatile __CMOUTbits_t CMOUTbits;

#define _MC1OUT                 0x01
#define _MC2OUT                 0x02

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x0116) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x0116) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x0117) __sfr FVRCON;

typedef union
  {
  struct
    {
    unsigned ADFVR0             : 1;
    unsigned ADFVR1             : 1;
    unsigned CDAFVR0            : 1;
    unsigned CDAFVR1            : 1;
    unsigned TSRNG              : 1;
    unsigned TSEN               : 1;
    unsigned FVRRDY             : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned ADFVR              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CDAFVR             : 2;
    unsigned                    : 4;
    };
  } __FVRCONbits_t;

extern __at(0x0117) volatile __FVRCONbits_t FVRCONbits;

#define _ADFVR0                 0x01
#define _ADFVR1                 0x02
#define _CDAFVR0                0x04
#define _CDAFVR1                0x08
#define _TSRNG                  0x10
#define _TSEN                   0x20
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        DACCON0 Bits

extern __at(0x0118) __sfr DACCON0;

typedef union
  {
  struct
    {
    unsigned DACNSS             : 1;
    unsigned                    : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned                    : 1;
    unsigned DACOE              : 1;
    unsigned DACLPS             : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };
  } __DACCON0bits_t;

extern __at(0x0118) volatile __DACCON0bits_t DACCON0bits;

#define _DACNSS                 0x01
#define _DACPSS0                0x04
#define _DACPSS1                0x08
#define _DACOE                  0x20
#define _DACLPS                 0x40
#define _DACEN                  0x80

//==============================================================================


//==============================================================================
//        DACCON1 Bits

extern __at(0x0119) __sfr DACCON1;

typedef union
  {
  struct
    {
    unsigned DACR0              : 1;
    unsigned DACR1              : 1;
    unsigned DACR2              : 1;
    unsigned DACR3              : 1;
    unsigned DACR4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DACR               : 5;
    unsigned                    : 3;
    };
  } __DACCON1bits_t;

extern __at(0x0119) volatile __DACCON1bits_t DACCON1bits;

#define _DACR0                  0x01
#define _DACR1                  0x02
#define _DACR2                  0x04
#define _DACR3                  0x08
#define _DACR4                  0x10

//==============================================================================


//==============================================================================
//        SRCON0 Bits

extern __at(0x011A) __sfr SRCON0;

typedef union
  {
  struct
    {
    unsigned SRPR               : 1;
    unsigned SRPS               : 1;
    unsigned SRNQEN             : 1;
    unsigned SRQEN              : 1;
    unsigned SRCLK0             : 1;
    unsigned SRCLK1             : 1;
    unsigned SRCLK2             : 1;
    unsigned SRLEN              : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned SRCLK              : 3;
    unsigned                    : 1;
    };
  } __SRCON0bits_t;

extern __at(0x011A) volatile __SRCON0bits_t SRCON0bits;

#define _SRPR                   0x01
#define _SRPS                   0x02
#define _SRNQEN                 0x04
#define _SRQEN                  0x08
#define _SRCLK0                 0x10
#define _SRCLK1                 0x20
#define _SRCLK2                 0x40
#define _SRLEN                  0x80

//==============================================================================


//==============================================================================
//        SRCON1 Bits

extern __at(0x011B) __sfr SRCON1;

typedef struct
  {
  unsigned SRRC1E               : 1;
  unsigned SRRC2E               : 1;
  unsigned SRRCKE               : 1;
  unsigned SRRPE                : 1;
  unsigned SRSC1E               : 1;
  unsigned SRSC2E               : 1;
  unsigned SRSCKE               : 1;
  unsigned SRSPE                : 1;
  } __SRCON1bits_t;

extern __at(0x011B) volatile __SRCON1bits_t SRCON1bits;

#define _SRRC1E                 0x01
#define _SRRC2E                 0x02
#define _SRRCKE                 0x04
#define _SRRPE                  0x08
#define _SRSC1E                 0x10
#define _SRSC2E                 0x20
#define _SRSCKE                 0x40
#define _SRSPE                  0x80

//==============================================================================


//==============================================================================
//        APFCON0 Bits

extern __at(0x011D) __sfr APFCON0;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TXCKSEL              : 1;
  unsigned T1GSEL               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned RXDTSEL              : 1;
  } __APFCON0bits_t;

extern __at(0x011D) volatile __APFCON0bits_t APFCON0bits;

#define _TXCKSEL                0x04
#define _T1GSEL                 0x08
#define _RXDTSEL                0x80

//==============================================================================


//==============================================================================
//        APFCON1 Bits

extern __at(0x011E) __sfr APFCON1;

typedef struct
  {
  unsigned CCP2SEL              : 1;
  unsigned P2BSEL               : 1;
  unsigned P1CSEL               : 1;
  unsigned P1DSEL               : 1;
  unsigned SS2SEL               : 1;
  unsigned SDO2SEL              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __APFCON1bits_t;

extern __at(0x011E) volatile __APFCON1bits_t APFCON1bits;

#define _CCP2SEL                0x01
#define _P2BSEL                 0x02
#define _P1CSEL                 0x04
#define _P1DSEL                 0x08
#define _SS2SEL                 0x10
#define _SDO2SEL                0x20

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x018C) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned                      : 1;
  unsigned ANSA4                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELAbits_t;

extern __at(0x018C) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA4                  0x10

//==============================================================================


//==============================================================================
//        ANSELB Bits

extern __at(0x018D) __sfr ANSELB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ANSB4                : 1;
  unsigned ANSB5                : 1;
  unsigned ANSB6                : 1;
  unsigned ANSB7                : 1;
  } __ANSELBbits_t;

extern __at(0x018D) volatile __ANSELBbits_t ANSELBbits;

#define _ANSB4                  0x10
#define _ANSB5                  0x20
#define _ANSB6                  0x40
#define _ANSB7                  0x80

//==============================================================================


//==============================================================================
//        ANSELC Bits

extern __at(0x018E) __sfr ANSELC;

typedef struct
  {
  unsigned ANSC0                : 1;
  unsigned ANSC1                : 1;
  unsigned ANSC2                : 1;
  unsigned ANSC3                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ANSC6                : 1;
  unsigned ANSC7                : 1;
  } __ANSELCbits_t;

extern __at(0x018E) volatile __ANSELCbits_t ANSELCbits;

#define _ANSC0                  0x01
#define _ANSC1                  0x02
#define _ANSC2                  0x04
#define _ANSC3                  0x08
#define _ANSC6                  0x40
#define _ANSC7                  0x80

//==============================================================================

extern __at(0x0191) __sfr EEADR;
extern __at(0x0191) __sfr EEADRL;
extern __at(0x0192) __sfr EEADRH;
extern __at(0x0193) __sfr EEDAT;
extern __at(0x0193) __sfr EEDATL;
extern __at(0x0194) __sfr EEDATH;

//==============================================================================
//        EECON1 Bits

extern __at(0x0195) __sfr EECON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned CFGS                 : 1;
  unsigned EEPGD                : 1;
  } __EECON1bits_t;

extern __at(0x0195) volatile __EECON1bits_t EECON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _CFGS                   0x40
#define _EEPGD                  0x80

//==============================================================================

extern __at(0x0196) __sfr EECON2;
extern __at(0x0199) __sfr RCREG;
extern __at(0x019A) __sfr TXREG;
extern __at(0x019B) __sfr SPBRG;
extern __at(0x019B) __sfr SPBRGL;
extern __at(0x019C) __sfr SPBRGH;

//==============================================================================
//        RCSTA Bits

extern __at(0x019D) __sfr RCSTA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTAbits_t;

extern __at(0x019D) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x019E) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x019E) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SENDB                  0x08
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _CSRC                   0x80

//==============================================================================


//==============================================================================
//        BAUDCON Bits

extern __at(0x019F) __sfr BAUDCON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCONbits_t;

extern __at(0x019F) volatile __BAUDCONbits_t BAUDCONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _SCKP                   0x10
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        WPUA Bits

extern __at(0x020C) __sfr WPUA;

typedef union
  {
  struct
    {
    unsigned WPUA0              : 1;
    unsigned WPUA1              : 1;
    unsigned WPUA2              : 1;
    unsigned WPUA3              : 1;
    unsigned WPUA4              : 1;
    unsigned WPUA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPUA               : 6;
    unsigned                    : 2;
    };
  } __WPUAbits_t;

extern __at(0x020C) volatile __WPUAbits_t WPUAbits;

#define _WPUA0                  0x01
#define _WPUA1                  0x02
#define _WPUA2                  0x04
#define _WPUA3                  0x08
#define _WPUA4                  0x10
#define _WPUA5                  0x20

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x020D) __sfr WPUB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x020D) volatile __WPUBbits_t WPUBbits;

#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        WPUC Bits

extern __at(0x020E) __sfr WPUC;

typedef struct
  {
  unsigned WPUC0                : 1;
  unsigned WPUC1                : 1;
  unsigned WPUC2                : 1;
  unsigned WPUC3                : 1;
  unsigned WPUC4                : 1;
  unsigned WPUC5                : 1;
  unsigned WPUC6                : 1;
  unsigned WPUC7                : 1;
  } __WPUCbits_t;

extern __at(0x020E) volatile __WPUCbits_t WPUCbits;

#define _WPUC0                  0x01
#define _WPUC1                  0x02
#define _WPUC2                  0x04
#define _WPUC3                  0x08
#define _WPUC4                  0x10
#define _WPUC5                  0x20
#define _WPUC6                  0x40
#define _WPUC7                  0x80

//==============================================================================

extern __at(0x0211) __sfr SSP1BUF;
extern __at(0x0211) __sfr SSPBUF;
extern __at(0x0212) __sfr SSP1ADD;
extern __at(0x0212) __sfr SSPADD;
extern __at(0x0213) __sfr SSP1MSK;
extern __at(0x0213) __sfr SSPMSK;

//==============================================================================
//        SSP1STAT Bits

extern __at(0x0214) __sfr SSP1STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP1STATbits_t;

extern __at(0x0214) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _S                      0x08
#define _P                      0x10
#define _D_NOT_A                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0214) __sfr SSPSTAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSPSTATbits_t;

extern __at(0x0214) volatile __SSPSTATbits_t SSPSTATbits;

#define _SSPSTAT_BF             0x01
#define _SSPSTAT_UA             0x02
#define _SSPSTAT_R_NOT_W        0x04
#define _SSPSTAT_S              0x08
#define _SSPSTAT_P              0x10
#define _SSPSTAT_D_NOT_A        0x20
#define _SSPSTAT_CKE            0x40
#define _SSPSTAT_SMP            0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0215) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0215) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSPCON Bits

extern __at(0x0215) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0215) volatile __SSPCONbits_t SSPCONbits;

#define _SSPCON_SSPM0           0x01
#define _SSPCON_SSPM1           0x02
#define _SSPCON_SSPM2           0x04
#define _SSPCON_SSPM3           0x08
#define _SSPCON_CKP             0x10
#define _SSPCON_SSPEN           0x20
#define _SSPCON_SSPOV           0x40
#define _SSPCON_WCOL            0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0215) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0215) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPCON1_SSPM0          0x01
#define _SSPCON1_SSPM1          0x02
#define _SSPCON1_SSPM2          0x04
#define _SSPCON1_SSPM3          0x08
#define _SSPCON1_CKP            0x10
#define _SSPCON1_SSPEN          0x20
#define _SSPCON1_SSPOV          0x40
#define _SSPCON1_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0216) __sfr SSP1CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP1CON2bits_t;

extern __at(0x0216) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0216) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0216) volatile __SSPCON2bits_t SSPCON2bits;

#define _SSPCON2_SEN            0x01
#define _SSPCON2_RSEN           0x02
#define _SSPCON2_PEN            0x04
#define _SSPCON2_RCEN           0x08
#define _SSPCON2_ACKEN          0x10
#define _SSPCON2_ACKDT          0x20
#define _SSPCON2_ACKSTAT        0x40
#define _SSPCON2_GCEN           0x80

//==============================================================================


//==============================================================================
//        SSP1CON3 Bits

extern __at(0x0217) __sfr SSP1CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP1CON3bits_t;

extern __at(0x0217) volatile __SSP1CON3bits_t SSP1CON3bits;

#define _DHEN                   0x01
#define _AHEN                   0x02
#define _SBCDE                  0x04
#define _SDAHT                  0x08
#define _BOEN                   0x10
#define _SCIE                   0x20
#define _PCIE                   0x40
#define _ACKTIM                 0x80

//==============================================================================


//==============================================================================
//        SSPCON3 Bits

extern __at(0x0217) __sfr SSPCON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSPCON3bits_t;

extern __at(0x0217) volatile __SSPCON3bits_t SSPCON3bits;

#define _SSPCON3_DHEN           0x01
#define _SSPCON3_AHEN           0x02
#define _SSPCON3_SBCDE          0x04
#define _SSPCON3_SDAHT          0x08
#define _SSPCON3_BOEN           0x10
#define _SSPCON3_SCIE           0x20
#define _SSPCON3_PCIE           0x40
#define _SSPCON3_ACKTIM         0x80

//==============================================================================

extern __at(0x0219) __sfr SSP2BUF;
extern __at(0x021A) __sfr SSP2ADD;
extern __at(0x021B) __sfr SSP2MSK;

//==============================================================================
//        SSP2STAT Bits

extern __at(0x021C) __sfr SSP2STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP2STATbits_t;

extern __at(0x021C) volatile __SSP2STATbits_t SSP2STATbits;

#define _SSP2STAT_BF            0x01
#define _SSP2STAT_UA            0x02
#define _SSP2STAT_R_NOT_W       0x04
#define _SSP2STAT_S             0x08
#define _SSP2STAT_P             0x10
#define _SSP2STAT_D_NOT_A       0x20
#define _SSP2STAT_CKE           0x40
#define _SSP2STAT_SMP           0x80

//==============================================================================


//==============================================================================
//        SSP2CON1 Bits

extern __at(0x021D) __sfr SSP2CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP2CON1bits_t;

extern __at(0x021D) volatile __SSP2CON1bits_t SSP2CON1bits;

#define _SSP2CON1_SSPM0         0x01
#define _SSP2CON1_SSPM1         0x02
#define _SSP2CON1_SSPM2         0x04
#define _SSP2CON1_SSPM3         0x08
#define _SSP2CON1_CKP           0x10
#define _SSP2CON1_SSPEN         0x20
#define _SSP2CON1_SSPOV         0x40
#define _SSP2CON1_WCOL          0x80

//==============================================================================


//==============================================================================
//        SSP2CON2 Bits

extern __at(0x021E) __sfr SSP2CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP2CON2bits_t;

extern __at(0x021E) volatile __SSP2CON2bits_t SSP2CON2bits;

#define _SSP2CON2_SEN           0x01
#define _SSP2CON2_RSEN          0x02
#define _SSP2CON2_PEN           0x04
#define _SSP2CON2_RCEN          0x08
#define _SSP2CON2_ACKEN         0x10
#define _SSP2CON2_ACKDT         0x20
#define _SSP2CON2_ACKSTAT       0x40
#define _SSP2CON2_GCEN          0x80

//==============================================================================


//==============================================================================
//        SSP2CON3 Bits

extern __at(0x021F) __sfr SSP2CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP2CON3bits_t;

extern __at(0x021F) volatile __SSP2CON3bits_t SSP2CON3bits;

#define _SSP2CON3_DHEN          0x01
#define _SSP2CON3_AHEN          0x02
#define _SSP2CON3_SBCDE         0x04
#define _SSP2CON3_SDAHT         0x08
#define _SSP2CON3_BOEN          0x10
#define _SSP2CON3_SCIE          0x20
#define _SSP2CON3_PCIE          0x40
#define _SSP2CON3_ACKTIM        0x80

//==============================================================================

extern __at(0x0291) __sfr CCPR1;
extern __at(0x0291) __sfr CCPR1L;
extern __at(0x0292) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0293) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned P1M0               : 1;
    unsigned P1M1               : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P1M                : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0293) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _DC1B1                  0x20
#define _P1M0                   0x40
#define _P1M1                   0x80

//==============================================================================


//==============================================================================
//        PWM1CON Bits

extern __at(0x0294) __sfr PWM1CON;

typedef union
  {
  struct
    {
    unsigned P1DC0              : 1;
    unsigned P1DC1              : 1;
    unsigned P1DC2              : 1;
    unsigned P1DC3              : 1;
    unsigned P1DC4              : 1;
    unsigned P1DC5              : 1;
    unsigned P1DC6              : 1;
    unsigned P1RSEN             : 1;
    };

  struct
    {
    unsigned P1DC               : 7;
    unsigned                    : 1;
    };
  } __PWM1CONbits_t;

extern __at(0x0294) volatile __PWM1CONbits_t PWM1CONbits;

#define _P1DC0                  0x01
#define _P1DC1                  0x02
#define _P1DC2                  0x04
#define _P1DC3                  0x08
#define _P1DC4                  0x10
#define _P1DC5                  0x20
#define _P1DC6                  0x40
#define _P1RSEN                 0x80

//==============================================================================


//==============================================================================
//        CCP1AS Bits

extern __at(0x0295) __sfr CCP1AS;

typedef union
  {
  struct
    {
    unsigned PSS1BD0            : 1;
    unsigned PSS1BD1            : 1;
    unsigned PSS1AC0            : 1;
    unsigned PSS1AC1            : 1;
    unsigned CCP1AS0            : 1;
    unsigned CCP1AS1            : 1;
    unsigned CCP1AS2            : 1;
    unsigned CCP1ASE            : 1;
    };

  struct
    {
    unsigned PSS1BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS1AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CCP1AS             : 3;
    unsigned                    : 1;
    };
  } __CCP1ASbits_t;

extern __at(0x0295) volatile __CCP1ASbits_t CCP1ASbits;

#define _PSS1BD0                0x01
#define _PSS1BD1                0x02
#define _PSS1AC0                0x04
#define _PSS1AC1                0x08
#define _CCP1AS0                0x10
#define _CCP1AS1                0x20
#define _CCP1AS2                0x40
#define _CCP1ASE                0x80

//==============================================================================


//==============================================================================
//        ECCP1AS Bits

extern __at(0x0295) __sfr ECCP1AS;

typedef union
  {
  struct
    {
    unsigned PSS1BD0            : 1;
    unsigned PSS1BD1            : 1;
    unsigned PSS1AC0            : 1;
    unsigned PSS1AC1            : 1;
    unsigned CCP1AS0            : 1;
    unsigned CCP1AS1            : 1;
    unsigned CCP1AS2            : 1;
    unsigned CCP1ASE            : 1;
    };

  struct
    {
    unsigned PSS1BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS1AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CCP1AS             : 3;
    unsigned                    : 1;
    };
  } __ECCP1ASbits_t;

extern __at(0x0295) volatile __ECCP1ASbits_t ECCP1ASbits;

#define _ECCP1AS_PSS1BD0        0x01
#define _ECCP1AS_PSS1BD1        0x02
#define _ECCP1AS_PSS1AC0        0x04
#define _ECCP1AS_PSS1AC1        0x08
#define _ECCP1AS_CCP1AS0        0x10
#define _ECCP1AS_CCP1AS1        0x20
#define _ECCP1AS_CCP1AS2        0x40
#define _ECCP1AS_CCP1ASE        0x80

//==============================================================================


//==============================================================================
//        PSTR1CON Bits

extern __at(0x0296) __sfr PSTR1CON;

typedef struct
  {
  unsigned STR1A                : 1;
  unsigned STR1B                : 1;
  unsigned STR1C                : 1;
  unsigned STR1D                : 1;
  unsigned STR1SYNC             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSTR1CONbits_t;

extern __at(0x0296) volatile __PSTR1CONbits_t PSTR1CONbits;

#define _STR1A                  0x01
#define _STR1B                  0x02
#define _STR1C                  0x04
#define _STR1D                  0x08
#define _STR1SYNC               0x10

//==============================================================================

extern __at(0x0298) __sfr CCPR2;
extern __at(0x0298) __sfr CCPR2L;
extern __at(0x0299) __sfr CCPR2H;

//==============================================================================
//        CCP2CON Bits

extern __at(0x029A) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned P2M0               : 1;
    unsigned P2M1               : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P2M                : 2;
    };
  } __CCP2CONbits_t;

extern __at(0x029A) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2M0                 0x01
#define _CCP2M1                 0x02
#define _CCP2M2                 0x04
#define _CCP2M3                 0x08
#define _DC2B0                  0x10
#define _DC2B1                  0x20
#define _P2M0                   0x40
#define _P2M1                   0x80

//==============================================================================


//==============================================================================
//        PWM2CON Bits

extern __at(0x029B) __sfr PWM2CON;

typedef union
  {
  struct
    {
    unsigned P2DC0              : 1;
    unsigned P2DC1              : 1;
    unsigned P2DC2              : 1;
    unsigned P2DC3              : 1;
    unsigned P2DC4              : 1;
    unsigned P2DC5              : 1;
    unsigned P2DC6              : 1;
    unsigned P2RSEN             : 1;
    };

  struct
    {
    unsigned P2DC               : 7;
    unsigned                    : 1;
    };
  } __PWM2CONbits_t;

extern __at(0x029B) volatile __PWM2CONbits_t PWM2CONbits;

#define _P2DC0                  0x01
#define _P2DC1                  0x02
#define _P2DC2                  0x04
#define _P2DC3                  0x08
#define _P2DC4                  0x10
#define _P2DC5                  0x20
#define _P2DC6                  0x40
#define _P2RSEN                 0x80

//==============================================================================


//==============================================================================
//        CCP2AS Bits

extern __at(0x029C) __sfr CCP2AS;

typedef union
  {
  struct
    {
    unsigned PSS2BD0            : 1;
    unsigned PSS2BD1            : 1;
    unsigned PSS2AC0            : 1;
    unsigned PSS2AC1            : 1;
    unsigned CCP2AS0            : 1;
    unsigned CCP2AS1            : 1;
    unsigned CCP2AS2            : 1;
    unsigned CCP2ASE            : 1;
    };

  struct
    {
    unsigned PSS2BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS2AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CCP2AS             : 3;
    unsigned                    : 1;
    };
  } __CCP2ASbits_t;

extern __at(0x029C) volatile __CCP2ASbits_t CCP2ASbits;

#define _PSS2BD0                0x01
#define _PSS2BD1                0x02
#define _PSS2AC0                0x04
#define _PSS2AC1                0x08
#define _CCP2AS0                0x10
#define _CCP2AS1                0x20
#define _CCP2AS2                0x40
#define _CCP2ASE                0x80

//==============================================================================


//==============================================================================
//        PSTR2CON Bits

extern __at(0x029D) __sfr PSTR2CON;

typedef struct
  {
  unsigned STR2A                : 1;
  unsigned STR2B                : 1;
  unsigned STR2C                : 1;
  unsigned STR2D                : 1;
  unsigned STR2SYNC             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSTR2CONbits_t;

extern __at(0x029D) volatile __PSTR2CONbits_t PSTR2CONbits;

#define _STR2A                  0x01
#define _STR2B                  0x02
#define _STR2C                  0x04
#define _STR2D                  0x08
#define _STR2SYNC               0x10

//==============================================================================


//==============================================================================
//        CCPTMRS Bits

extern __at(0x029E) __sfr CCPTMRS;

typedef union
  {
  struct
    {
    unsigned C1TSEL0            : 1;
    unsigned C1TSEL1            : 1;
    unsigned C2TSEL0            : 1;
    unsigned C2TSEL1            : 1;
    unsigned C3TSEL0            : 1;
    unsigned C3TSEL1            : 1;
    unsigned C4TSEL0            : 1;
    unsigned C4TSEL1            : 1;
    };

  struct
    {
    unsigned C1TSEL             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned C2TSEL             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned C3TSEL             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned C4TSEL             : 2;
    };
  } __CCPTMRSbits_t;

extern __at(0x029E) volatile __CCPTMRSbits_t CCPTMRSbits;

#define _C1TSEL0                0x01
#define _C1TSEL1                0x02
#define _C2TSEL0                0x04
#define _C2TSEL1                0x08
#define _C3TSEL0                0x10
#define _C3TSEL1                0x20
#define _C4TSEL0                0x40
#define _C4TSEL1                0x80

//==============================================================================

extern __at(0x0311) __sfr CCPR3;
extern __at(0x0311) __sfr CCPR3L;
extern __at(0x0312) __sfr CCPR3H;

//==============================================================================
//        CCP3CON Bits

extern __at(0x0313) __sfr CCP3CON;

typedef union
  {
  struct
    {
    unsigned CCP3M0             : 1;
    unsigned CCP3M1             : 1;
    unsigned CCP3M2             : 1;
    unsigned CCP3M3             : 1;
    unsigned DC3B0              : 1;
    unsigned DC3B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP3M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC3B               : 2;
    unsigned                    : 2;
    };
  } __CCP3CONbits_t;

extern __at(0x0313) volatile __CCP3CONbits_t CCP3CONbits;

#define _CCP3M0                 0x01
#define _CCP3M1                 0x02
#define _CCP3M2                 0x04
#define _CCP3M3                 0x08
#define _DC3B0                  0x10
#define _DC3B1                  0x20

//==============================================================================

extern __at(0x0318) __sfr CCPR4;
extern __at(0x0318) __sfr CCPR4L;
extern __at(0x0319) __sfr CCPR4H;

//==============================================================================
//        CCP4CON Bits

extern __at(0x031A) __sfr CCP4CON;

typedef union
  {
  struct
    {
    unsigned CCP4M0             : 1;
    unsigned CCP4M1             : 1;
    unsigned CCP4M2             : 1;
    unsigned CCP4M3             : 1;
    unsigned DC4B0              : 1;
    unsigned DC4B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP4M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC4B               : 2;
    unsigned                    : 2;
    };
  } __CCP4CONbits_t;

extern __at(0x031A) volatile __CCP4CONbits_t CCP4CONbits;

#define _CCP4M0                 0x01
#define _CCP4M1                 0x02
#define _CCP4M2                 0x04
#define _CCP4M3                 0x08
#define _DC4B0                  0x10
#define _DC4B1                  0x20

//==============================================================================


//==============================================================================
//        INLVLA Bits

extern __at(0x038C) __sfr INLVLA;

typedef union
  {
  struct
    {
    unsigned INLVLA0            : 1;
    unsigned INLVLA1            : 1;
    unsigned INLVLA2            : 1;
    unsigned INLVLA3            : 1;
    unsigned INLVLA4            : 1;
    unsigned INLVLA5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INLVLA             : 6;
    unsigned                    : 2;
    };
  } __INLVLAbits_t;

extern __at(0x038C) volatile __INLVLAbits_t INLVLAbits;

#define _INLVLA0                0x01
#define _INLVLA1                0x02
#define _INLVLA2                0x04
#define _INLVLA3                0x08
#define _INLVLA4                0x10
#define _INLVLA5                0x20

//==============================================================================


//==============================================================================
//        INLVLB Bits

extern __at(0x038D) __sfr INLVLB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned INLVLB4              : 1;
  unsigned INLVLB5              : 1;
  unsigned INLVLB6              : 1;
  unsigned INLVLB7              : 1;
  } __INLVLBbits_t;

extern __at(0x038D) volatile __INLVLBbits_t INLVLBbits;

#define _INLVLB4                0x10
#define _INLVLB5                0x20
#define _INLVLB6                0x40
#define _INLVLB7                0x80

//==============================================================================


//==============================================================================
//        INLVLC Bits

extern __at(0x038E) __sfr INLVLC;

typedef struct
  {
  unsigned INLVLC0              : 1;
  unsigned INLVLC1              : 1;
  unsigned INLVLC2              : 1;
  unsigned INLVLC3              : 1;
  unsigned INLVLC4              : 1;
  unsigned INLVLC5              : 1;
  unsigned INLVLC6              : 1;
  unsigned INLVLC7              : 1;
  } __INLVLCbits_t;

extern __at(0x038E) volatile __INLVLCbits_t INLVLCbits;

#define _INLVLC0                0x01
#define _INLVLC1                0x02
#define _INLVLC2                0x04
#define _INLVLC3                0x08
#define _INLVLC4                0x10
#define _INLVLC5                0x20
#define _INLVLC6                0x40
#define _INLVLC7                0x80

//==============================================================================


//==============================================================================
//        IOCAP Bits

extern __at(0x0391) __sfr IOCAP;

typedef union
  {
  struct
    {
    unsigned IOCAP0             : 1;
    unsigned IOCAP1             : 1;
    unsigned IOCAP2             : 1;
    unsigned IOCAP3             : 1;
    unsigned IOCAP4             : 1;
    unsigned IOCAP5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAP              : 6;
    unsigned                    : 2;
    };
  } __IOCAPbits_t;

extern __at(0x0391) volatile __IOCAPbits_t IOCAPbits;

#define _IOCAP0                 0x01
#define _IOCAP1                 0x02
#define _IOCAP2                 0x04
#define _IOCAP3                 0x08
#define _IOCAP4                 0x10
#define _IOCAP5                 0x20

//==============================================================================


//==============================================================================
//        IOCAN Bits

extern __at(0x0392) __sfr IOCAN;

typedef union
  {
  struct
    {
    unsigned IOCAN0             : 1;
    unsigned IOCAN1             : 1;
    unsigned IOCAN2             : 1;
    unsigned IOCAN3             : 1;
    unsigned IOCAN4             : 1;
    unsigned IOCAN5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAN              : 6;
    unsigned                    : 2;
    };
  } __IOCANbits_t;

extern __at(0x0392) volatile __IOCANbits_t IOCANbits;

#define _IOCAN0                 0x01
#define _IOCAN1                 0x02
#define _IOCAN2                 0x04
#define _IOCAN3                 0x08
#define _IOCAN4                 0x10
#define _IOCAN5                 0x20

//==============================================================================


//==============================================================================
//        IOCAF Bits

extern __at(0x0393) __sfr IOCAF;

typedef union
  {
  struct
    {
    unsigned IOCAF0             : 1;
    unsigned IOCAF1             : 1;
    unsigned IOCAF2             : 1;
    unsigned IOCAF3             : 1;
    unsigned IOCAF4             : 1;
    unsigned IOCAF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAF              : 6;
    unsigned                    : 2;
    };
  } __IOCAFbits_t;

extern __at(0x0393) volatile __IOCAFbits_t IOCAFbits;

#define _IOCAF0                 0x01
#define _IOCAF1                 0x02
#define _IOCAF2                 0x04
#define _IOCAF3                 0x08
#define _IOCAF4                 0x10
#define _IOCAF5                 0x20

//==============================================================================


//==============================================================================
//        IOCBP Bits

extern __at(0x0394) __sfr IOCBP;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCBP4               : 1;
  unsigned IOCBP5               : 1;
  unsigned IOCBP6               : 1;
  unsigned IOCBP7               : 1;
  } __IOCBPbits_t;

extern __at(0x0394) volatile __IOCBPbits_t IOCBPbits;

#define _IOCBP4                 0x10
#define _IOCBP5                 0x20
#define _IOCBP6                 0x40
#define _IOCBP7                 0x80

//==============================================================================


//==============================================================================
//        IOCBN Bits

extern __at(0x0395) __sfr IOCBN;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCBN4               : 1;
  unsigned IOCBN5               : 1;
  unsigned IOCBN6               : 1;
  unsigned IOCBN7               : 1;
  } __IOCBNbits_t;

extern __at(0x0395) volatile __IOCBNbits_t IOCBNbits;

#define _IOCBN4                 0x10
#define _IOCBN5                 0x20
#define _IOCBN6                 0x40
#define _IOCBN7                 0x80

//==============================================================================


//==============================================================================
//        IOCBF Bits

extern __at(0x0396) __sfr IOCBF;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCBF4               : 1;
  unsigned IOCBF5               : 1;
  unsigned IOCBF6               : 1;
  unsigned IOCBF7               : 1;
  } __IOCBFbits_t;

extern __at(0x0396) volatile __IOCBFbits_t IOCBFbits;

#define _IOCBF4                 0x10
#define _IOCBF5                 0x20
#define _IOCBF6                 0x40
#define _IOCBF7                 0x80

//==============================================================================


//==============================================================================
//        CLKRCON Bits

extern __at(0x039A) __sfr CLKRCON;

typedef union
  {
  struct
    {
    unsigned CLKRDIV0           : 1;
    unsigned CLKRDIV1           : 1;
    unsigned CLKRDIV2           : 1;
    unsigned CLKRDC0            : 1;
    unsigned CLKRDC1            : 1;
    unsigned CLKRSLR            : 1;
    unsigned CLKROE             : 1;
    unsigned CLKREN             : 1;
    };

  struct
    {
    unsigned CLKRDIV            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned CLKRDC             : 2;
    unsigned                    : 3;
    };
  } __CLKRCONbits_t;

extern __at(0x039A) volatile __CLKRCONbits_t CLKRCONbits;

#define _CLKRDIV0               0x01
#define _CLKRDIV1               0x02
#define _CLKRDIV2               0x04
#define _CLKRDC0                0x08
#define _CLKRDC1                0x10
#define _CLKRSLR                0x20
#define _CLKROE                 0x40
#define _CLKREN                 0x80

//==============================================================================


//==============================================================================
//        MDCON Bits

extern __at(0x039C) __sfr MDCON;

typedef struct
  {
  unsigned MDBIT                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned MDOUT                : 1;
  unsigned MDOPOL               : 1;
  unsigned MDSLR                : 1;
  unsigned MDOE                 : 1;
  unsigned MDEN                 : 1;
  } __MDCONbits_t;

extern __at(0x039C) volatile __MDCONbits_t MDCONbits;

#define _MDBIT                  0x01
#define _MDOUT                  0x08
#define _MDOPOL                 0x10
#define _MDSLR                  0x20
#define _MDOE                   0x40
#define _MDEN                   0x80

//==============================================================================


//==============================================================================
//        MDSRC Bits

extern __at(0x039D) __sfr MDSRC;

typedef union
  {
  struct
    {
    unsigned MDMS0              : 1;
    unsigned MDMS1              : 1;
    unsigned MDMS2              : 1;
    unsigned MDMS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MDMSODIS           : 1;
    };

  struct
    {
    unsigned MDMS               : 4;
    unsigned                    : 4;
    };
  } __MDSRCbits_t;

extern __at(0x039D) volatile __MDSRCbits_t MDSRCbits;

#define _MDMS0                  0x01
#define _MDMS1                  0x02
#define _MDMS2                  0x04
#define _MDMS3                  0x08
#define _MDMSODIS               0x80

//==============================================================================


//==============================================================================
//        MDCARL Bits

extern __at(0x039E) __sfr MDCARL;

typedef union
  {
  struct
    {
    unsigned MDCL0              : 1;
    unsigned MDCL1              : 1;
    unsigned MDCL2              : 1;
    unsigned MDCL3              : 1;
    unsigned                    : 1;
    unsigned MDCLSYNC           : 1;
    unsigned MDCLPOL            : 1;
    unsigned MDCLODIS           : 1;
    };

  struct
    {
    unsigned MDCL               : 4;
    unsigned                    : 4;
    };
  } __MDCARLbits_t;

extern __at(0x039E) volatile __MDCARLbits_t MDCARLbits;

#define _MDCL0                  0x01
#define _MDCL1                  0x02
#define _MDCL2                  0x04
#define _MDCL3                  0x08
#define _MDCLSYNC               0x20
#define _MDCLPOL                0x40
#define _MDCLODIS               0x80

//==============================================================================


//==============================================================================
//        MDCARH Bits

extern __at(0x039F) __sfr MDCARH;

typedef union
  {
  struct
    {
    unsigned MDCH0              : 1;
    unsigned MDCH1              : 1;
    unsigned MDCH2              : 1;
    unsigned MDCH3              : 1;
    unsigned                    : 1;
    unsigned MDCHSYNC           : 1;
    unsigned MDCHPOL            : 1;
    unsigned MDCHODIS           : 1;
    };

  struct
    {
    unsigned MDCH               : 4;
    unsigned                    : 4;
    };
  } __MDCARHbits_t;

extern __at(0x039F) volatile __MDCARHbits_t MDCARHbits;

#define _MDCH0                  0x01
#define _MDCH1                  0x02
#define _MDCH2                  0x04
#define _MDCH3                  0x08
#define _MDCHSYNC               0x20
#define _MDCHPOL                0x40
#define _MDCHODIS               0x80

//==============================================================================

extern __at(0x0415) __sfr TMR4;
extern __at(0x0416) __sfr PR4;

//==============================================================================
//        T4CON Bits

extern __at(0x0417) __sfr T4CON;

typedef union
  {
  struct
    {
    unsigned T4CKPS0            : 1;
    unsigned T4CKPS1            : 1;
    unsigned TMR4ON             : 1;
    unsigned T4OUTPS0           : 1;
    unsigned T4OUTPS1           : 1;
    unsigned T4OUTPS2           : 1;
    unsigned T4OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T4OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T4CONbits_t;

extern __at(0x0417) volatile __T4CONbits_t T4CONbits;

#define _T4CKPS0                0x01
#define _T4CKPS1                0x02
#define _TMR4ON                 0x04
#define _T4OUTPS0               0x08
#define _T4OUTPS1               0x10
#define _T4OUTPS2               0x20
#define _T4OUTPS3               0x40

//==============================================================================

extern __at(0x041C) __sfr TMR6;
extern __at(0x041D) __sfr PR6;

//==============================================================================
//        T6CON Bits

extern __at(0x041E) __sfr T6CON;

typedef union
  {
  struct
    {
    unsigned T6CKPS0            : 1;
    unsigned T6CKPS1            : 1;
    unsigned TMR6ON             : 1;
    unsigned T6OUTPS0           : 1;
    unsigned T6OUTPS1           : 1;
    unsigned T6OUTPS2           : 1;
    unsigned T6OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T6OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T6CONbits_t;

extern __at(0x041E) volatile __T6CONbits_t T6CONbits;

#define _T6CKPS0                0x01
#define _T6CKPS1                0x02
#define _TMR6ON                 0x04
#define _T6OUTPS0               0x08
#define _T6OUTPS1               0x10
#define _T6OUTPS2               0x20
#define _T6OUTPS3               0x40

//==============================================================================


//==============================================================================
//        STATUS_SHAD Bits

extern __at(0x0FE4) __sfr STATUS_SHAD;

typedef struct
  {
  unsigned C_SHAD               : 1;
  unsigned DC_SHAD              : 1;
  unsigned Z_SHAD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUS_SHADbits_t;

extern __at(0x0FE4) volatile __STATUS_SHADbits_t STATUS_SHADbits;

#define _C_SHAD                 0x01
#define _DC_SHAD                0x02
#define _Z_SHAD                 0x04

//==============================================================================

extern __at(0x0FE5) __sfr WREG_SHAD;
extern __at(0x0FE6) __sfr BSR_SHAD;
extern __at(0x0FE7) __sfr PCLATH_SHAD;
extern __at(0x0FE8) __sfr FSR0L_SHAD;
extern __at(0x0FE9) __sfr FSR0H_SHAD;
extern __at(0x0FEA) __sfr FSR1L_SHAD;
extern __at(0x0FEB) __sfr FSR1H_SHAD;
extern __at(0x0FED) __sfr STKPTR;
extern __at(0x0FEE) __sfr TOSL;
extern __at(0x0FEF) __sfr TOSH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x8007
#define _CONFIG2                0x8008

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_LP                0xFFF8  // LP Oscillator, Low-power crystal connected between OSC1 and OSC2 pins.
#define _FOSC_XT                0xFFF9  // XT Oscillator, Crystal/resonator connected between OSC1 and OSC2 pins.
#define _FOSC_HS                0xFFFA  // HS Oscillator, High-speed crystal/resonator connected between OSC1 and OSC2 pins.
#define _FOSC_EXTRC             0xFFFB  // EXTRC oscillator: External RC circuit connected to CLKIN pin.
#define _FOSC_INTOSC            0xFFFC  // INTOSC oscillator: I/O function on CLKIN pin.
#define _FOSC_ECL               0xFFFD  // ECL, External Clock, Low Power Mode (0-0.5 MHz): device clock supplied to CLKIN pin.
#define _FOSC_ECM               0xFFFE  // ECM, External Clock, Medium Power Mode (0.5-4 MHz): device clock supplied to CLKIN pin.
#define _FOSC_ECH               0xFFFF  // ECH, External Clock, High Power Mode (4-32 MHz): device clock supplied to CLKIN pin.
#define _WDTE_OFF               0xFFE7  // WDT disabled.
#define _WDTE_SWDTEN            0xFFEF  // WDT controlled by the SWDTEN bit in the WDTCON register.
#define _WDTE_NSLEEP            0xFFF7  // WDT enabled while running and disabled in Sleep.
#define _WDTE_ON                0xFFFF  // WDT enabled.
#define _PWRTE_ON               0xFFDF  // PWRT enabled.
#define _PWRTE_OFF              0xFFFF  // PWRT disabled.
#define _MCLRE_OFF              0xFFBF  // MCLR/VPP pin function is digital input.
#define _MCLRE_ON               0xFFFF  // MCLR/VPP pin function is MCLR.
#define _CP_ON                  0xFF7F  // Program memory code protection is enabled.
#define _CP_OFF                 0xFFFF  // Program memory code protection is disabled.
#define _CPD_ON                 0xFEFF  // Data memory code protection is enabled.
#define _CPD_OFF                0xFFFF  // Data memory code protection is disabled.
#define _BOREN_OFF              0xF9FF  // Brown-out Reset disabled.
#define _BOREN_SBODEN           0xFBFF  // Brown-out Reset controlled by the SBOREN bit in the BORCON register.
#define _BOREN_NSLEEP           0xFDFF  // Brown-out Reset enabled while running and disabled in Sleep.
#define _BOREN_ON               0xFFFF  // Brown-out Reset enabled.
#define _CLKOUTEN_ON            0xF7FF  // CLKOUT function is enabled on the CLKOUT pin.
#define _CLKOUTEN_OFF           0xFFFF  // CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin.
#define _IESO_OFF               0xEFFF  // Internal/External Switchover mode is disabled.
#define _IESO_ON                0xFFFF  // Internal/External Switchover mode is enabled.
#define _FCMEN_OFF              0xDFFF  // Fail-Safe Clock Monitor is disabled.
#define _FCMEN_ON               0xFFFF  // Fail-Safe Clock Monitor is enabled.

//----------------------------- CONFIG2 Options -------------------------------

#define _WRT_ALL                0xFFFC  // 000h to 1FFFh write protected, no addresses may be modified by EECON control.
#define _WRT_HALF               0xFFFD  // 000h to FFFh write protected, 1000h to 1FFFh may be modified by EECON control.
#define _WRT_BOOT               0xFFFE  // 000h to 1FFh write protected, 200h to 1FFFh may be modified by EECON control.
#define _WRT_OFF                0xFFFF  // Write protection off.
#define _PLLEN_OFF              0xFEFF  // 4x PLL disabled.
#define _PLLEN_ON               0xFFFF  // 4x PLL enabled.
#define _STVREN_OFF             0xFDFF  // Stack Overflow or Underflow will not cause a Reset.
#define _STVREN_ON              0xFFFF  // Stack Overflow or Underflow will cause a Reset.
#define _BORV_HI                0xFBFF  // Brown-out Reset Voltage (Vbor), high trip point selected.
#define _BORV_LO                0xFFFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _BORV_19                0xFFFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _LVP_OFF                0xDFFF  // High-voltage on MCLR/VPP must be used for programming.
#define _LVP_ON                 0xFFFF  // Low-voltage programming enabled.

//==============================================================================

#define _DEVID1                 0x8006

#define _IDLOC0                 0x8000
#define _IDLOC1                 0x8001
#define _IDLOC2                 0x8002
#define _IDLOC3                 0x8003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 1, shadows bit in ADCON0bits
#define ADGO                    ADCON0bits.ADGO                 // bit 1, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 1, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 2
#define CHS1                    ADCON0bits.CHS1                 // bit 3
#define CHS2                    ADCON0bits.CHS2                 // bit 4
#define CHS3                    ADCON0bits.CHS3                 // bit 5
#define CHS4                    ADCON0bits.CHS4                 // bit 6

#define ADPREF0                 ADCON1bits.ADPREF0              // bit 0
#define ADPREF1                 ADCON1bits.ADPREF1              // bit 1
#define ADNREF                  ADCON1bits.ADNREF               // bit 2
#define ADCS0                   ADCON1bits.ADCS0                // bit 4
#define ADCS1                   ADCON1bits.ADCS1                // bit 5
#define ADCS2                   ADCON1bits.ADCS2                // bit 6
#define ADFM                    ADCON1bits.ADFM                 // bit 7

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA4                   ANSELAbits.ANSA4                // bit 4

#define ANSB4                   ANSELBbits.ANSB4                // bit 4
#define ANSB5                   ANSELBbits.ANSB5                // bit 5
#define ANSB6                   ANSELBbits.ANSB6                // bit 6
#define ANSB7                   ANSELBbits.ANSB7                // bit 7

#define ANSC0                   ANSELCbits.ANSC0                // bit 0
#define ANSC1                   ANSELCbits.ANSC1                // bit 1
#define ANSC2                   ANSELCbits.ANSC2                // bit 2
#define ANSC3                   ANSELCbits.ANSC3                // bit 3
#define ANSC6                   ANSELCbits.ANSC6                // bit 6
#define ANSC7                   ANSELCbits.ANSC7                // bit 7

#define TXCKSEL                 APFCON0bits.TXCKSEL             // bit 2
#define T1GSEL                  APFCON0bits.T1GSEL              // bit 3
#define RXDTSEL                 APFCON0bits.RXDTSEL             // bit 7

#define CCP2SEL                 APFCON1bits.CCP2SEL             // bit 0
#define P2BSEL                  APFCON1bits.P2BSEL              // bit 1
#define P1CSEL                  APFCON1bits.P1CSEL              // bit 2
#define P1DSEL                  APFCON1bits.P1DSEL              // bit 3
#define SS2SEL                  APFCON1bits.SS2SEL              // bit 4
#define SDO2SEL                 APFCON1bits.SDO2SEL             // bit 5

#define ABDEN                   BAUDCONbits.ABDEN               // bit 0
#define WUE                     BAUDCONbits.WUE                 // bit 1
#define BRG16                   BAUDCONbits.BRG16               // bit 3
#define SCKP                    BAUDCONbits.SCKP                // bit 4
#define RCIDL                   BAUDCONbits.RCIDL               // bit 6
#define ABDOVF                  BAUDCONbits.ABDOVF              // bit 7

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define BSR0                    BSRbits.BSR0                    // bit 0
#define BSR1                    BSRbits.BSR1                    // bit 1
#define BSR2                    BSRbits.BSR2                    // bit 2
#define BSR3                    BSRbits.BSR3                    // bit 3
#define BSR4                    BSRbits.BSR4                    // bit 4

#define PSS1BD0                 CCP1ASbits.PSS1BD0              // bit 0
#define PSS1BD1                 CCP1ASbits.PSS1BD1              // bit 1
#define PSS1AC0                 CCP1ASbits.PSS1AC0              // bit 2
#define PSS1AC1                 CCP1ASbits.PSS1AC1              // bit 3
#define CCP1AS0                 CCP1ASbits.CCP1AS0              // bit 4
#define CCP1AS1                 CCP1ASbits.CCP1AS1              // bit 5
#define CCP1AS2                 CCP1ASbits.CCP1AS2              // bit 6
#define CCP1ASE                 CCP1ASbits.CCP1ASE              // bit 7

#define CCP1M0                  CCP1CONbits.CCP1M0              // bit 0
#define CCP1M1                  CCP1CONbits.CCP1M1              // bit 1
#define CCP1M2                  CCP1CONbits.CCP1M2              // bit 2
#define CCP1M3                  CCP1CONbits.CCP1M3              // bit 3
#define DC1B0                   CCP1CONbits.DC1B0               // bit 4
#define DC1B1                   CCP1CONbits.DC1B1               // bit 5
#define P1M0                    CCP1CONbits.P1M0                // bit 6
#define P1M1                    CCP1CONbits.P1M1                // bit 7

#define PSS2BD0                 CCP2ASbits.PSS2BD0              // bit 0
#define PSS2BD1                 CCP2ASbits.PSS2BD1              // bit 1
#define PSS2AC0                 CCP2ASbits.PSS2AC0              // bit 2
#define PSS2AC1                 CCP2ASbits.PSS2AC1              // bit 3
#define CCP2AS0                 CCP2ASbits.CCP2AS0              // bit 4
#define CCP2AS1                 CCP2ASbits.CCP2AS1              // bit 5
#define CCP2AS2                 CCP2ASbits.CCP2AS2              // bit 6
#define CCP2ASE                 CCP2ASbits.CCP2ASE              // bit 7

#define CCP2M0                  CCP2CONbits.CCP2M0              // bit 0
#define CCP2M1                  CCP2CONbits.CCP2M1              // bit 1
#define CCP2M2                  CCP2CONbits.CCP2M2              // bit 2
#define CCP2M3                  CCP2CONbits.CCP2M3              // bit 3
#define DC2B0                   CCP2CONbits.DC2B0               // bit 4
#define DC2B1                   CCP2CONbits.DC2B1               // bit 5
#define P2M0                    CCP2CONbits.P2M0                // bit 6
#define P2M1                    CCP2CONbits.P2M1                // bit 7

#define CCP3M0                  CCP3CONbits.CCP3M0              // bit 0
#define CCP3M1                  CCP3CONbits.CCP3M1              // bit 1
#define CCP3M2                  CCP3CONbits.CCP3M2              // bit 2
#define CCP3M3                  CCP3CONbits.CCP3M3              // bit 3
#define DC3B0                   CCP3CONbits.DC3B0               // bit 4
#define DC3B1                   CCP3CONbits.DC3B1               // bit 5

#define CCP4M0                  CCP4CONbits.CCP4M0              // bit 0
#define CCP4M1                  CCP4CONbits.CCP4M1              // bit 1
#define CCP4M2                  CCP4CONbits.CCP4M2              // bit 2
#define CCP4M3                  CCP4CONbits.CCP4M3              // bit 3
#define DC4B0                   CCP4CONbits.DC4B0               // bit 4
#define DC4B1                   CCP4CONbits.DC4B1               // bit 5

#define C1TSEL0                 CCPTMRSbits.C1TSEL0             // bit 0
#define C1TSEL1                 CCPTMRSbits.C1TSEL1             // bit 1
#define C2TSEL0                 CCPTMRSbits.C2TSEL0             // bit 2
#define C2TSEL1                 CCPTMRSbits.C2TSEL1             // bit 3
#define C3TSEL0                 CCPTMRSbits.C3TSEL0             // bit 4
#define C3TSEL1                 CCPTMRSbits.C3TSEL1             // bit 5
#define C4TSEL0                 CCPTMRSbits.C4TSEL0             // bit 6
#define C4TSEL1                 CCPTMRSbits.C4TSEL1             // bit 7

#define CLKRDIV0                CLKRCONbits.CLKRDIV0            // bit 0
#define CLKRDIV1                CLKRCONbits.CLKRDIV1            // bit 1
#define CLKRDIV2                CLKRCONbits.CLKRDIV2            // bit 2
#define CLKRDC0                 CLKRCONbits.CLKRDC0             // bit 3
#define CLKRDC1                 CLKRCONbits.CLKRDC1             // bit 4
#define CLKRSLR                 CLKRCONbits.CLKRSLR             // bit 5
#define CLKROE                  CLKRCONbits.CLKROE              // bit 6
#define CLKREN                  CLKRCONbits.CLKREN              // bit 7

#define C1SYNC                  CM1CON0bits.C1SYNC              // bit 0
#define C1HYS                   CM1CON0bits.C1HYS               // bit 1
#define C1SP                    CM1CON0bits.C1SP                // bit 2
#define C1POL                   CM1CON0bits.C1POL               // bit 4
#define C1OE                    CM1CON0bits.C1OE                // bit 5
#define C1OUT                   CM1CON0bits.C1OUT               // bit 6
#define C1ON                    CM1CON0bits.C1ON                // bit 7

#define C1NCH0                  CM1CON1bits.C1NCH0              // bit 0
#define C1NCH1                  CM1CON1bits.C1NCH1              // bit 1
#define C1PCH0                  CM1CON1bits.C1PCH0              // bit 4
#define C1PCH1                  CM1CON1bits.C1PCH1              // bit 5
#define C1INTN                  CM1CON1bits.C1INTN              // bit 6
#define C1INTP                  CM1CON1bits.C1INTP              // bit 7

#define C2SYNC                  CM2CON0bits.C2SYNC              // bit 0
#define C2HYS                   CM2CON0bits.C2HYS               // bit 1
#define C2SP                    CM2CON0bits.C2SP                // bit 2
#define C2POL                   CM2CON0bits.C2POL               // bit 4
#define C2OE                    CM2CON0bits.C2OE                // bit 5
#define C2OUT                   CM2CON0bits.C2OUT               // bit 6
#define C2ON                    CM2CON0bits.C2ON                // bit 7

#define C2NCH0                  CM2CON1bits.C2NCH0              // bit 0
#define C2NCH1                  CM2CON1bits.C2NCH1              // bit 1
#define C2PCH0                  CM2CON1bits.C2PCH0              // bit 4
#define C2PCH1                  CM2CON1bits.C2PCH1              // bit 5
#define C2INTN                  CM2CON1bits.C2INTN              // bit 6
#define C2INTP                  CM2CON1bits.C2INTP              // bit 7

#define MC1OUT                  CMOUTbits.MC1OUT                // bit 0
#define MC2OUT                  CMOUTbits.MC2OUT                // bit 1

#define T0XCS                   CPSCON0bits.T0XCS               // bit 0
#define CPSOUT                  CPSCON0bits.CPSOUT              // bit 1
#define CPSRNG0                 CPSCON0bits.CPSRNG0             // bit 2
#define CPSRNG1                 CPSCON0bits.CPSRNG1             // bit 3
#define CPSRM                   CPSCON0bits.CPSRM               // bit 6
#define CPSON                   CPSCON0bits.CPSON               // bit 7

#define CPSCH0                  CPSCON1bits.CPSCH0              // bit 0
#define CPSCH1                  CPSCON1bits.CPSCH1              // bit 1
#define CPSCH2                  CPSCON1bits.CPSCH2              // bit 2
#define CPSCH3                  CPSCON1bits.CPSCH3              // bit 3

#define DACNSS                  DACCON0bits.DACNSS              // bit 0
#define DACPSS0                 DACCON0bits.DACPSS0             // bit 2
#define DACPSS1                 DACCON0bits.DACPSS1             // bit 3
#define DACOE                   DACCON0bits.DACOE               // bit 5
#define DACLPS                  DACCON0bits.DACLPS              // bit 6
#define DACEN                   DACCON0bits.DACEN               // bit 7

#define DACR0                   DACCON1bits.DACR0               // bit 0
#define DACR1                   DACCON1bits.DACR1               // bit 1
#define DACR2                   DACCON1bits.DACR2               // bit 2
#define DACR3                   DACCON1bits.DACR3               // bit 3
#define DACR4                   DACCON1bits.DACR4               // bit 4

#define RD                      EECON1bits.RD                   // bit 0
#define WR                      EECON1bits.WR                   // bit 1
#define WREN                    EECON1bits.WREN                 // bit 2
#define WRERR                   EECON1bits.WRERR                // bit 3
#define FREE                    EECON1bits.FREE                 // bit 4
#define LWLO                    EECON1bits.LWLO                 // bit 5
#define CFGS                    EECON1bits.CFGS                 // bit 6
#define EEPGD                   EECON1bits.EEPGD                // bit 7

#define ADFVR0                  FVRCONbits.ADFVR0               // bit 0
#define ADFVR1                  FVRCONbits.ADFVR1               // bit 1
#define CDAFVR0                 FVRCONbits.CDAFVR0              // bit 2
#define CDAFVR1                 FVRCONbits.CDAFVR1              // bit 3
#define TSRNG                   FVRCONbits.TSRNG                // bit 4
#define TSEN                    FVRCONbits.TSEN                 // bit 5
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define INLVLA0                 INLVLAbits.INLVLA0              // bit 0
#define INLVLA1                 INLVLAbits.INLVLA1              // bit 1
#define INLVLA2                 INLVLAbits.INLVLA2              // bit 2
#define INLVLA3                 INLVLAbits.INLVLA3              // bit 3
#define INLVLA4                 INLVLAbits.INLVLA4              // bit 4
#define INLVLA5                 INLVLAbits.INLVLA5              // bit 5

#define INLVLB4                 INLVLBbits.INLVLB4              // bit 4
#define INLVLB5                 INLVLBbits.INLVLB5              // bit 5
#define INLVLB6                 INLVLBbits.INLVLB6              // bit 6
#define INLVLB7                 INLVLBbits.INLVLB7              // bit 7

#define INLVLC0                 INLVLCbits.INLVLC0              // bit 0
#define INLVLC1                 INLVLCbits.INLVLC1              // bit 1
#define INLVLC2                 INLVLCbits.INLVLC2              // bit 2
#define INLVLC3                 INLVLCbits.INLVLC3              // bit 3
#define INLVLC4                 INLVLCbits.INLVLC4              // bit 4
#define INLVLC5                 INLVLCbits.INLVLC5              // bit 5
#define INLVLC6                 INLVLCbits.INLVLC6              // bit 6
#define INLVLC7                 INLVLCbits.INLVLC7              // bit 7

#define IOCIF                   INTCONbits.IOCIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define IOCIE                   INTCONbits.IOCIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCAF0                  IOCAFbits.IOCAF0                // bit 0
#define IOCAF1                  IOCAFbits.IOCAF1                // bit 1
#define IOCAF2                  IOCAFbits.IOCAF2                // bit 2
#define IOCAF3                  IOCAFbits.IOCAF3                // bit 3
#define IOCAF4                  IOCAFbits.IOCAF4                // bit 4
#define IOCAF5                  IOCAFbits.IOCAF5                // bit 5

#define IOCAN0                  IOCANbits.IOCAN0                // bit 0
#define IOCAN1                  IOCANbits.IOCAN1                // bit 1
#define IOCAN2                  IOCANbits.IOCAN2                // bit 2
#define IOCAN3                  IOCANbits.IOCAN3                // bit 3
#define IOCAN4                  IOCANbits.IOCAN4                // bit 4
#define IOCAN5                  IOCANbits.IOCAN5                // bit 5

#define IOCAP0                  IOCAPbits.IOCAP0                // bit 0
#define IOCAP1                  IOCAPbits.IOCAP1                // bit 1
#define IOCAP2                  IOCAPbits.IOCAP2                // bit 2
#define IOCAP3                  IOCAPbits.IOCAP3                // bit 3
#define IOCAP4                  IOCAPbits.IOCAP4                // bit 4
#define IOCAP5                  IOCAPbits.IOCAP5                // bit 5

#define IOCBF4                  IOCBFbits.IOCBF4                // bit 4
#define IOCBF5                  IOCBFbits.IOCBF5                // bit 5
#define IOCBF6                  IOCBFbits.IOCBF6                // bit 6
#define IOCBF7                  IOCBFbits.IOCBF7                // bit 7

#define IOCBN4                  IOCBNbits.IOCBN4                // bit 4
#define IOCBN5                  IOCBNbits.IOCBN5                // bit 5
#define IOCBN6                  IOCBNbits.IOCBN6                // bit 6
#define IOCBN7                  IOCBNbits.IOCBN7                // bit 7

#define IOCBP4                  IOCBPbits.IOCBP4                // bit 4
#define IOCBP5                  IOCBPbits.IOCBP5                // bit 5
#define IOCBP6                  IOCBPbits.IOCBP6                // bit 6
#define IOCBP7                  IOCBPbits.IOCBP7                // bit 7

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2
#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5

#define LATB4                   LATBbits.LATB4                  // bit 4
#define LATB5                   LATBbits.LATB5                  // bit 5
#define LATB6                   LATBbits.LATB6                  // bit 6
#define LATB7                   LATBbits.LATB7                  // bit 7

#define LATC0                   LATCbits.LATC0                  // bit 0
#define LATC1                   LATCbits.LATC1                  // bit 1
#define LATC2                   LATCbits.LATC2                  // bit 2
#define LATC3                   LATCbits.LATC3                  // bit 3
#define LATC4                   LATCbits.LATC4                  // bit 4
#define LATC5                   LATCbits.LATC5                  // bit 5
#define LATC6                   LATCbits.LATC6                  // bit 6
#define LATC7                   LATCbits.LATC7                  // bit 7

#define MDCH0                   MDCARHbits.MDCH0                // bit 0
#define MDCH1                   MDCARHbits.MDCH1                // bit 1
#define MDCH2                   MDCARHbits.MDCH2                // bit 2
#define MDCH3                   MDCARHbits.MDCH3                // bit 3
#define MDCHSYNC                MDCARHbits.MDCHSYNC             // bit 5
#define MDCHPOL                 MDCARHbits.MDCHPOL              // bit 6
#define MDCHODIS                MDCARHbits.MDCHODIS             // bit 7

#define MDCL0                   MDCARLbits.MDCL0                // bit 0
#define MDCL1                   MDCARLbits.MDCL1                // bit 1
#define MDCL2                   MDCARLbits.MDCL2                // bit 2
#define MDCL3                   MDCARLbits.MDCL3                // bit 3
#define MDCLSYNC                MDCARLbits.MDCLSYNC             // bit 5
#define MDCLPOL                 MDCARLbits.MDCLPOL              // bit 6
#define MDCLODIS                MDCARLbits.MDCLODIS             // bit 7

#define MDBIT                   MDCONbits.MDBIT                 // bit 0
#define MDOUT                   MDCONbits.MDOUT                 // bit 3
#define MDOPOL                  MDCONbits.MDOPOL                // bit 4
#define MDSLR                   MDCONbits.MDSLR                 // bit 5
#define MDOE                    MDCONbits.MDOE                  // bit 6
#define MDEN                    MDCONbits.MDEN                  // bit 7

#define MDMS0                   MDSRCbits.MDMS0                 // bit 0
#define MDMS1                   MDSRCbits.MDMS1                 // bit 1
#define MDMS2                   MDSRCbits.MDMS2                 // bit 2
#define MDMS3                   MDSRCbits.MDMS3                 // bit 3
#define MDMSODIS                MDSRCbits.MDMSODIS              // bit 7

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define TMR0SE                  OPTION_REGbits.TMR0SE           // bit 4, shadows bit in OPTION_REGbits
#define T0SE                    OPTION_REGbits.T0SE             // bit 4, shadows bit in OPTION_REGbits
#define TMR0CS                  OPTION_REGbits.TMR0CS           // bit 5, shadows bit in OPTION_REGbits
#define T0CS                    OPTION_REGbits.T0CS             // bit 5, shadows bit in OPTION_REGbits
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_WPUEN               OPTION_REGbits.NOT_WPUEN        // bit 7

#define SCS0                    OSCCONbits.SCS0                 // bit 0
#define SCS1                    OSCCONbits.SCS1                 // bit 1
#define IRCF0                   OSCCONbits.IRCF0                // bit 3
#define IRCF1                   OSCCONbits.IRCF1                // bit 4
#define IRCF2                   OSCCONbits.IRCF2                // bit 5
#define IRCF3                   OSCCONbits.IRCF3                // bit 6
#define SPLLEN                  OSCCONbits.SPLLEN               // bit 7

#define HFIOFS                  OSCSTATbits.HFIOFS              // bit 0
#define LFIOFR                  OSCSTATbits.LFIOFR              // bit 1
#define MFIOFR                  OSCSTATbits.MFIOFR              // bit 2
#define HFIOFL                  OSCSTATbits.HFIOFL              // bit 3
#define HFIOFR                  OSCSTATbits.HFIOFR              // bit 4
#define OSTS                    OSCSTATbits.OSTS                // bit 5
#define PLLR                    OSCSTATbits.PLLR                // bit 6
#define T1OSCR                  OSCSTATbits.T1OSCR              // bit 7

#define TUN0                    OSCTUNEbits.TUN0                // bit 0
#define TUN1                    OSCTUNEbits.TUN1                // bit 1
#define TUN2                    OSCTUNEbits.TUN2                // bit 2
#define TUN3                    OSCTUNEbits.TUN3                // bit 3
#define TUN4                    OSCTUNEbits.TUN4                // bit 4
#define TUN5                    OSCTUNEbits.TUN5                // bit 5

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define NOT_RI                  PCONbits.NOT_RI                 // bit 2
#define NOT_RMCLR               PCONbits.NOT_RMCLR              // bit 3
#define STKUNF                  PCONbits.STKUNF                 // bit 6
#define STKOVF                  PCONbits.STKOVF                 // bit 7

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define CCP1IE                  PIE1bits.CCP1IE                 // bit 2
#define SSP1IE                  PIE1bits.SSP1IE                 // bit 3
#define TXIE                    PIE1bits.TXIE                   // bit 4
#define RCIE                    PIE1bits.RCIE                   // bit 5
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define CCP2IE                  PIE2bits.CCP2IE                 // bit 0
#define BCL1IE                  PIE2bits.BCL1IE                 // bit 3
#define EEIE                    PIE2bits.EEIE                   // bit 4
#define C1IE                    PIE2bits.C1IE                   // bit 5
#define C2IE                    PIE2bits.C2IE                   // bit 6
#define OSFIE                   PIE2bits.OSFIE                  // bit 7

#define TMR4IE                  PIE3bits.TMR4IE                 // bit 1
#define TMR6IE                  PIE3bits.TMR6IE                 // bit 3
#define CCP3IE                  PIE3bits.CCP3IE                 // bit 4
#define CCP4IE                  PIE3bits.CCP4IE                 // bit 5

#define SSP2IE                  PIE4bits.SSP2IE                 // bit 0
#define BCL2IE                  PIE4bits.BCL2IE                 // bit 1

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define CCP1IF                  PIR1bits.CCP1IF                 // bit 2
#define SSP1IF                  PIR1bits.SSP1IF                 // bit 3
#define TXIF                    PIR1bits.TXIF                   // bit 4
#define RCIF                    PIR1bits.RCIF                   // bit 5
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define CCP2IF                  PIR2bits.CCP2IF                 // bit 0
#define BCL1IF                  PIR2bits.BCL1IF                 // bit 3
#define EEIF                    PIR2bits.EEIF                   // bit 4
#define C1IF                    PIR2bits.C1IF                   // bit 5
#define C2IF                    PIR2bits.C2IF                   // bit 6
#define OSFIF                   PIR2bits.OSFIF                  // bit 7

#define TMR4IF                  PIR3bits.TMR4IF                 // bit 1
#define TMR6IF                  PIR3bits.TMR6IF                 // bit 3
#define CCP3IF                  PIR3bits.CCP3IF                 // bit 4
#define CCP4IF                  PIR3bits.CCP4IF                 // bit 5

#define SSP2IF                  PIR4bits.SSP2IF                 // bit 0
#define BCL2IF                  PIR4bits.BCL2IF                 // bit 1

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5

#define RB4                     PORTBbits.RB4                   // bit 4
#define RB5                     PORTBbits.RB5                   // bit 5
#define RB6                     PORTBbits.RB6                   // bit 6
#define RB7                     PORTBbits.RB7                   // bit 7

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5
#define RC6                     PORTCbits.RC6                   // bit 6
#define RC7                     PORTCbits.RC7                   // bit 7

#define STR1A                   PSTR1CONbits.STR1A              // bit 0
#define STR1B                   PSTR1CONbits.STR1B              // bit 1
#define STR1C                   PSTR1CONbits.STR1C              // bit 2
#define STR1D                   PSTR1CONbits.STR1D              // bit 3
#define STR1SYNC                PSTR1CONbits.STR1SYNC           // bit 4

#define STR2A                   PSTR2CONbits.STR2A              // bit 0
#define STR2B                   PSTR2CONbits.STR2B              // bit 1
#define STR2C                   PSTR2CONbits.STR2C              // bit 2
#define STR2D                   PSTR2CONbits.STR2D              // bit 3
#define STR2SYNC                PSTR2CONbits.STR2SYNC           // bit 4

#define P1DC0                   PWM1CONbits.P1DC0               // bit 0
#define P1DC1                   PWM1CONbits.P1DC1               // bit 1
#define P1DC2                   PWM1CONbits.P1DC2               // bit 2
#define P1DC3                   PWM1CONbits.P1DC3               // bit 3
#define P1DC4                   PWM1CONbits.P1DC4               // bit 4
#define P1DC5                   PWM1CONbits.P1DC5               // bit 5
#define P1DC6                   PWM1CONbits.P1DC6               // bit 6
#define P1RSEN                  PWM1CONbits.P1RSEN              // bit 7

#define P2DC0                   PWM2CONbits.P2DC0               // bit 0
#define P2DC1                   PWM2CONbits.P2DC1               // bit 1
#define P2DC2                   PWM2CONbits.P2DC2               // bit 2
#define P2DC3                   PWM2CONbits.P2DC3               // bit 3
#define P2DC4                   PWM2CONbits.P2DC4               // bit 4
#define P2DC5                   PWM2CONbits.P2DC5               // bit 5
#define P2DC6                   PWM2CONbits.P2DC6               // bit 6
#define P2RSEN                  PWM2CONbits.P2RSEN              // bit 7

#define RX9D                    RCSTAbits.RX9D                  // bit 0
#define OERR                    RCSTAbits.OERR                  // bit 1
#define FERR                    RCSTAbits.FERR                  // bit 2
#define ADDEN                   RCSTAbits.ADDEN                 // bit 3
#define CREN                    RCSTAbits.CREN                  // bit 4
#define SREN                    RCSTAbits.SREN                  // bit 5
#define RX9                     RCSTAbits.RX9                   // bit 6
#define SPEN                    RCSTAbits.SPEN                  // bit 7

#define SRPR                    SRCON0bits.SRPR                 // bit 0
#define SRPS                    SRCON0bits.SRPS                 // bit 1
#define SRNQEN                  SRCON0bits.SRNQEN               // bit 2
#define SRQEN                   SRCON0bits.SRQEN                // bit 3
#define SRCLK0                  SRCON0bits.SRCLK0               // bit 4
#define SRCLK1                  SRCON0bits.SRCLK1               // bit 5
#define SRCLK2                  SRCON0bits.SRCLK2               // bit 6
#define SRLEN                   SRCON0bits.SRLEN                // bit 7

#define SRRC1E                  SRCON1bits.SRRC1E               // bit 0
#define SRRC2E                  SRCON1bits.SRRC2E               // bit 1
#define SRRCKE                  SRCON1bits.SRRCKE               // bit 2
#define SRRPE                   SRCON1bits.SRRPE                // bit 3
#define SRSC1E                  SRCON1bits.SRSC1E               // bit 4
#define SRSC2E                  SRCON1bits.SRSC2E               // bit 5
#define SRSCKE                  SRCON1bits.SRSCKE               // bit 6
#define SRSPE                   SRCON1bits.SRSPE                // bit 7

#define SSPM0                   SSP1CON1bits.SSPM0              // bit 0
#define SSPM1                   SSP1CON1bits.SSPM1              // bit 1
#define SSPM2                   SSP1CON1bits.SSPM2              // bit 2
#define SSPM3                   SSP1CON1bits.SSPM3              // bit 3
#define CKP                     SSP1CON1bits.CKP                // bit 4
#define SSPEN                   SSP1CON1bits.SSPEN              // bit 5
#define SSPOV                   SSP1CON1bits.SSPOV              // bit 6
#define WCOL                    SSP1CON1bits.WCOL               // bit 7

#define SEN                     SSP1CON2bits.SEN                // bit 0
#define RSEN                    SSP1CON2bits.RSEN               // bit 1
#define PEN                     SSP1CON2bits.PEN                // bit 2
#define RCEN                    SSP1CON2bits.RCEN               // bit 3
#define ACKEN                   SSP1CON2bits.ACKEN              // bit 4
#define ACKDT                   SSP1CON2bits.ACKDT              // bit 5
#define ACKSTAT                 SSP1CON2bits.ACKSTAT            // bit 6
#define GCEN                    SSP1CON2bits.GCEN               // bit 7

#define DHEN                    SSP1CON3bits.DHEN               // bit 0
#define AHEN                    SSP1CON3bits.AHEN               // bit 1
#define SBCDE                   SSP1CON3bits.SBCDE              // bit 2
#define SDAHT                   SSP1CON3bits.SDAHT              // bit 3
#define BOEN                    SSP1CON3bits.BOEN               // bit 4
#define SCIE                    SSP1CON3bits.SCIE               // bit 5
#define PCIE                    SSP1CON3bits.PCIE               // bit 6
#define ACKTIM                  SSP1CON3bits.ACKTIM             // bit 7

#define BF                      SSP1STATbits.BF                 // bit 0
#define UA                      SSP1STATbits.UA                 // bit 1
#define R_NOT_W                 SSP1STATbits.R_NOT_W            // bit 2
#define S                       SSP1STATbits.S                  // bit 3
#define P                       SSP1STATbits.P                  // bit 4
#define D_NOT_A                 SSP1STATbits.D_NOT_A            // bit 5
#define CKE                     SSP1STATbits.CKE                // bit 6
#define SMP                     SSP1STATbits.SMP                // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4

#define C_SHAD                  STATUS_SHADbits.C_SHAD          // bit 0
#define DC_SHAD                 STATUS_SHADbits.DC_SHAD         // bit 1
#define Z_SHAD                  STATUS_SHADbits.Z_SHAD          // bit 2

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2
#define T1OSCEN                 T1CONbits.T1OSCEN               // bit 3
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1CS0                 T1CONbits.TMR1CS0               // bit 6
#define TMR1CS1                 T1CONbits.TMR1CS1               // bit 7

#define T1GSS0                  T1GCONbits.T1GSS0               // bit 0
#define T1GSS1                  T1GCONbits.T1GSS1               // bit 1
#define T1GVAL                  T1GCONbits.T1GVAL               // bit 2
#define T1GGO                   T1GCONbits.T1GGO                // bit 3
#define T1GSPM                  T1GCONbits.T1GSPM               // bit 4
#define T1GTM                   T1GCONbits.T1GTM                // bit 5
#define T1GPOL                  T1GCONbits.T1GPOL               // bit 6
#define TMR1GE                  T1GCONbits.TMR1GE               // bit 7

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define T2OUTPS0                T2CONbits.T2OUTPS0              // bit 3
#define T2OUTPS1                T2CONbits.T2OUTPS1              // bit 4
#define T2OUTPS2                T2CONbits.T2OUTPS2              // bit 5
#define T2OUTPS3                T2CONbits.T2OUTPS3              // bit 6

#define T4CKPS0                 T4CONbits.T4CKPS0               // bit 0
#define T4CKPS1                 T4CONbits.T4CKPS1               // bit 1
#define TMR4ON                  T4CONbits.TMR4ON                // bit 2
#define T4OUTPS0                T4CONbits.T4OUTPS0              // bit 3
#define T4OUTPS1                T4CONbits.T4OUTPS1              // bit 4
#define T4OUTPS2                T4CONbits.T4OUTPS2              // bit 5
#define T4OUTPS3                T4CONbits.T4OUTPS3              // bit 6

#define T6CKPS0                 T6CONbits.T6CKPS0               // bit 0
#define T6CKPS1                 T6CONbits.T6CKPS1               // bit 1
#define TMR6ON                  T6CONbits.TMR6ON                // bit 2
#define T6OUTPS0                T6CONbits.T6OUTPS0              // bit 3
#define T6OUTPS1                T6CONbits.T6OUTPS1              // bit 4
#define T6OUTPS2                T6CONbits.T6OUTPS2              // bit 5
#define T6OUTPS3                T6CONbits.T6OUTPS3              // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5

#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5
#define TRISC6                  TRISCbits.TRISC6                // bit 6
#define TRISC7                  TRISCbits.TRISC7                // bit 7

#define TX9D                    TXSTAbits.TX9D                  // bit 0
#define TRMT                    TXSTAbits.TRMT                  // bit 1
#define BRGH                    TXSTAbits.BRGH                  // bit 2
#define SENDB                   TXSTAbits.SENDB                 // bit 3
#define SYNC                    TXSTAbits.SYNC                  // bit 4
#define TXEN                    TXSTAbits.TXEN                  // bit 5
#define TX9                     TXSTAbits.TX9                   // bit 6
#define CSRC                    TXSTAbits.CSRC                  // bit 7

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4
#define WDTPS4                  WDTCONbits.WDTPS4               // bit 5

#define WPUA0                   WPUAbits.WPUA0                  // bit 0
#define WPUA1                   WPUAbits.WPUA1                  // bit 1
#define WPUA2                   WPUAbits.WPUA2                  // bit 2
#define WPUA3                   WPUAbits.WPUA3                  // bit 3
#define WPUA4                   WPUAbits.WPUA4                  // bit 4
#define WPUA5                   WPUAbits.WPUA5                  // bit 5

#define WPUB4                   WPUBbits.WPUB4                  // bit 4
#define WPUB5                   WPUBbits.WPUB5                  // bit 5
#define WPUB6                   WPUBbits.WPUB6                  // bit 6
#define WPUB7                   WPUBbits.WPUB7                  // bit 7

#define WPUC0                   WPUCbits.WPUC0                  // bit 0
#define WPUC1                   WPUCbits.WPUC1                  // bit 1
#define WPUC2                   WPUCbits.WPUC2                  // bit 2
#define WPUC3                   WPUCbits.WPUC3                  // bit 3
#define WPUC4                   WPUCbits.WPUC4                  // bit 4
#define WPUC5                   WPUCbits.WPUC5                  // bit 5
#define WPUC6                   WPUCbits.WPUC6                  // bit 6
#define WPUC7                   WPUCbits.WPUC7                  // bit 7

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16F1829_H__
