/*
 * This declarations of the PIC16F1946 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2014.
 *
 * This file is generated automatically by the cinc2h.pl, 2014-03-09 13:32:31 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16F1946_H__
#define __PIC16F1946_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF0_ADDR              0x0000
#define INDF1_ADDR              0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR0_ADDR               0x0004
#define FSR0L_ADDR              0x0004
#define FSR0H_ADDR              0x0005
#define FSR1_ADDR               0x0006
#define FSR1L_ADDR              0x0006
#define FSR1H_ADDR              0x0007
#define BSR_ADDR                0x0008
#define WREG_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PORTA_ADDR              0x000C
#define PORTB_ADDR              0x000D
#define PORTC_ADDR              0x000E
#define PORTD_ADDR              0x000F
#define PORTE_ADDR              0x0010
#define PIR1_ADDR               0x0011
#define PIR2_ADDR               0x0012
#define PIR3_ADDR               0x0013
#define PIR4_ADDR               0x0014
#define TMR0_ADDR               0x0015
#define TMR1_ADDR               0x0016
#define TMR1L_ADDR              0x0016
#define TMR1H_ADDR              0x0017
#define T1CON_ADDR              0x0018
#define T1GCON_ADDR             0x0019
#define TMR2_ADDR               0x001A
#define PR2_ADDR                0x001B
#define T2CON_ADDR              0x001C
#define CPSCON0_ADDR            0x001E
#define CPSCON1_ADDR            0x001F
#define TRISA_ADDR              0x008C
#define TRISB_ADDR              0x008D
#define TRISC_ADDR              0x008E
#define TRISD_ADDR              0x008F
#define TRISE_ADDR              0x0090
#define PIE1_ADDR               0x0091
#define PIE2_ADDR               0x0092
#define PIE3_ADDR               0x0093
#define PIE4_ADDR               0x0094
#define OPTION_REG_ADDR         0x0095
#define PCON_ADDR               0x0096
#define WDTCON_ADDR             0x0097
#define OSCTUNE_ADDR            0x0098
#define OSCCON_ADDR             0x0099
#define OSCSTAT_ADDR            0x009A
#define ADRES_ADDR              0x009B
#define ADRESL_ADDR             0x009B
#define ADRESH_ADDR             0x009C
#define ADCON0_ADDR             0x009D
#define ADCON1_ADDR             0x009E
#define LATA_ADDR               0x010C
#define LATB_ADDR               0x010D
#define LATC_ADDR               0x010E
#define LATD_ADDR               0x010F
#define LATE_ADDR               0x0110
#define CM1CON0_ADDR            0x0111
#define CM1CON1_ADDR            0x0112
#define CM2CON0_ADDR            0x0113
#define CM2CON1_ADDR            0x0114
#define CMOUT_ADDR              0x0115
#define BORCON_ADDR             0x0116
#define FVRCON_ADDR             0x0117
#define DACCON0_ADDR            0x0118
#define DACCON1_ADDR            0x0119
#define SRCON0_ADDR             0x011A
#define SRCON1_ADDR             0x011B
#define APFCON_ADDR             0x011D
#define CM3CON0_ADDR            0x011E
#define CM3CON1_ADDR            0x011F
#define ANSELA_ADDR             0x018C
#define ANSELE_ADDR             0x0190
#define EEADR_ADDR              0x0191
#define EEADRL_ADDR             0x0191
#define EEADRH_ADDR             0x0192
#define EEDAT_ADDR              0x0193
#define EEDATL_ADDR             0x0193
#define EEDATH_ADDR             0x0194
#define EECON1_ADDR             0x0195
#define EECON2_ADDR             0x0196
#define RC1REG_ADDR             0x0199
#define RCREG_ADDR              0x0199
#define TX1REG_ADDR             0x019A
#define TXREG_ADDR              0x019A
#define SP1BRG_ADDR             0x019B
#define SP1BRGL_ADDR            0x019B
#define SPBRG_ADDR              0x019B
#define SPBRGL_ADDR             0x019B
#define SP1BRGH_ADDR            0x019C
#define SPBRGH_ADDR             0x019C
#define RC1STA_ADDR             0x019D
#define RCSTA_ADDR              0x019D
#define TX1STA_ADDR             0x019E
#define TXSTA_ADDR              0x019E
#define BAUD1CON_ADDR           0x019F
#define WPUB_ADDR               0x020D
#define SSP1BUF_ADDR            0x0211
#define SSPBUF_ADDR             0x0211
#define SSP1ADD_ADDR            0x0212
#define SSPADD_ADDR             0x0212
#define SSP1MSK_ADDR            0x0213
#define SSPMSK_ADDR             0x0213
#define SSP1STAT_ADDR           0x0214
#define SSPSTAT_ADDR            0x0214
#define SSP1CON1_ADDR           0x0215
#define SSPCON_ADDR             0x0215
#define SSPCON1_ADDR            0x0215
#define SSP1CON2_ADDR           0x0216
#define SSPCON2_ADDR            0x0216
#define SSP1CON3_ADDR           0x0217
#define SSPCON3_ADDR            0x0217
#define SSP2BUF_ADDR            0x0219
#define SSP2ADD_ADDR            0x021A
#define SSP2MSK_ADDR            0x021B
#define SSP2STAT_ADDR           0x021C
#define SSP2CON1_ADDR           0x021D
#define SSP2CON2_ADDR           0x021E
#define SSP2CON3_ADDR           0x021F
#define PORTF_ADDR              0x028C
#define PORTG_ADDR              0x028D
#define CCPR1_ADDR              0x0291
#define CCPR1L_ADDR             0x0291
#define CCPR1H_ADDR             0x0292
#define CCP1CON_ADDR            0x0293
#define PWM1CON_ADDR            0x0294
#define CCP1AS_ADDR             0x0295
#define ECCP1AS_ADDR            0x0295
#define PSTR1CON_ADDR           0x0296
#define CCPR2_ADDR              0x0298
#define CCPR2L_ADDR             0x0298
#define CCPR2H_ADDR             0x0299
#define CCP2CON_ADDR            0x029A
#define PWM2CON_ADDR            0x029B
#define CCP2AS_ADDR             0x029C
#define ECCP2AS_ADDR            0x029C
#define PSTR2CON_ADDR           0x029D
#define CCPTMRS0_ADDR           0x029E
#define CCPTMRS1_ADDR           0x029F
#define TRISF_ADDR              0x030C
#define TRISG_ADDR              0x030D
#define CCPR3_ADDR              0x0311
#define CCPR3L_ADDR             0x0311
#define CCPR3H_ADDR             0x0312
#define CCP3CON_ADDR            0x0313
#define PWM3CON_ADDR            0x0314
#define CCP3AS_ADDR             0x0315
#define ECCP3AS_ADDR            0x0315
#define PSTR3CON_ADDR           0x0316
#define CCPR4_ADDR              0x0318
#define CCPR4L_ADDR             0x0318
#define CCPR4H_ADDR             0x0319
#define CCP4CON_ADDR            0x031A
#define CCPR5_ADDR              0x031C
#define CCPR5L_ADDR             0x031C
#define CCPR5H_ADDR             0x031D
#define CCP5CON_ADDR            0x031E
#define LATF_ADDR               0x038C
#define LATG_ADDR               0x038D
#define IOCBP_ADDR              0x0394
#define IOCBN_ADDR              0x0395
#define IOCBF_ADDR              0x0396
#define ANSELF_ADDR             0x040C
#define ANSELG_ADDR             0x040D
#define TMR4_ADDR               0x0415
#define PR4_ADDR                0x0416
#define T4CON_ADDR              0x0417
#define TMR6_ADDR               0x041C
#define PR6_ADDR                0x041D
#define T6CON_ADDR              0x041E
#define WPUG_ADDR               0x048D
#define RC2REG_ADDR             0x0491
#define TX2REG_ADDR             0x0492
#define SP2BRGL_ADDR            0x0493
#define SPBRG2_ADDR             0x0493
#define SP2BRGH_ADDR            0x0494
#define RC2STA_ADDR             0x0495
#define TX2STA_ADDR             0x0496
#define BAUD2CON_ADDR           0x0497
#define LCDCON_ADDR             0x0791
#define LCDPS_ADDR              0x0792
#define LCDREF_ADDR             0x0793
#define LCDCST_ADDR             0x0794
#define LCDRL_ADDR              0x0795
#define LCDSE0_ADDR             0x0798
#define LCDSE1_ADDR             0x0799
#define LCDSE2_ADDR             0x079A
#define LCDSE3_ADDR             0x079B
#define LCDSE4_ADDR             0x079C
#define LCDSE5_ADDR             0x079D
#define LCDDATA0_ADDR           0x07A0
#define LCDDATA1_ADDR           0x07A1
#define LCDDATA2_ADDR           0x07A2
#define LCDDATA3_ADDR           0x07A3
#define LCDDATA4_ADDR           0x07A4
#define LCDDATA5_ADDR           0x07A5
#define LCDDATA6_ADDR           0x07A6
#define LCDDATA7_ADDR           0x07A7
#define LCDDATA8_ADDR           0x07A8
#define LCDDATA9_ADDR           0x07A9
#define LCDDATA10_ADDR          0x07AA
#define LCDDATA11_ADDR          0x07AB
#define LCDDATA12_ADDR          0x07AC
#define LCDDATA13_ADDR          0x07AD
#define LCDDATA14_ADDR          0x07AE
#define LCDDATA15_ADDR          0x07AF
#define LCDDATA16_ADDR          0x07B0
#define LCDDATA17_ADDR          0x07B1
#define LCDDATA18_ADDR          0x07B2
#define LCDDATA19_ADDR          0x07B3
#define LCDDATA20_ADDR          0x07B4
#define LCDDATA21_ADDR          0x07B5
#define LCDDATA22_ADDR          0x07B6
#define LCDDATA23_ADDR          0x07B7
#define STATUS_SHAD_ADDR        0x0FE4
#define WREG_SHAD_ADDR          0x0FE5
#define BSR_SHAD_ADDR           0x0FE6
#define PCLATH_SHAD_ADDR        0x0FE7
#define FSR0L_SHAD_ADDR         0x0FE8
#define FSR0H_SHAD_ADDR         0x0FE9
#define FSR1L_SHAD_ADDR         0x0FEA
#define FSR1H_SHAD_ADDR         0x0FEB
#define STKPTR_ADDR             0x0FED
#define TOSL_ADDR               0x0FEE
#define TOSH_ADDR               0x0FEF

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF0;
extern __at(0x0001) __sfr INDF1;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned NOT_PD               : 1;
  unsigned NOT_TO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10

//==============================================================================

extern __at(0x0004) __sfr FSR0;
extern __at(0x0004) __sfr FSR0L;
extern __at(0x0005) __sfr FSR0H;
extern __at(0x0006) __sfr FSR1;
extern __at(0x0006) __sfr FSR1L;
extern __at(0x0007) __sfr FSR1H;

//==============================================================================
//        BSR Bits

extern __at(0x0008) __sfr BSR;

typedef union
  {
  struct
    {
    unsigned BSR0               : 1;
    unsigned BSR1               : 1;
    unsigned BSR2               : 1;
    unsigned BSR3               : 1;
    unsigned BSR4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BSR                : 5;
    unsigned                    : 3;
    };
  } __BSRbits_t;

extern __at(0x0008) volatile __BSRbits_t BSRbits;

#define _BSR0                   0x01
#define _BSR1                   0x02
#define _BSR2                   0x04
#define _BSR3                   0x08
#define _BSR4                   0x10

//==============================================================================

extern __at(0x0009) __sfr WREG;
extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned IOCIF              : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned IOCIE              : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _IOCIE                  0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x000C) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };

  struct
    {
    unsigned AN0                : 1;
    unsigned AN1                : 1;
    unsigned AN2                : 1;
    unsigned AN3                : 1;
    unsigned SEG14              : 1;
    unsigned AN4                : 1;
    unsigned SEG36              : 1;
    unsigned SEG37              : 1;
    };

  struct
    {
    unsigned CPS0               : 1;
    unsigned CPS1               : 1;
    unsigned CPS2               : 1;
    unsigned CPS3               : 1;
    unsigned T0CKI              : 1;
    unsigned CPS4               : 1;
    unsigned OSC2               : 1;
    unsigned OSC1               : 1;
    };

  struct
    {
    unsigned SEG33              : 1;
    unsigned SEG18              : 1;
    unsigned SEG34              : 1;
    unsigned SEG35              : 1;
    unsigned                    : 1;
    unsigned SEG15              : 1;
    unsigned CLKOUT             : 1;
    unsigned CLKIN              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned VREFM              : 1;
    unsigned VREFP              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTAbits_t;

extern __at(0x000C) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _AN0                    0x01
#define _CPS0                   0x01
#define _SEG33                  0x01
#define _RA1                    0x02
#define _AN1                    0x02
#define _CPS1                   0x02
#define _SEG18                  0x02
#define _RA2                    0x04
#define _AN2                    0x04
#define _CPS2                   0x04
#define _SEG34                  0x04
#define _VREFM                  0x04
#define _RA3                    0x08
#define _AN3                    0x08
#define _CPS3                   0x08
#define _SEG35                  0x08
#define _VREFP                  0x08
#define _RA4                    0x10
#define _SEG14                  0x10
#define _T0CKI                  0x10
#define _RA5                    0x20
#define _AN4                    0x20
#define _CPS4                   0x20
#define _SEG15                  0x20
#define _RA6                    0x40
#define _SEG36                  0x40
#define _OSC2                   0x40
#define _CLKOUT                 0x40
#define _RA7                    0x80
#define _SEG37                  0x80
#define _OSC1                   0x80
#define _CLKIN                  0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x000D) __sfr PORTB;

typedef union
  {
  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };

  struct
    {
    unsigned SEG30              : 1;
    unsigned SEG8               : 1;
    unsigned SEG9               : 1;
    unsigned SEG10              : 1;
    unsigned SEG11              : 1;
    unsigned SEG29              : 1;
    unsigned SEG38              : 1;
    unsigned SEG39              : 1;
    };

  struct
    {
    unsigned SRI                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1G                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FLT0               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTBbits_t;

extern __at(0x000D) volatile __PORTBbits_t PORTBbits;

#define _RB0                    0x01
#define _SEG30                  0x01
#define _SRI                    0x01
#define _FLT0                   0x01
#define _RB1                    0x02
#define _SEG8                   0x02
#define _RB2                    0x04
#define _SEG9                   0x04
#define _RB3                    0x08
#define _SEG10                  0x08
#define _RB4                    0x10
#define _SEG11                  0x10
#define _RB5                    0x20
#define _SEG29                  0x20
#define _T1G                    0x20
#define _RB6                    0x40
#define _SEG38                  0x40
#define _RB7                    0x80
#define _SEG39                  0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x000E) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };

  struct
    {
    unsigned SEG40              : 1;
    unsigned SEG32              : 1;
    unsigned SEG13              : 1;
    unsigned SEG17              : 1;
    unsigned SEG16              : 1;
    unsigned SEG12              : 1;
    unsigned SEG27              : 1;
    unsigned SEG28              : 1;
    };

  struct
    {
    unsigned T1OSO              : 1;
    unsigned T1OSI              : 1;
    unsigned CCP1               : 1;
    unsigned SCK1               : 1;
    unsigned SDI1               : 1;
    unsigned SDO1               : 1;
    unsigned TX1                : 1;
    unsigned RX1                : 1;
    };

  struct
    {
    unsigned T1CKI              : 1;
    unsigned CCP2               : 1;
    unsigned P1A                : 1;
    unsigned SCL1               : 1;
    unsigned SDA1               : 1;
    unsigned                    : 1;
    unsigned CK1                : 1;
    unsigned DT1                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned P2A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTCbits_t;

extern __at(0x000E) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _SEG40                  0x01
#define _T1OSO                  0x01
#define _T1CKI                  0x01
#define _RC1                    0x02
#define _SEG32                  0x02
#define _T1OSI                  0x02
#define _CCP2                   0x02
#define _P2A                    0x02
#define _RC2                    0x04
#define _SEG13                  0x04
#define _CCP1                   0x04
#define _P1A                    0x04
#define _RC3                    0x08
#define _SEG17                  0x08
#define _SCK1                   0x08
#define _SCL1                   0x08
#define _RC4                    0x10
#define _SEG16                  0x10
#define _SDI1                   0x10
#define _SDA1                   0x10
#define _RC5                    0x20
#define _SEG12                  0x20
#define _SDO1                   0x20
#define _RC6                    0x40
#define _SEG27                  0x40
#define _TX1                    0x40
#define _CK1                    0x40
#define _RC7                    0x80
#define _SEG28                  0x80
#define _RX1                    0x80
#define _DT1                    0x80

//==============================================================================


//==============================================================================
//        PORTD Bits

extern __at(0x000F) __sfr PORTD;

typedef union
  {
  struct
    {
    unsigned RD0                : 1;
    unsigned RD1                : 1;
    unsigned RD2                : 1;
    unsigned RD3                : 1;
    unsigned RD4                : 1;
    unsigned RD5                : 1;
    unsigned RD6                : 1;
    unsigned RD7                : 1;
    };

  struct
    {
    unsigned SEG0               : 1;
    unsigned SEG1               : 1;
    unsigned SEG2               : 1;
    unsigned SEG3               : 1;
    unsigned SEG4               : 1;
    unsigned SEG5               : 1;
    unsigned SEG6               : 1;
    unsigned SEG7               : 1;
    };

  struct
    {
    unsigned P2D                : 1;
    unsigned P2C                : 1;
    unsigned P2B                : 1;
    unsigned P3C                : 1;
    unsigned P3B                : 1;
    unsigned P1C                : 1;
    unsigned P1B                : 1;
    unsigned NOT_SS2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SDO2               : 1;
    unsigned SDI2               : 1;
    unsigned SCK2               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SDA2               : 1;
    unsigned SCL2               : 1;
    unsigned                    : 1;
    };
  } __PORTDbits_t;

extern __at(0x000F) volatile __PORTDbits_t PORTDbits;

#define _RD0                    0x01
#define _SEG0                   0x01
#define _P2D                    0x01
#define _RD1                    0x02
#define _SEG1                   0x02
#define _P2C                    0x02
#define _RD2                    0x04
#define _SEG2                   0x04
#define _P2B                    0x04
#define _RD3                    0x08
#define _SEG3                   0x08
#define _P3C                    0x08
#define _RD4                    0x10
#define _SEG4                   0x10
#define _P3B                    0x10
#define _SDO2                   0x10
#define _RD5                    0x20
#define _SEG5                   0x20
#define _P1C                    0x20
#define _SDI2                   0x20
#define _SDA2                   0x20
#define _RD6                    0x40
#define _SEG6                   0x40
#define _P1B                    0x40
#define _SCK2                   0x40
#define _SCL2                   0x40
#define _RD7                    0x80
#define _SEG7                   0x80
#define _NOT_SS2                0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0010) __sfr PORTE;

typedef union
  {
  struct
    {
    unsigned RE0                : 1;
    unsigned RE1                : 1;
    unsigned RE2                : 1;
    unsigned RE3                : 1;
    unsigned RE4                : 1;
    unsigned RE5                : 1;
    unsigned RE6                : 1;
    unsigned RE7                : 1;
    };

  struct
    {
    unsigned VLCD1              : 1;
    unsigned VLCD2              : 1;
    unsigned VLCD3              : 1;
    unsigned COM0               : 1;
    unsigned COM1               : 1;
    unsigned COM2               : 1;
    unsigned COM3               : 1;
    unsigned SEG31              : 1;
    };

  struct
    {
    unsigned P2D                : 1;
    unsigned P2C                : 1;
    unsigned P2B                : 1;
    unsigned P3C                : 1;
    unsigned P3B                : 1;
    unsigned P1C                : 1;
    unsigned P1B                : 1;
    unsigned P2A                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2               : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned COM                : 4;
    unsigned                    : 1;
    };
  } __PORTEbits_t;

extern __at(0x0010) volatile __PORTEbits_t PORTEbits;

#define _PORTE_RE0              0x01
#define _PORTE_VLCD1            0x01
#define _PORTE_P2D              0x01
#define _PORTE_RE1              0x02
#define _PORTE_VLCD2            0x02
#define _PORTE_P2C              0x02
#define _PORTE_RE2              0x04
#define _PORTE_VLCD3            0x04
#define _PORTE_P2B              0x04
#define _PORTE_RE3              0x08
#define _PORTE_COM0             0x08
#define _PORTE_P3C              0x08
#define _PORTE_RE4              0x10
#define _PORTE_COM1             0x10
#define _PORTE_P3B              0x10
#define _PORTE_RE5              0x20
#define _PORTE_COM2             0x20
#define _PORTE_P1C              0x20
#define _PORTE_RE6              0x40
#define _PORTE_COM3             0x40
#define _PORTE_P1B              0x40
#define _PORTE_RE7              0x80
#define _PORTE_SEG31            0x80
#define _PORTE_P2A              0x80
#define _PORTE_CCP2             0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0011) __sfr PIR1;

typedef union
  {
  struct
    {
    unsigned TMR1IF             : 1;
    unsigned TMR2IF             : 1;
    unsigned CCP1IF             : 1;
    unsigned SSP1IF             : 1;
    unsigned TX1IF              : 1;
    unsigned RC1IF              : 1;
    unsigned ADIF               : 1;
    unsigned TMR1GIF            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSPIF              : 1;
    unsigned TXIF               : 1;
    unsigned RCIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR1bits_t;

extern __at(0x0011) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSP1IF                 0x08
#define _SSPIF                  0x08
#define _TX1IF                  0x10
#define _TXIF                   0x10
#define _RC1IF                  0x20
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0012) __sfr PIR2;

typedef struct
  {
  unsigned CCP2IF               : 1;
  unsigned C3IF                 : 1;
  unsigned LCDIF                : 1;
  unsigned BCLIF                : 1;
  unsigned EEIF                 : 1;
  unsigned C1IF                 : 1;
  unsigned C2IF                 : 1;
  unsigned OSFIF                : 1;
  } __PIR2bits_t;

extern __at(0x0012) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01
#define _C3IF                   0x02
#define _LCDIF                  0x04
#define _BCLIF                  0x08
#define _EEIF                   0x10
#define _C1IF                   0x20
#define _C2IF                   0x40
#define _OSFIF                  0x80

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0013) __sfr PIR3;

typedef struct
  {
  unsigned                      : 1;
  unsigned TMR4IF               : 1;
  unsigned                      : 1;
  unsigned TMR6IF               : 1;
  unsigned CCP3IF               : 1;
  unsigned CCP4IF               : 1;
  unsigned CCP5IF               : 1;
  unsigned                      : 1;
  } __PIR3bits_t;

extern __at(0x0013) volatile __PIR3bits_t PIR3bits;

#define _TMR4IF                 0x02
#define _TMR6IF                 0x08
#define _CCP3IF                 0x10
#define _CCP4IF                 0x20
#define _CCP5IF                 0x40

//==============================================================================


//==============================================================================
//        PIR4 Bits

extern __at(0x0014) __sfr PIR4;

typedef struct
  {
  unsigned SSP2IF               : 1;
  unsigned BCL2IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TX2IF                : 1;
  unsigned RC2IF                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR4bits_t;

extern __at(0x0014) volatile __PIR4bits_t PIR4bits;

#define _SSP2IF                 0x01
#define _BCL2IF                 0x02
#define _TX2IF                  0x10
#define _RC2IF                  0x20

//==============================================================================

extern __at(0x0015) __sfr TMR0;
extern __at(0x0016) __sfr TMR1;
extern __at(0x0016) __sfr TMR1L;
extern __at(0x0017) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0018) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0018) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _NOT_T1SYNC             0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0019) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0019) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO_NOT_DONE         0x08
#define _T1GGO                  0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================

extern __at(0x001A) __sfr TMR2;
extern __at(0x001B) __sfr PR2;

//==============================================================================
//        T2CON Bits

extern __at(0x001C) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x001C) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================


//==============================================================================
//        CPSCON0 Bits

extern __at(0x001E) __sfr CPSCON0;

typedef union
  {
  struct
    {
    unsigned T0XCS              : 1;
    unsigned CPSOUT             : 1;
    unsigned CPSRNG0            : 1;
    unsigned CPSRNG1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CPSRM              : 1;
    unsigned CPSON              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CPSRNG             : 2;
    unsigned                    : 4;
    };
  } __CPSCON0bits_t;

extern __at(0x001E) volatile __CPSCON0bits_t CPSCON0bits;

#define _T0XCS                  0x01
#define _CPSOUT                 0x02
#define _CPSRNG0                0x04
#define _CPSRNG1                0x08
#define _CPSRM                  0x40
#define _CPSON                  0x80

//==============================================================================


//==============================================================================
//        CPSCON1 Bits

extern __at(0x001F) __sfr CPSCON1;

typedef union
  {
  struct
    {
    unsigned CPSCH0             : 1;
    unsigned CPSCH1             : 1;
    unsigned CPSCH2             : 1;
    unsigned CPSCH3             : 1;
    unsigned CPSCH4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CPSCH              : 5;
    unsigned                    : 3;
    };
  } __CPSCON1bits_t;

extern __at(0x001F) volatile __CPSCON1bits_t CPSCON1bits;

#define _CPSCH0                 0x01
#define _CPSCH1                 0x02
#define _CPSCH2                 0x04
#define _CPSCH3                 0x08
#define _CPSCH4                 0x10

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x008C) __sfr TRISA;

typedef struct
  {
  unsigned TRISA0               : 1;
  unsigned TRISA1               : 1;
  unsigned TRISA2               : 1;
  unsigned TRISA3               : 1;
  unsigned TRISA4               : 1;
  unsigned TRISA5               : 1;
  unsigned TRISA6               : 1;
  unsigned TRISA7               : 1;
  } __TRISAbits_t;

extern __at(0x008C) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20
#define _TRISA6                 0x40
#define _TRISA7                 0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x008D) __sfr TRISB;

typedef struct
  {
  unsigned TRISB0               : 1;
  unsigned TRISB1               : 1;
  unsigned TRISB2               : 1;
  unsigned TRISB3               : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x008D) volatile __TRISBbits_t TRISBbits;

#define _TRISB0                 0x01
#define _TRISB1                 0x02
#define _TRISB2                 0x04
#define _TRISB3                 0x08
#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x008E) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x008E) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        TRISD Bits

extern __at(0x008F) __sfr TRISD;

typedef struct
  {
  unsigned TRISD0               : 1;
  unsigned TRISD1               : 1;
  unsigned TRISD2               : 1;
  unsigned TRISD3               : 1;
  unsigned TRISD4               : 1;
  unsigned TRISD5               : 1;
  unsigned TRISD6               : 1;
  unsigned TRISD7               : 1;
  } __TRISDbits_t;

extern __at(0x008F) volatile __TRISDbits_t TRISDbits;

#define _TRISD0                 0x01
#define _TRISD1                 0x02
#define _TRISD2                 0x04
#define _TRISD3                 0x08
#define _TRISD4                 0x10
#define _TRISD5                 0x20
#define _TRISD6                 0x40
#define _TRISD7                 0x80

//==============================================================================


//==============================================================================
//        TRISE Bits

extern __at(0x0090) __sfr TRISE;

typedef struct
  {
  unsigned TRISE0               : 1;
  unsigned TRISE1               : 1;
  unsigned TRISE2               : 1;
  unsigned TRISE3               : 1;
  unsigned TRISE4               : 1;
  unsigned TRISE5               : 1;
  unsigned TRISE6               : 1;
  unsigned TRISE7               : 1;
  } __TRISEbits_t;

extern __at(0x0090) volatile __TRISEbits_t TRISEbits;

#define _TRISE0                 0x01
#define _TRISE1                 0x02
#define _TRISE2                 0x04
#define _TRISE3                 0x08
#define _TRISE4                 0x10
#define _TRISE5                 0x20
#define _TRISE6                 0x40
#define _TRISE7                 0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0091) __sfr PIE1;

typedef union
  {
  struct
    {
    unsigned TMR1IE             : 1;
    unsigned TMR2IE             : 1;
    unsigned CCP1IE             : 1;
    unsigned SSP1IE             : 1;
    unsigned TX1IE              : 1;
    unsigned RC1IE              : 1;
    unsigned ADIE               : 1;
    unsigned TMR1GIE            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSPIE              : 1;
    unsigned TXIE               : 1;
    unsigned RCIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE1bits_t;

extern __at(0x0091) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSP1IE                 0x08
#define _SSPIE                  0x08
#define _TX1IE                  0x10
#define _TXIE                   0x10
#define _RC1IE                  0x20
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0092) __sfr PIE2;

typedef struct
  {
  unsigned CCP2IE               : 1;
  unsigned C3IE                 : 1;
  unsigned LCDIE                : 1;
  unsigned BCLIE                : 1;
  unsigned EEIE                 : 1;
  unsigned C1IE                 : 1;
  unsigned C2IE                 : 1;
  unsigned OSFIE                : 1;
  } __PIE2bits_t;

extern __at(0x0092) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01
#define _C3IE                   0x02
#define _LCDIE                  0x04
#define _BCLIE                  0x08
#define _EEIE                   0x10
#define _C1IE                   0x20
#define _C2IE                   0x40
#define _OSFIE                  0x80

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0093) __sfr PIE3;

typedef struct
  {
  unsigned                      : 1;
  unsigned TMR4IE               : 1;
  unsigned                      : 1;
  unsigned TMR6IE               : 1;
  unsigned CCP3IE               : 1;
  unsigned CCP4IE               : 1;
  unsigned CCP5IE               : 1;
  unsigned                      : 1;
  } __PIE3bits_t;

extern __at(0x0093) volatile __PIE3bits_t PIE3bits;

#define _TMR4IE                 0x02
#define _TMR6IE                 0x08
#define _CCP3IE                 0x10
#define _CCP4IE                 0x20
#define _CCP5IE                 0x40

//==============================================================================


//==============================================================================
//        PIE4 Bits

extern __at(0x0094) __sfr PIE4;

typedef struct
  {
  unsigned SSP2IE               : 1;
  unsigned BCL2IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TX2IE                : 1;
  unsigned RC2IE                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE4bits_t;

extern __at(0x0094) volatile __PIE4bits_t PIE4bits;

#define _SSP2IE                 0x01
#define _BCL2IE                 0x02
#define _TX2IE                  0x10
#define _RC2IE                  0x20

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0095) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_WPUEN          : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR0SE             : 1;
    unsigned TMR0CS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0095) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _TMR0SE                 0x10
#define _T0CS                   0x20
#define _TMR0CS                 0x20
#define _INTEDG                 0x40
#define _NOT_WPUEN              0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x0096) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned NOT_RI               : 1;
  unsigned NOT_RMCLR            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned STKUNF               : 1;
  unsigned STKOVF               : 1;
  } __PCONbits_t;

extern __at(0x0096) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02
#define _NOT_RI                 0x04
#define _NOT_RMCLR              0x08
#define _STKUNF                 0x40
#define _STKOVF                 0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0097) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCONbits_t;

extern __at(0x0097) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10
#define _WDTPS4                 0x20

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0098) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TUN                : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x0098) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0099) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned                    : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IRCF3              : 1;
    unsigned SPLLEN             : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned IRCF               : 4;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0099) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IRCF0                  0x08
#define _IRCF1                  0x10
#define _IRCF2                  0x20
#define _IRCF3                  0x40
#define _SPLLEN                 0x80

//==============================================================================


//==============================================================================
//        OSCSTAT Bits

extern __at(0x009A) __sfr OSCSTAT;

typedef struct
  {
  unsigned HFIOFS               : 1;
  unsigned LFIOFR               : 1;
  unsigned MFIOFR               : 1;
  unsigned HFIOFL               : 1;
  unsigned HFIOFR               : 1;
  unsigned OSTS                 : 1;
  unsigned PLLR                 : 1;
  unsigned T1OSCR               : 1;
  } __OSCSTATbits_t;

extern __at(0x009A) volatile __OSCSTATbits_t OSCSTATbits;

#define _HFIOFS                 0x01
#define _LFIOFR                 0x02
#define _MFIOFR                 0x04
#define _HFIOFL                 0x08
#define _HFIOFR                 0x10
#define _OSTS                   0x20
#define _PLLR                   0x40
#define _T1OSCR                 0x80

//==============================================================================

extern __at(0x009B) __sfr ADRES;
extern __at(0x009B) __sfr ADRESL;
extern __at(0x009C) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x009D) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADGO               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __ADCON0bits_t;

extern __at(0x009D) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _ADGO                   0x02
#define _GO                     0x02
#define _NOT_DONE               0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _CHS4                   0x40

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x009E) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned ADNREF             : 1;
    unsigned                    : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCS               : 3;
    unsigned                    : 1;
    };
  } __ADCON1bits_t;

extern __at(0x009E) volatile __ADCON1bits_t ADCON1bits;

#define _ADPREF0                0x01
#define _ADPREF1                0x02
#define _ADNREF                 0x04
#define _ADCS0                  0x10
#define _ADCS1                  0x20
#define _ADCS2                  0x40
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x010C) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned LATA3                : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned LATA6                : 1;
  unsigned LATA7                : 1;
  } __LATAbits_t;

extern __at(0x010C) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20
#define _LATA6                  0x40
#define _LATA7                  0x80

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x010D) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x010D) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x010E) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x010E) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        LATD Bits

extern __at(0x010F) __sfr LATD;

typedef struct
  {
  unsigned LATD0                : 1;
  unsigned LATD1                : 1;
  unsigned LATD2                : 1;
  unsigned LATD3                : 1;
  unsigned LATD4                : 1;
  unsigned LATD5                : 1;
  unsigned LATD6                : 1;
  unsigned LATD7                : 1;
  } __LATDbits_t;

extern __at(0x010F) volatile __LATDbits_t LATDbits;

#define _LATD0                  0x01
#define _LATD1                  0x02
#define _LATD2                  0x04
#define _LATD3                  0x08
#define _LATD4                  0x10
#define _LATD5                  0x20
#define _LATD6                  0x40
#define _LATD7                  0x80

//==============================================================================


//==============================================================================
//        LATE Bits

extern __at(0x0110) __sfr LATE;

typedef struct
  {
  unsigned LATE0                : 1;
  unsigned LATE1                : 1;
  unsigned LATE2                : 1;
  unsigned LATE3                : 1;
  unsigned LATE4                : 1;
  unsigned LATE5                : 1;
  unsigned LATE6                : 1;
  unsigned LATE7                : 1;
  } __LATEbits_t;

extern __at(0x0110) volatile __LATEbits_t LATEbits;

#define _LATE0                  0x01
#define _LATE1                  0x02
#define _LATE2                  0x04
#define _LATE3                  0x08
#define _LATE4                  0x10
#define _LATE5                  0x20
#define _LATE6                  0x40
#define _LATE7                  0x80

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x0111) __sfr CM1CON0;

typedef struct
  {
  unsigned C1SYNC               : 1;
  unsigned C1HYS                : 1;
  unsigned C1SP                 : 1;
  unsigned                      : 1;
  unsigned C1POL                : 1;
  unsigned C1OE                 : 1;
  unsigned C1OUT                : 1;
  unsigned C1ON                 : 1;
  } __CM1CON0bits_t;

extern __at(0x0111) volatile __CM1CON0bits_t CM1CON0bits;

#define _C1SYNC                 0x01
#define _C1HYS                  0x02
#define _C1SP                   0x04
#define _C1POL                  0x10
#define _C1OE                   0x20
#define _C1OUT                  0x40
#define _C1ON                   0x80

//==============================================================================


//==============================================================================
//        CM1CON1 Bits

extern __at(0x0112) __sfr CM1CON1;

typedef union
  {
  struct
    {
    unsigned C1NCH0             : 1;
    unsigned C1NCH1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned C1PCH0             : 1;
    unsigned C1PCH1             : 1;
    unsigned C1INTN             : 1;
    unsigned C1INTP             : 1;
    };

  struct
    {
    unsigned C1NCH              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned C1PCH              : 2;
    unsigned                    : 2;
    };
  } __CM1CON1bits_t;

extern __at(0x0112) volatile __CM1CON1bits_t CM1CON1bits;

#define _C1NCH0                 0x01
#define _C1NCH1                 0x02
#define _C1PCH0                 0x10
#define _C1PCH1                 0x20
#define _C1INTN                 0x40
#define _C1INTP                 0x80

//==============================================================================


//==============================================================================
//        CM2CON0 Bits

extern __at(0x0113) __sfr CM2CON0;

typedef struct
  {
  unsigned C2SYNC               : 1;
  unsigned C2HYS                : 1;
  unsigned C2SP                 : 1;
  unsigned                      : 1;
  unsigned C2POL                : 1;
  unsigned C2OE                 : 1;
  unsigned C2OUT                : 1;
  unsigned C2ON                 : 1;
  } __CM2CON0bits_t;

extern __at(0x0113) volatile __CM2CON0bits_t CM2CON0bits;

#define _C2SYNC                 0x01
#define _C2HYS                  0x02
#define _C2SP                   0x04
#define _C2POL                  0x10
#define _C2OE                   0x20
#define _C2OUT                  0x40
#define _C2ON                   0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x0114) __sfr CM2CON1;

typedef union
  {
  struct
    {
    unsigned C2NCH0             : 1;
    unsigned C2NCH1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned C2PCH0             : 1;
    unsigned C2PCH1             : 1;
    unsigned C2INTN             : 1;
    unsigned C2INTP             : 1;
    };

  struct
    {
    unsigned C2NCH              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned C2PCH              : 2;
    unsigned                    : 2;
    };
  } __CM2CON1bits_t;

extern __at(0x0114) volatile __CM2CON1bits_t CM2CON1bits;

#define _C2NCH0                 0x01
#define _C2NCH1                 0x02
#define _C2PCH0                 0x10
#define _C2PCH1                 0x20
#define _C2INTN                 0x40
#define _C2INTP                 0x80

//==============================================================================


//==============================================================================
//        CMOUT Bits

extern __at(0x0115) __sfr CMOUT;

typedef struct
  {
  unsigned MC1OUT               : 1;
  unsigned MC2OUT               : 1;
  unsigned MC3OUT               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CMOUTbits_t;

extern __at(0x0115) volatile __CMOUTbits_t CMOUTbits;

#define _MC1OUT                 0x01
#define _MC2OUT                 0x02
#define _MC3OUT                 0x04

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x0116) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x0116) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x0117) __sfr FVRCON;

typedef union
  {
  struct
    {
    unsigned ADFVR0             : 1;
    unsigned ADFVR1             : 1;
    unsigned CDAFVR0            : 1;
    unsigned CDAFVR1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned FVRRDY             : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned ADFVR              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CDAFVR             : 2;
    unsigned                    : 4;
    };
  } __FVRCONbits_t;

extern __at(0x0117) volatile __FVRCONbits_t FVRCONbits;

#define _ADFVR0                 0x01
#define _ADFVR1                 0x02
#define _CDAFVR0                0x04
#define _CDAFVR1                0x08
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        DACCON0 Bits

extern __at(0x0118) __sfr DACCON0;

typedef union
  {
  struct
    {
    unsigned DACNSS             : 1;
    unsigned                    : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned                    : 1;
    unsigned DACOE              : 1;
    unsigned DACLPS             : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };
  } __DACCON0bits_t;

extern __at(0x0118) volatile __DACCON0bits_t DACCON0bits;

#define _DACNSS                 0x01
#define _DACPSS0                0x04
#define _DACPSS1                0x08
#define _DACOE                  0x20
#define _DACLPS                 0x40
#define _DACEN                  0x80

//==============================================================================


//==============================================================================
//        DACCON1 Bits

extern __at(0x0119) __sfr DACCON1;

typedef union
  {
  struct
    {
    unsigned DACR0              : 1;
    unsigned DACR1              : 1;
    unsigned DACR2              : 1;
    unsigned DACR3              : 1;
    unsigned DACR4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DACR               : 5;
    unsigned                    : 3;
    };
  } __DACCON1bits_t;

extern __at(0x0119) volatile __DACCON1bits_t DACCON1bits;

#define _DACR0                  0x01
#define _DACR1                  0x02
#define _DACR2                  0x04
#define _DACR3                  0x08
#define _DACR4                  0x10

//==============================================================================


//==============================================================================
//        SRCON0 Bits

extern __at(0x011A) __sfr SRCON0;

typedef union
  {
  struct
    {
    unsigned SRPR               : 1;
    unsigned SRPS               : 1;
    unsigned SRNQEN             : 1;
    unsigned SRQEN              : 1;
    unsigned SRCLK0             : 1;
    unsigned SRCLK1             : 1;
    unsigned SRCLK2             : 1;
    unsigned SRLEN              : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned SRCLK              : 3;
    unsigned                    : 1;
    };
  } __SRCON0bits_t;

extern __at(0x011A) volatile __SRCON0bits_t SRCON0bits;

#define _SRPR                   0x01
#define _SRPS                   0x02
#define _SRNQEN                 0x04
#define _SRQEN                  0x08
#define _SRCLK0                 0x10
#define _SRCLK1                 0x20
#define _SRCLK2                 0x40
#define _SRLEN                  0x80

//==============================================================================


//==============================================================================
//        SRCON1 Bits

extern __at(0x011B) __sfr SRCON1;

typedef struct
  {
  unsigned SRRC1E               : 1;
  unsigned SRRC2E               : 1;
  unsigned SRRCKE               : 1;
  unsigned SRRPE                : 1;
  unsigned SRSC1E               : 1;
  unsigned SRSC2E               : 1;
  unsigned SRSCKE               : 1;
  unsigned SRSPE                : 1;
  } __SRCON1bits_t;

extern __at(0x011B) volatile __SRCON1bits_t SRCON1bits;

#define _SRRC1E                 0x01
#define _SRRC2E                 0x02
#define _SRRCKE                 0x04
#define _SRRPE                  0x08
#define _SRSC1E                 0x10
#define _SRSC2E                 0x20
#define _SRSCKE                 0x40
#define _SRSPE                  0x80

//==============================================================================


//==============================================================================
//        APFCON Bits

extern __at(0x011D) __sfr APFCON;

typedef struct
  {
  unsigned P1BSEL               : 1;
  unsigned P1CSEL               : 1;
  unsigned CCP2SEL              : 1;
  unsigned P2BSEL               : 1;
  unsigned P2CSEL               : 1;
  unsigned P2DSEL               : 1;
  unsigned P3BSEL               : 1;
  unsigned P3CSEL               : 1;
  } __APFCONbits_t;

extern __at(0x011D) volatile __APFCONbits_t APFCONbits;

#define _P1BSEL                 0x01
#define _P1CSEL                 0x02
#define _CCP2SEL                0x04
#define _P2BSEL                 0x08
#define _P2CSEL                 0x10
#define _P2DSEL                 0x20
#define _P3BSEL                 0x40
#define _P3CSEL                 0x80

//==============================================================================


//==============================================================================
//        CM3CON0 Bits

extern __at(0x011E) __sfr CM3CON0;

typedef struct
  {
  unsigned C3SYNC               : 1;
  unsigned C3HYS                : 1;
  unsigned C3SP                 : 1;
  unsigned                      : 1;
  unsigned C3POL                : 1;
  unsigned C3OE                 : 1;
  unsigned C3OUT                : 1;
  unsigned C3ON                 : 1;
  } __CM3CON0bits_t;

extern __at(0x011E) volatile __CM3CON0bits_t CM3CON0bits;

#define _C3SYNC                 0x01
#define _C3HYS                  0x02
#define _C3SP                   0x04
#define _C3POL                  0x10
#define _C3OE                   0x20
#define _C3OUT                  0x40
#define _C3ON                   0x80

//==============================================================================


//==============================================================================
//        CM3CON1 Bits

extern __at(0x011F) __sfr CM3CON1;

typedef union
  {
  struct
    {
    unsigned C3NCH0             : 1;
    unsigned C3NCH1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned C3PCH0             : 1;
    unsigned C3PCH1             : 1;
    unsigned C3INTN             : 1;
    unsigned C3INTP             : 1;
    };

  struct
    {
    unsigned C3NCH              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned C3PCH              : 2;
    unsigned                    : 2;
    };
  } __CM3CON1bits_t;

extern __at(0x011F) volatile __CM3CON1bits_t CM3CON1bits;

#define _C3NCH0                 0x01
#define _C3NCH1                 0x02
#define _C3PCH0                 0x10
#define _C3PCH1                 0x20
#define _C3INTN                 0x40
#define _C3INTP                 0x80

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x018C) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned ANSA3                : 1;
  unsigned                      : 1;
  unsigned ANSA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELAbits_t;

extern __at(0x018C) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA3                  0x08
#define _ANSA5                  0x20

//==============================================================================


//==============================================================================
//        ANSELE Bits

extern __at(0x0190) __sfr ANSELE;

typedef union
  {
  struct
    {
    unsigned ANSE0              : 1;
    unsigned ANSE1              : 1;
    unsigned ANSE2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSE               : 3;
    unsigned                    : 5;
    };
  } __ANSELEbits_t;

extern __at(0x0190) volatile __ANSELEbits_t ANSELEbits;

#define _ANSE0                  0x01
#define _ANSE1                  0x02
#define _ANSE2                  0x04

//==============================================================================

extern __at(0x0191) __sfr EEADR;
extern __at(0x0191) __sfr EEADRL;
extern __at(0x0192) __sfr EEADRH;
extern __at(0x0193) __sfr EEDAT;
extern __at(0x0193) __sfr EEDATL;
extern __at(0x0194) __sfr EEDATH;

//==============================================================================
//        EECON1 Bits

extern __at(0x0195) __sfr EECON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned CFGS                 : 1;
  unsigned EEPGD                : 1;
  } __EECON1bits_t;

extern __at(0x0195) volatile __EECON1bits_t EECON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _CFGS                   0x40
#define _EEPGD                  0x80

//==============================================================================

extern __at(0x0196) __sfr EECON2;
extern __at(0x0199) __sfr RC1REG;
extern __at(0x0199) __sfr RCREG;
extern __at(0x019A) __sfr TX1REG;
extern __at(0x019A) __sfr TXREG;
extern __at(0x019B) __sfr SP1BRG;
extern __at(0x019B) __sfr SP1BRGL;
extern __at(0x019B) __sfr SPBRG;
extern __at(0x019B) __sfr SPBRGL;
extern __at(0x019C) __sfr SP1BRGH;
extern __at(0x019C) __sfr SPBRGH;

//==============================================================================
//        RC1STA Bits

extern __at(0x019D) __sfr RC1STA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RC1STAbits_t;

extern __at(0x019D) volatile __RC1STAbits_t RC1STAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x019D) __sfr RCSTA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTAbits_t;

extern __at(0x019D) volatile __RCSTAbits_t RCSTAbits;

#define _RCSTA_RX9D             0x01
#define _RCSTA_OERR             0x02
#define _RCSTA_FERR             0x04
#define _RCSTA_ADDEN            0x08
#define _RCSTA_CREN             0x10
#define _RCSTA_SREN             0x20
#define _RCSTA_RX9              0x40
#define _RCSTA_SPEN             0x80

//==============================================================================


//==============================================================================
//        TX1STA Bits

extern __at(0x019E) __sfr TX1STA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TX1STAbits_t;

extern __at(0x019E) volatile __TX1STAbits_t TX1STAbits;

#define _TX9D                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SENDB                  0x08
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _CSRC                   0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x019E) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x019E) volatile __TXSTAbits_t TXSTAbits;

#define _TXSTA_TX9D             0x01
#define _TXSTA_TRMT             0x02
#define _TXSTA_BRGH             0x04
#define _TXSTA_SENDB            0x08
#define _TXSTA_SYNC             0x10
#define _TXSTA_TXEN             0x20
#define _TXSTA_TX9              0x40
#define _TXSTA_CSRC             0x80

//==============================================================================


//==============================================================================
//        BAUD1CON Bits

extern __at(0x019F) __sfr BAUD1CON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUD1CONbits_t;

extern __at(0x019F) volatile __BAUD1CONbits_t BAUD1CONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _SCKP                   0x10
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x020D) __sfr WPUB;

typedef struct
  {
  unsigned WPUB0                : 1;
  unsigned WPUB1                : 1;
  unsigned WPUB2                : 1;
  unsigned WPUB3                : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x020D) volatile __WPUBbits_t WPUBbits;

#define _WPUB0                  0x01
#define _WPUB1                  0x02
#define _WPUB2                  0x04
#define _WPUB3                  0x08
#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================

extern __at(0x0211) __sfr SSP1BUF;
extern __at(0x0211) __sfr SSPBUF;
extern __at(0x0212) __sfr SSP1ADD;
extern __at(0x0212) __sfr SSPADD;
extern __at(0x0213) __sfr SSP1MSK;
extern __at(0x0213) __sfr SSPMSK;

//==============================================================================
//        SSP1STAT Bits

extern __at(0x0214) __sfr SSP1STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP1STATbits_t;

extern __at(0x0214) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _S                      0x08
#define _P                      0x10
#define _D_NOT_A                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0214) __sfr SSPSTAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSPSTATbits_t;

extern __at(0x0214) volatile __SSPSTATbits_t SSPSTATbits;

#define _SSPSTAT_BF             0x01
#define _SSPSTAT_UA             0x02
#define _SSPSTAT_R_NOT_W        0x04
#define _SSPSTAT_S              0x08
#define _SSPSTAT_P              0x10
#define _SSPSTAT_D_NOT_A        0x20
#define _SSPSTAT_CKE            0x40
#define _SSPSTAT_SMP            0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0215) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0215) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSPCON Bits

extern __at(0x0215) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0215) volatile __SSPCONbits_t SSPCONbits;

#define _SSPCON_SSPM0           0x01
#define _SSPCON_SSPM1           0x02
#define _SSPCON_SSPM2           0x04
#define _SSPCON_SSPM3           0x08
#define _SSPCON_CKP             0x10
#define _SSPCON_SSPEN           0x20
#define _SSPCON_SSPOV           0x40
#define _SSPCON_WCOL            0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0215) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0215) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPCON1_SSPM0          0x01
#define _SSPCON1_SSPM1          0x02
#define _SSPCON1_SSPM2          0x04
#define _SSPCON1_SSPM3          0x08
#define _SSPCON1_CKP            0x10
#define _SSPCON1_SSPEN          0x20
#define _SSPCON1_SSPOV          0x40
#define _SSPCON1_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0216) __sfr SSP1CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP1CON2bits_t;

extern __at(0x0216) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0216) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0216) volatile __SSPCON2bits_t SSPCON2bits;

#define _SSPCON2_SEN            0x01
#define _SSPCON2_RSEN           0x02
#define _SSPCON2_PEN            0x04
#define _SSPCON2_RCEN           0x08
#define _SSPCON2_ACKEN          0x10
#define _SSPCON2_ACKDT          0x20
#define _SSPCON2_ACKSTAT        0x40
#define _SSPCON2_GCEN           0x80

//==============================================================================


//==============================================================================
//        SSP1CON3 Bits

extern __at(0x0217) __sfr SSP1CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP1CON3bits_t;

extern __at(0x0217) volatile __SSP1CON3bits_t SSP1CON3bits;

#define _DHEN                   0x01
#define _AHEN                   0x02
#define _SBCDE                  0x04
#define _SDAHT                  0x08
#define _BOEN                   0x10
#define _SCIE                   0x20
#define _PCIE                   0x40
#define _ACKTIM                 0x80

//==============================================================================


//==============================================================================
//        SSPCON3 Bits

extern __at(0x0217) __sfr SSPCON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSPCON3bits_t;

extern __at(0x0217) volatile __SSPCON3bits_t SSPCON3bits;

#define _SSPCON3_DHEN           0x01
#define _SSPCON3_AHEN           0x02
#define _SSPCON3_SBCDE          0x04
#define _SSPCON3_SDAHT          0x08
#define _SSPCON3_BOEN           0x10
#define _SSPCON3_SCIE           0x20
#define _SSPCON3_PCIE           0x40
#define _SSPCON3_ACKTIM         0x80

//==============================================================================

extern __at(0x0219) __sfr SSP2BUF;
extern __at(0x021A) __sfr SSP2ADD;
extern __at(0x021B) __sfr SSP2MSK;

//==============================================================================
//        SSP2STAT Bits

extern __at(0x021C) __sfr SSP2STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP2STATbits_t;

extern __at(0x021C) volatile __SSP2STATbits_t SSP2STATbits;

#define _SSP2STAT_BF            0x01
#define _SSP2STAT_UA            0x02
#define _SSP2STAT_R_NOT_W       0x04
#define _SSP2STAT_S             0x08
#define _SSP2STAT_P             0x10
#define _SSP2STAT_D_NOT_A       0x20
#define _SSP2STAT_CKE           0x40
#define _SSP2STAT_SMP           0x80

//==============================================================================


//==============================================================================
//        SSP2CON1 Bits

extern __at(0x021D) __sfr SSP2CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP2CON1bits_t;

extern __at(0x021D) volatile __SSP2CON1bits_t SSP2CON1bits;

#define _SSP2CON1_SSPM0         0x01
#define _SSP2CON1_SSPM1         0x02
#define _SSP2CON1_SSPM2         0x04
#define _SSP2CON1_SSPM3         0x08
#define _SSP2CON1_CKP           0x10
#define _SSP2CON1_SSPEN         0x20
#define _SSP2CON1_SSPOV         0x40
#define _SSP2CON1_WCOL          0x80

//==============================================================================


//==============================================================================
//        SSP2CON2 Bits

extern __at(0x021E) __sfr SSP2CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP2CON2bits_t;

extern __at(0x021E) volatile __SSP2CON2bits_t SSP2CON2bits;

#define _SSP2CON2_SEN           0x01
#define _SSP2CON2_RSEN          0x02
#define _SSP2CON2_PEN           0x04
#define _SSP2CON2_RCEN          0x08
#define _SSP2CON2_ACKEN         0x10
#define _SSP2CON2_ACKDT         0x20
#define _SSP2CON2_ACKSTAT       0x40
#define _SSP2CON2_GCEN          0x80

//==============================================================================


//==============================================================================
//        SSP2CON3 Bits

extern __at(0x021F) __sfr SSP2CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP2CON3bits_t;

extern __at(0x021F) volatile __SSP2CON3bits_t SSP2CON3bits;

#define _SSP2CON3_DHEN          0x01
#define _SSP2CON3_AHEN          0x02
#define _SSP2CON3_SBCDE         0x04
#define _SSP2CON3_SDAHT         0x08
#define _SSP2CON3_BOEN          0x10
#define _SSP2CON3_SCIE          0x20
#define _SSP2CON3_PCIE          0x40
#define _SSP2CON3_ACKTIM        0x80

//==============================================================================


//==============================================================================
//        PORTF Bits

extern __at(0x028C) __sfr PORTF;

typedef union
  {
  struct
    {
    unsigned RF0                : 1;
    unsigned RF1                : 1;
    unsigned RF2                : 1;
    unsigned RF3                : 1;
    unsigned RF4                : 1;
    unsigned RF5                : 1;
    unsigned RF6                : 1;
    unsigned RF7                : 1;
    };

  struct
    {
    unsigned AN16               : 1;
    unsigned AN6                : 1;
    unsigned AN7                : 1;
    unsigned AN8                : 1;
    unsigned AN9                : 1;
    unsigned AN10               : 1;
    unsigned AN11               : 1;
    unsigned AN5                : 1;
    };

  struct
    {
    unsigned SEG41              : 1;
    unsigned SEG19              : 1;
    unsigned SEG20              : 1;
    unsigned SEG21              : 1;
    unsigned SEG22              : 1;
    unsigned SEG23              : 1;
    unsigned SEG24              : 1;
    unsigned SEG25              : 1;
    };

  struct
    {
    unsigned CPS16              : 1;
    unsigned CPS6               : 1;
    unsigned CPS7               : 1;
    unsigned CPS8               : 1;
    unsigned CPS9               : 1;
    unsigned CPS10              : 1;
    unsigned CPS11              : 1;
    unsigned CPS5               : 1;
    };

  struct
    {
    unsigned C1IN0N             : 1;
    unsigned C2OUT              : 1;
    unsigned C1OUT              : 1;
    unsigned C1IN2N             : 1;
    unsigned C2INP              : 1;
    unsigned C1IN1N             : 1;
    unsigned C1INP              : 1;
    unsigned C1IN3N             : 1;
    };

  struct
    {
    unsigned C2IN0N             : 1;
    unsigned SRNQ               : 1;
    unsigned SRQ                : 1;
    unsigned C2IN2N             : 1;
    unsigned                    : 1;
    unsigned C2IN1N             : 1;
    unsigned                    : 1;
    unsigned C2IN3N             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned C3IN2N             : 1;
    unsigned                    : 1;
    unsigned DACOUT             : 1;
    unsigned                    : 1;
    unsigned C3IN3N             : 1;
    };
  } __PORTFbits_t;

extern __at(0x028C) volatile __PORTFbits_t PORTFbits;

#define _PORTF_RF0              0x01
#define _PORTF_AN16             0x01
#define _PORTF_SEG41            0x01
#define _PORTF_CPS16            0x01
#define _PORTF_C1IN0N           0x01
#define _PORTF_C2IN0N           0x01
#define _PORTF_RF1              0x02
#define _PORTF_AN6              0x02
#define _PORTF_SEG19            0x02
#define _PORTF_CPS6             0x02
#define _PORTF_C2OUT            0x02
#define _PORTF_SRNQ             0x02
#define _PORTF_RF2              0x04
#define _PORTF_AN7              0x04
#define _PORTF_SEG20            0x04
#define _PORTF_CPS7             0x04
#define _PORTF_C1OUT            0x04
#define _PORTF_SRQ              0x04
#define _PORTF_RF3              0x08
#define _PORTF_AN8              0x08
#define _PORTF_SEG21            0x08
#define _PORTF_CPS8             0x08
#define _PORTF_C1IN2N           0x08
#define _PORTF_C2IN2N           0x08
#define _PORTF_C3IN2N           0x08
#define _PORTF_RF4              0x10
#define _PORTF_AN9              0x10
#define _PORTF_SEG22            0x10
#define _PORTF_CPS9             0x10
#define _PORTF_C2INP            0x10
#define _PORTF_RF5              0x20
#define _PORTF_AN10             0x20
#define _PORTF_SEG23            0x20
#define _PORTF_CPS10            0x20
#define _PORTF_C1IN1N           0x20
#define _PORTF_C2IN1N           0x20
#define _PORTF_DACOUT           0x20
#define _PORTF_RF6              0x40
#define _PORTF_AN11             0x40
#define _PORTF_SEG24            0x40
#define _PORTF_CPS11            0x40
#define _PORTF_C1INP            0x40
#define _PORTF_RF7              0x80
#define _PORTF_AN5              0x80
#define _PORTF_SEG25            0x80
#define _PORTF_CPS5             0x80
#define _PORTF_C1IN3N           0x80
#define _PORTF_C2IN3N           0x80
#define _PORTF_C3IN3N           0x80

//==============================================================================


//==============================================================================
//        PORTG Bits

extern __at(0x028D) __sfr PORTG;

typedef union
  {
  struct
    {
    unsigned RG0                : 1;
    unsigned RG1                : 1;
    unsigned RG2                : 1;
    unsigned RG3                : 1;
    unsigned RG4                : 1;
    unsigned RG5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SEG42              : 1;
    unsigned AN15               : 1;
    unsigned AN14               : 1;
    unsigned AN13               : 1;
    unsigned AN12               : 1;
    unsigned NOT_MCLR           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP3               : 1;
    unsigned SEG43              : 1;
    unsigned SEG44              : 1;
    unsigned SEG45              : 1;
    unsigned SEG26              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned P3A                : 1;
    unsigned CPS15              : 1;
    unsigned CPS14              : 1;
    unsigned CPS13              : 1;
    unsigned CPS12              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned C3OUT              : 1;
    unsigned C3INP              : 1;
    unsigned C3IN0N             : 1;
    unsigned C3IN1N             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned TX2                : 1;
    unsigned RX2                : 1;
    unsigned CCP4               : 1;
    unsigned CCP5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned CK2                : 1;
    unsigned DT2                : 1;
    unsigned P3D                : 1;
    unsigned P1D                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG                 : 6;
    unsigned                    : 2;
    };
  } __PORTGbits_t;

extern __at(0x028D) volatile __PORTGbits_t PORTGbits;

#define _PORTG_RG0              0x01
#define _PORTG_SEG42            0x01
#define _PORTG_CCP3             0x01
#define _PORTG_P3A              0x01
#define _PORTG_RG1              0x02
#define _PORTG_AN15             0x02
#define _PORTG_SEG43            0x02
#define _PORTG_CPS15            0x02
#define _PORTG_C3OUT            0x02
#define _PORTG_TX2              0x02
#define _PORTG_CK2              0x02
#define _PORTG_RG2              0x04
#define _PORTG_AN14             0x04
#define _PORTG_SEG44            0x04
#define _PORTG_CPS14            0x04
#define _PORTG_C3INP            0x04
#define _PORTG_RX2              0x04
#define _PORTG_DT2              0x04
#define _PORTG_RG3              0x08
#define _PORTG_AN13             0x08
#define _PORTG_SEG45            0x08
#define _PORTG_CPS13            0x08
#define _PORTG_C3IN0N           0x08
#define _PORTG_CCP4             0x08
#define _PORTG_P3D              0x08
#define _PORTG_RG4              0x10
#define _PORTG_AN12             0x10
#define _PORTG_SEG26            0x10
#define _PORTG_CPS12            0x10
#define _PORTG_C3IN1N           0x10
#define _PORTG_CCP5             0x10
#define _PORTG_P1D              0x10
#define _PORTG_RG5              0x20
#define _PORTG_NOT_MCLR         0x20

//==============================================================================

extern __at(0x0291) __sfr CCPR1;
extern __at(0x0291) __sfr CCPR1L;
extern __at(0x0292) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0293) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned P1M0               : 1;
    unsigned P1M1               : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P1M                : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0293) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _DC1B1                  0x20
#define _P1M0                   0x40
#define _P1M1                   0x80

//==============================================================================


//==============================================================================
//        PWM1CON Bits

extern __at(0x0294) __sfr PWM1CON;

typedef union
  {
  struct
    {
    unsigned P1DC0              : 1;
    unsigned P1DC1              : 1;
    unsigned P1DC2              : 1;
    unsigned P1DC3              : 1;
    unsigned P1DC4              : 1;
    unsigned P1DC5              : 1;
    unsigned P1DC6              : 1;
    unsigned P1RSEN             : 1;
    };

  struct
    {
    unsigned P1DC               : 7;
    unsigned                    : 1;
    };
  } __PWM1CONbits_t;

extern __at(0x0294) volatile __PWM1CONbits_t PWM1CONbits;

#define _P1DC0                  0x01
#define _P1DC1                  0x02
#define _P1DC2                  0x04
#define _P1DC3                  0x08
#define _P1DC4                  0x10
#define _P1DC5                  0x20
#define _P1DC6                  0x40
#define _P1RSEN                 0x80

//==============================================================================


//==============================================================================
//        CCP1AS Bits

extern __at(0x0295) __sfr CCP1AS;

typedef union
  {
  struct
    {
    unsigned PSS1BD0            : 1;
    unsigned PSS1BD1            : 1;
    unsigned PSS1AC0            : 1;
    unsigned PSS1AC1            : 1;
    unsigned CCP1AS0            : 1;
    unsigned CCP1AS1            : 1;
    unsigned CCP1AS2            : 1;
    unsigned CCP1ASE            : 1;
    };

  struct
    {
    unsigned PSS1BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS1AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CCP1AS             : 3;
    unsigned                    : 1;
    };
  } __CCP1ASbits_t;

extern __at(0x0295) volatile __CCP1ASbits_t CCP1ASbits;

#define _PSS1BD0                0x01
#define _PSS1BD1                0x02
#define _PSS1AC0                0x04
#define _PSS1AC1                0x08
#define _CCP1AS0                0x10
#define _CCP1AS1                0x20
#define _CCP1AS2                0x40
#define _CCP1ASE                0x80

//==============================================================================


//==============================================================================
//        ECCP1AS Bits

extern __at(0x0295) __sfr ECCP1AS;

typedef union
  {
  struct
    {
    unsigned PSS1BD0            : 1;
    unsigned PSS1BD1            : 1;
    unsigned PSS1AC0            : 1;
    unsigned PSS1AC1            : 1;
    unsigned CCP1AS0            : 1;
    unsigned CCP1AS1            : 1;
    unsigned CCP1AS2            : 1;
    unsigned CCP1ASE            : 1;
    };

  struct
    {
    unsigned PSS1BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS1AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CCP1AS             : 3;
    unsigned                    : 1;
    };
  } __ECCP1ASbits_t;

extern __at(0x0295) volatile __ECCP1ASbits_t ECCP1ASbits;

#define _ECCP1AS_PSS1BD0        0x01
#define _ECCP1AS_PSS1BD1        0x02
#define _ECCP1AS_PSS1AC0        0x04
#define _ECCP1AS_PSS1AC1        0x08
#define _ECCP1AS_CCP1AS0        0x10
#define _ECCP1AS_CCP1AS1        0x20
#define _ECCP1AS_CCP1AS2        0x40
#define _ECCP1AS_CCP1ASE        0x80

//==============================================================================


//==============================================================================
//        PSTR1CON Bits

extern __at(0x0296) __sfr PSTR1CON;

typedef struct
  {
  unsigned STR1A                : 1;
  unsigned STR1B                : 1;
  unsigned STR1C                : 1;
  unsigned STR1D                : 1;
  unsigned STR1SYNC             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSTR1CONbits_t;

extern __at(0x0296) volatile __PSTR1CONbits_t PSTR1CONbits;

#define _STR1A                  0x01
#define _STR1B                  0x02
#define _STR1C                  0x04
#define _STR1D                  0x08
#define _STR1SYNC               0x10

//==============================================================================

extern __at(0x0298) __sfr CCPR2;
extern __at(0x0298) __sfr CCPR2L;
extern __at(0x0299) __sfr CCPR2H;

//==============================================================================
//        CCP2CON Bits

extern __at(0x029A) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned P2M0               : 1;
    unsigned P2M1               : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P2M                : 2;
    };
  } __CCP2CONbits_t;

extern __at(0x029A) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2M0                 0x01
#define _CCP2M1                 0x02
#define _CCP2M2                 0x04
#define _CCP2M3                 0x08
#define _DC2B0                  0x10
#define _DC2B1                  0x20
#define _P2M0                   0x40
#define _P2M1                   0x80

//==============================================================================


//==============================================================================
//        PWM2CON Bits

extern __at(0x029B) __sfr PWM2CON;

typedef union
  {
  struct
    {
    unsigned P2DC0              : 1;
    unsigned P2DC1              : 1;
    unsigned P2DC2              : 1;
    unsigned P2DC3              : 1;
    unsigned P2DC4              : 1;
    unsigned P2DC5              : 1;
    unsigned P2DC6              : 1;
    unsigned P2RSEN             : 1;
    };

  struct
    {
    unsigned P2DC               : 7;
    unsigned                    : 1;
    };
  } __PWM2CONbits_t;

extern __at(0x029B) volatile __PWM2CONbits_t PWM2CONbits;

#define _P2DC0                  0x01
#define _P2DC1                  0x02
#define _P2DC2                  0x04
#define _P2DC3                  0x08
#define _P2DC4                  0x10
#define _P2DC5                  0x20
#define _P2DC6                  0x40
#define _P2RSEN                 0x80

//==============================================================================


//==============================================================================
//        CCP2AS Bits

extern __at(0x029C) __sfr CCP2AS;

typedef union
  {
  struct
    {
    unsigned PSS2BD0            : 1;
    unsigned PSS2BD1            : 1;
    unsigned PSS2AC0            : 1;
    unsigned PSS2AC1            : 1;
    unsigned CCP2AS0            : 1;
    unsigned CCP2AS1            : 1;
    unsigned CCP2AS2            : 1;
    unsigned CCP2ASE            : 1;
    };

  struct
    {
    unsigned PSS2BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS2AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CCP2AS             : 3;
    unsigned                    : 1;
    };
  } __CCP2ASbits_t;

extern __at(0x029C) volatile __CCP2ASbits_t CCP2ASbits;

#define _PSS2BD0                0x01
#define _PSS2BD1                0x02
#define _PSS2AC0                0x04
#define _PSS2AC1                0x08
#define _CCP2AS0                0x10
#define _CCP2AS1                0x20
#define _CCP2AS2                0x40
#define _CCP2ASE                0x80

//==============================================================================


//==============================================================================
//        ECCP2AS Bits

extern __at(0x029C) __sfr ECCP2AS;

typedef union
  {
  struct
    {
    unsigned PSS2BD0            : 1;
    unsigned PSS2BD1            : 1;
    unsigned PSS2AC0            : 1;
    unsigned PSS2AC1            : 1;
    unsigned CCP2AS0            : 1;
    unsigned CCP2AS1            : 1;
    unsigned CCP2AS2            : 1;
    unsigned CCP2ASE            : 1;
    };

  struct
    {
    unsigned PSS2BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS2AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CCP2AS             : 3;
    unsigned                    : 1;
    };
  } __ECCP2ASbits_t;

extern __at(0x029C) volatile __ECCP2ASbits_t ECCP2ASbits;

#define _ECCP2AS_PSS2BD0        0x01
#define _ECCP2AS_PSS2BD1        0x02
#define _ECCP2AS_PSS2AC0        0x04
#define _ECCP2AS_PSS2AC1        0x08
#define _ECCP2AS_CCP2AS0        0x10
#define _ECCP2AS_CCP2AS1        0x20
#define _ECCP2AS_CCP2AS2        0x40
#define _ECCP2AS_CCP2ASE        0x80

//==============================================================================


//==============================================================================
//        PSTR2CON Bits

extern __at(0x029D) __sfr PSTR2CON;

typedef struct
  {
  unsigned STR2A                : 1;
  unsigned STR2B                : 1;
  unsigned STR2C                : 1;
  unsigned STR2D                : 1;
  unsigned STR2SYNC             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSTR2CONbits_t;

extern __at(0x029D) volatile __PSTR2CONbits_t PSTR2CONbits;

#define _STR2A                  0x01
#define _STR2B                  0x02
#define _STR2C                  0x04
#define _STR2D                  0x08
#define _STR2SYNC               0x10

//==============================================================================


//==============================================================================
//        CCPTMRS0 Bits

extern __at(0x029E) __sfr CCPTMRS0;

typedef union
  {
  struct
    {
    unsigned C1TSEL0            : 1;
    unsigned C1TSEL1            : 1;
    unsigned C2TSEL0            : 1;
    unsigned C2TSEL1            : 1;
    unsigned C3TSEL0            : 1;
    unsigned C3TSEL1            : 1;
    unsigned C4TSEL0            : 1;
    unsigned C4TSEL1            : 1;
    };

  struct
    {
    unsigned C1TSEL             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned C2TSEL             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned C3TSEL             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned C4TSEL             : 2;
    };
  } __CCPTMRS0bits_t;

extern __at(0x029E) volatile __CCPTMRS0bits_t CCPTMRS0bits;

#define _C1TSEL0                0x01
#define _C1TSEL1                0x02
#define _C2TSEL0                0x04
#define _C2TSEL1                0x08
#define _C3TSEL0                0x10
#define _C3TSEL1                0x20
#define _C4TSEL0                0x40
#define _C4TSEL1                0x80

//==============================================================================


//==============================================================================
//        CCPTMRS1 Bits

extern __at(0x029F) __sfr CCPTMRS1;

typedef union
  {
  struct
    {
    unsigned C5TSEL0            : 1;
    unsigned C5TSEL1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C5TSEL             : 2;
    unsigned                    : 6;
    };
  } __CCPTMRS1bits_t;

extern __at(0x029F) volatile __CCPTMRS1bits_t CCPTMRS1bits;

#define _C5TSEL0                0x01
#define _C5TSEL1                0x02

//==============================================================================


//==============================================================================
//        TRISF Bits

extern __at(0x030C) __sfr TRISF;

typedef struct
  {
  unsigned TRISF0               : 1;
  unsigned TRISF1               : 1;
  unsigned TRISF2               : 1;
  unsigned TRISF3               : 1;
  unsigned TRISF4               : 1;
  unsigned TRISF5               : 1;
  unsigned TRISF6               : 1;
  unsigned TRISF7               : 1;
  } __TRISFbits_t;

extern __at(0x030C) volatile __TRISFbits_t TRISFbits;

#define _TRISF0                 0x01
#define _TRISF1                 0x02
#define _TRISF2                 0x04
#define _TRISF3                 0x08
#define _TRISF4                 0x10
#define _TRISF5                 0x20
#define _TRISF6                 0x40
#define _TRISF7                 0x80

//==============================================================================


//==============================================================================
//        TRISG Bits

extern __at(0x030D) __sfr TRISG;

typedef union
  {
  struct
    {
    unsigned TRISG0             : 1;
    unsigned TRISG1             : 1;
    unsigned TRISG2             : 1;
    unsigned TRISG3             : 1;
    unsigned TRISG4             : 1;
    unsigned TRISG5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISG              : 6;
    unsigned                    : 2;
    };
  } __TRISGbits_t;

extern __at(0x030D) volatile __TRISGbits_t TRISGbits;

#define _TRISG0                 0x01
#define _TRISG1                 0x02
#define _TRISG2                 0x04
#define _TRISG3                 0x08
#define _TRISG4                 0x10
#define _TRISG5                 0x20

//==============================================================================

extern __at(0x0311) __sfr CCPR3;
extern __at(0x0311) __sfr CCPR3L;
extern __at(0x0312) __sfr CCPR3H;

//==============================================================================
//        CCP3CON Bits

extern __at(0x0313) __sfr CCP3CON;

typedef union
  {
  struct
    {
    unsigned CCP3M0             : 1;
    unsigned CCP3M1             : 1;
    unsigned CCP3M2             : 1;
    unsigned CCP3M3             : 1;
    unsigned DC3B0              : 1;
    unsigned DC3B1              : 1;
    unsigned P3M0               : 1;
    unsigned P3M1               : 1;
    };

  struct
    {
    unsigned CCP3M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC3B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P3M                : 2;
    };
  } __CCP3CONbits_t;

extern __at(0x0313) volatile __CCP3CONbits_t CCP3CONbits;

#define _CCP3M0                 0x01
#define _CCP3M1                 0x02
#define _CCP3M2                 0x04
#define _CCP3M3                 0x08
#define _DC3B0                  0x10
#define _DC3B1                  0x20
#define _P3M0                   0x40
#define _P3M1                   0x80

//==============================================================================


//==============================================================================
//        PWM3CON Bits

extern __at(0x0314) __sfr PWM3CON;

typedef union
  {
  struct
    {
    unsigned P3DC0              : 1;
    unsigned P3DC1              : 1;
    unsigned P3DC2              : 1;
    unsigned P3DC3              : 1;
    unsigned P3DC4              : 1;
    unsigned P3DC5              : 1;
    unsigned P3DC6              : 1;
    unsigned P3RSEN             : 1;
    };

  struct
    {
    unsigned P3DC               : 7;
    unsigned                    : 1;
    };
  } __PWM3CONbits_t;

extern __at(0x0314) volatile __PWM3CONbits_t PWM3CONbits;

#define _P3DC0                  0x01
#define _P3DC1                  0x02
#define _P3DC2                  0x04
#define _P3DC3                  0x08
#define _P3DC4                  0x10
#define _P3DC5                  0x20
#define _P3DC6                  0x40
#define _P3RSEN                 0x80

//==============================================================================


//==============================================================================
//        CCP3AS Bits

extern __at(0x0315) __sfr CCP3AS;

typedef union
  {
  struct
    {
    unsigned PSS3BD0            : 1;
    unsigned PSS3BD1            : 1;
    unsigned PSS3AC0            : 1;
    unsigned PSS3AC1            : 1;
    unsigned CCP3AS0            : 1;
    unsigned CCP3AS1            : 1;
    unsigned CCP3AS2            : 1;
    unsigned CCP3ASE            : 1;
    };

  struct
    {
    unsigned PSS3BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS3AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CCP3AS             : 3;
    unsigned                    : 1;
    };
  } __CCP3ASbits_t;

extern __at(0x0315) volatile __CCP3ASbits_t CCP3ASbits;

#define _PSS3BD0                0x01
#define _PSS3BD1                0x02
#define _PSS3AC0                0x04
#define _PSS3AC1                0x08
#define _CCP3AS0                0x10
#define _CCP3AS1                0x20
#define _CCP3AS2                0x40
#define _CCP3ASE                0x80

//==============================================================================


//==============================================================================
//        ECCP3AS Bits

extern __at(0x0315) __sfr ECCP3AS;

typedef union
  {
  struct
    {
    unsigned PSS3BD0            : 1;
    unsigned PSS3BD1            : 1;
    unsigned PSS3AC0            : 1;
    unsigned PSS3AC1            : 1;
    unsigned CCP3AS0            : 1;
    unsigned CCP3AS1            : 1;
    unsigned CCP3AS2            : 1;
    unsigned CCP3ASE            : 1;
    };

  struct
    {
    unsigned PSS3BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS3AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CCP3AS             : 3;
    unsigned                    : 1;
    };
  } __ECCP3ASbits_t;

extern __at(0x0315) volatile __ECCP3ASbits_t ECCP3ASbits;

#define _ECCP3AS_PSS3BD0        0x01
#define _ECCP3AS_PSS3BD1        0x02
#define _ECCP3AS_PSS3AC0        0x04
#define _ECCP3AS_PSS3AC1        0x08
#define _ECCP3AS_CCP3AS0        0x10
#define _ECCP3AS_CCP3AS1        0x20
#define _ECCP3AS_CCP3AS2        0x40
#define _ECCP3AS_CCP3ASE        0x80

//==============================================================================


//==============================================================================
//        PSTR3CON Bits

extern __at(0x0316) __sfr PSTR3CON;

typedef struct
  {
  unsigned STR3A                : 1;
  unsigned STR3B                : 1;
  unsigned STR3C                : 1;
  unsigned STR3D                : 1;
  unsigned STR3SYNC             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSTR3CONbits_t;

extern __at(0x0316) volatile __PSTR3CONbits_t PSTR3CONbits;

#define _STR3A                  0x01
#define _STR3B                  0x02
#define _STR3C                  0x04
#define _STR3D                  0x08
#define _STR3SYNC               0x10

//==============================================================================

extern __at(0x0318) __sfr CCPR4;
extern __at(0x0318) __sfr CCPR4L;
extern __at(0x0319) __sfr CCPR4H;

//==============================================================================
//        CCP4CON Bits

extern __at(0x031A) __sfr CCP4CON;

typedef union
  {
  struct
    {
    unsigned CCP4M0             : 1;
    unsigned CCP4M1             : 1;
    unsigned CCP4M2             : 1;
    unsigned CCP4M3             : 1;
    unsigned DC4B0              : 1;
    unsigned DC4B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP4M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC4B               : 2;
    unsigned                    : 2;
    };
  } __CCP4CONbits_t;

extern __at(0x031A) volatile __CCP4CONbits_t CCP4CONbits;

#define _CCP4M0                 0x01
#define _CCP4M1                 0x02
#define _CCP4M2                 0x04
#define _CCP4M3                 0x08
#define _DC4B0                  0x10
#define _DC4B1                  0x20

//==============================================================================

extern __at(0x031C) __sfr CCPR5;
extern __at(0x031C) __sfr CCPR5L;
extern __at(0x031D) __sfr CCPR5H;

//==============================================================================
//        CCP5CON Bits

extern __at(0x031E) __sfr CCP5CON;

typedef union
  {
  struct
    {
    unsigned CCP5M0             : 1;
    unsigned CCP5M1             : 1;
    unsigned CCP5M2             : 1;
    unsigned CCP5M3             : 1;
    unsigned DC5B0              : 1;
    unsigned DC5B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP5M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC5B               : 2;
    unsigned                    : 2;
    };
  } __CCP5CONbits_t;

extern __at(0x031E) volatile __CCP5CONbits_t CCP5CONbits;

#define _CCP5M0                 0x01
#define _CCP5M1                 0x02
#define _CCP5M2                 0x04
#define _CCP5M3                 0x08
#define _DC5B0                  0x10
#define _DC5B1                  0x20

//==============================================================================


//==============================================================================
//        LATF Bits

extern __at(0x038C) __sfr LATF;

typedef struct
  {
  unsigned LATF0                : 1;
  unsigned LATF1                : 1;
  unsigned LATF2                : 1;
  unsigned LATF3                : 1;
  unsigned LATF4                : 1;
  unsigned LATF5                : 1;
  unsigned LATF6                : 1;
  unsigned LATF7                : 1;
  } __LATFbits_t;

extern __at(0x038C) volatile __LATFbits_t LATFbits;

#define _LATF0                  0x01
#define _LATF1                  0x02
#define _LATF2                  0x04
#define _LATF3                  0x08
#define _LATF4                  0x10
#define _LATF5                  0x20
#define _LATF6                  0x40
#define _LATF7                  0x80

//==============================================================================


//==============================================================================
//        LATG Bits

extern __at(0x038D) __sfr LATG;

typedef union
  {
  struct
    {
    unsigned LATG0              : 1;
    unsigned LATG1              : 1;
    unsigned LATG2              : 1;
    unsigned LATG3              : 1;
    unsigned LATG4              : 1;
    unsigned LATG5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATG               : 6;
    unsigned                    : 2;
    };
  } __LATGbits_t;

extern __at(0x038D) volatile __LATGbits_t LATGbits;

#define _LATG0                  0x01
#define _LATG1                  0x02
#define _LATG2                  0x04
#define _LATG3                  0x08
#define _LATG4                  0x10
#define _LATG5                  0x20

//==============================================================================


//==============================================================================
//        IOCBP Bits

extern __at(0x0394) __sfr IOCBP;

typedef struct
  {
  unsigned IOCBP0               : 1;
  unsigned IOCBP1               : 1;
  unsigned IOCBP2               : 1;
  unsigned IOCBP3               : 1;
  unsigned IOCBP4               : 1;
  unsigned IOCBP5               : 1;
  unsigned IOCBP6               : 1;
  unsigned IOCBP7               : 1;
  } __IOCBPbits_t;

extern __at(0x0394) volatile __IOCBPbits_t IOCBPbits;

#define _IOCBP0                 0x01
#define _IOCBP1                 0x02
#define _IOCBP2                 0x04
#define _IOCBP3                 0x08
#define _IOCBP4                 0x10
#define _IOCBP5                 0x20
#define _IOCBP6                 0x40
#define _IOCBP7                 0x80

//==============================================================================


//==============================================================================
//        IOCBN Bits

extern __at(0x0395) __sfr IOCBN;

typedef struct
  {
  unsigned IOCBN0               : 1;
  unsigned IOCBN1               : 1;
  unsigned IOCBN2               : 1;
  unsigned IOCBN3               : 1;
  unsigned IOCBN4               : 1;
  unsigned IOCBN5               : 1;
  unsigned IOCBN6               : 1;
  unsigned IOCBN7               : 1;
  } __IOCBNbits_t;

extern __at(0x0395) volatile __IOCBNbits_t IOCBNbits;

#define _IOCBN0                 0x01
#define _IOCBN1                 0x02
#define _IOCBN2                 0x04
#define _IOCBN3                 0x08
#define _IOCBN4                 0x10
#define _IOCBN5                 0x20
#define _IOCBN6                 0x40
#define _IOCBN7                 0x80

//==============================================================================


//==============================================================================
//        IOCBF Bits

extern __at(0x0396) __sfr IOCBF;

typedef struct
  {
  unsigned IOCBF0               : 1;
  unsigned IOCBF1               : 1;
  unsigned IOCBF2               : 1;
  unsigned IOCBF3               : 1;
  unsigned IOCBF4               : 1;
  unsigned IOCBF5               : 1;
  unsigned IOCBF6               : 1;
  unsigned IOCBF7               : 1;
  } __IOCBFbits_t;

extern __at(0x0396) volatile __IOCBFbits_t IOCBFbits;

#define _IOCBF0                 0x01
#define _IOCBF1                 0x02
#define _IOCBF2                 0x04
#define _IOCBF3                 0x08
#define _IOCBF4                 0x10
#define _IOCBF5                 0x20
#define _IOCBF6                 0x40
#define _IOCBF7                 0x80

//==============================================================================


//==============================================================================
//        ANSELF Bits

extern __at(0x040C) __sfr ANSELF;

typedef struct
  {
  unsigned ANSF0                : 1;
  unsigned ANSF1                : 1;
  unsigned ANSF2                : 1;
  unsigned ANSF3                : 1;
  unsigned ANSF4                : 1;
  unsigned ANSF5                : 1;
  unsigned ANSF6                : 1;
  unsigned ANSF7                : 1;
  } __ANSELFbits_t;

extern __at(0x040C) volatile __ANSELFbits_t ANSELFbits;

#define _ANSF0                  0x01
#define _ANSF1                  0x02
#define _ANSF2                  0x04
#define _ANSF3                  0x08
#define _ANSF4                  0x10
#define _ANSF5                  0x20
#define _ANSF6                  0x40
#define _ANSF7                  0x80

//==============================================================================


//==============================================================================
//        ANSELG Bits

extern __at(0x040D) __sfr ANSELG;

typedef struct
  {
  unsigned                      : 1;
  unsigned ANSG1                : 1;
  unsigned ANSG2                : 1;
  unsigned ANSG3                : 1;
  unsigned ANSG4                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELGbits_t;

extern __at(0x040D) volatile __ANSELGbits_t ANSELGbits;

#define _ANSG1                  0x02
#define _ANSG2                  0x04
#define _ANSG3                  0x08
#define _ANSG4                  0x10

//==============================================================================

extern __at(0x0415) __sfr TMR4;
extern __at(0x0416) __sfr PR4;

//==============================================================================
//        T4CON Bits

extern __at(0x0417) __sfr T4CON;

typedef union
  {
  struct
    {
    unsigned T4CKPS0            : 1;
    unsigned T4CKPS1            : 1;
    unsigned TMR4ON             : 1;
    unsigned T4OUTPS0           : 1;
    unsigned T4OUTPS1           : 1;
    unsigned T4OUTPS2           : 1;
    unsigned T4OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T4OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T4CONbits_t;

extern __at(0x0417) volatile __T4CONbits_t T4CONbits;

#define _T4CKPS0                0x01
#define _T4CKPS1                0x02
#define _TMR4ON                 0x04
#define _T4OUTPS0               0x08
#define _T4OUTPS1               0x10
#define _T4OUTPS2               0x20
#define _T4OUTPS3               0x40

//==============================================================================

extern __at(0x041C) __sfr TMR6;
extern __at(0x041D) __sfr PR6;

//==============================================================================
//        T6CON Bits

extern __at(0x041E) __sfr T6CON;

typedef union
  {
  struct
    {
    unsigned T6CKPS0            : 1;
    unsigned T6CKPS1            : 1;
    unsigned TMR6ON             : 1;
    unsigned T6OUTPS0           : 1;
    unsigned T6OUTPS1           : 1;
    unsigned T6OUTPS2           : 1;
    unsigned T6OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T6OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T6CONbits_t;

extern __at(0x041E) volatile __T6CONbits_t T6CONbits;

#define _T6CKPS0                0x01
#define _T6CKPS1                0x02
#define _TMR6ON                 0x04
#define _T6OUTPS0               0x08
#define _T6OUTPS1               0x10
#define _T6OUTPS2               0x20
#define _T6OUTPS3               0x40

//==============================================================================


//==============================================================================
//        WPUG Bits

extern __at(0x048D) __sfr WPUG;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned WPUG5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __WPUGbits_t;

extern __at(0x048D) volatile __WPUGbits_t WPUGbits;

#define _WPUG5                  0x20

//==============================================================================

extern __at(0x0491) __sfr RC2REG;
extern __at(0x0492) __sfr TX2REG;
extern __at(0x0493) __sfr SP2BRGL;
extern __at(0x0493) __sfr SPBRG2;
extern __at(0x0494) __sfr SP2BRGH;

//==============================================================================
//        RC2STA Bits

extern __at(0x0495) __sfr RC2STA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RC2STAbits_t;

extern __at(0x0495) volatile __RC2STAbits_t RC2STAbits;

#define _RC2STA_RX9D            0x01
#define _RC2STA_OERR            0x02
#define _RC2STA_FERR            0x04
#define _RC2STA_ADDEN           0x08
#define _RC2STA_CREN            0x10
#define _RC2STA_SREN            0x20
#define _RC2STA_RX9             0x40
#define _RC2STA_SPEN            0x80

//==============================================================================


//==============================================================================
//        TX2STA Bits

extern __at(0x0496) __sfr TX2STA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TX2STAbits_t;

extern __at(0x0496) volatile __TX2STAbits_t TX2STAbits;

#define _TX2STA_TX9D            0x01
#define _TX2STA_TRMT            0x02
#define _TX2STA_BRGH            0x04
#define _TX2STA_SENDB           0x08
#define _TX2STA_SYNC            0x10
#define _TX2STA_TXEN            0x20
#define _TX2STA_TX9             0x40
#define _TX2STA_CSRC            0x80

//==============================================================================


//==============================================================================
//        BAUD2CON Bits

extern __at(0x0497) __sfr BAUD2CON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUD2CONbits_t;

extern __at(0x0497) volatile __BAUD2CONbits_t BAUD2CONbits;

#define _BAUD2CON_ABDEN         0x01
#define _BAUD2CON_WUE           0x02
#define _BAUD2CON_BRG16         0x08
#define _BAUD2CON_SCKP          0x10
#define _BAUD2CON_RCIDL         0x40
#define _BAUD2CON_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        LCDCON Bits

extern __at(0x0791) __sfr LCDCON;

typedef union
  {
  struct
    {
    unsigned LMUX0              : 1;
    unsigned LMUX1              : 1;
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned                    : 1;
    unsigned WERR               : 1;
    unsigned SLPEN              : 1;
    unsigned LCDEN              : 1;
    };

  struct
    {
    unsigned LMUX               : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CS                 : 2;
    unsigned                    : 4;
    };
  } __LCDCONbits_t;

extern __at(0x0791) volatile __LCDCONbits_t LCDCONbits;

#define _LMUX0                  0x01
#define _LMUX1                  0x02
#define _CS0                    0x04
#define _CS1                    0x08
#define _WERR                   0x20
#define _SLPEN                  0x40
#define _LCDEN                  0x80

//==============================================================================


//==============================================================================
//        LCDPS Bits

extern __at(0x0792) __sfr LCDPS;

typedef union
  {
  struct
    {
    unsigned LP0                : 1;
    unsigned LP1                : 1;
    unsigned LP2                : 1;
    unsigned LP3                : 1;
    unsigned WA                 : 1;
    unsigned LCDA               : 1;
    unsigned BIASMD             : 1;
    unsigned WFT                : 1;
    };

  struct
    {
    unsigned LP                 : 4;
    unsigned                    : 4;
    };
  } __LCDPSbits_t;

extern __at(0x0792) volatile __LCDPSbits_t LCDPSbits;

#define _LP0                    0x01
#define _LP1                    0x02
#define _LP2                    0x04
#define _LP3                    0x08
#define _WA                     0x10
#define _LCDA                   0x20
#define _BIASMD                 0x40
#define _WFT                    0x80

//==============================================================================


//==============================================================================
//        LCDREF Bits

extern __at(0x0793) __sfr LCDREF;

typedef struct
  {
  unsigned                      : 1;
  unsigned VLCD1PE              : 1;
  unsigned VLCD2PE              : 1;
  unsigned VLCD3PE              : 1;
  unsigned                      : 1;
  unsigned LCDIRI               : 1;
  unsigned LCDIRS               : 1;
  unsigned LCDIRE               : 1;
  } __LCDREFbits_t;

extern __at(0x0793) volatile __LCDREFbits_t LCDREFbits;

#define _VLCD1PE                0x02
#define _VLCD2PE                0x04
#define _VLCD3PE                0x08
#define _LCDIRI                 0x20
#define _LCDIRS                 0x40
#define _LCDIRE                 0x80

//==============================================================================


//==============================================================================
//        LCDCST Bits

extern __at(0x0794) __sfr LCDCST;

typedef union
  {
  struct
    {
    unsigned LCDCST0            : 1;
    unsigned LCDCST1            : 1;
    unsigned LCDCST2            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LCDCST             : 3;
    unsigned                    : 5;
    };
  } __LCDCSTbits_t;

extern __at(0x0794) volatile __LCDCSTbits_t LCDCSTbits;

#define _LCDCST0                0x01
#define _LCDCST1                0x02
#define _LCDCST2                0x04

//==============================================================================


//==============================================================================
//        LCDRL Bits

extern __at(0x0795) __sfr LCDRL;

typedef union
  {
  struct
    {
    unsigned LRLAT0             : 1;
    unsigned LRLAT1             : 1;
    unsigned LRLAT2             : 1;
    unsigned                    : 1;
    unsigned LRLBP0             : 1;
    unsigned LRLBP1             : 1;
    unsigned LRLAP0             : 1;
    unsigned LRLAP1             : 1;
    };

  struct
    {
    unsigned LRLAT              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned LRLBP              : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned LRLAP              : 2;
    };
  } __LCDRLbits_t;

extern __at(0x0795) volatile __LCDRLbits_t LCDRLbits;

#define _LRLAT0                 0x01
#define _LRLAT1                 0x02
#define _LRLAT2                 0x04
#define _LRLBP0                 0x10
#define _LRLBP1                 0x20
#define _LRLAP0                 0x40
#define _LRLAP1                 0x80

//==============================================================================


//==============================================================================
//        LCDSE0 Bits

extern __at(0x0798) __sfr LCDSE0;

typedef struct
  {
  unsigned SE0                  : 1;
  unsigned SE1                  : 1;
  unsigned SE2                  : 1;
  unsigned SE3                  : 1;
  unsigned SE4                  : 1;
  unsigned SE5                  : 1;
  unsigned SE6                  : 1;
  unsigned SE7                  : 1;
  } __LCDSE0bits_t;

extern __at(0x0798) volatile __LCDSE0bits_t LCDSE0bits;

#define _SE0                    0x01
#define _SE1                    0x02
#define _SE2                    0x04
#define _SE3                    0x08
#define _SE4                    0x10
#define _SE5                    0x20
#define _SE6                    0x40
#define _SE7                    0x80

//==============================================================================


//==============================================================================
//        LCDSE1 Bits

extern __at(0x0799) __sfr LCDSE1;

typedef struct
  {
  unsigned SE8                  : 1;
  unsigned SE9                  : 1;
  unsigned SE10                 : 1;
  unsigned SE11                 : 1;
  unsigned SE12                 : 1;
  unsigned SE13                 : 1;
  unsigned SE14                 : 1;
  unsigned SE15                 : 1;
  } __LCDSE1bits_t;

extern __at(0x0799) volatile __LCDSE1bits_t LCDSE1bits;

#define _SE8                    0x01
#define _SE9                    0x02
#define _SE10                   0x04
#define _SE11                   0x08
#define _SE12                   0x10
#define _SE13                   0x20
#define _SE14                   0x40
#define _SE15                   0x80

//==============================================================================


//==============================================================================
//        LCDSE2 Bits

extern __at(0x079A) __sfr LCDSE2;

typedef struct
  {
  unsigned SE16                 : 1;
  unsigned SE17                 : 1;
  unsigned SE18                 : 1;
  unsigned SE19                 : 1;
  unsigned SE20                 : 1;
  unsigned SE21                 : 1;
  unsigned SE22                 : 1;
  unsigned SE23                 : 1;
  } __LCDSE2bits_t;

extern __at(0x079A) volatile __LCDSE2bits_t LCDSE2bits;

#define _SE16                   0x01
#define _SE17                   0x02
#define _SE18                   0x04
#define _SE19                   0x08
#define _SE20                   0x10
#define _SE21                   0x20
#define _SE22                   0x40
#define _SE23                   0x80

//==============================================================================


//==============================================================================
//        LCDSE3 Bits

extern __at(0x079B) __sfr LCDSE3;

typedef struct
  {
  unsigned SE24                 : 1;
  unsigned SE25                 : 1;
  unsigned SE26                 : 1;
  unsigned SE27                 : 1;
  unsigned SE28                 : 1;
  unsigned SE29                 : 1;
  unsigned SE30                 : 1;
  unsigned SE31                 : 1;
  } __LCDSE3bits_t;

extern __at(0x079B) volatile __LCDSE3bits_t LCDSE3bits;

#define _SE24                   0x01
#define _SE25                   0x02
#define _SE26                   0x04
#define _SE27                   0x08
#define _SE28                   0x10
#define _SE29                   0x20
#define _SE30                   0x40
#define _SE31                   0x80

//==============================================================================


//==============================================================================
//        LCDSE4 Bits

extern __at(0x079C) __sfr LCDSE4;

typedef struct
  {
  unsigned SE32                 : 1;
  unsigned SE33                 : 1;
  unsigned SE34                 : 1;
  unsigned SE35                 : 1;
  unsigned SE36                 : 1;
  unsigned SE37                 : 1;
  unsigned SE38                 : 1;
  unsigned SE39                 : 1;
  } __LCDSE4bits_t;

extern __at(0x079C) volatile __LCDSE4bits_t LCDSE4bits;

#define _SE32                   0x01
#define _SE33                   0x02
#define _SE34                   0x04
#define _SE35                   0x08
#define _SE36                   0x10
#define _SE37                   0x20
#define _SE38                   0x40
#define _SE39                   0x80

//==============================================================================


//==============================================================================
//        LCDSE5 Bits

extern __at(0x079D) __sfr LCDSE5;

typedef struct
  {
  unsigned SE40                 : 1;
  unsigned SE41                 : 1;
  unsigned SE42                 : 1;
  unsigned SE43                 : 1;
  unsigned SE44                 : 1;
  unsigned SE45                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LCDSE5bits_t;

extern __at(0x079D) volatile __LCDSE5bits_t LCDSE5bits;

#define _SE40                   0x01
#define _SE41                   0x02
#define _SE42                   0x04
#define _SE43                   0x08
#define _SE44                   0x10
#define _SE45                   0x20

//==============================================================================


//==============================================================================
//        LCDDATA0 Bits

extern __at(0x07A0) __sfr LCDDATA0;

typedef struct
  {
  unsigned SEG0COM0             : 1;
  unsigned SEG1COM0             : 1;
  unsigned SEG2COM0             : 1;
  unsigned SEG3COM0             : 1;
  unsigned SEG4COM0             : 1;
  unsigned SEG5COM0             : 1;
  unsigned SEG6COM0             : 1;
  unsigned SEG7COM0             : 1;
  } __LCDDATA0bits_t;

extern __at(0x07A0) volatile __LCDDATA0bits_t LCDDATA0bits;

#define _SEG0COM0               0x01
#define _SEG1COM0               0x02
#define _SEG2COM0               0x04
#define _SEG3COM0               0x08
#define _SEG4COM0               0x10
#define _SEG5COM0               0x20
#define _SEG6COM0               0x40
#define _SEG7COM0               0x80

//==============================================================================


//==============================================================================
//        LCDDATA1 Bits

extern __at(0x07A1) __sfr LCDDATA1;

typedef struct
  {
  unsigned SEG8COM0             : 1;
  unsigned SEG9COM0             : 1;
  unsigned SEG10COM0            : 1;
  unsigned SEG11COM0            : 1;
  unsigned SEG12COM0            : 1;
  unsigned SEG13COM0            : 1;
  unsigned SEG14COM0            : 1;
  unsigned SEG15COM0            : 1;
  } __LCDDATA1bits_t;

extern __at(0x07A1) volatile __LCDDATA1bits_t LCDDATA1bits;

#define _SEG8COM0               0x01
#define _SEG9COM0               0x02
#define _SEG10COM0              0x04
#define _SEG11COM0              0x08
#define _SEG12COM0              0x10
#define _SEG13COM0              0x20
#define _SEG14COM0              0x40
#define _SEG15COM0              0x80

//==============================================================================


//==============================================================================
//        LCDDATA2 Bits

extern __at(0x07A2) __sfr LCDDATA2;

typedef struct
  {
  unsigned SEG16COM0            : 1;
  unsigned SEG17COM0            : 1;
  unsigned SEG18COM0            : 1;
  unsigned SEG19COM0            : 1;
  unsigned SEG20COM0            : 1;
  unsigned SEG21COM0            : 1;
  unsigned SEG22COM0            : 1;
  unsigned SEG23COM0            : 1;
  } __LCDDATA2bits_t;

extern __at(0x07A2) volatile __LCDDATA2bits_t LCDDATA2bits;

#define _SEG16COM0              0x01
#define _SEG17COM0              0x02
#define _SEG18COM0              0x04
#define _SEG19COM0              0x08
#define _SEG20COM0              0x10
#define _SEG21COM0              0x20
#define _SEG22COM0              0x40
#define _SEG23COM0              0x80

//==============================================================================


//==============================================================================
//        LCDDATA3 Bits

extern __at(0x07A3) __sfr LCDDATA3;

typedef struct
  {
  unsigned SEG0COM1             : 1;
  unsigned SEG1COM1             : 1;
  unsigned SEG2COM1             : 1;
  unsigned SEG3COM1             : 1;
  unsigned SEG4COM1             : 1;
  unsigned SEG5COM1             : 1;
  unsigned SEG6COM1             : 1;
  unsigned SEG7COM1             : 1;
  } __LCDDATA3bits_t;

extern __at(0x07A3) volatile __LCDDATA3bits_t LCDDATA3bits;

#define _SEG0COM1               0x01
#define _SEG1COM1               0x02
#define _SEG2COM1               0x04
#define _SEG3COM1               0x08
#define _SEG4COM1               0x10
#define _SEG5COM1               0x20
#define _SEG6COM1               0x40
#define _SEG7COM1               0x80

//==============================================================================


//==============================================================================
//        LCDDATA4 Bits

extern __at(0x07A4) __sfr LCDDATA4;

typedef struct
  {
  unsigned SEG8COM1             : 1;
  unsigned SEG9COM1             : 1;
  unsigned SEG10COM1            : 1;
  unsigned SEG11COM1            : 1;
  unsigned SEG12COM1            : 1;
  unsigned SEG13COM1            : 1;
  unsigned SEG14COM1            : 1;
  unsigned SEG15COM1            : 1;
  } __LCDDATA4bits_t;

extern __at(0x07A4) volatile __LCDDATA4bits_t LCDDATA4bits;

#define _SEG8COM1               0x01
#define _SEG9COM1               0x02
#define _SEG10COM1              0x04
#define _SEG11COM1              0x08
#define _SEG12COM1              0x10
#define _SEG13COM1              0x20
#define _SEG14COM1              0x40
#define _SEG15COM1              0x80

//==============================================================================


//==============================================================================
//        LCDDATA5 Bits

extern __at(0x07A5) __sfr LCDDATA5;

typedef struct
  {
  unsigned SEG16COM1            : 1;
  unsigned SEG17COM1            : 1;
  unsigned SEG18COM1            : 1;
  unsigned SEG19COM1            : 1;
  unsigned SEG20COM1            : 1;
  unsigned SEG21COM1            : 1;
  unsigned SEG22COM1            : 1;
  unsigned SEG23COM1            : 1;
  } __LCDDATA5bits_t;

extern __at(0x07A5) volatile __LCDDATA5bits_t LCDDATA5bits;

#define _SEG16COM1              0x01
#define _SEG17COM1              0x02
#define _SEG18COM1              0x04
#define _SEG19COM1              0x08
#define _SEG20COM1              0x10
#define _SEG21COM1              0x20
#define _SEG22COM1              0x40
#define _SEG23COM1              0x80

//==============================================================================


//==============================================================================
//        LCDDATA6 Bits

extern __at(0x07A6) __sfr LCDDATA6;

typedef struct
  {
  unsigned SEG0COM2             : 1;
  unsigned SEG1COM2             : 1;
  unsigned SEG2COM2             : 1;
  unsigned SEG3COM2             : 1;
  unsigned SEG4COM2             : 1;
  unsigned SEG5COM2             : 1;
  unsigned SEG6COM2             : 1;
  unsigned SEG7COM2             : 1;
  } __LCDDATA6bits_t;

extern __at(0x07A6) volatile __LCDDATA6bits_t LCDDATA6bits;

#define _SEG0COM2               0x01
#define _SEG1COM2               0x02
#define _SEG2COM2               0x04
#define _SEG3COM2               0x08
#define _SEG4COM2               0x10
#define _SEG5COM2               0x20
#define _SEG6COM2               0x40
#define _SEG7COM2               0x80

//==============================================================================


//==============================================================================
//        LCDDATA7 Bits

extern __at(0x07A7) __sfr LCDDATA7;

typedef struct
  {
  unsigned SEG8COM2             : 1;
  unsigned SEG9COM2             : 1;
  unsigned SEG10COM2            : 1;
  unsigned SEG11COM2            : 1;
  unsigned SEG12COM2            : 1;
  unsigned SEG13COM2            : 1;
  unsigned SEG14COM2            : 1;
  unsigned SEG15COM2            : 1;
  } __LCDDATA7bits_t;

extern __at(0x07A7) volatile __LCDDATA7bits_t LCDDATA7bits;

#define _SEG8COM2               0x01
#define _SEG9COM2               0x02
#define _SEG10COM2              0x04
#define _SEG11COM2              0x08
#define _SEG12COM2              0x10
#define _SEG13COM2              0x20
#define _SEG14COM2              0x40
#define _SEG15COM2              0x80

//==============================================================================


//==============================================================================
//        LCDDATA8 Bits

extern __at(0x07A8) __sfr LCDDATA8;

typedef struct
  {
  unsigned SEG16COM2            : 1;
  unsigned SEG17COM2            : 1;
  unsigned SEG18COM2            : 1;
  unsigned SEG19COM2            : 1;
  unsigned SEG20COM2            : 1;
  unsigned SEG21COM2            : 1;
  unsigned SEG22COM2            : 1;
  unsigned SEG23COM2            : 1;
  } __LCDDATA8bits_t;

extern __at(0x07A8) volatile __LCDDATA8bits_t LCDDATA8bits;

#define _SEG16COM2              0x01
#define _SEG17COM2              0x02
#define _SEG18COM2              0x04
#define _SEG19COM2              0x08
#define _SEG20COM2              0x10
#define _SEG21COM2              0x20
#define _SEG22COM2              0x40
#define _SEG23COM2              0x80

//==============================================================================


//==============================================================================
//        LCDDATA9 Bits

extern __at(0x07A9) __sfr LCDDATA9;

typedef struct
  {
  unsigned SEG0COM3             : 1;
  unsigned SEG1COM3             : 1;
  unsigned SEG2COM3             : 1;
  unsigned SEG3COM3             : 1;
  unsigned SEG4COM3             : 1;
  unsigned SEG5COM3             : 1;
  unsigned SEG6COM3             : 1;
  unsigned SEG7COM3             : 1;
  } __LCDDATA9bits_t;

extern __at(0x07A9) volatile __LCDDATA9bits_t LCDDATA9bits;

#define _SEG0COM3               0x01
#define _SEG1COM3               0x02
#define _SEG2COM3               0x04
#define _SEG3COM3               0x08
#define _SEG4COM3               0x10
#define _SEG5COM3               0x20
#define _SEG6COM3               0x40
#define _SEG7COM3               0x80

//==============================================================================


//==============================================================================
//        LCDDATA10 Bits

extern __at(0x07AA) __sfr LCDDATA10;

typedef struct
  {
  unsigned SEG8COM3             : 1;
  unsigned SEG9COM3             : 1;
  unsigned SEG10COM3            : 1;
  unsigned SEG11COM3            : 1;
  unsigned SEG12COM3            : 1;
  unsigned SEG13COM3            : 1;
  unsigned SEG14COM3            : 1;
  unsigned SEG15COM3            : 1;
  } __LCDDATA10bits_t;

extern __at(0x07AA) volatile __LCDDATA10bits_t LCDDATA10bits;

#define _SEG8COM3               0x01
#define _SEG9COM3               0x02
#define _SEG10COM3              0x04
#define _SEG11COM3              0x08
#define _SEG12COM3              0x10
#define _SEG13COM3              0x20
#define _SEG14COM3              0x40
#define _SEG15COM3              0x80

//==============================================================================


//==============================================================================
//        LCDDATA11 Bits

extern __at(0x07AB) __sfr LCDDATA11;

typedef struct
  {
  unsigned SEG16COM3            : 1;
  unsigned SEG17COM3            : 1;
  unsigned SEG18COM3            : 1;
  unsigned SEG19COM3            : 1;
  unsigned SEG20COM3            : 1;
  unsigned SEG21COM3            : 1;
  unsigned SEG22COM3            : 1;
  unsigned SEG23COM3            : 1;
  } __LCDDATA11bits_t;

extern __at(0x07AB) volatile __LCDDATA11bits_t LCDDATA11bits;

#define _SEG16COM3              0x01
#define _SEG17COM3              0x02
#define _SEG18COM3              0x04
#define _SEG19COM3              0x08
#define _SEG20COM3              0x10
#define _SEG21COM3              0x20
#define _SEG22COM3              0x40
#define _SEG23COM3              0x80

//==============================================================================


//==============================================================================
//        LCDDATA12 Bits

extern __at(0x07AC) __sfr LCDDATA12;

typedef struct
  {
  unsigned SEG24COM0            : 1;
  unsigned SEG25COM0            : 1;
  unsigned SEG26COM0            : 1;
  unsigned SEG27COM0            : 1;
  unsigned SEG28COM0            : 1;
  unsigned SEG29COM0            : 1;
  unsigned SEG30COM0            : 1;
  unsigned SEG31COM0            : 1;
  } __LCDDATA12bits_t;

extern __at(0x07AC) volatile __LCDDATA12bits_t LCDDATA12bits;

#define _SEG24COM0              0x01
#define _SEG25COM0              0x02
#define _SEG26COM0              0x04
#define _SEG27COM0              0x08
#define _SEG28COM0              0x10
#define _SEG29COM0              0x20
#define _SEG30COM0              0x40
#define _SEG31COM0              0x80

//==============================================================================


//==============================================================================
//        LCDDATA13 Bits

extern __at(0x07AD) __sfr LCDDATA13;

typedef struct
  {
  unsigned SEG32COM0            : 1;
  unsigned SEG33COM0            : 1;
  unsigned SEG34COM0            : 1;
  unsigned SEG35COM0            : 1;
  unsigned SEG36COM0            : 1;
  unsigned SEG37COM0            : 1;
  unsigned SEG38COM0            : 1;
  unsigned SEG39COM0            : 1;
  } __LCDDATA13bits_t;

extern __at(0x07AD) volatile __LCDDATA13bits_t LCDDATA13bits;

#define _SEG32COM0              0x01
#define _SEG33COM0              0x02
#define _SEG34COM0              0x04
#define _SEG35COM0              0x08
#define _SEG36COM0              0x10
#define _SEG37COM0              0x20
#define _SEG38COM0              0x40
#define _SEG39COM0              0x80

//==============================================================================


//==============================================================================
//        LCDDATA14 Bits

extern __at(0x07AE) __sfr LCDDATA14;

typedef struct
  {
  unsigned SEG40COM0            : 1;
  unsigned SEG41COM0            : 1;
  unsigned SEG42COM0            : 1;
  unsigned SEG43COM0            : 1;
  unsigned SEG44COM0            : 1;
  unsigned SEG45COM0            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LCDDATA14bits_t;

extern __at(0x07AE) volatile __LCDDATA14bits_t LCDDATA14bits;

#define _SEG40COM0              0x01
#define _SEG41COM0              0x02
#define _SEG42COM0              0x04
#define _SEG43COM0              0x08
#define _SEG44COM0              0x10
#define _SEG45COM0              0x20

//==============================================================================


//==============================================================================
//        LCDDATA15 Bits

extern __at(0x07AF) __sfr LCDDATA15;

typedef struct
  {
  unsigned SEG24COM1            : 1;
  unsigned SEG25COM1            : 1;
  unsigned SEG26COM1            : 1;
  unsigned SEG27COM1            : 1;
  unsigned SEG28COM1            : 1;
  unsigned SEG29COM1            : 1;
  unsigned SEG30COM1            : 1;
  unsigned SEG31COM1            : 1;
  } __LCDDATA15bits_t;

extern __at(0x07AF) volatile __LCDDATA15bits_t LCDDATA15bits;

#define _SEG24COM1              0x01
#define _SEG25COM1              0x02
#define _SEG26COM1              0x04
#define _SEG27COM1              0x08
#define _SEG28COM1              0x10
#define _SEG29COM1              0x20
#define _SEG30COM1              0x40
#define _SEG31COM1              0x80

//==============================================================================


//==============================================================================
//        LCDDATA16 Bits

extern __at(0x07B0) __sfr LCDDATA16;

typedef struct
  {
  unsigned SEG32COM1            : 1;
  unsigned SEG33COM1            : 1;
  unsigned SEG34COM1            : 1;
  unsigned SEG35COM1            : 1;
  unsigned SEG36COM1            : 1;
  unsigned SEG37COM1            : 1;
  unsigned SEG38COM1            : 1;
  unsigned SEG39COM1            : 1;
  } __LCDDATA16bits_t;

extern __at(0x07B0) volatile __LCDDATA16bits_t LCDDATA16bits;

#define _SEG32COM1              0x01
#define _SEG33COM1              0x02
#define _SEG34COM1              0x04
#define _SEG35COM1              0x08
#define _SEG36COM1              0x10
#define _SEG37COM1              0x20
#define _SEG38COM1              0x40
#define _SEG39COM1              0x80

//==============================================================================


//==============================================================================
//        LCDDATA17 Bits

extern __at(0x07B1) __sfr LCDDATA17;

typedef struct
  {
  unsigned SEG40COM1            : 1;
  unsigned SEG41COM1            : 1;
  unsigned SEG42COM1            : 1;
  unsigned SEG43COM1            : 1;
  unsigned SEG44COM1            : 1;
  unsigned SEG45COM1            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LCDDATA17bits_t;

extern __at(0x07B1) volatile __LCDDATA17bits_t LCDDATA17bits;

#define _SEG40COM1              0x01
#define _SEG41COM1              0x02
#define _SEG42COM1              0x04
#define _SEG43COM1              0x08
#define _SEG44COM1              0x10
#define _SEG45COM1              0x20

//==============================================================================


//==============================================================================
//        LCDDATA18 Bits

extern __at(0x07B2) __sfr LCDDATA18;

typedef struct
  {
  unsigned SEG24COM2            : 1;
  unsigned SEG25COM2            : 1;
  unsigned SEG26COM2            : 1;
  unsigned SEG27COM2            : 1;
  unsigned SEG28COM2            : 1;
  unsigned SEG29COM2            : 1;
  unsigned SEG30COM2            : 1;
  unsigned SEG31COM2            : 1;
  } __LCDDATA18bits_t;

extern __at(0x07B2) volatile __LCDDATA18bits_t LCDDATA18bits;

#define _SEG24COM2              0x01
#define _SEG25COM2              0x02
#define _SEG26COM2              0x04
#define _SEG27COM2              0x08
#define _SEG28COM2              0x10
#define _SEG29COM2              0x20
#define _SEG30COM2              0x40
#define _SEG31COM2              0x80

//==============================================================================


//==============================================================================
//        LCDDATA19 Bits

extern __at(0x07B3) __sfr LCDDATA19;

typedef struct
  {
  unsigned SEG32COM2            : 1;
  unsigned SEG33COM2            : 1;
  unsigned SEG34COM2            : 1;
  unsigned SEG35COM2            : 1;
  unsigned SEG36COM2            : 1;
  unsigned SEG37COM2            : 1;
  unsigned SEG38COM2            : 1;
  unsigned SEG39COM2            : 1;
  } __LCDDATA19bits_t;

extern __at(0x07B3) volatile __LCDDATA19bits_t LCDDATA19bits;

#define _SEG32COM2              0x01
#define _SEG33COM2              0x02
#define _SEG34COM2              0x04
#define _SEG35COM2              0x08
#define _SEG36COM2              0x10
#define _SEG37COM2              0x20
#define _SEG38COM2              0x40
#define _SEG39COM2              0x80

//==============================================================================


//==============================================================================
//        LCDDATA20 Bits

extern __at(0x07B4) __sfr LCDDATA20;

typedef struct
  {
  unsigned SEG40COM2            : 1;
  unsigned SEG41COM2            : 1;
  unsigned SEG42COM2            : 1;
  unsigned SEG43COM2            : 1;
  unsigned SEG44COM2            : 1;
  unsigned SEG45COM2            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LCDDATA20bits_t;

extern __at(0x07B4) volatile __LCDDATA20bits_t LCDDATA20bits;

#define _SEG40COM2              0x01
#define _SEG41COM2              0x02
#define _SEG42COM2              0x04
#define _SEG43COM2              0x08
#define _SEG44COM2              0x10
#define _SEG45COM2              0x20

//==============================================================================


//==============================================================================
//        LCDDATA21 Bits

extern __at(0x07B5) __sfr LCDDATA21;

typedef struct
  {
  unsigned SEG24COM3            : 1;
  unsigned SEG25COM3            : 1;
  unsigned SEG26COM3            : 1;
  unsigned SEG27COM3            : 1;
  unsigned SEG28COM3            : 1;
  unsigned SEG29COM3            : 1;
  unsigned SEG30COM3            : 1;
  unsigned SEG31COM3            : 1;
  } __LCDDATA21bits_t;

extern __at(0x07B5) volatile __LCDDATA21bits_t LCDDATA21bits;

#define _SEG24COM3              0x01
#define _SEG25COM3              0x02
#define _SEG26COM3              0x04
#define _SEG27COM3              0x08
#define _SEG28COM3              0x10
#define _SEG29COM3              0x20
#define _SEG30COM3              0x40
#define _SEG31COM3              0x80

//==============================================================================


//==============================================================================
//        LCDDATA22 Bits

extern __at(0x07B6) __sfr LCDDATA22;

typedef struct
  {
  unsigned SEG32COM3            : 1;
  unsigned SEG33COM3            : 1;
  unsigned SEG34COM3            : 1;
  unsigned SEG35COM3            : 1;
  unsigned SEG36COM3            : 1;
  unsigned SEG37COM3            : 1;
  unsigned SEG38COM3            : 1;
  unsigned SEG39COM3            : 1;
  } __LCDDATA22bits_t;

extern __at(0x07B6) volatile __LCDDATA22bits_t LCDDATA22bits;

#define _SEG32COM3              0x01
#define _SEG33COM3              0x02
#define _SEG34COM3              0x04
#define _SEG35COM3              0x08
#define _SEG36COM3              0x10
#define _SEG37COM3              0x20
#define _SEG38COM3              0x40
#define _SEG39COM3              0x80

//==============================================================================


//==============================================================================
//        LCDDATA23 Bits

extern __at(0x07B7) __sfr LCDDATA23;

typedef struct
  {
  unsigned SEG40COM3            : 1;
  unsigned SEG41COM3            : 1;
  unsigned SEG42COM3            : 1;
  unsigned SEG43COM3            : 1;
  unsigned SEG44COM3            : 1;
  unsigned SEG45COM3            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LCDDATA23bits_t;

extern __at(0x07B7) volatile __LCDDATA23bits_t LCDDATA23bits;

#define _SEG40COM3              0x01
#define _SEG41COM3              0x02
#define _SEG42COM3              0x04
#define _SEG43COM3              0x08
#define _SEG44COM3              0x10
#define _SEG45COM3              0x20

//==============================================================================


//==============================================================================
//        STATUS_SHAD Bits

extern __at(0x0FE4) __sfr STATUS_SHAD;

typedef struct
  {
  unsigned C_SHAD               : 1;
  unsigned DC_SHAD              : 1;
  unsigned Z_SHAD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUS_SHADbits_t;

extern __at(0x0FE4) volatile __STATUS_SHADbits_t STATUS_SHADbits;

#define _C_SHAD                 0x01
#define _DC_SHAD                0x02
#define _Z_SHAD                 0x04

//==============================================================================

extern __at(0x0FE5) __sfr WREG_SHAD;
extern __at(0x0FE6) __sfr BSR_SHAD;
extern __at(0x0FE7) __sfr PCLATH_SHAD;
extern __at(0x0FE8) __sfr FSR0L_SHAD;
extern __at(0x0FE9) __sfr FSR0H_SHAD;
extern __at(0x0FEA) __sfr FSR1L_SHAD;
extern __at(0x0FEB) __sfr FSR1H_SHAD;
extern __at(0x0FED) __sfr STKPTR;
extern __at(0x0FEE) __sfr TOSL;
extern __at(0x0FEF) __sfr TOSH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x8007
#define _CONFIG2                0x8008

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_LP                0xFFF8  // LP Oscillator, Low-power crystal connected between OSC1 and OSC2 pins.
#define _FOSC_XT                0xFFF9  // XT Oscillator, Crystal/resonator connected between OSC1 and OSC2 pins.
#define _FOSC_HS                0xFFFA  // HS Oscillator, High-speed crystal/resonator connected between OSC1 and OSC2 pins.
#define _FOSC_EXTRC             0xFFFB  // EXTRC oscillator: External RC circuit connected to CLKIN pin.
#define _FOSC_INTOSC            0xFFFC  // INTOSC oscillator: I/O function on CLKIN pin.
#define _FOSC_ECL               0xFFFD  // ECL, External Clock, Low Power Mode (0-0.5 MHz): device clock supplied to CLKIN pin.
#define _FOSC_ECM               0xFFFE  // ECM, External Clock, Medium Power Mode (0.5-4 MHz): device clock supplied to CLKIN pin.
#define _FOSC_ECH               0xFFFF  // ECH, External Clock, High Power Mode (4-32 MHz): device clock supplied to CLKIN pin.
#define _WDTE_OFF               0xFFE7  // WDT disabled.
#define _WDTE_SWDTEN            0xFFEF  // WDT controlled by the SWDTEN bit in the WDTCON register.
#define _WDTE_NSLEEP            0xFFF7  // WDT enabled while running and disabled in Sleep.
#define _WDTE_ON                0xFFFF  // WDT enabled.
#define _PWRTE_ON               0xFFDF  // PWRT enabled.
#define _PWRTE_OFF              0xFFFF  // PWRT disabled.
#define _MCLRE_OFF              0xFFBF  // MCLR/VPP pin function is digital input.
#define _MCLRE_ON               0xFFFF  // MCLR/VPP pin function is MCLR.
#define _CP_ON                  0xFF7F  // Program memory code protection is enabled.
#define _CP_OFF                 0xFFFF  // Program memory code protection is disabled.
#define _CPD_ON                 0xFEFF  // Data memory code protection is enabled.
#define _CPD_OFF                0xFFFF  // Data memory code protection is disabled.
#define _BOREN_OFF              0xF9FF  // Brown-out Reset disabled.
#define _BOREN_SBODEN           0xFBFF  // Brown-out Reset controlled by the SBOREN bit in the BORCON register.
#define _BOREN_NSLEEP           0xFDFF  // Brown-out Reset enabled while running and disabled in Sleep.
#define _BOREN_ON               0xFFFF  // Brown-out Reset enabled.
#define _CLKOUTEN_ON            0xF7FF  // CLKOUT function is enabled on the CLKOUT pin.
#define _CLKOUTEN_OFF           0xFFFF  // CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin.
#define _IESO_OFF               0xEFFF  // Internal/External Switchover mode is disabled.
#define _IESO_ON                0xFFFF  // Internal/External Switchover mode is enabled.
#define _FCMEN_OFF              0xDFFF  // Fail-Safe Clock Monitor is disabled.
#define _FCMEN_ON               0xFFFF  // Fail-Safe Clock Monitor is enabled.

//----------------------------- CONFIG2 Options -------------------------------

#define _WRT_ALL                0xFFFC  // 000h to 1FFFh write protected, no addresses may be modified by EECON control.
#define _WRT_HALF               0xFFFD  // 000h to FFFh write protected, 1000h to 1FFFh may be modified by EECON control.
#define _WRT_BOOT               0xFFFE  // 000h to 1FFh write protected, 200h to 1FFFh may be modified by EECON control.
#define _WRT_OFF                0xFFFF  // Write protection off.
#define _VCAPEN_ON              0xFFEF  // VCAP functionality is enabled on VCAP pin.
#define _VCAPEN_OFF             0xFFFF  // VCAP pin functionality is disabled.
#define _PLLEN_OFF              0xFEFF  // 4x PLL disabled.
#define _PLLEN_ON               0xFFFF  // 4x PLL enabled.
#define _STVREN_OFF             0xFDFF  // Stack Overflow or Underflow will not cause a Reset.
#define _STVREN_ON              0xFFFF  // Stack Overflow or Underflow will cause a Reset.
#define _BORV_HI                0xFBFF  // Brown-out Reset Voltage (Vbor), high trip point selected.
#define _BORV_25                0xFBFF  // Brown-out Reset Voltage (Vbor), high trip point selected.
#define _BORV_LO                0xFFFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _BORV_19                0xFFFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _LVP_OFF                0xDFFF  // High-voltage on MCLR/VPP must be used for programming.
#define _LVP_ON                 0xFFFF  // Low-voltage programming enabled.

//==============================================================================

#define _DEVID1                 0x8006

#define _IDLOC0                 0x8000
#define _IDLOC1                 0x8001
#define _IDLOC2                 0x8002
#define _IDLOC3                 0x8003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 1, shadows bit in ADCON0bits
#define ADGO                    ADCON0bits.ADGO                 // bit 1, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 1, shadows bit in ADCON0bits
#define NOT_DONE                ADCON0bits.NOT_DONE             // bit 1, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 2
#define CHS1                    ADCON0bits.CHS1                 // bit 3
#define CHS2                    ADCON0bits.CHS2                 // bit 4
#define CHS3                    ADCON0bits.CHS3                 // bit 5
#define CHS4                    ADCON0bits.CHS4                 // bit 6

#define ADPREF0                 ADCON1bits.ADPREF0              // bit 0
#define ADPREF1                 ADCON1bits.ADPREF1              // bit 1
#define ADNREF                  ADCON1bits.ADNREF               // bit 2
#define ADCS0                   ADCON1bits.ADCS0                // bit 4
#define ADCS1                   ADCON1bits.ADCS1                // bit 5
#define ADCS2                   ADCON1bits.ADCS2                // bit 6
#define ADFM                    ADCON1bits.ADFM                 // bit 7

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA3                   ANSELAbits.ANSA3                // bit 3
#define ANSA5                   ANSELAbits.ANSA5                // bit 5

#define ANSE0                   ANSELEbits.ANSE0                // bit 0
#define ANSE1                   ANSELEbits.ANSE1                // bit 1
#define ANSE2                   ANSELEbits.ANSE2                // bit 2

#define ANSF0                   ANSELFbits.ANSF0                // bit 0
#define ANSF1                   ANSELFbits.ANSF1                // bit 1
#define ANSF2                   ANSELFbits.ANSF2                // bit 2
#define ANSF3                   ANSELFbits.ANSF3                // bit 3
#define ANSF4                   ANSELFbits.ANSF4                // bit 4
#define ANSF5                   ANSELFbits.ANSF5                // bit 5
#define ANSF6                   ANSELFbits.ANSF6                // bit 6
#define ANSF7                   ANSELFbits.ANSF7                // bit 7

#define ANSG1                   ANSELGbits.ANSG1                // bit 1
#define ANSG2                   ANSELGbits.ANSG2                // bit 2
#define ANSG3                   ANSELGbits.ANSG3                // bit 3
#define ANSG4                   ANSELGbits.ANSG4                // bit 4

#define P1BSEL                  APFCONbits.P1BSEL               // bit 0
#define P1CSEL                  APFCONbits.P1CSEL               // bit 1
#define CCP2SEL                 APFCONbits.CCP2SEL              // bit 2
#define P2BSEL                  APFCONbits.P2BSEL               // bit 3
#define P2CSEL                  APFCONbits.P2CSEL               // bit 4
#define P2DSEL                  APFCONbits.P2DSEL               // bit 5
#define P3BSEL                  APFCONbits.P3BSEL               // bit 6
#define P3CSEL                  APFCONbits.P3CSEL               // bit 7

#define ABDEN                   BAUD1CONbits.ABDEN              // bit 0
#define WUE                     BAUD1CONbits.WUE                // bit 1
#define BRG16                   BAUD1CONbits.BRG16              // bit 3
#define SCKP                    BAUD1CONbits.SCKP               // bit 4
#define RCIDL                   BAUD1CONbits.RCIDL              // bit 6
#define ABDOVF                  BAUD1CONbits.ABDOVF             // bit 7

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define BSR0                    BSRbits.BSR0                    // bit 0
#define BSR1                    BSRbits.BSR1                    // bit 1
#define BSR2                    BSRbits.BSR2                    // bit 2
#define BSR3                    BSRbits.BSR3                    // bit 3
#define BSR4                    BSRbits.BSR4                    // bit 4

#define PSS1BD0                 CCP1ASbits.PSS1BD0              // bit 0
#define PSS1BD1                 CCP1ASbits.PSS1BD1              // bit 1
#define PSS1AC0                 CCP1ASbits.PSS1AC0              // bit 2
#define PSS1AC1                 CCP1ASbits.PSS1AC1              // bit 3
#define CCP1AS0                 CCP1ASbits.CCP1AS0              // bit 4
#define CCP1AS1                 CCP1ASbits.CCP1AS1              // bit 5
#define CCP1AS2                 CCP1ASbits.CCP1AS2              // bit 6
#define CCP1ASE                 CCP1ASbits.CCP1ASE              // bit 7

#define CCP1M0                  CCP1CONbits.CCP1M0              // bit 0
#define CCP1M1                  CCP1CONbits.CCP1M1              // bit 1
#define CCP1M2                  CCP1CONbits.CCP1M2              // bit 2
#define CCP1M3                  CCP1CONbits.CCP1M3              // bit 3
#define DC1B0                   CCP1CONbits.DC1B0               // bit 4
#define DC1B1                   CCP1CONbits.DC1B1               // bit 5
#define P1M0                    CCP1CONbits.P1M0                // bit 6
#define P1M1                    CCP1CONbits.P1M1                // bit 7

#define PSS2BD0                 CCP2ASbits.PSS2BD0              // bit 0
#define PSS2BD1                 CCP2ASbits.PSS2BD1              // bit 1
#define PSS2AC0                 CCP2ASbits.PSS2AC0              // bit 2
#define PSS2AC1                 CCP2ASbits.PSS2AC1              // bit 3
#define CCP2AS0                 CCP2ASbits.CCP2AS0              // bit 4
#define CCP2AS1                 CCP2ASbits.CCP2AS1              // bit 5
#define CCP2AS2                 CCP2ASbits.CCP2AS2              // bit 6
#define CCP2ASE                 CCP2ASbits.CCP2ASE              // bit 7

#define CCP2M0                  CCP2CONbits.CCP2M0              // bit 0
#define CCP2M1                  CCP2CONbits.CCP2M1              // bit 1
#define CCP2M2                  CCP2CONbits.CCP2M2              // bit 2
#define CCP2M3                  CCP2CONbits.CCP2M3              // bit 3
#define DC2B0                   CCP2CONbits.DC2B0               // bit 4
#define DC2B1                   CCP2CONbits.DC2B1               // bit 5
#define P2M0                    CCP2CONbits.P2M0                // bit 6
#define P2M1                    CCP2CONbits.P2M1                // bit 7

#define PSS3BD0                 CCP3ASbits.PSS3BD0              // bit 0
#define PSS3BD1                 CCP3ASbits.PSS3BD1              // bit 1
#define PSS3AC0                 CCP3ASbits.PSS3AC0              // bit 2
#define PSS3AC1                 CCP3ASbits.PSS3AC1              // bit 3
#define CCP3AS0                 CCP3ASbits.CCP3AS0              // bit 4
#define CCP3AS1                 CCP3ASbits.CCP3AS1              // bit 5
#define CCP3AS2                 CCP3ASbits.CCP3AS2              // bit 6
#define CCP3ASE                 CCP3ASbits.CCP3ASE              // bit 7

#define CCP3M0                  CCP3CONbits.CCP3M0              // bit 0
#define CCP3M1                  CCP3CONbits.CCP3M1              // bit 1
#define CCP3M2                  CCP3CONbits.CCP3M2              // bit 2
#define CCP3M3                  CCP3CONbits.CCP3M3              // bit 3
#define DC3B0                   CCP3CONbits.DC3B0               // bit 4
#define DC3B1                   CCP3CONbits.DC3B1               // bit 5
#define P3M0                    CCP3CONbits.P3M0                // bit 6
#define P3M1                    CCP3CONbits.P3M1                // bit 7

#define CCP4M0                  CCP4CONbits.CCP4M0              // bit 0
#define CCP4M1                  CCP4CONbits.CCP4M1              // bit 1
#define CCP4M2                  CCP4CONbits.CCP4M2              // bit 2
#define CCP4M3                  CCP4CONbits.CCP4M3              // bit 3
#define DC4B0                   CCP4CONbits.DC4B0               // bit 4
#define DC4B1                   CCP4CONbits.DC4B1               // bit 5

#define CCP5M0                  CCP5CONbits.CCP5M0              // bit 0
#define CCP5M1                  CCP5CONbits.CCP5M1              // bit 1
#define CCP5M2                  CCP5CONbits.CCP5M2              // bit 2
#define CCP5M3                  CCP5CONbits.CCP5M3              // bit 3
#define DC5B0                   CCP5CONbits.DC5B0               // bit 4
#define DC5B1                   CCP5CONbits.DC5B1               // bit 5

#define C1TSEL0                 CCPTMRS0bits.C1TSEL0            // bit 0
#define C1TSEL1                 CCPTMRS0bits.C1TSEL1            // bit 1
#define C2TSEL0                 CCPTMRS0bits.C2TSEL0            // bit 2
#define C2TSEL1                 CCPTMRS0bits.C2TSEL1            // bit 3
#define C3TSEL0                 CCPTMRS0bits.C3TSEL0            // bit 4
#define C3TSEL1                 CCPTMRS0bits.C3TSEL1            // bit 5
#define C4TSEL0                 CCPTMRS0bits.C4TSEL0            // bit 6
#define C4TSEL1                 CCPTMRS0bits.C4TSEL1            // bit 7

#define C5TSEL0                 CCPTMRS1bits.C5TSEL0            // bit 0
#define C5TSEL1                 CCPTMRS1bits.C5TSEL1            // bit 1

#define C1SYNC                  CM1CON0bits.C1SYNC              // bit 0
#define C1HYS                   CM1CON0bits.C1HYS               // bit 1
#define C1SP                    CM1CON0bits.C1SP                // bit 2
#define C1POL                   CM1CON0bits.C1POL               // bit 4
#define C1OE                    CM1CON0bits.C1OE                // bit 5
#define C1OUT                   CM1CON0bits.C1OUT               // bit 6
#define C1ON                    CM1CON0bits.C1ON                // bit 7

#define C1NCH0                  CM1CON1bits.C1NCH0              // bit 0
#define C1NCH1                  CM1CON1bits.C1NCH1              // bit 1
#define C1PCH0                  CM1CON1bits.C1PCH0              // bit 4
#define C1PCH1                  CM1CON1bits.C1PCH1              // bit 5
#define C1INTN                  CM1CON1bits.C1INTN              // bit 6
#define C1INTP                  CM1CON1bits.C1INTP              // bit 7

#define C2SYNC                  CM2CON0bits.C2SYNC              // bit 0
#define C2HYS                   CM2CON0bits.C2HYS               // bit 1
#define C2SP                    CM2CON0bits.C2SP                // bit 2
#define C2POL                   CM2CON0bits.C2POL               // bit 4
#define C2OE                    CM2CON0bits.C2OE                // bit 5
#define C2OUT                   CM2CON0bits.C2OUT               // bit 6
#define C2ON                    CM2CON0bits.C2ON                // bit 7

#define C2NCH0                  CM2CON1bits.C2NCH0              // bit 0
#define C2NCH1                  CM2CON1bits.C2NCH1              // bit 1
#define C2PCH0                  CM2CON1bits.C2PCH0              // bit 4
#define C2PCH1                  CM2CON1bits.C2PCH1              // bit 5
#define C2INTN                  CM2CON1bits.C2INTN              // bit 6
#define C2INTP                  CM2CON1bits.C2INTP              // bit 7

#define C3SYNC                  CM3CON0bits.C3SYNC              // bit 0
#define C3HYS                   CM3CON0bits.C3HYS               // bit 1
#define C3SP                    CM3CON0bits.C3SP                // bit 2
#define C3POL                   CM3CON0bits.C3POL               // bit 4
#define C3OE                    CM3CON0bits.C3OE                // bit 5
#define C3OUT                   CM3CON0bits.C3OUT               // bit 6
#define C3ON                    CM3CON0bits.C3ON                // bit 7

#define C3NCH0                  CM3CON1bits.C3NCH0              // bit 0
#define C3NCH1                  CM3CON1bits.C3NCH1              // bit 1
#define C3PCH0                  CM3CON1bits.C3PCH0              // bit 4
#define C3PCH1                  CM3CON1bits.C3PCH1              // bit 5
#define C3INTN                  CM3CON1bits.C3INTN              // bit 6
#define C3INTP                  CM3CON1bits.C3INTP              // bit 7

#define MC1OUT                  CMOUTbits.MC1OUT                // bit 0
#define MC2OUT                  CMOUTbits.MC2OUT                // bit 1
#define MC3OUT                  CMOUTbits.MC3OUT                // bit 2

#define T0XCS                   CPSCON0bits.T0XCS               // bit 0
#define CPSOUT                  CPSCON0bits.CPSOUT              // bit 1
#define CPSRNG0                 CPSCON0bits.CPSRNG0             // bit 2
#define CPSRNG1                 CPSCON0bits.CPSRNG1             // bit 3
#define CPSRM                   CPSCON0bits.CPSRM               // bit 6
#define CPSON                   CPSCON0bits.CPSON               // bit 7

#define CPSCH0                  CPSCON1bits.CPSCH0              // bit 0
#define CPSCH1                  CPSCON1bits.CPSCH1              // bit 1
#define CPSCH2                  CPSCON1bits.CPSCH2              // bit 2
#define CPSCH3                  CPSCON1bits.CPSCH3              // bit 3
#define CPSCH4                  CPSCON1bits.CPSCH4              // bit 4

#define DACNSS                  DACCON0bits.DACNSS              // bit 0
#define DACPSS0                 DACCON0bits.DACPSS0             // bit 2
#define DACPSS1                 DACCON0bits.DACPSS1             // bit 3
#define DACOE                   DACCON0bits.DACOE               // bit 5
#define DACLPS                  DACCON0bits.DACLPS              // bit 6
#define DACEN                   DACCON0bits.DACEN               // bit 7

#define DACR0                   DACCON1bits.DACR0               // bit 0
#define DACR1                   DACCON1bits.DACR1               // bit 1
#define DACR2                   DACCON1bits.DACR2               // bit 2
#define DACR3                   DACCON1bits.DACR3               // bit 3
#define DACR4                   DACCON1bits.DACR4               // bit 4

#define RD                      EECON1bits.RD                   // bit 0
#define WR                      EECON1bits.WR                   // bit 1
#define WREN                    EECON1bits.WREN                 // bit 2
#define WRERR                   EECON1bits.WRERR                // bit 3
#define FREE                    EECON1bits.FREE                 // bit 4
#define LWLO                    EECON1bits.LWLO                 // bit 5
#define CFGS                    EECON1bits.CFGS                 // bit 6
#define EEPGD                   EECON1bits.EEPGD                // bit 7

#define ADFVR0                  FVRCONbits.ADFVR0               // bit 0
#define ADFVR1                  FVRCONbits.ADFVR1               // bit 1
#define CDAFVR0                 FVRCONbits.CDAFVR0              // bit 2
#define CDAFVR1                 FVRCONbits.CDAFVR1              // bit 3
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define IOCIF                   INTCONbits.IOCIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define IOCIE                   INTCONbits.IOCIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCBF0                  IOCBFbits.IOCBF0                // bit 0
#define IOCBF1                  IOCBFbits.IOCBF1                // bit 1
#define IOCBF2                  IOCBFbits.IOCBF2                // bit 2
#define IOCBF3                  IOCBFbits.IOCBF3                // bit 3
#define IOCBF4                  IOCBFbits.IOCBF4                // bit 4
#define IOCBF5                  IOCBFbits.IOCBF5                // bit 5
#define IOCBF6                  IOCBFbits.IOCBF6                // bit 6
#define IOCBF7                  IOCBFbits.IOCBF7                // bit 7

#define IOCBN0                  IOCBNbits.IOCBN0                // bit 0
#define IOCBN1                  IOCBNbits.IOCBN1                // bit 1
#define IOCBN2                  IOCBNbits.IOCBN2                // bit 2
#define IOCBN3                  IOCBNbits.IOCBN3                // bit 3
#define IOCBN4                  IOCBNbits.IOCBN4                // bit 4
#define IOCBN5                  IOCBNbits.IOCBN5                // bit 5
#define IOCBN6                  IOCBNbits.IOCBN6                // bit 6
#define IOCBN7                  IOCBNbits.IOCBN7                // bit 7

#define IOCBP0                  IOCBPbits.IOCBP0                // bit 0
#define IOCBP1                  IOCBPbits.IOCBP1                // bit 1
#define IOCBP2                  IOCBPbits.IOCBP2                // bit 2
#define IOCBP3                  IOCBPbits.IOCBP3                // bit 3
#define IOCBP4                  IOCBPbits.IOCBP4                // bit 4
#define IOCBP5                  IOCBPbits.IOCBP5                // bit 5
#define IOCBP6                  IOCBPbits.IOCBP6                // bit 6
#define IOCBP7                  IOCBPbits.IOCBP7                // bit 7

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2
#define LATA3                   LATAbits.LATA3                  // bit 3
#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5
#define LATA6                   LATAbits.LATA6                  // bit 6
#define LATA7                   LATAbits.LATA7                  // bit 7

#define LATB0                   LATBbits.LATB0                  // bit 0
#define LATB1                   LATBbits.LATB1                  // bit 1
#define LATB2                   LATBbits.LATB2                  // bit 2
#define LATB3                   LATBbits.LATB3                  // bit 3
#define LATB4                   LATBbits.LATB4                  // bit 4
#define LATB5                   LATBbits.LATB5                  // bit 5
#define LATB6                   LATBbits.LATB6                  // bit 6
#define LATB7                   LATBbits.LATB7                  // bit 7

#define LATC0                   LATCbits.LATC0                  // bit 0
#define LATC1                   LATCbits.LATC1                  // bit 1
#define LATC2                   LATCbits.LATC2                  // bit 2
#define LATC3                   LATCbits.LATC3                  // bit 3
#define LATC4                   LATCbits.LATC4                  // bit 4
#define LATC5                   LATCbits.LATC5                  // bit 5
#define LATC6                   LATCbits.LATC6                  // bit 6
#define LATC7                   LATCbits.LATC7                  // bit 7

#define LATD0                   LATDbits.LATD0                  // bit 0
#define LATD1                   LATDbits.LATD1                  // bit 1
#define LATD2                   LATDbits.LATD2                  // bit 2
#define LATD3                   LATDbits.LATD3                  // bit 3
#define LATD4                   LATDbits.LATD4                  // bit 4
#define LATD5                   LATDbits.LATD5                  // bit 5
#define LATD6                   LATDbits.LATD6                  // bit 6
#define LATD7                   LATDbits.LATD7                  // bit 7

#define LATE0                   LATEbits.LATE0                  // bit 0
#define LATE1                   LATEbits.LATE1                  // bit 1
#define LATE2                   LATEbits.LATE2                  // bit 2
#define LATE3                   LATEbits.LATE3                  // bit 3
#define LATE4                   LATEbits.LATE4                  // bit 4
#define LATE5                   LATEbits.LATE5                  // bit 5
#define LATE6                   LATEbits.LATE6                  // bit 6
#define LATE7                   LATEbits.LATE7                  // bit 7

#define LATF0                   LATFbits.LATF0                  // bit 0
#define LATF1                   LATFbits.LATF1                  // bit 1
#define LATF2                   LATFbits.LATF2                  // bit 2
#define LATF3                   LATFbits.LATF3                  // bit 3
#define LATF4                   LATFbits.LATF4                  // bit 4
#define LATF5                   LATFbits.LATF5                  // bit 5
#define LATF6                   LATFbits.LATF6                  // bit 6
#define LATF7                   LATFbits.LATF7                  // bit 7

#define LATG0                   LATGbits.LATG0                  // bit 0
#define LATG1                   LATGbits.LATG1                  // bit 1
#define LATG2                   LATGbits.LATG2                  // bit 2
#define LATG3                   LATGbits.LATG3                  // bit 3
#define LATG4                   LATGbits.LATG4                  // bit 4
#define LATG5                   LATGbits.LATG5                  // bit 5

#define LMUX0                   LCDCONbits.LMUX0                // bit 0
#define LMUX1                   LCDCONbits.LMUX1                // bit 1
#define CS0                     LCDCONbits.CS0                  // bit 2
#define CS1                     LCDCONbits.CS1                  // bit 3
#define WERR                    LCDCONbits.WERR                 // bit 5
#define SLPEN                   LCDCONbits.SLPEN                // bit 6
#define LCDEN                   LCDCONbits.LCDEN                // bit 7

#define LCDCST0                 LCDCSTbits.LCDCST0              // bit 0
#define LCDCST1                 LCDCSTbits.LCDCST1              // bit 1
#define LCDCST2                 LCDCSTbits.LCDCST2              // bit 2

#define SEG0COM0                LCDDATA0bits.SEG0COM0           // bit 0
#define SEG1COM0                LCDDATA0bits.SEG1COM0           // bit 1
#define SEG2COM0                LCDDATA0bits.SEG2COM0           // bit 2
#define SEG3COM0                LCDDATA0bits.SEG3COM0           // bit 3
#define SEG4COM0                LCDDATA0bits.SEG4COM0           // bit 4
#define SEG5COM0                LCDDATA0bits.SEG5COM0           // bit 5
#define SEG6COM0                LCDDATA0bits.SEG6COM0           // bit 6
#define SEG7COM0                LCDDATA0bits.SEG7COM0           // bit 7

#define SEG8COM0                LCDDATA1bits.SEG8COM0           // bit 0
#define SEG9COM0                LCDDATA1bits.SEG9COM0           // bit 1
#define SEG10COM0               LCDDATA1bits.SEG10COM0          // bit 2
#define SEG11COM0               LCDDATA1bits.SEG11COM0          // bit 3
#define SEG12COM0               LCDDATA1bits.SEG12COM0          // bit 4
#define SEG13COM0               LCDDATA1bits.SEG13COM0          // bit 5
#define SEG14COM0               LCDDATA1bits.SEG14COM0          // bit 6
#define SEG15COM0               LCDDATA1bits.SEG15COM0          // bit 7

#define SEG16COM0               LCDDATA2bits.SEG16COM0          // bit 0
#define SEG17COM0               LCDDATA2bits.SEG17COM0          // bit 1
#define SEG18COM0               LCDDATA2bits.SEG18COM0          // bit 2
#define SEG19COM0               LCDDATA2bits.SEG19COM0          // bit 3
#define SEG20COM0               LCDDATA2bits.SEG20COM0          // bit 4
#define SEG21COM0               LCDDATA2bits.SEG21COM0          // bit 5
#define SEG22COM0               LCDDATA2bits.SEG22COM0          // bit 6
#define SEG23COM0               LCDDATA2bits.SEG23COM0          // bit 7

#define SEG0COM1                LCDDATA3bits.SEG0COM1           // bit 0
#define SEG1COM1                LCDDATA3bits.SEG1COM1           // bit 1
#define SEG2COM1                LCDDATA3bits.SEG2COM1           // bit 2
#define SEG3COM1                LCDDATA3bits.SEG3COM1           // bit 3
#define SEG4COM1                LCDDATA3bits.SEG4COM1           // bit 4
#define SEG5COM1                LCDDATA3bits.SEG5COM1           // bit 5
#define SEG6COM1                LCDDATA3bits.SEG6COM1           // bit 6
#define SEG7COM1                LCDDATA3bits.SEG7COM1           // bit 7

#define SEG8COM1                LCDDATA4bits.SEG8COM1           // bit 0
#define SEG9COM1                LCDDATA4bits.SEG9COM1           // bit 1
#define SEG10COM1               LCDDATA4bits.SEG10COM1          // bit 2
#define SEG11COM1               LCDDATA4bits.SEG11COM1          // bit 3
#define SEG12COM1               LCDDATA4bits.SEG12COM1          // bit 4
#define SEG13COM1               LCDDATA4bits.SEG13COM1          // bit 5
#define SEG14COM1               LCDDATA4bits.SEG14COM1          // bit 6
#define SEG15COM1               LCDDATA4bits.SEG15COM1          // bit 7

#define SEG16COM1               LCDDATA5bits.SEG16COM1          // bit 0
#define SEG17COM1               LCDDATA5bits.SEG17COM1          // bit 1
#define SEG18COM1               LCDDATA5bits.SEG18COM1          // bit 2
#define SEG19COM1               LCDDATA5bits.SEG19COM1          // bit 3
#define SEG20COM1               LCDDATA5bits.SEG20COM1          // bit 4
#define SEG21COM1               LCDDATA5bits.SEG21COM1          // bit 5
#define SEG22COM1               LCDDATA5bits.SEG22COM1          // bit 6
#define SEG23COM1               LCDDATA5bits.SEG23COM1          // bit 7

#define SEG0COM2                LCDDATA6bits.SEG0COM2           // bit 0
#define SEG1COM2                LCDDATA6bits.SEG1COM2           // bit 1
#define SEG2COM2                LCDDATA6bits.SEG2COM2           // bit 2
#define SEG3COM2                LCDDATA6bits.SEG3COM2           // bit 3
#define SEG4COM2                LCDDATA6bits.SEG4COM2           // bit 4
#define SEG5COM2                LCDDATA6bits.SEG5COM2           // bit 5
#define SEG6COM2                LCDDATA6bits.SEG6COM2           // bit 6
#define SEG7COM2                LCDDATA6bits.SEG7COM2           // bit 7

#define SEG8COM2                LCDDATA7bits.SEG8COM2           // bit 0
#define SEG9COM2                LCDDATA7bits.SEG9COM2           // bit 1
#define SEG10COM2               LCDDATA7bits.SEG10COM2          // bit 2
#define SEG11COM2               LCDDATA7bits.SEG11COM2          // bit 3
#define SEG12COM2               LCDDATA7bits.SEG12COM2          // bit 4
#define SEG13COM2               LCDDATA7bits.SEG13COM2          // bit 5
#define SEG14COM2               LCDDATA7bits.SEG14COM2          // bit 6
#define SEG15COM2               LCDDATA7bits.SEG15COM2          // bit 7

#define SEG16COM2               LCDDATA8bits.SEG16COM2          // bit 0
#define SEG17COM2               LCDDATA8bits.SEG17COM2          // bit 1
#define SEG18COM2               LCDDATA8bits.SEG18COM2          // bit 2
#define SEG19COM2               LCDDATA8bits.SEG19COM2          // bit 3
#define SEG20COM2               LCDDATA8bits.SEG20COM2          // bit 4
#define SEG21COM2               LCDDATA8bits.SEG21COM2          // bit 5
#define SEG22COM2               LCDDATA8bits.SEG22COM2          // bit 6
#define SEG23COM2               LCDDATA8bits.SEG23COM2          // bit 7

#define SEG0COM3                LCDDATA9bits.SEG0COM3           // bit 0
#define SEG1COM3                LCDDATA9bits.SEG1COM3           // bit 1
#define SEG2COM3                LCDDATA9bits.SEG2COM3           // bit 2
#define SEG3COM3                LCDDATA9bits.SEG3COM3           // bit 3
#define SEG4COM3                LCDDATA9bits.SEG4COM3           // bit 4
#define SEG5COM3                LCDDATA9bits.SEG5COM3           // bit 5
#define SEG6COM3                LCDDATA9bits.SEG6COM3           // bit 6
#define SEG7COM3                LCDDATA9bits.SEG7COM3           // bit 7

#define SEG8COM3                LCDDATA10bits.SEG8COM3          // bit 0
#define SEG9COM3                LCDDATA10bits.SEG9COM3          // bit 1
#define SEG10COM3               LCDDATA10bits.SEG10COM3         // bit 2
#define SEG11COM3               LCDDATA10bits.SEG11COM3         // bit 3
#define SEG12COM3               LCDDATA10bits.SEG12COM3         // bit 4
#define SEG13COM3               LCDDATA10bits.SEG13COM3         // bit 5
#define SEG14COM3               LCDDATA10bits.SEG14COM3         // bit 6
#define SEG15COM3               LCDDATA10bits.SEG15COM3         // bit 7

#define SEG16COM3               LCDDATA11bits.SEG16COM3         // bit 0
#define SEG17COM3               LCDDATA11bits.SEG17COM3         // bit 1
#define SEG18COM3               LCDDATA11bits.SEG18COM3         // bit 2
#define SEG19COM3               LCDDATA11bits.SEG19COM3         // bit 3
#define SEG20COM3               LCDDATA11bits.SEG20COM3         // bit 4
#define SEG21COM3               LCDDATA11bits.SEG21COM3         // bit 5
#define SEG22COM3               LCDDATA11bits.SEG22COM3         // bit 6
#define SEG23COM3               LCDDATA11bits.SEG23COM3         // bit 7

#define SEG24COM0               LCDDATA12bits.SEG24COM0         // bit 0
#define SEG25COM0               LCDDATA12bits.SEG25COM0         // bit 1
#define SEG26COM0               LCDDATA12bits.SEG26COM0         // bit 2
#define SEG27COM0               LCDDATA12bits.SEG27COM0         // bit 3
#define SEG28COM0               LCDDATA12bits.SEG28COM0         // bit 4
#define SEG29COM0               LCDDATA12bits.SEG29COM0         // bit 5
#define SEG30COM0               LCDDATA12bits.SEG30COM0         // bit 6
#define SEG31COM0               LCDDATA12bits.SEG31COM0         // bit 7

#define SEG32COM0               LCDDATA13bits.SEG32COM0         // bit 0
#define SEG33COM0               LCDDATA13bits.SEG33COM0         // bit 1
#define SEG34COM0               LCDDATA13bits.SEG34COM0         // bit 2
#define SEG35COM0               LCDDATA13bits.SEG35COM0         // bit 3
#define SEG36COM0               LCDDATA13bits.SEG36COM0         // bit 4
#define SEG37COM0               LCDDATA13bits.SEG37COM0         // bit 5
#define SEG38COM0               LCDDATA13bits.SEG38COM0         // bit 6
#define SEG39COM0               LCDDATA13bits.SEG39COM0         // bit 7

#define SEG40COM0               LCDDATA14bits.SEG40COM0         // bit 0
#define SEG41COM0               LCDDATA14bits.SEG41COM0         // bit 1
#define SEG42COM0               LCDDATA14bits.SEG42COM0         // bit 2
#define SEG43COM0               LCDDATA14bits.SEG43COM0         // bit 3
#define SEG44COM0               LCDDATA14bits.SEG44COM0         // bit 4
#define SEG45COM0               LCDDATA14bits.SEG45COM0         // bit 5

#define SEG24COM1               LCDDATA15bits.SEG24COM1         // bit 0
#define SEG25COM1               LCDDATA15bits.SEG25COM1         // bit 1
#define SEG26COM1               LCDDATA15bits.SEG26COM1         // bit 2
#define SEG27COM1               LCDDATA15bits.SEG27COM1         // bit 3
#define SEG28COM1               LCDDATA15bits.SEG28COM1         // bit 4
#define SEG29COM1               LCDDATA15bits.SEG29COM1         // bit 5
#define SEG30COM1               LCDDATA15bits.SEG30COM1         // bit 6
#define SEG31COM1               LCDDATA15bits.SEG31COM1         // bit 7

#define SEG32COM1               LCDDATA16bits.SEG32COM1         // bit 0
#define SEG33COM1               LCDDATA16bits.SEG33COM1         // bit 1
#define SEG34COM1               LCDDATA16bits.SEG34COM1         // bit 2
#define SEG35COM1               LCDDATA16bits.SEG35COM1         // bit 3
#define SEG36COM1               LCDDATA16bits.SEG36COM1         // bit 4
#define SEG37COM1               LCDDATA16bits.SEG37COM1         // bit 5
#define SEG38COM1               LCDDATA16bits.SEG38COM1         // bit 6
#define SEG39COM1               LCDDATA16bits.SEG39COM1         // bit 7

#define SEG40COM1               LCDDATA17bits.SEG40COM1         // bit 0
#define SEG41COM1               LCDDATA17bits.SEG41COM1         // bit 1
#define SEG42COM1               LCDDATA17bits.SEG42COM1         // bit 2
#define SEG43COM1               LCDDATA17bits.SEG43COM1         // bit 3
#define SEG44COM1               LCDDATA17bits.SEG44COM1         // bit 4
#define SEG45COM1               LCDDATA17bits.SEG45COM1         // bit 5

#define SEG24COM2               LCDDATA18bits.SEG24COM2         // bit 0
#define SEG25COM2               LCDDATA18bits.SEG25COM2         // bit 1
#define SEG26COM2               LCDDATA18bits.SEG26COM2         // bit 2
#define SEG27COM2               LCDDATA18bits.SEG27COM2         // bit 3
#define SEG28COM2               LCDDATA18bits.SEG28COM2         // bit 4
#define SEG29COM2               LCDDATA18bits.SEG29COM2         // bit 5
#define SEG30COM2               LCDDATA18bits.SEG30COM2         // bit 6
#define SEG31COM2               LCDDATA18bits.SEG31COM2         // bit 7

#define SEG32COM2               LCDDATA19bits.SEG32COM2         // bit 0
#define SEG33COM2               LCDDATA19bits.SEG33COM2         // bit 1
#define SEG34COM2               LCDDATA19bits.SEG34COM2         // bit 2
#define SEG35COM2               LCDDATA19bits.SEG35COM2         // bit 3
#define SEG36COM2               LCDDATA19bits.SEG36COM2         // bit 4
#define SEG37COM2               LCDDATA19bits.SEG37COM2         // bit 5
#define SEG38COM2               LCDDATA19bits.SEG38COM2         // bit 6
#define SEG39COM2               LCDDATA19bits.SEG39COM2         // bit 7

#define SEG40COM2               LCDDATA20bits.SEG40COM2         // bit 0
#define SEG41COM2               LCDDATA20bits.SEG41COM2         // bit 1
#define SEG42COM2               LCDDATA20bits.SEG42COM2         // bit 2
#define SEG43COM2               LCDDATA20bits.SEG43COM2         // bit 3
#define SEG44COM2               LCDDATA20bits.SEG44COM2         // bit 4
#define SEG45COM2               LCDDATA20bits.SEG45COM2         // bit 5

#define SEG24COM3               LCDDATA21bits.SEG24COM3         // bit 0
#define SEG25COM3               LCDDATA21bits.SEG25COM3         // bit 1
#define SEG26COM3               LCDDATA21bits.SEG26COM3         // bit 2
#define SEG27COM3               LCDDATA21bits.SEG27COM3         // bit 3
#define SEG28COM3               LCDDATA21bits.SEG28COM3         // bit 4
#define SEG29COM3               LCDDATA21bits.SEG29COM3         // bit 5
#define SEG30COM3               LCDDATA21bits.SEG30COM3         // bit 6
#define SEG31COM3               LCDDATA21bits.SEG31COM3         // bit 7

#define SEG32COM3               LCDDATA22bits.SEG32COM3         // bit 0
#define SEG33COM3               LCDDATA22bits.SEG33COM3         // bit 1
#define SEG34COM3               LCDDATA22bits.SEG34COM3         // bit 2
#define SEG35COM3               LCDDATA22bits.SEG35COM3         // bit 3
#define SEG36COM3               LCDDATA22bits.SEG36COM3         // bit 4
#define SEG37COM3               LCDDATA22bits.SEG37COM3         // bit 5
#define SEG38COM3               LCDDATA22bits.SEG38COM3         // bit 6
#define SEG39COM3               LCDDATA22bits.SEG39COM3         // bit 7

#define SEG40COM3               LCDDATA23bits.SEG40COM3         // bit 0
#define SEG41COM3               LCDDATA23bits.SEG41COM3         // bit 1
#define SEG42COM3               LCDDATA23bits.SEG42COM3         // bit 2
#define SEG43COM3               LCDDATA23bits.SEG43COM3         // bit 3
#define SEG44COM3               LCDDATA23bits.SEG44COM3         // bit 4
#define SEG45COM3               LCDDATA23bits.SEG45COM3         // bit 5

#define LP0                     LCDPSbits.LP0                   // bit 0
#define LP1                     LCDPSbits.LP1                   // bit 1
#define LP2                     LCDPSbits.LP2                   // bit 2
#define LP3                     LCDPSbits.LP3                   // bit 3
#define WA                      LCDPSbits.WA                    // bit 4
#define LCDA                    LCDPSbits.LCDA                  // bit 5
#define BIASMD                  LCDPSbits.BIASMD                // bit 6
#define WFT                     LCDPSbits.WFT                   // bit 7

#define VLCD1PE                 LCDREFbits.VLCD1PE              // bit 1
#define VLCD2PE                 LCDREFbits.VLCD2PE              // bit 2
#define VLCD3PE                 LCDREFbits.VLCD3PE              // bit 3
#define LCDIRI                  LCDREFbits.LCDIRI               // bit 5
#define LCDIRS                  LCDREFbits.LCDIRS               // bit 6
#define LCDIRE                  LCDREFbits.LCDIRE               // bit 7

#define LRLAT0                  LCDRLbits.LRLAT0                // bit 0
#define LRLAT1                  LCDRLbits.LRLAT1                // bit 1
#define LRLAT2                  LCDRLbits.LRLAT2                // bit 2
#define LRLBP0                  LCDRLbits.LRLBP0                // bit 4
#define LRLBP1                  LCDRLbits.LRLBP1                // bit 5
#define LRLAP0                  LCDRLbits.LRLAP0                // bit 6
#define LRLAP1                  LCDRLbits.LRLAP1                // bit 7

#define SE0                     LCDSE0bits.SE0                  // bit 0
#define SE1                     LCDSE0bits.SE1                  // bit 1
#define SE2                     LCDSE0bits.SE2                  // bit 2
#define SE3                     LCDSE0bits.SE3                  // bit 3
#define SE4                     LCDSE0bits.SE4                  // bit 4
#define SE5                     LCDSE0bits.SE5                  // bit 5
#define SE6                     LCDSE0bits.SE6                  // bit 6
#define SE7                     LCDSE0bits.SE7                  // bit 7

#define SE8                     LCDSE1bits.SE8                  // bit 0
#define SE9                     LCDSE1bits.SE9                  // bit 1
#define SE10                    LCDSE1bits.SE10                 // bit 2
#define SE11                    LCDSE1bits.SE11                 // bit 3
#define SE12                    LCDSE1bits.SE12                 // bit 4
#define SE13                    LCDSE1bits.SE13                 // bit 5
#define SE14                    LCDSE1bits.SE14                 // bit 6
#define SE15                    LCDSE1bits.SE15                 // bit 7

#define SE16                    LCDSE2bits.SE16                 // bit 0
#define SE17                    LCDSE2bits.SE17                 // bit 1
#define SE18                    LCDSE2bits.SE18                 // bit 2
#define SE19                    LCDSE2bits.SE19                 // bit 3
#define SE20                    LCDSE2bits.SE20                 // bit 4
#define SE21                    LCDSE2bits.SE21                 // bit 5
#define SE22                    LCDSE2bits.SE22                 // bit 6
#define SE23                    LCDSE2bits.SE23                 // bit 7

#define SE24                    LCDSE3bits.SE24                 // bit 0
#define SE25                    LCDSE3bits.SE25                 // bit 1
#define SE26                    LCDSE3bits.SE26                 // bit 2
#define SE27                    LCDSE3bits.SE27                 // bit 3
#define SE28                    LCDSE3bits.SE28                 // bit 4
#define SE29                    LCDSE3bits.SE29                 // bit 5
#define SE30                    LCDSE3bits.SE30                 // bit 6
#define SE31                    LCDSE3bits.SE31                 // bit 7

#define SE32                    LCDSE4bits.SE32                 // bit 0
#define SE33                    LCDSE4bits.SE33                 // bit 1
#define SE34                    LCDSE4bits.SE34                 // bit 2
#define SE35                    LCDSE4bits.SE35                 // bit 3
#define SE36                    LCDSE4bits.SE36                 // bit 4
#define SE37                    LCDSE4bits.SE37                 // bit 5
#define SE38                    LCDSE4bits.SE38                 // bit 6
#define SE39                    LCDSE4bits.SE39                 // bit 7

#define SE40                    LCDSE5bits.SE40                 // bit 0
#define SE41                    LCDSE5bits.SE41                 // bit 1
#define SE42                    LCDSE5bits.SE42                 // bit 2
#define SE43                    LCDSE5bits.SE43                 // bit 3
#define SE44                    LCDSE5bits.SE44                 // bit 4
#define SE45                    LCDSE5bits.SE45                 // bit 5

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define T0SE                    OPTION_REGbits.T0SE             // bit 4, shadows bit in OPTION_REGbits
#define TMR0SE                  OPTION_REGbits.TMR0SE           // bit 4, shadows bit in OPTION_REGbits
#define T0CS                    OPTION_REGbits.T0CS             // bit 5, shadows bit in OPTION_REGbits
#define TMR0CS                  OPTION_REGbits.TMR0CS           // bit 5, shadows bit in OPTION_REGbits
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_WPUEN               OPTION_REGbits.NOT_WPUEN        // bit 7

#define SCS0                    OSCCONbits.SCS0                 // bit 0
#define SCS1                    OSCCONbits.SCS1                 // bit 1
#define IRCF0                   OSCCONbits.IRCF0                // bit 3
#define IRCF1                   OSCCONbits.IRCF1                // bit 4
#define IRCF2                   OSCCONbits.IRCF2                // bit 5
#define IRCF3                   OSCCONbits.IRCF3                // bit 6
#define SPLLEN                  OSCCONbits.SPLLEN               // bit 7

#define HFIOFS                  OSCSTATbits.HFIOFS              // bit 0
#define LFIOFR                  OSCSTATbits.LFIOFR              // bit 1
#define MFIOFR                  OSCSTATbits.MFIOFR              // bit 2
#define HFIOFL                  OSCSTATbits.HFIOFL              // bit 3
#define HFIOFR                  OSCSTATbits.HFIOFR              // bit 4
#define OSTS                    OSCSTATbits.OSTS                // bit 5
#define PLLR                    OSCSTATbits.PLLR                // bit 6
#define T1OSCR                  OSCSTATbits.T1OSCR              // bit 7

#define TUN0                    OSCTUNEbits.TUN0                // bit 0
#define TUN1                    OSCTUNEbits.TUN1                // bit 1
#define TUN2                    OSCTUNEbits.TUN2                // bit 2
#define TUN3                    OSCTUNEbits.TUN3                // bit 3
#define TUN4                    OSCTUNEbits.TUN4                // bit 4
#define TUN5                    OSCTUNEbits.TUN5                // bit 5

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define NOT_RI                  PCONbits.NOT_RI                 // bit 2
#define NOT_RMCLR               PCONbits.NOT_RMCLR              // bit 3
#define STKUNF                  PCONbits.STKUNF                 // bit 6
#define STKOVF                  PCONbits.STKOVF                 // bit 7

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define CCP1IE                  PIE1bits.CCP1IE                 // bit 2
#define SSP1IE                  PIE1bits.SSP1IE                 // bit 3, shadows bit in PIE1bits
#define SSPIE                   PIE1bits.SSPIE                  // bit 3, shadows bit in PIE1bits
#define TX1IE                   PIE1bits.TX1IE                  // bit 4, shadows bit in PIE1bits
#define TXIE                    PIE1bits.TXIE                   // bit 4, shadows bit in PIE1bits
#define RC1IE                   PIE1bits.RC1IE                  // bit 5, shadows bit in PIE1bits
#define RCIE                    PIE1bits.RCIE                   // bit 5, shadows bit in PIE1bits
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define CCP2IE                  PIE2bits.CCP2IE                 // bit 0
#define C3IE                    PIE2bits.C3IE                   // bit 1
#define LCDIE                   PIE2bits.LCDIE                  // bit 2
#define BCLIE                   PIE2bits.BCLIE                  // bit 3
#define EEIE                    PIE2bits.EEIE                   // bit 4
#define C1IE                    PIE2bits.C1IE                   // bit 5
#define C2IE                    PIE2bits.C2IE                   // bit 6
#define OSFIE                   PIE2bits.OSFIE                  // bit 7

#define TMR4IE                  PIE3bits.TMR4IE                 // bit 1
#define TMR6IE                  PIE3bits.TMR6IE                 // bit 3
#define CCP3IE                  PIE3bits.CCP3IE                 // bit 4
#define CCP4IE                  PIE3bits.CCP4IE                 // bit 5
#define CCP5IE                  PIE3bits.CCP5IE                 // bit 6

#define SSP2IE                  PIE4bits.SSP2IE                 // bit 0
#define BCL2IE                  PIE4bits.BCL2IE                 // bit 1
#define TX2IE                   PIE4bits.TX2IE                  // bit 4
#define RC2IE                   PIE4bits.RC2IE                  // bit 5

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define CCP1IF                  PIR1bits.CCP1IF                 // bit 2
#define SSP1IF                  PIR1bits.SSP1IF                 // bit 3, shadows bit in PIR1bits
#define SSPIF                   PIR1bits.SSPIF                  // bit 3, shadows bit in PIR1bits
#define TX1IF                   PIR1bits.TX1IF                  // bit 4, shadows bit in PIR1bits
#define TXIF                    PIR1bits.TXIF                   // bit 4, shadows bit in PIR1bits
#define RC1IF                   PIR1bits.RC1IF                  // bit 5, shadows bit in PIR1bits
#define RCIF                    PIR1bits.RCIF                   // bit 5, shadows bit in PIR1bits
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define CCP2IF                  PIR2bits.CCP2IF                 // bit 0
#define C3IF                    PIR2bits.C3IF                   // bit 1
#define LCDIF                   PIR2bits.LCDIF                  // bit 2
#define BCLIF                   PIR2bits.BCLIF                  // bit 3
#define EEIF                    PIR2bits.EEIF                   // bit 4
#define C1IF                    PIR2bits.C1IF                   // bit 5
#define C2IF                    PIR2bits.C2IF                   // bit 6
#define OSFIF                   PIR2bits.OSFIF                  // bit 7

#define TMR4IF                  PIR3bits.TMR4IF                 // bit 1
#define TMR6IF                  PIR3bits.TMR6IF                 // bit 3
#define CCP3IF                  PIR3bits.CCP3IF                 // bit 4
#define CCP4IF                  PIR3bits.CCP4IF                 // bit 5
#define CCP5IF                  PIR3bits.CCP5IF                 // bit 6

#define SSP2IF                  PIR4bits.SSP2IF                 // bit 0
#define BCL2IF                  PIR4bits.BCL2IF                 // bit 1
#define TX2IF                   PIR4bits.TX2IF                  // bit 4
#define RC2IF                   PIR4bits.RC2IF                  // bit 5

#define RA0                     PORTAbits.RA0                   // bit 0, shadows bit in PORTAbits
#define AN0                     PORTAbits.AN0                   // bit 0, shadows bit in PORTAbits
#define CPS0                    PORTAbits.CPS0                  // bit 0, shadows bit in PORTAbits
#define SEG33                   PORTAbits.SEG33                 // bit 0, shadows bit in PORTAbits
#define RA1                     PORTAbits.RA1                   // bit 1, shadows bit in PORTAbits
#define AN1                     PORTAbits.AN1                   // bit 1, shadows bit in PORTAbits
#define CPS1                    PORTAbits.CPS1                  // bit 1, shadows bit in PORTAbits
#define SEG18                   PORTAbits.SEG18                 // bit 1, shadows bit in PORTAbits
#define RA2                     PORTAbits.RA2                   // bit 2, shadows bit in PORTAbits
#define AN2                     PORTAbits.AN2                   // bit 2, shadows bit in PORTAbits
#define CPS2                    PORTAbits.CPS2                  // bit 2, shadows bit in PORTAbits
#define SEG34                   PORTAbits.SEG34                 // bit 2, shadows bit in PORTAbits
#define VREFM                   PORTAbits.VREFM                 // bit 2, shadows bit in PORTAbits
#define RA3                     PORTAbits.RA3                   // bit 3, shadows bit in PORTAbits
#define AN3                     PORTAbits.AN3                   // bit 3, shadows bit in PORTAbits
#define CPS3                    PORTAbits.CPS3                  // bit 3, shadows bit in PORTAbits
#define SEG35                   PORTAbits.SEG35                 // bit 3, shadows bit in PORTAbits
#define VREFP                   PORTAbits.VREFP                 // bit 3, shadows bit in PORTAbits
#define RA4                     PORTAbits.RA4                   // bit 4, shadows bit in PORTAbits
#define SEG14                   PORTAbits.SEG14                 // bit 4, shadows bit in PORTAbits
#define T0CKI                   PORTAbits.T0CKI                 // bit 4, shadows bit in PORTAbits
#define RA5                     PORTAbits.RA5                   // bit 5, shadows bit in PORTAbits
#define AN4                     PORTAbits.AN4                   // bit 5, shadows bit in PORTAbits
#define CPS4                    PORTAbits.CPS4                  // bit 5, shadows bit in PORTAbits
#define SEG15                   PORTAbits.SEG15                 // bit 5, shadows bit in PORTAbits
#define RA6                     PORTAbits.RA6                   // bit 6, shadows bit in PORTAbits
#define SEG36                   PORTAbits.SEG36                 // bit 6, shadows bit in PORTAbits
#define OSC2                    PORTAbits.OSC2                  // bit 6, shadows bit in PORTAbits
#define CLKOUT                  PORTAbits.CLKOUT                // bit 6, shadows bit in PORTAbits
#define RA7                     PORTAbits.RA7                   // bit 7, shadows bit in PORTAbits
#define SEG37                   PORTAbits.SEG37                 // bit 7, shadows bit in PORTAbits
#define OSC1                    PORTAbits.OSC1                  // bit 7, shadows bit in PORTAbits
#define CLKIN                   PORTAbits.CLKIN                 // bit 7, shadows bit in PORTAbits

#define RB0                     PORTBbits.RB0                   // bit 0, shadows bit in PORTBbits
#define SEG30                   PORTBbits.SEG30                 // bit 0, shadows bit in PORTBbits
#define SRI                     PORTBbits.SRI                   // bit 0, shadows bit in PORTBbits
#define FLT0                    PORTBbits.FLT0                  // bit 0, shadows bit in PORTBbits
#define RB1                     PORTBbits.RB1                   // bit 1, shadows bit in PORTBbits
#define SEG8                    PORTBbits.SEG8                  // bit 1, shadows bit in PORTBbits
#define RB2                     PORTBbits.RB2                   // bit 2, shadows bit in PORTBbits
#define SEG9                    PORTBbits.SEG9                  // bit 2, shadows bit in PORTBbits
#define RB3                     PORTBbits.RB3                   // bit 3, shadows bit in PORTBbits
#define SEG10                   PORTBbits.SEG10                 // bit 3, shadows bit in PORTBbits
#define RB4                     PORTBbits.RB4                   // bit 4, shadows bit in PORTBbits
#define SEG11                   PORTBbits.SEG11                 // bit 4, shadows bit in PORTBbits
#define RB5                     PORTBbits.RB5                   // bit 5, shadows bit in PORTBbits
#define SEG29                   PORTBbits.SEG29                 // bit 5, shadows bit in PORTBbits
#define T1G                     PORTBbits.T1G                   // bit 5, shadows bit in PORTBbits
#define RB6                     PORTBbits.RB6                   // bit 6, shadows bit in PORTBbits
#define SEG38                   PORTBbits.SEG38                 // bit 6, shadows bit in PORTBbits
#define RB7                     PORTBbits.RB7                   // bit 7, shadows bit in PORTBbits
#define SEG39                   PORTBbits.SEG39                 // bit 7, shadows bit in PORTBbits

#define RC0                     PORTCbits.RC0                   // bit 0, shadows bit in PORTCbits
#define SEG40                   PORTCbits.SEG40                 // bit 0, shadows bit in PORTCbits
#define T1OSO                   PORTCbits.T1OSO                 // bit 0, shadows bit in PORTCbits
#define T1CKI                   PORTCbits.T1CKI                 // bit 0, shadows bit in PORTCbits
#define RC1                     PORTCbits.RC1                   // bit 1, shadows bit in PORTCbits
#define SEG32                   PORTCbits.SEG32                 // bit 1, shadows bit in PORTCbits
#define T1OSI                   PORTCbits.T1OSI                 // bit 1, shadows bit in PORTCbits
#define CCP2                    PORTCbits.CCP2                  // bit 1, shadows bit in PORTCbits
#define P2A                     PORTCbits.P2A                   // bit 1, shadows bit in PORTCbits
#define RC2                     PORTCbits.RC2                   // bit 2, shadows bit in PORTCbits
#define SEG13                   PORTCbits.SEG13                 // bit 2, shadows bit in PORTCbits
#define CCP1                    PORTCbits.CCP1                  // bit 2, shadows bit in PORTCbits
#define P1A                     PORTCbits.P1A                   // bit 2, shadows bit in PORTCbits
#define RC3                     PORTCbits.RC3                   // bit 3, shadows bit in PORTCbits
#define SEG17                   PORTCbits.SEG17                 // bit 3, shadows bit in PORTCbits
#define SCK1                    PORTCbits.SCK1                  // bit 3, shadows bit in PORTCbits
#define SCL1                    PORTCbits.SCL1                  // bit 3, shadows bit in PORTCbits
#define RC4                     PORTCbits.RC4                   // bit 4, shadows bit in PORTCbits
#define SEG16                   PORTCbits.SEG16                 // bit 4, shadows bit in PORTCbits
#define SDI1                    PORTCbits.SDI1                  // bit 4, shadows bit in PORTCbits
#define SDA1                    PORTCbits.SDA1                  // bit 4, shadows bit in PORTCbits
#define RC5                     PORTCbits.RC5                   // bit 5, shadows bit in PORTCbits
#define SEG12                   PORTCbits.SEG12                 // bit 5, shadows bit in PORTCbits
#define SDO1                    PORTCbits.SDO1                  // bit 5, shadows bit in PORTCbits
#define RC6                     PORTCbits.RC6                   // bit 6, shadows bit in PORTCbits
#define SEG27                   PORTCbits.SEG27                 // bit 6, shadows bit in PORTCbits
#define TX1                     PORTCbits.TX1                   // bit 6, shadows bit in PORTCbits
#define CK1                     PORTCbits.CK1                   // bit 6, shadows bit in PORTCbits
#define RC7                     PORTCbits.RC7                   // bit 7, shadows bit in PORTCbits
#define SEG28                   PORTCbits.SEG28                 // bit 7, shadows bit in PORTCbits
#define RX1                     PORTCbits.RX1                   // bit 7, shadows bit in PORTCbits
#define DT1                     PORTCbits.DT1                   // bit 7, shadows bit in PORTCbits

#define RD0                     PORTDbits.RD0                   // bit 0, shadows bit in PORTDbits
#define SEG0                    PORTDbits.SEG0                  // bit 0, shadows bit in PORTDbits
#define P2D                     PORTDbits.P2D                   // bit 0, shadows bit in PORTDbits
#define RD1                     PORTDbits.RD1                   // bit 1, shadows bit in PORTDbits
#define SEG1                    PORTDbits.SEG1                  // bit 1, shadows bit in PORTDbits
#define P2C                     PORTDbits.P2C                   // bit 1, shadows bit in PORTDbits
#define RD2                     PORTDbits.RD2                   // bit 2, shadows bit in PORTDbits
#define SEG2                    PORTDbits.SEG2                  // bit 2, shadows bit in PORTDbits
#define P2B                     PORTDbits.P2B                   // bit 2, shadows bit in PORTDbits
#define RD3                     PORTDbits.RD3                   // bit 3, shadows bit in PORTDbits
#define SEG3                    PORTDbits.SEG3                  // bit 3, shadows bit in PORTDbits
#define P3C                     PORTDbits.P3C                   // bit 3, shadows bit in PORTDbits
#define RD4                     PORTDbits.RD4                   // bit 4, shadows bit in PORTDbits
#define SEG4                    PORTDbits.SEG4                  // bit 4, shadows bit in PORTDbits
#define P3B                     PORTDbits.P3B                   // bit 4, shadows bit in PORTDbits
#define SDO2                    PORTDbits.SDO2                  // bit 4, shadows bit in PORTDbits
#define RD5                     PORTDbits.RD5                   // bit 5, shadows bit in PORTDbits
#define SEG5                    PORTDbits.SEG5                  // bit 5, shadows bit in PORTDbits
#define P1C                     PORTDbits.P1C                   // bit 5, shadows bit in PORTDbits
#define SDI2                    PORTDbits.SDI2                  // bit 5, shadows bit in PORTDbits
#define SDA2                    PORTDbits.SDA2                  // bit 5, shadows bit in PORTDbits
#define RD6                     PORTDbits.RD6                   // bit 6, shadows bit in PORTDbits
#define SEG6                    PORTDbits.SEG6                  // bit 6, shadows bit in PORTDbits
#define P1B                     PORTDbits.P1B                   // bit 6, shadows bit in PORTDbits
#define SCK2                    PORTDbits.SCK2                  // bit 6, shadows bit in PORTDbits
#define SCL2                    PORTDbits.SCL2                  // bit 6, shadows bit in PORTDbits
#define RD7                     PORTDbits.RD7                   // bit 7, shadows bit in PORTDbits
#define SEG7                    PORTDbits.SEG7                  // bit 7, shadows bit in PORTDbits
#define NOT_SS2                 PORTDbits.NOT_SS2               // bit 7, shadows bit in PORTDbits

#define STR1A                   PSTR1CONbits.STR1A              // bit 0
#define STR1B                   PSTR1CONbits.STR1B              // bit 1
#define STR1C                   PSTR1CONbits.STR1C              // bit 2
#define STR1D                   PSTR1CONbits.STR1D              // bit 3
#define STR1SYNC                PSTR1CONbits.STR1SYNC           // bit 4

#define STR2A                   PSTR2CONbits.STR2A              // bit 0
#define STR2B                   PSTR2CONbits.STR2B              // bit 1
#define STR2C                   PSTR2CONbits.STR2C              // bit 2
#define STR2D                   PSTR2CONbits.STR2D              // bit 3
#define STR2SYNC                PSTR2CONbits.STR2SYNC           // bit 4

#define STR3A                   PSTR3CONbits.STR3A              // bit 0
#define STR3B                   PSTR3CONbits.STR3B              // bit 1
#define STR3C                   PSTR3CONbits.STR3C              // bit 2
#define STR3D                   PSTR3CONbits.STR3D              // bit 3
#define STR3SYNC                PSTR3CONbits.STR3SYNC           // bit 4

#define P1DC0                   PWM1CONbits.P1DC0               // bit 0
#define P1DC1                   PWM1CONbits.P1DC1               // bit 1
#define P1DC2                   PWM1CONbits.P1DC2               // bit 2
#define P1DC3                   PWM1CONbits.P1DC3               // bit 3
#define P1DC4                   PWM1CONbits.P1DC4               // bit 4
#define P1DC5                   PWM1CONbits.P1DC5               // bit 5
#define P1DC6                   PWM1CONbits.P1DC6               // bit 6
#define P1RSEN                  PWM1CONbits.P1RSEN              // bit 7

#define P2DC0                   PWM2CONbits.P2DC0               // bit 0
#define P2DC1                   PWM2CONbits.P2DC1               // bit 1
#define P2DC2                   PWM2CONbits.P2DC2               // bit 2
#define P2DC3                   PWM2CONbits.P2DC3               // bit 3
#define P2DC4                   PWM2CONbits.P2DC4               // bit 4
#define P2DC5                   PWM2CONbits.P2DC5               // bit 5
#define P2DC6                   PWM2CONbits.P2DC6               // bit 6
#define P2RSEN                  PWM2CONbits.P2RSEN              // bit 7

#define P3DC0                   PWM3CONbits.P3DC0               // bit 0
#define P3DC1                   PWM3CONbits.P3DC1               // bit 1
#define P3DC2                   PWM3CONbits.P3DC2               // bit 2
#define P3DC3                   PWM3CONbits.P3DC3               // bit 3
#define P3DC4                   PWM3CONbits.P3DC4               // bit 4
#define P3DC5                   PWM3CONbits.P3DC5               // bit 5
#define P3DC6                   PWM3CONbits.P3DC6               // bit 6
#define P3RSEN                  PWM3CONbits.P3RSEN              // bit 7

#define RX9D                    RC1STAbits.RX9D                 // bit 0
#define OERR                    RC1STAbits.OERR                 // bit 1
#define FERR                    RC1STAbits.FERR                 // bit 2
#define ADDEN                   RC1STAbits.ADDEN                // bit 3
#define CREN                    RC1STAbits.CREN                 // bit 4
#define SREN                    RC1STAbits.SREN                 // bit 5
#define RX9                     RC1STAbits.RX9                  // bit 6
#define SPEN                    RC1STAbits.SPEN                 // bit 7

#define SRPR                    SRCON0bits.SRPR                 // bit 0
#define SRPS                    SRCON0bits.SRPS                 // bit 1
#define SRNQEN                  SRCON0bits.SRNQEN               // bit 2
#define SRQEN                   SRCON0bits.SRQEN                // bit 3
#define SRCLK0                  SRCON0bits.SRCLK0               // bit 4
#define SRCLK1                  SRCON0bits.SRCLK1               // bit 5
#define SRCLK2                  SRCON0bits.SRCLK2               // bit 6
#define SRLEN                   SRCON0bits.SRLEN                // bit 7

#define SRRC1E                  SRCON1bits.SRRC1E               // bit 0
#define SRRC2E                  SRCON1bits.SRRC2E               // bit 1
#define SRRCKE                  SRCON1bits.SRRCKE               // bit 2
#define SRRPE                   SRCON1bits.SRRPE                // bit 3
#define SRSC1E                  SRCON1bits.SRSC1E               // bit 4
#define SRSC2E                  SRCON1bits.SRSC2E               // bit 5
#define SRSCKE                  SRCON1bits.SRSCKE               // bit 6
#define SRSPE                   SRCON1bits.SRSPE                // bit 7

#define SSPM0                   SSP1CON1bits.SSPM0              // bit 0
#define SSPM1                   SSP1CON1bits.SSPM1              // bit 1
#define SSPM2                   SSP1CON1bits.SSPM2              // bit 2
#define SSPM3                   SSP1CON1bits.SSPM3              // bit 3
#define CKP                     SSP1CON1bits.CKP                // bit 4
#define SSPEN                   SSP1CON1bits.SSPEN              // bit 5
#define SSPOV                   SSP1CON1bits.SSPOV              // bit 6
#define WCOL                    SSP1CON1bits.WCOL               // bit 7

#define SEN                     SSP1CON2bits.SEN                // bit 0
#define RSEN                    SSP1CON2bits.RSEN               // bit 1
#define PEN                     SSP1CON2bits.PEN                // bit 2
#define RCEN                    SSP1CON2bits.RCEN               // bit 3
#define ACKEN                   SSP1CON2bits.ACKEN              // bit 4
#define ACKDT                   SSP1CON2bits.ACKDT              // bit 5
#define ACKSTAT                 SSP1CON2bits.ACKSTAT            // bit 6
#define GCEN                    SSP1CON2bits.GCEN               // bit 7

#define DHEN                    SSP1CON3bits.DHEN               // bit 0
#define AHEN                    SSP1CON3bits.AHEN               // bit 1
#define SBCDE                   SSP1CON3bits.SBCDE              // bit 2
#define SDAHT                   SSP1CON3bits.SDAHT              // bit 3
#define BOEN                    SSP1CON3bits.BOEN               // bit 4
#define SCIE                    SSP1CON3bits.SCIE               // bit 5
#define PCIE                    SSP1CON3bits.PCIE               // bit 6
#define ACKTIM                  SSP1CON3bits.ACKTIM             // bit 7

#define BF                      SSP1STATbits.BF                 // bit 0
#define UA                      SSP1STATbits.UA                 // bit 1
#define R_NOT_W                 SSP1STATbits.R_NOT_W            // bit 2
#define S                       SSP1STATbits.S                  // bit 3
#define P                       SSP1STATbits.P                  // bit 4
#define D_NOT_A                 SSP1STATbits.D_NOT_A            // bit 5
#define CKE                     SSP1STATbits.CKE                // bit 6
#define SMP                     SSP1STATbits.SMP                // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4

#define C_SHAD                  STATUS_SHADbits.C_SHAD          // bit 0
#define DC_SHAD                 STATUS_SHADbits.DC_SHAD         // bit 1
#define Z_SHAD                  STATUS_SHADbits.Z_SHAD          // bit 2

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2
#define T1OSCEN                 T1CONbits.T1OSCEN               // bit 3
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1CS0                 T1CONbits.TMR1CS0               // bit 6
#define TMR1CS1                 T1CONbits.TMR1CS1               // bit 7

#define T1GSS0                  T1GCONbits.T1GSS0               // bit 0
#define T1GSS1                  T1GCONbits.T1GSS1               // bit 1
#define T1GVAL                  T1GCONbits.T1GVAL               // bit 2
#define T1GGO_NOT_DONE          T1GCONbits.T1GGO_NOT_DONE       // bit 3, shadows bit in T1GCONbits
#define T1GGO                   T1GCONbits.T1GGO                // bit 3, shadows bit in T1GCONbits
#define T1GSPM                  T1GCONbits.T1GSPM               // bit 4
#define T1GTM                   T1GCONbits.T1GTM                // bit 5
#define T1GPOL                  T1GCONbits.T1GPOL               // bit 6
#define TMR1GE                  T1GCONbits.TMR1GE               // bit 7

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define T2OUTPS0                T2CONbits.T2OUTPS0              // bit 3
#define T2OUTPS1                T2CONbits.T2OUTPS1              // bit 4
#define T2OUTPS2                T2CONbits.T2OUTPS2              // bit 5
#define T2OUTPS3                T2CONbits.T2OUTPS3              // bit 6

#define T4CKPS0                 T4CONbits.T4CKPS0               // bit 0
#define T4CKPS1                 T4CONbits.T4CKPS1               // bit 1
#define TMR4ON                  T4CONbits.TMR4ON                // bit 2
#define T4OUTPS0                T4CONbits.T4OUTPS0              // bit 3
#define T4OUTPS1                T4CONbits.T4OUTPS1              // bit 4
#define T4OUTPS2                T4CONbits.T4OUTPS2              // bit 5
#define T4OUTPS3                T4CONbits.T4OUTPS3              // bit 6

#define T6CKPS0                 T6CONbits.T6CKPS0               // bit 0
#define T6CKPS1                 T6CONbits.T6CKPS1               // bit 1
#define TMR6ON                  T6CONbits.TMR6ON                // bit 2
#define T6OUTPS0                T6CONbits.T6OUTPS0              // bit 3
#define T6OUTPS1                T6CONbits.T6OUTPS1              // bit 4
#define T6OUTPS2                T6CONbits.T6OUTPS2              // bit 5
#define T6OUTPS3                T6CONbits.T6OUTPS3              // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5
#define TRISA6                  TRISAbits.TRISA6                // bit 6
#define TRISA7                  TRISAbits.TRISA7                // bit 7

#define TRISB0                  TRISBbits.TRISB0                // bit 0
#define TRISB1                  TRISBbits.TRISB1                // bit 1
#define TRISB2                  TRISBbits.TRISB2                // bit 2
#define TRISB3                  TRISBbits.TRISB3                // bit 3
#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5
#define TRISC6                  TRISCbits.TRISC6                // bit 6
#define TRISC7                  TRISCbits.TRISC7                // bit 7

#define TRISD0                  TRISDbits.TRISD0                // bit 0
#define TRISD1                  TRISDbits.TRISD1                // bit 1
#define TRISD2                  TRISDbits.TRISD2                // bit 2
#define TRISD3                  TRISDbits.TRISD3                // bit 3
#define TRISD4                  TRISDbits.TRISD4                // bit 4
#define TRISD5                  TRISDbits.TRISD5                // bit 5
#define TRISD6                  TRISDbits.TRISD6                // bit 6
#define TRISD7                  TRISDbits.TRISD7                // bit 7

#define TRISE0                  TRISEbits.TRISE0                // bit 0
#define TRISE1                  TRISEbits.TRISE1                // bit 1
#define TRISE2                  TRISEbits.TRISE2                // bit 2
#define TRISE3                  TRISEbits.TRISE3                // bit 3
#define TRISE4                  TRISEbits.TRISE4                // bit 4
#define TRISE5                  TRISEbits.TRISE5                // bit 5
#define TRISE6                  TRISEbits.TRISE6                // bit 6
#define TRISE7                  TRISEbits.TRISE7                // bit 7

#define TRISF0                  TRISFbits.TRISF0                // bit 0
#define TRISF1                  TRISFbits.TRISF1                // bit 1
#define TRISF2                  TRISFbits.TRISF2                // bit 2
#define TRISF3                  TRISFbits.TRISF3                // bit 3
#define TRISF4                  TRISFbits.TRISF4                // bit 4
#define TRISF5                  TRISFbits.TRISF5                // bit 5
#define TRISF6                  TRISFbits.TRISF6                // bit 6
#define TRISF7                  TRISFbits.TRISF7                // bit 7

#define TRISG0                  TRISGbits.TRISG0                // bit 0
#define TRISG1                  TRISGbits.TRISG1                // bit 1
#define TRISG2                  TRISGbits.TRISG2                // bit 2
#define TRISG3                  TRISGbits.TRISG3                // bit 3
#define TRISG4                  TRISGbits.TRISG4                // bit 4
#define TRISG5                  TRISGbits.TRISG5                // bit 5

#define TX9D                    TX1STAbits.TX9D                 // bit 0
#define TRMT                    TX1STAbits.TRMT                 // bit 1
#define BRGH                    TX1STAbits.BRGH                 // bit 2
#define SENDB                   TX1STAbits.SENDB                // bit 3
#define SYNC                    TX1STAbits.SYNC                 // bit 4
#define TXEN                    TX1STAbits.TXEN                 // bit 5
#define TX9                     TX1STAbits.TX9                  // bit 6
#define CSRC                    TX1STAbits.CSRC                 // bit 7

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4
#define WDTPS4                  WDTCONbits.WDTPS4               // bit 5

#define WPUB0                   WPUBbits.WPUB0                  // bit 0
#define WPUB1                   WPUBbits.WPUB1                  // bit 1
#define WPUB2                   WPUBbits.WPUB2                  // bit 2
#define WPUB3                   WPUBbits.WPUB3                  // bit 3
#define WPUB4                   WPUBbits.WPUB4                  // bit 4
#define WPUB5                   WPUBbits.WPUB5                  // bit 5
#define WPUB6                   WPUBbits.WPUB6                  // bit 6
#define WPUB7                   WPUBbits.WPUB7                  // bit 7

#define WPUG5                   WPUGbits.WPUG5                  // bit 5

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16F1946_H__
