;################################################################################
;#										#
;# Z80 emulator		 							#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.macro getpcbyte
		getmembyte	@0,PC_L,PC_H	;10/11
		adiw	PC_L,1			;2 increment PC
.endmacro

.macro getpcbyte_m1
.if nop_gate == 1
		clr	@0			;1
		getmembyte	r0,PC_L,PC_H	;10/11
		sbrc	PC_H,7			;exec always if < 0x8000
		sbrc	r0,6			;exec not if bit 6=0
		mov	@0,r0
		adiw	PC_L,1			;2 increment PC
.else
		getmembyte	@0,PC_L,PC_H	;10/11
		adiw	PC_L,1			;2 increment PC
.endif
.endmacro

.macro getpcword
		getmemword	@0,@1,PC_L,PC_H
		adiw	PC_L,2			;2 increment PC
.endmacro


.macro getixbyte
		movw	r0,reg_ixl
		mov	ZL,@1
		ldi	ZH,0x80
		sub	ZL,ZH
		sub	r0,ZH
		sbc	r1,const_0
		add	r0,ZL
		adc	r1,const_0
		getmembyte	@0,r0,r1
.endmacro

.macro putixbyte
		movw	r0,reg_ixl
		mov	ZL,@1
		ldi	ZH,0x80
		sub	ZL,ZH
		sub	r0,ZH
		sbc	r1,const_0
		add	r0,ZL
		adc	r1,const_0
		putmembyte	@0,r0,r1
.endmacro

.macro getiybyte
		movw	r0,reg_iyl
		mov	ZL,@1
		ldi	ZH,0x80
		sub	ZL,ZH
		sub	r0,ZH
		sbc	r1,const_0
		add	r0,ZL
		adc	r1,const_0
		getmembyte	@0,r0,r1
.endmacro

.macro putiybyte
		movw	r0,reg_iyl
		mov	ZL,@1
		ldi	ZH,0x80
		sub	ZL,ZH
		sub	r0,ZH
		sbc	r1,const_0
		add	r0,ZL
		adc	r1,const_0
		putmembyte	@0,r0,r1
.endmacro


.macro z80_setnflag
		out	GPIOR0,const_1
.endm

.macro z80_clrnflag
		out	GPIOR0,const_0
.endm


.macro z80_rlc
		bst	@0,7			;1
		lsl	@0			;1
		bld	@0,0			;1
		mov	ZL,@0			;1
.endm

.macro z80_rl
		lsr	reg_f			;1 shift out carry
		bst	@0,7			;1 save bit 7 for new carry
		rol	@0			;1
		mov	ZL,@0			;1
.endm

.macro z80_rrc
		bst	@0,0			;1
		lsr	@0			;1
		bld	@0,7			;1
		mov	ZL,@0			;1
.endm

.macro z80_rr
		mov	r18,reg_f		;1 copy flagbyte
		lsr	r18			;1 shift out carry
		bst	@0,0
		ror	@0			;1
		mov	ZL,@0			;1
.endm

.macro z80_sla
		bst	@0,7
		lsl	@0			;1
		mov	ZL,@0			;1
.endm

.macro z80_sls
		bst	@0,7
		lsl	@0			;1
		or	@0,const_1
		mov	ZL,@0			;1
.endm

.macro z80_sra
		mov	r18,@0
		lsl	r18
		bst	@0,0
		ror	@0			;1
		mov	ZL,@0			;1
.endm

.macro z80_srl
		bst	@0,0
		lsr	@0			;1
		mov	ZL,@0			;1
.endm

.macro z80_bit
		mov	r18,@0
		com	r18
		bst	r18,@1
		bld	reg_f,1
		andi	reg_f,0xfb		;1 clear S
		z80_clrnflag			;1 clear N
		ori	reg_f,flags_seth	;1 set H
.endm

.macro z80_res
		ldi	r18,255-(1<<@1)
		and	@0,r18
.endm

.macro z80_set
		ldi	r18,1<<@1
		or	@0,r18
.endm



.macro reg_add
		add	reg_a,@0
.endm

.macro reg_adc
		lsr	reg_f			;shift out carry
		adc	reg_a,@0
.endm

.macro reg_sub
		sub	reg_a,@0
.endm

.macro reg_sbc
		lsr	reg_f			;shift out carry
		sez				;set zero flag
		sbc	reg_a,@0
.endm

.macro reg_cmp
		cp	reg_a,@0
.endm


.macro z80_increg
		bst	reg_f,aflag_c		;save old carry
		add	@0,const_1		;+1
		in	reg_f,SREG
		bld	reg_f,aflag_c		;restore old carry
		z80_clrnflag
.endm

.macro z80_inc16
		add	@0,const_1		;+1
		adc	@1,const_0
.endm

.macro z80_decreg
		bst	reg_f,aflag_c		;save old carry
		sub	@0,const_1		;+1
		in	reg_f,SREG
		bld	reg_f,aflag_c		;restore old carry
		z80_setnflag
.endm

.macro z80_dec16
		sub	@0,const_1		;+1
		sbc	@1,const_0
.endm

.macro z80_add16
		lsr	reg_f			;shift out carry
		add	reg_l,@0
		adc	reg_h,@1
		rol	reg_f			;shift in new carry
		z80_clrnflag			;clear N flag
.endm



.macro z80_loop
		rjmp	emu_loop
.endm


.macro z80_push
		ldi	XL,2
		sub	SP_L,XL
		sbc	SP_H,const_0
		putmemword	@0,@1,SP_L,SP_H
.endm

.macro z80_pop
		getmemword	@0,@1,SP_L,SP_H
		ldi	XL,2
		add	SP_L,XL
		adc	SP_H,const_0
.endm
