;################################################################################
;#										#
;# libmio - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
;the keyboard routine
;09 no char from keyboard
;26 key, but released
;43 key, state 1
;------------------------------------------------------------------------------
libmio_keyb:
		lds	ZL,UCSR0A		;2 status
		sbrs	ZL,RXC0			;1 RXC?
		rjmp	libmio_kir_end		;2 no byte available
		lds	ZL,UDR0			;2 get data
		lds	XL,libmio_kbdstate	;2

;+10
		ldi	ZH,HIGH(libmio_kstab*2)	;1 set start of table
		lpm	XH,Z			;3 get config byte
;+14
		sbrs	XH,0			;1 skip if char
		rjmp	libmio_kir_nch		;2 no char
;+16
		sbrs	XL,7			;1 check release flag
		rjmp	libmio_kir_01		;2
		sts	libmio_keycode,const_0	;2 clear keycode
		rjmp	libmio_kir_enb		;2
;+19
libmio_kir_01:	ldi	ZH,HIGH(libmio_ktables*2) ;1 start ext keytable
;+23
;check for extended
		andi	ZL,0x7f			;1 clear bit 7 of low

		sbrc	XL,6			;1 skip if extended
		inc	ZH			;1 table 3 (extended)

		sbrc	XL,0			;1 shift
		ori	ZL,0x80			;1 part 2 of table
;+30
		lpm	ZL,Z			;3 get value
		sts	libmio_keycode,ZL	;2
		sts	libmio_lastkey,ZL
libmio_kir_enb:	andi	XL,0x1f			;1 clear ext and release bit
		sts	libmio_kbdstate,XL	;2 store keyboard status
		pop	ZH			;2 restore sreg
		out	SREG,ZH			;1 put back
		pop	XL			;2 restore Y-register
		pop	XH			;2 restore Y-register
		pop	YL			;2 restore Y-register
		pop	ZL			;2 restore Z-register
		pop	ZH			;2 restore Z-register
		reti				;4 thats all



;no char (+17)
libmio_kir_nch:	sbrs	ZL,7
		rjmp	libmio_kir_nc2

		cpi	ZL,0xf0
		brne	libmio_kir_nc1
		ori	XL,0x80			;1 set release flag
		rjmp	libmio_kir_enc
;+20
libmio_kir_nc1:	cpi	ZL,0xe0
		brne	libmio_kir_nc2
		ori	XL,0x40			;1 set extended flag
		rjmp	libmio_kir_enc

;+23
libmio_kir_ncs:	sbrc	XL,6			;skip if not extended
		rjmp	libmio_kir_enb		;extended->ignore
		ori	XL,0x01			;set shift bit
		sbrc	XL,7			;skip if not release
		andi	XL,0xfe			;clear shift bit
		rjmp	libmio_kir_enb		;thats all

libmio_kir_nc2:	cpi	ZL,0x12			;left shift
		breq	libmio_kir_ncs		;yes
;+26
libmio_kir_nc3:	cpi	ZL,0x59			;right shift
		breq	libmio_kir_ncs		;yes
;+29
libmio_kir_nc4:	cpi	ZL,0x14			;control
		brne	libmio_kir_nc6		;jump if not
		ori	XL,0x04			;set control bit
		sbrc	XL,7			;skip if not release
		andi	XL,0xfb			;clear ctrl bit
		rjmp	libmio_kir_enb		;thats all

;+32
libmio_kir_nc6:	cpi	ZL,0x11			;alternate
		brne	libmio_kir_nc7		;jump if not
		ori	XL,0x10			;set alt bit
		sbrc	XL,7			;skip if not release
		andi	XL,0xef			;clear alt bit
		rjmp	libmio_kir_enb		;thats all

libmio_kir_nc7:	sts	libmio_keycode,const_0	;clear keycode
		andi	XL,0x1f			;1 clear ext and release bit
libmio_kir_enc:	sts	libmio_kbdstate,XL	;2 store keyboard status
libmio_kir_end:

;-------------------------------------------------------------------------------
;restore registers and exit
;-------------------------------------------------------------------------------
		pop	ZH			;2 restore sreg
		out	SREG,ZH			;1 put back
		pop	XL			;2 restore Y-register
		pop	XH			;2 restore Y-register
		pop	YL			;2 restore Y-register
		pop	ZL			;2 restore Z-register
		pop	ZH			;2 restore Z-register
		reti				;4 thats all
