;################################################################################
;#										#
;# Z80 emulator		 							#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

; the level2 jump table
;------------------------------------------------------------------------------
.org (pc+255) & 0xff00

emu7_jtab:	jmp	emu_loop		;2	0x00	NOP
		jmp	emu_code_01
		jmp	emu_code_02
		jmp	emu_code_03
		jmp	emu_code_04
		jmp	emu_code_05
		jmp	emu_code_06
		jmp	emu_code_07
		jmp	emu_code_08
		jmp	emu7_code_09
		jmp	emu_code_0a
		jmp	emu_code_0b
		jmp	emu_code_0c
		jmp	emu_code_0d
		jmp	emu_code_0e
		jmp	emu_code_0f

		jmp	emu_code_10
		jmp	emu_code_11
		jmp	emu_code_12
		jmp	emu_code_13
		jmp	emu_code_14
		jmp	emu_code_15
		jmp	emu_code_16
		jmp	emu_code_17
		jmp	emu_code_18
		jmp	emu7_code_19
		jmp	emu_code_1a
		jmp	emu_code_1b
		jmp	emu_code_1c
		jmp	emu_code_1d
		jmp	emu_code_1e
		jmp	emu_code_1f

		jmp	emu_code_20
		jmp	emu7_code_21
		jmp	emu7_code_22
		jmp	emu7_code_23
		jmp	emu7_code_24
		jmp	emu7_code_25
		jmp	emu7_code_26
		jmp	emu_code_27
		jmp	emu_code_28
		jmp	emu7_code_29
		jmp	emu7_code_2a
		jmp	emu7_code_2b
		jmp	emu7_code_2c
		jmp	emu7_code_2d
		jmp	emu7_code_2e
		jmp	emu_code_2f

		jmp	emu_code_30
		jmp	emu_code_31
		jmp	emu_code_32
		jmp	emu_code_33
		jmp	emu7_code_34
		jmp	emu7_code_35
		jmp	emu7_code_36
		jmp	emu_code_37
		jmp	emu_code_38
		jmp	emu7_code_39
		jmp	emu_code_3a
		jmp	emu_code_3b
		jmp	emu_code_3c
		jmp	emu_code_3d
		jmp	emu_code_3e
		jmp	emu_code_3f

		jmp	emu_code_40
		jmp	emu_code_41
		jmp	emu_code_42
		jmp	emu_code_43
		jmp	emu7_code_44
		jmp	emu7_code_45
		jmp	emu7_code_46
		jmp	emu_code_47
		jmp	emu_code_48
		jmp	emu_code_49
		jmp	emu_code_4a
		jmp	emu_code_4b
		jmp	emu7_code_4c
		jmp	emu7_code_4d
		jmp	emu7_code_4e
		jmp	emu_code_4f

		jmp	emu_code_50
		jmp	emu_code_51
		jmp	emu_code_52
		jmp	emu_code_53
		jmp	emu7_code_54
		jmp	emu7_code_55
		jmp	emu7_code_56
		jmp	emu_code_57
		jmp	emu_code_58
		jmp	emu_code_59
		jmp	emu_code_5a
		jmp	emu_code_5b
		jmp	emu7_code_5c
		jmp	emu7_code_5d
		jmp	emu7_code_5e
		jmp	emu_code_5f

		jmp	emu7_code_60
		jmp	emu7_code_61
		jmp	emu7_code_62
		jmp	emu7_code_63
		jmp	emu7_code_64
		jmp	emu7_code_65
		jmp	emu7_code_66
		jmp	emu7_code_67
		jmp	emu7_code_68
		jmp	emu7_code_69
		jmp	emu7_code_6a
		jmp	emu7_code_6b
		jmp	emu7_code_6c
		jmp	emu7_code_6d
		jmp	emu7_code_6e
		jmp	emu7_code_6f

		jmp	emu7_code_70
		jmp	emu7_code_71
		jmp	emu7_code_72
		jmp	emu7_code_73
		jmp	emu7_code_74
		jmp	emu7_code_75
		jmp	emu_code_76
		jmp	emu7_code_77
		jmp	emu_code_78
		jmp	emu_code_79
		jmp	emu_code_7a
		jmp	emu_code_7b
		jmp	emu7_code_7c
		jmp	emu7_code_7d
		jmp	emu7_code_7e
		jmp	emu_code_7f

		jmp	emu_code_80
		jmp	emu_code_81
		jmp	emu_code_82
		jmp	emu_code_83
		jmp	emu7_code_84
		jmp	emu7_code_85
		jmp	emu7_code_86
		jmp	emu_code_87
		jmp	emu_code_88
		jmp	emu_code_89
		jmp	emu_code_8a
		jmp	emu_code_8b
		jmp	emu7_code_8c
		jmp	emu7_code_8d
		jmp	emu7_code_8e
		jmp	emu_code_8f

		jmp	emu_code_90
		jmp	emu_code_91
		jmp	emu_code_92
		jmp	emu_code_93
		jmp	emu7_code_94
		jmp	emu7_code_95
		jmp	emu7_code_96
		jmp	emu_code_97
		jmp	emu_code_98
		jmp	emu_code_99
		jmp	emu_code_9a
		jmp	emu_code_9b
		jmp	emu7_code_9c
		jmp	emu7_code_9d
		jmp	emu7_code_9e
		jmp	emu_code_9f

		jmp	emu_code_a0
		jmp	emu_code_a1
		jmp	emu_code_a2
		jmp	emu_code_a3
		jmp	emu7_code_a4
		jmp	emu7_code_a5
		jmp	emu7_code_a6
		jmp	emu_code_a7
		jmp	emu_code_a8
		jmp	emu_code_a9
		jmp	emu_code_aa
		jmp	emu_code_ab
		jmp	emu7_code_ac
		jmp	emu7_code_ad
		jmp	emu7_code_ae
		jmp	emu_code_af

		jmp	emu_code_b0
		jmp	emu_code_b1
		jmp	emu_code_b2
		jmp	emu_code_b3
		jmp	emu7_code_b4
		jmp	emu7_code_b5
		jmp	emu7_code_b6
		jmp	emu_code_b7
		jmp	emu_code_b8
		jmp	emu_code_b9
		jmp	emu_code_ba
		jmp	emu_code_bb
		jmp	emu7_code_bc
		jmp	emu7_code_bd
		jmp	emu7_code_be
		jmp	emu_code_bf

		jmp	emu_code_c0
		jmp	emu_code_c1
		jmp	emu_code_c2
		jmp	emu_code_c3
		jmp	emu_code_c4
		jmp	emu_code_c5
		jmp	emu_code_c6
		jmp	emu_code_c7
		jmp	emu_code_c8
		jmp	emu_code_c9
		jmp	emu_code_ca
		jmp	emu7_code_cb
		jmp	emu_code_cc
		jmp	emu_code_cd
		jmp	emu_code_ce
		jmp	emu_code_cf

		jmp	emu_code_d0
		jmp	emu_code_d1
		jmp	emu_code_d2
		jmp	emu_code_d3
		jmp	emu_code_d4
		jmp	emu_code_d5
		jmp	emu_code_d6
		jmp	emu_code_d7
		jmp	emu_code_d8
		jmp	emu_code_d9
		jmp	emu_code_da
		jmp	emu_code_db
		jmp	emu_code_dc
		jmp	emu7_code_dd
		jmp	emu_code_de
		jmp	emu_code_df

		jmp	emu_code_e0
		jmp	emu7_code_e1
		jmp	emu_code_e2
		jmp	emu7_code_e3
		jmp	emu_code_e4
		jmp	emu7_code_e5
		jmp	emu_code_e6
		jmp	emu_code_e7
		jmp	emu_code_e8
		jmp	emu7_code_e9
		jmp	emu_code_ea
		jmp	emu7_code_eb
		jmp	emu_code_ec
		jmp	emu7_code_ed
		jmp	emu_code_ee
		jmp	emu_code_ef

		jmp	emu_code_f0
		jmp	emu_code_f1
		jmp	emu_code_f2
		jmp	emu_code_f3
		jmp	emu_code_f4
		jmp	emu_code_f5
		jmp	emu_code_f6
		jmp	emu_code_f7
		jmp	emu_code_f8
		jmp	emu7_code_f9
		jmp	emu_code_fa
		jmp	emu_code_fb
		jmp	emu_code_fc
		jmp	emu7_code_fd
		jmp	emu_code_fe
		jmp	emu_code_ff

;------------------------------------------------------------------------------
; 0x09		ADD	Ix,BC
;------------------------------------------------------------------------------
emu7_code_09:	lsr	reg_f			;shift out C flag
		add	r0,reg_c
		adc	r1,reg_b
		rol	reg_f			;shift in C flag
		rjmp	emu7_loopnc

;------------------------------------------------------------------------------
; 0x19		ADD	Ix,DE
;------------------------------------------------------------------------------
emu7_code_19:	lsr	reg_f			;shift out C flag
		add	r0,reg_e
		adc	r1,reg_d
		rol	reg_f			;shift in C flag
		rjmp	emu7_loopnc

;------------------------------------------------------------------------------
; 0x21		LD 	Ix,nnnn
;------------------------------------------------------------------------------
emu7_code_21:	getpcword r0,r1
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x22		LD 	(nnnn),Ix
;------------------------------------------------------------------------------
emu7_code_22:	getpcword XL,XH
		putmemword r0,r1,XL,XH
		rjmp	emu7_loopnw		;2 end of command

;------------------------------------------------------------------------------
; 0x23		INC	Ix
;------------------------------------------------------------------------------
emu7_code_23:	z80_inc16	r0,r1
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x24		INC	IxH
;------------------------------------------------------------------------------
emu7_code_24:	z80_increg r1
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x25		DEC	IxH
;------------------------------------------------------------------------------
emu7_code_25:	z80_decreg r1
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x26		LD	IxH,nn
;------------------------------------------------------------------------------
emu7_code_26:	getpcbyte r1
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x29		ADD	Ix,Ix
;------------------------------------------------------------------------------
emu7_code_29:	lsr	reg_f			;shift out C flag
		add	r0,r0
		adc	r1,r1
		rol	reg_f			;shift in C flag
		rjmp	emu7_loopnc

;------------------------------------------------------------------------------
; 0x2a		LD 	Ix,(nnnn)
;------------------------------------------------------------------------------
emu7_code_2a:	getpcword XL,XH
		getmemword r0,r1,XL,XH
		rjmp	emu7_loop		;2 end of command

;------------------------------------------------------------------------------
; 0x2b		DEC	Ix
;------------------------------------------------------------------------------
emu7_code_2b:	z80_dec16	r0,r1
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x2c		INC	IxL
;------------------------------------------------------------------------------
emu7_code_2c:	z80_increg r0
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x2d		DEC	IxL
;------------------------------------------------------------------------------
emu7_code_2d:	z80_decreg r0
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x2e		LD	IxL,nn
;------------------------------------------------------------------------------
emu7_code_2e:	getpcbyte r0
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x34		INC	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_34:	getpcbyte r17
		getidbyte r16,r17
		z80_increg r16
		putidbyte1 r16,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x35		DEC	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_35:	getpcbyte r17
		getidbyte r16,r17
		z80_decreg r16
		putidbyte1 r16,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x36		LD 	(Ix+d),nn
;------------------------------------------------------------------------------
emu7_code_36:	getpcword r17,r16
		putidbyte r16,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x39		ADD	Ix,SP
;------------------------------------------------------------------------------
emu7_code_39:	lsr	reg_f			;shift out C flag
		add	r0,SP_L
		adc	r1,SP_H
		rol	reg_f			;shift in C flag
		rjmp	emu7_loopnc

;------------------------------------------------------------------------------
; 0x44		LD	B,IxH
;------------------------------------------------------------------------------
emu7_code_44:	mov	reg_b,r1
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x45		LD	B,IxL
;------------------------------------------------------------------------------
emu7_code_45:	mov	reg_b,r0
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x46		LD	B,(Ix+d)
;------------------------------------------------------------------------------
emu7_code_46:	getpcbyte r17
		getidbyte reg_b,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x4c		LD	C,IxH
;------------------------------------------------------------------------------
emu7_code_4c:	mov	reg_c,r1
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x4d		LD	C,IxL
;------------------------------------------------------------------------------
emu7_code_4d:	mov	reg_c,r0
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x4e		LD	C,(Ix+d)
;------------------------------------------------------------------------------
emu7_code_4e:	getpcbyte r17
		getidbyte reg_c,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x54		LD	D,IxH
;------------------------------------------------------------------------------
emu7_code_54:	mov	reg_d,r1
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x55		LD	D,IxL
;------------------------------------------------------------------------------
emu7_code_55:	mov	reg_d,r0
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x56		LD	D,(Ix+d)
;------------------------------------------------------------------------------
emu7_code_56:	getpcbyte r17
		getidbyte reg_d,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x5c		LD	E,IxH
;------------------------------------------------------------------------------
emu7_code_5c:	mov	reg_e,r1
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x5d		LD	E,IxL
;------------------------------------------------------------------------------
emu7_code_5d:	mov	reg_e,r0
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x5e		LD	E,(Ix+d)
;------------------------------------------------------------------------------
emu7_code_5e:	getpcbyte r17
		getidbyte reg_e,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x60		LD	IxH,B
;------------------------------------------------------------------------------
emu7_code_60:	mov	r1,reg_b
		rjmp	emu7_loop		;goto loop

;------------------------------------------------------------------------------
; 0x61		LD	IxH,C
;------------------------------------------------------------------------------
emu7_code_61:	mov	r1,reg_c
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x62		LD	IxH,D
;------------------------------------------------------------------------------
emu7_code_62:	mov	r1,reg_d
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x63		LD	IxH,E
;------------------------------------------------------------------------------
emu7_code_63:	mov	r1,reg_e
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x64		LD	IxH,IxH
;------------------------------------------------------------------------------
emu7_code_64:	rjmp	emu7_loop		;goto loop

;------------------------------------------------------------------------------
; 0x65		LD	IxH,IxL
;------------------------------------------------------------------------------
emu7_code_65:	mov	r1,r0
		rjmp	emu7_loop		;goto loop

;------------------------------------------------------------------------------
; 0x66		LD	H,(Ix+d)
;------------------------------------------------------------------------------
emu7_code_66:	getpcbyte r17
		getidbyte reg_h,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x67		LD	IxH,A
;------------------------------------------------------------------------------
emu7_code_67:	mov	r1,reg_a
		rjmp	emu7_loop		;goto loop

;------------------------------------------------------------------------------
; 0x68		LD	IxL,B
;------------------------------------------------------------------------------
emu7_code_68:	mov	r0,reg_b
		rjmp	emu7_loop		;goto loop

;------------------------------------------------------------------------------
; 0x69		LD	IxL,C
;------------------------------------------------------------------------------
emu7_code_69:	mov	r0,reg_c
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x6a		LD	IxL,D
;------------------------------------------------------------------------------
emu7_code_6a:	mov	r0,reg_d
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x6b		LD	IxL,E
;------------------------------------------------------------------------------
emu7_code_6b:	mov	r0,reg_e
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x6c		LD	IxL,IxH
;------------------------------------------------------------------------------
emu7_code_6c:	mov	r0,r1
		rjmp	emu7_loop		;goto loop

;------------------------------------------------------------------------------
; 0x6d		LD	IxL,IxL
;------------------------------------------------------------------------------
emu7_code_6d:	rjmp	emu7_loop		;goto loop

;------------------------------------------------------------------------------
; 0x6e		LD	L,(Ix+d)
;------------------------------------------------------------------------------
emu7_code_6e:	getpcbyte r17
		getidbyte reg_l,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x6f		LD	IxL,A
;------------------------------------------------------------------------------
emu7_code_6f:	mov	r0,reg_a
		rjmp	emu7_loop		;goto loop

;------------------------------------------------------------------------------
; 0x70		LD	(Ix+d),B
;------------------------------------------------------------------------------
emu7_code_70:	getpcbyte r17
		putidbyte reg_b,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x71		LD	(Ix+d),C
;------------------------------------------------------------------------------
emu7_code_71:	getpcbyte r17
		putidbyte reg_c,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x72		LD	(Ix+d),D
;------------------------------------------------------------------------------
emu7_code_72:	getpcbyte r17
		putidbyte reg_d,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x73		LD	(Ix+d),E
;------------------------------------------------------------------------------
emu7_code_73:	getpcbyte r17
		putidbyte reg_e,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x74		LD	(Ix+d),H
;------------------------------------------------------------------------------
emu7_code_74:	getpcbyte r17
		putidbyte reg_h,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x75		LD	(Ix+d),L
;------------------------------------------------------------------------------
emu7_code_75:	getpcbyte r17
		putidbyte reg_l,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x77		LD	(Ix+d),A
;------------------------------------------------------------------------------
emu7_code_77:	getpcbyte r17
		putidbyte reg_a,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x7c		LD	A,IxH
;------------------------------------------------------------------------------
emu7_code_7c:	mov	reg_a,r1
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x7d		LD	A,IxL
;------------------------------------------------------------------------------
emu7_code_7d:	mov	reg_a,r0
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x7e		LD	A,(Ix+d)
;------------------------------------------------------------------------------
emu7_code_7e:	getpcbyte r17
		getidbyte reg_a,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x84		ADD	IxH
;------------------------------------------------------------------------------
emu7_code_84:	reg_add	r1
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x85		ADD	IxL
;------------------------------------------------------------------------------
emu7_code_85:	reg_add	r0
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x86		ADD	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_86:	getpcbyte r17
		getidbyte r16,r17
		reg_add	r16
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x8c		ADC	IxH
;------------------------------------------------------------------------------
emu7_code_8c:	reg_adc	r1
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x8d		ADC	IxL
;------------------------------------------------------------------------------
emu7_code_8d:	reg_adc	r0
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x8e		ADC	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_8e:	getpcbyte r17
		getidbyte r16,r17
		reg_adc	r16
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x94		SUB	IxH
;------------------------------------------------------------------------------
emu7_code_94:	reg_sub	r1
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0x95		SUB	IxL
;------------------------------------------------------------------------------
emu7_code_95:	reg_sub	r0
		jmp	emu_loops		;2 goto loop

;------------------------------------------------------------------------------
; 0x96		SUB	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_96:	getpcbyte r17
		getidbyte r16,r17
		reg_sub	r16
		jmp	emu_loops		;2 goto loop

;------------------------------------------------------------------------------
; 0x9c		SBC	IxH
;------------------------------------------------------------------------------
emu7_code_9c:	reg_sbc	r1
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0x9d		SBC	IxL
;------------------------------------------------------------------------------
emu7_code_9d:	reg_sbc	r0
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0x9e		SBC	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_9e:	getpcbyte r17
		getidbyte r16,r17
		reg_sbc	r16
		jmp	emu_loops		;2 goto loop

;------------------------------------------------------------------------------
; 0xa4		AND	IxH
;------------------------------------------------------------------------------
emu7_code_a4:	and	reg_a,r1
		jmp	emu_and

;------------------------------------------------------------------------------
; 0xa5		AND	IxL
;------------------------------------------------------------------------------
emu7_code_a5:	and	reg_a,r0
		jmp	emu_and

;------------------------------------------------------------------------------
; 0xa6		AND	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_a6:	getpcbyte r17
		getidbyte r16,r17
		and	reg_a,r16
		jmp	emu_and

;------------------------------------------------------------------------------
; 0xac		XOR	IxH
;------------------------------------------------------------------------------
emu7_code_ac:	eor	reg_a,r1
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xad		XOR	IxL
;------------------------------------------------------------------------------
emu7_code_ad:	eor	reg_a,r0
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xae		XOR	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_ae:	getpcbyte r17
		getidbyte r16,r17
		eor	reg_a,r16
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xb4		OR	IxH
;------------------------------------------------------------------------------
emu7_code_b4:	or	reg_a,r1
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xb5		OR	IxL
;------------------------------------------------------------------------------
emu7_code_b5:	or	reg_a,r0
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xb6		OR	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_b6:	getpcbyte r17
		getidbyte r16,r17
		or	reg_a,r16
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xbc		CMP	IxH
;------------------------------------------------------------------------------
emu7_code_bc:	cp	reg_a,r1		;sub A
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0xbd		CMP	IxL
;------------------------------------------------------------------------------
emu7_code_bd:	cp	reg_a,r0		;sub A
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0xbe		CMP	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_be:	getpcbyte r17
		getidbyte r16,r17
		reg_cmp	r16
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0xcb		Ix bit commands
;------------------------------------------------------------------------------
emu7_code_cb:	jmp	emu8_sel		;goto loop

;------------------------------------------------------------------------------
; 0xdd		IX commands (todo)
;------------------------------------------------------------------------------
emu7_code_dd:	jmp	emu_code_dd		;goto loop

;------------------------------------------------------------------------------
; 0xe1		POP	Ix
;------------------------------------------------------------------------------
emu7_code_e1:	z80_pop		r0,r1
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0xe3		EX (SP),Ix
;------------------------------------------------------------------------------
emu7_code_e3:	movw	XL,SP_L
		movw	YL,r0
		getmemword r0,r1,XL,XH
		putmemword YL,YH,XL,XH
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0xe5		PUSH Ix
;------------------------------------------------------------------------------
emu7_code_e5:	z80_push	r0,r1
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0xe9		JMP Ix
;------------------------------------------------------------------------------
emu7_code_e9:	movw	PC_L,r0
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0xeb		EX 	DE,Ix
;------------------------------------------------------------------------------
emu7_code_eb:	st	Y,reg_e
		std	Y+1,reg_d
		movw	reg_e,r0
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0xed		transport ext (todo)
;------------------------------------------------------------------------------
emu7_code_ed:	rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0xf9		LD	SP,Ix
;------------------------------------------------------------------------------
emu7_code_f9:	movw	SP_L,r0
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0xfd		Ix bit commands
;------------------------------------------------------------------------------
emu7_code_fd:	jmp	emu_code_fd		;goto loop

emu7_loopnc:	z80_clrnflag
emu7_loop:	st	Y,r0
		std	Y+1,r1
emu7_loopnw:	getpcbyte_m1			;12/13
		ijmp				;2


emu7_sel:	getpcbyte ZL			;12/13 cmd
		ldi	ZH,HIGH(emu7_jtab)	;1
		lsl	ZL
		adc	ZH,const_0
		ijmp				;2

