;################################################################################
;#										#
;# fsys - file system library							#
;# copyright (c) 2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU  General Public				#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU  General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
; load snapshot
;------------------------------------------------------------------------------
fsys_load_jace:	sts	fsys_sectnr,const_0	;start with sector 0
		rcall	fsys_rsector

		ldi	YL,LOW(fsys_buffer)
		ldi	YH,HIGH(fsys_buffer)
		ldd	XL,Y+16			;valid flag
		cpi	XL,0xdc
		breq	fsys_rf_ja_0
		ret

fsys_rf_ja_0:	ldi	ZL,LOW(fsys_buf1)
		ldi	ZH,HIGH(fsys_buf1)
		ldi	XH,10
fsys_rf_ja_0a:	ld	XL,Y+
		st	Z+,XL
		dec	XH
		brne	fsys_rf_ja_0a

		ldi	YL,LOW(fsys_buffer+256)
		ldi	YH,HIGH(fsys_buffer+256)
		ld	reg_f,Y+		;get F register (offset 0)
		ld	reg_a,Y+		;get A register (offset 1)
		adiw	YL,2			;skip 2 zero bytes

		ld	reg_c,Y+		;get C register (offset 4)
		ld	reg_b,Y+		;get B register (offset 5)
		adiw	YL,2			;skip 2 zero bytes

		ld	reg_e,Y+		;get E register (offset 8)
		ld	reg_d,Y+		;get D register (offset 9)
		adiw	YL,2			;skip 2 zero bytes

		ld	reg_l,Y+		;get L register (offset 12)
		ld	reg_h,Y+		;get H register (offset 13)
		adiw	YL,2			;skip 2 zero bytes

		ld	XL,Y+			;get IX register (offset 16)
		sts	zreg_ixl,XL
		ld	XL,Y+
		sts	zreg_ixh,XL
		adiw	YL,2			;skip 2 zero bytes

		ld	XL,Y+			;get IY register (offset 20)
		sts	zreg_iyl,XL
		ld	XL,Y+
		sts	zreg_iyh,XL
		adiw	YL,2			;skip 2 zero bytes

		ld	SP_L,Y+			;get SP register (offset 24)
		ld	SP_H,Y+
		adiw	YL,2			;skip 2 zero bytes

		ld	PC_L,Y+			;get PC register (offset 28)
		ld	PC_H,Y+
		adiw	YL,2			;skip 2 zero bytes

		ld	XL,Y+			;get F' register (offset 32)
		sts	zreg_f1,XL
		ld	XL,Y+			;get A' register
		sts	zreg_a1,XL
		adiw	YL,2			;skip 2 zero bytes

		ld	XL,Y+			;get C' register (offset 36)
		sts	zreg_c1,XL
		ld	XL,Y+			;get B' register
		sts	zreg_b1,XL
		adiw	YL,2			;skip 2 zero bytes

		ld	XL,Y+			;get E' register (offset 40)
		sts	zreg_e1,XL
		ld	XL,Y+			;get D' register
		sts	zreg_d1,XL
		adiw	YL,2			;skip 2 zero bytes

		ld	XL,Y+			;get L' register (offset 44)
		sts	zreg_l1,XL
		ld	XL,Y+			;get H' register
		sts	zreg_h1,XL
		adiw	YL,2			;skip 2 zero bytes

		ld	XL,Y+			;get IMode (offset 48)
		sts	z80_imode,XL
		adiw	YL,3			;skip 3 zero bytes

		ld	XL,Y+			;get IFF1 (offset 52)
		andi	XL,0x01
		adiw	YL,3			;skip 3 zero bytes

		ld	XH,Y+			;get IFF1 (offset 56)
		andi	XH,0x01
		lsl	XH
		adiw	YL,3			;skip 3 zero bytes

		or	XL,XH
		sts	z80_iflag,XL

		ld	XL,Y+			;get i register (offset 60)
		sts	zreg_i,XL
		adiw	YL,3			;skip 3 zero bytes

		ld	XL,Y+			;get r register (offset 64)
		sts	zreg_r,XL
		adiw	YL,3			;skip 3 zero bytes

fsys_rf_ja_01:	lds	XL,fsys_sectnr		;next sector
		inc	XL
		sts	fsys_sectnr,XL
		cpi	XL,33			;beyond last
		brne	fsys_rf_ja_02
		jmp	fsys_ll_clow
fsys_rf_ja_02:	rcall	fsys_rsector		;read sector
		lds	ZH,fsys_sectnr
		dec	ZH			;start with 0
		lsl	ZH
		subi	ZH,0xe0
		ldi	ZL,0x00
		ldi	YL,LOW(fsys_buffer)
		ldi	YH,HIGH(fsys_buffer)
		ldi	XH,0
fsys_rf_ja_03:	ld	XL,Y+
		push	ZL
		push	ZH
		movw	r0,ZL
		putmembyte XL,r0,r1
		pop	ZH
		pop	ZL
		adiw	ZL,1
		ld	XL,Y+
		push	ZL
		push	ZH
		movw	r0,ZL
		putmembyte XL,r0,r1
		pop	ZH
		pop	ZL
		adiw	ZL,1
		dec	XH
		brne	fsys_rf_ja_03
		rjmp	fsys_rf_ja_01


;------------------------------------------------------------------------------
; write file
;------------------------------------------------------------------------------
fsys_save_jace:	ldi	YL,LOW(fsys_buffer)
		ldi	YH,HIGH(fsys_buffer)
		ldi	XL,0xff
		ldi	XH,0x00
fsys_wf_ja_0a:	st	Y+,XL
		st	Y+,XL
		dec	XH
		brne	fsys_wf_ja_0a

		subi	YH,2

		ldi	ZL,LOW(fsys_buf1)
		ldi	ZH,HIGH(fsys_buf1)
		ldi	XH,12
fsys_wf_ja_0b:	ld	XL,Z+
		st	Y+,XL
		dec	XH
		brne	fsys_wf_ja_0b

		ldi	XL,0xdc
		sts	fsys_buffer+16,XL	;set as valid

		ldi	YL,LOW(fsys_buffer+256)
		ldi	YH,HIGH(fsys_buffer+256)
		st	Y+,reg_f		;put F register (offset 0)
		st	Y+,reg_a		;put A register
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte

		st	Y+,reg_c		;put C register (offset 4)
		st	Y+,reg_b		;put B register
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte

		st	Y+,reg_e		;put E register (offset 8)
		st	Y+,reg_d		;put D register
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte

		st	Y+,reg_e		;put L register (offset 12)
		st	Y+,reg_d		;put H register
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte

		lds	XL,zreg_ixl		;put IX register (offset 16)
		st	Y+,XL
		lds	XL,zreg_ixh
		st	Y+,XL
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte

		lds	XL,zreg_iyl		;put IY register (offset 20)
		st	Y+,XL
		lds	XL,zreg_iyh
		st	Y+,XL
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte

		st	Y+,SP_L			;put SP register (offset 24)
		st	Y+,SP_H
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte

		st	Y+,PC_L			;put PC register (offset 28)
		st	Y+,PC_H
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte

		lds	XL,zreg_f1		;put AF' register (offset 32)
		lds	XH,zreg_a1
		st	Y+,XL
		st	Y+,XH
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte

		lds	XL,zreg_c1		;put BC' register (offset 36)
		lds	XH,zreg_b1
		st	Y+,XL
		st	Y+,XH
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte

		lds	XL,zreg_e1		;put DE' register (offset 40)
		lds	XH,zreg_d1
		st	Y+,XL
		st	Y+,XH
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte

		lds	XL,zreg_l1		;put HL' register (offset 44)
		lds	XH,zreg_h1
		st	Y+,XL
		st	Y+,XH
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte


		lds	XL,z80_imode		;put IMode (offset 48)
		andi	XL,0x03
		st	Y+,XL
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte

		lds	XL,z80_iflag		;put IFF1 (offset 52)
		andi	XL,0x01
		st	Y+,XL
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte

		lds	XL,z80_iflag		;put IFF2 (offset 56)
		lsr	XL
		andi	XL,0x01
		st	Y+,XL
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte

		lds	XL,zreg_i
		st	Y+,XL			;put i register (offset 60)
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte

		lds	XL,zreg_r
		st	Y+,XL			;put r register (offset 64)
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte

		ldi	XL,0x80
		st	Y+,XL			;not defined value (offset 68)
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte
		st	Y+,const_0		;put dummy byte

		sts	fsys_sectnr,const_0	;start with sector 0
		rcall	fsys_wsector

fsys_wf_ja_01:	lds	XL,fsys_sectnr
		inc	XL
		sts	fsys_sectnr,XL
		cpi	XL,33			;beyond last
		brne	fsys_wf_ja_02
		jmp	fsys_ll_clow
fsys_wf_ja_02:	lds	ZH,fsys_sectnr
		dec	ZH
		lsl	ZH
		subi	ZH,0xe0
		ldi	ZL,0x00
		ldi	YL,LOW(fsys_buffer)
		ldi	YH,HIGH(fsys_buffer)
		ldi	XH,0
fsys_wf_ja_03:	push	ZL
		push	ZH
		movw	r0,ZL
		getmembyte XL,r0,r1
		pop	ZH
		pop	ZL
		st	Y+,XL
		adiw	ZL,1
		push	ZL
		push	ZH
		movw	r0,ZL
		getmembyte XL,r0,r1
		pop	ZH
		pop	ZL
		st	Y+,XL
		adiw	ZL,1
		dec	XH
		brne	fsys_wf_ja_03

		rcall	fsys_wsector		;write sector
		rjmp	fsys_wf_ja_01

