;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# EEPROM/Flash memory interface						#
;# copyright (c) 2006-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################



mem_spm:	in	r16,SPMCSR
		sbrc	r16,0
		rjmp	mem_spm
mem_spm1:	out	SPMCSR,XH
		spm
		ret
mem_spm2:	in	r16,SPMCSR
		sbrc	r16,0
		rjmp	mem_spm2
		ret

mem_waitrww:	in	r16,SPMCSR
		sbrs	r16,6
		ret
		ldi	XH,0x11
		rcall	mem_spm
		rjmp	mem_waitrww

;------------------------------------------------------------------------------
; save a snapshot to Flash
;------------------------------------------------------------------------------
mem_snap:	rcall	mem_save_em		;save emulator data
mem_snap_nos:	cli
		wdr					;watchdog reset
		in	XL,MCUSR
		andi	XL,0xf7
		out	MCUSR,XL
		lds	XL,WDTCSR
		andi	XL,0xe7
		mov	XH,XL
		ori	XL,0x18			;set WDCE + WDE
		ori	XH,0x10			;set only EDCE
		sts	WDTCSR,XL		;disable WDT
		sts	WDTCSR,XH

		in	ZL,RAMPZ
		push	ZL

		ldi	YL,LOW(zx_ram)		;start address RAM
		ldi	YH,HIGH(zx_ram)
		ldi	ZL,LOW(snapshot*2)
		ldi	ZH,HIGH(snapshot*2)

mem_snap_1:	ldi	XH,0x03			;page erase
		rcall	mem_spm
		rcall	mem_waitrww

		ldi	XL,0x80			;no. of words to copy
mem_wpage1:	ld	r0,Y+			;low byte
		ld	r1,Y+			;high byte
		ldi	XH,0x01			;write to buffer
		rcall	mem_spm
		adiw	ZL,2
		dec	XL
		brne	mem_wpage1
		sbiw	ZL,2

		ldi	XH,0x05			;page write
		rcall	mem_spm
mem_wpage2:	rcall	mem_waitrww
		adiw	ZL,2
		cpi	YH,HIGH(fsys_buffer)
		brcs	mem_snap_1
		wdr
		ldi	XL,0x08			;re-enable watchdog
		sts	WDTCSR,XL
		pop	ZL
		out	RAMPZ,ZL
		sei
		rjmp	mem_upload_f

;------------------------------------------------------------------------------
; clear in Flash
;------------------------------------------------------------------------------
mem_csnap:	cli
		wdr					;watchdog reset
		in	XL,MCUSR
		andi	XL,0xf7
		out	MCUSR,XL
		lds	XL,WDTCSR
		andi	XL,0xe7
		mov	XH,XL
		ori	XL,0x18			;set WDCE + WDE
		ori	XH,0x10			;set only EDCE
		sts	WDTCSR,XL		;disable WDT
		sts	WDTCSR,XH

		in	ZL,RAMPZ
		push	ZL

		ldi	ZL,LOW(snapshot*2)
		ldi	ZH,HIGH(snapshot*2)

		ldi	XH,0x03			;page erase
		rcall	mem_spm
		rcall	mem_waitrww

		wdr
		ldi	XL,0x08			;re-enable watchdog
		sts	WDTCSR,XL
		pop	ZL
		out	RAMPZ,ZL
		sei
		rjmp	mem_upload_f


;------------------------------------------------------------------------------
; check snapshot
;------------------------------------------------------------------------------
mem_chksnap:	in	ZL,RAMPZ
		push	ZL
		out	RAMPZ,const_1
		ldi	ZL,LOW(snapshot*2)
		ldi	ZH,HIGH(snapshot*2)
		ldi	XL,0
mem_chksnap_t:	elpm	ZL,Z
		cpi	ZL,0xff
		brne	mem_chksnap_e
		dec	XL
		brne	mem_chksnap_t
mem_chksnap_e:	pop	ZL
		out	RAMPZ,ZL
		ret

;------------------------------------------------------------------------------
; read back snapshot to RAM
;------------------------------------------------------------------------------
mem_rsnap:	in	ZL,RAMPZ
		push	ZL
		out	RAMPZ,const_1

		ldi	ZL,LOW(snapshot*2)
		ldi	ZH,HIGH(snapshot*2)
		ldi	XL,0
mem_rsnap_t:	elpm	ZL,Z
		cpi	ZL,0xff
		brne	mem_rsnap_0
		dec	XL
		brne	mem_rsnap_t
mem_rsnap_e:	pop	ZL
		out	RAMPZ,ZL
		ret
mem_rsnap_0:	ldi	YL,LOW(zx_ram)		;start address RAM
		ldi	YH,HIGH(zx_ram)
		ldi	ZL,LOW(snapshot*2)
		ldi	ZH,HIGH(snapshot*2)
		cli

mem_rsnap_1:	elpm	XL,Z+
		st	Y+,XL
		cpi	YH,HIGH(fsys_buffer)
		brcs	mem_rsnap_1

		ldi	YL,0			;restore emulator state
		ldi	YH,sys_dfile

		ld	PC_L,Y+
		ld	PC_H,Y+

		ld	SP_L,Y+
		ld	SP_H,Y+

		ld	reg_f,Y+
		ld	reg_a,Y+

		ld	reg_c,Y+
		ld	reg_b,Y+
		ld	reg_e,Y+
		ld	reg_d,Y+
		ld	reg_l,Y+
		ld	reg_h,Y+

		ld	XL,Y+
		sts	vsys_mode,XL

		ld	XL,Y+
		in	XH,GPIOR0
		andi	XH,0xf0
		andi	XL,0x0f
		or	XL,XH
		out	GPIOR0,XL

		ld	XL,Y+
		sts	vsys_kpulse,XL

		ld	XL,Y+
		sts	vsys_kwait,XL

		ldi	ZL,LOW(z80emu_ram)
		ldi	ZH,HIGH(z80emu_ram)
		ldi	XH,24
mem_rsnap_2:	ld	XL,Y+
		st	Z+,XL
		dec	XH
		brne	mem_rsnap_2
		sts	vsys_nmi,const_1
		pop	ZL
		out	RAMPZ,ZL
		rjmp	mem_upload_e


;------------------------------------------------------------------------------
; send current snapshot to serial port
;------------------------------------------------------------------------------
mem_upload:	ldi	XL,10
		sts	vsys_wait,XL
		cbi	PORTD,1				;send start break
		sbi	DDRD,1				;activate output
mem_upload_1:	lds	XL,vsys_wait
		cpi	XL,0
		brne	mem_upload_1
		sbi	PORTD,1
		ldi	XL,0x02				;enable U2X
		sts	UCSR0A,XL
		sts	UCSR0B,const_0			;disable
.if clock_freq ==  24
		ldi	XL,52
.endif
.if clock_freq ==  25
		ldi	XL,54
.endif
		sts	UBRR0H,const_0
		sts	UBRR0L,XL
		ldi	XL,0x08				;only TX enabled
		sts	UCSR0B,XL
		ldi	XL,0x06
		sts	UCSR0C,XL

		rcall	mem_save_em			;save emu system data
		ldi	XL,0
		ldi	XH,4
		call	sys_gotoxy
		ldi	ZL,LOW(monitor_utxt*2)
		ldi	ZH,HIGH(monitor_utxt*2)
		call	sys_flashtext

		ldi	YL,LOW(zx_ram)		;start address RAM
		ldi	YH,HIGH(zx_ram)

mem_upload_2:	lds	XL,UCSR0A
		sbrs	XL,5
		rjmp	mem_upload_2
		ld	XL,Y+
		sts	UDR0,XL
		cpi	YH,HIGH(fsys_buffer)
		brcs	mem_upload_2
		ldi	XL,0
		ldi	XH,0
mem_upload_3:	sbiw	XL,1
		brne	mem_upload_3

		cli
		nop
		sts	UCSR0B,const_0			;disable
		sts	UCSR0C,const_0			;disable
		sts	UCSR0A,const_0			;re-configure to KBD
		sts	UBRR0H,const_0
		sts	UBRR0L,const_0
		ldi	XL,0x10				;only RX enabled
		sts	UCSR0B,XL
		ldi	XL,0x66
		sts	UCSR0C,XL
mem_upload_f:	lds	XL,UCSR0A
		sbrs	XL,7
		rjmp	mem_upload_e
		lds	XL,UDR0
		rjmp	mem_upload_f
mem_upload_e:	sei
		sts	vsys_kbdstate,const_0
		sts	vsys_keycode,const_0
		cbi	DDRD,1				;set pin back to input
		jmp	fsys_sc_init1

;------------------------------------------------------------------------------
; receive snapshot from serial port
;------------------------------------------------------------------------------
mem_recv:	sbis	PIND,2				;wait for signal release
		rjmp	mem_recv

		cli
		wdr					;watchdog reset
		in	XL,MCUSR
		andi	XL,0xf7
		out	MCUSR,XL
		lds	XL,WDTCSR
		andi	XL,0xe7
		mov	XH,XL
		ori	XL,0x18			;set WDCE + WDE
		ori	XH,0x10			;set only EDCE
		sts	WDTCSR,XL		;disable WDT
		sts	WDTCSR,XH

		ldi	XL,0x02
		sts	UCSR1A,XL			;enable U2X
		sts	UCSR1B,const_0			;disable
.if clock_freq ==  24
		ldi	XL,52
.endif
.if clock_freq ==  25
		ldi	XL,54
.endif
		sts	UBRR1H,const_0
		sts	UBRR1L,XL
		ldi	XL,0x10				;only RX enabled
		sts	UCSR1B,XL
		ldi	XL,0x06
		sts	UCSR1C,XL

		out	DDRA,const_0			;
.if USE_IOB == 1
		out	DDRB,const_0
.endif

		ldi	YL,LOW(zx_ram)		;start address RAM
		ldi	YH,HIGH(zx_ram)

mem_recv_2:	lds	XL,UCSR1A
		sbrs	XL,RXC1
		rjmp	mem_recv_2
		lds	XL,UDR1
		st	Y+,XL
		cpi	YH,HIGH(fsys_buffer)
		brcs	mem_recv_2

		wdr
		ldi	XL,0x08			;re-enable watchdog
		sts	WDTCSR,XL
		wdr

		rcall	mem_snap_nos			;save snapshot to Flash
		rcall	mem_rsnap
		cbi	PORTB,llist_flag
		cbi	PORTB,break_flag
		cbi	PORTB,go_flag
		jmp	vsys_t2i

wx:		cli					;disable INT
		rjmp	wx				;let watchdog restart the system


;------------------------------------------------------------------------------
; save system data to first 256 bytes of dfile
;------------------------------------------------------------------------------
mem_save_em:	ldi	YL,0			;save emulator state
		ldi	YH,sys_dfile

		ldi	XL,0
mem_save_em_1:	st	Y+,const_0
		dec	XL
		brne	mem_save_em_1
		dec	YH

		st	Y+,PC_L
		st	Y+,PC_H

		st	Y+,SP_L
		st	Y+,SP_H

		st	Y+,reg_f
		st	Y+,reg_a

		st	Y+,reg_c
		st	Y+,reg_b
		st	Y+,reg_e
		st	Y+,reg_d
		st	Y+,reg_l
		st	Y+,reg_h

		lds	XL,vsys_mode
		st	Y+,XL

		in	XL,GPIOR0
		st	Y+,XL

		lds	XL,vsys_kpulse
		st	Y+,XL

		lds	XL,vsys_kwait
		st	Y+,XL

		ldi	ZL,LOW(z80emu_ram)
		ldi	ZH,HIGH(z80emu_ram)
		ldi	XH,24
mem_svem_0:	ld	XL,Z+
		st	Y+,XL
		dec	XH
		brne	mem_svem_0
		ret
