
;-----------------------------------------------------------------------------------
; clear system screen
; R19=char
;-----------------------------------------------------------------------------------
sys_clear:	push	XL
		push	XH
		push	YL
		push	YH
		push	ZL
		ldi	YH,sys_dfile		;video mem
		ldi	YL,0
		ldi	XH,24
sys_vclear_1:	ldi	XL,32
sys_vclear_2:	st	Y+,r19
		dec	XL
		brne	sys_vclear_2
		dec	XH
		brne	sys_vclear_1
		pop	ZL
		pop	YH
		pop	YL
		pop	XH
		pop	XL
		ret

;-----------------------------------------------------------------------------------
; set write coords
; XL=X   XH=Y
;-----------------------------------------------------------------------------------
sys_gotoxy:	sts	vsys_xpos,XL
		sts	vsys_ypos,XH
		ret

sys_space:	ldi	r19,0x20

		;write char r19
sys_char:	push	XL
		push	XH
		push	YL
		push	YH
		push	ZL
		push	r19
		lds	XL,vsys_xpos
		lds	XH,vsys_ypos
		cpi	XL,32
		brcs	sys_char_0
		clr	XL
		inc	XH
sys_char_0:	cpi	XH,24
		brcs	sys_char_1
		clr	XH
sys_char_1:	ldi	YL,0
		ldi	YH,sys_dfile
		ldi	ZL,32
		mul	ZL,XH
		add	YL,r0
		adc	YH,r1
		add	YL,XL
		adc	YH,const_0
		andi	r19,0x7f
		lds	ZL,vsys_color
		andi	ZL,0x38
		cpi	ZL,0x10
		brcs	sys_char_2
		ori	r19,0x80		;invert
sys_char_2:	st	Y+,r19
		inc	XL			;next X
		sts	vsys_xpos,XL
		sts	vsys_ypos,XH
		pop	r19
		pop	ZL
		pop	YH
		pop	YL
		pop	XH
		pop	XL
		ret


		;write a bit 6 terminated string from flash to screen
sys_textxy:	rcall	sys_gotoxy
sys_flashtext:	push	XL
		in	XL,RAMPZ
		out	RAMPZ,const_1
sys_ftext_0:	elpm	r19,Z+
		cpi	r19,0x00
		breq	sys_ftext_1
		rcall	sys_char		;write to screen
		rjmp	sys_ftext_0
sys_ftext_1:	out	RAMPZ,XL
		pop	XL
		ret


sys_hexout:	push	r16
		push	r19
		mov	r19,r16
		swap	r19
		andi	r19,0x0f
		subi	r19,0xd0
		cpi	r19,0x3a
		brcs	sys_hexout_1
		subi	r19,0xf9
sys_hexout_1:	rcall	sys_char
		mov	r19,r16
		andi	r19,0x0f
		subi	r19,0xd0
		cpi	r19,0x3a
		brcs	sys_hexout_2
		subi	r19,0xf9
sys_hexout_2:	rcall	sys_char
		pop	r19
		pop	r16
		ret


;-----------------------------------------------------------------------------------
; calc crc
;-----------------------------------------------------------------------------------
sys_check:	ldi	ZL,0
		ldi	ZH,0
		ldi	r16,0x00
		ldi	r17,0x00
		ldi	r18,0x00
		ldi	r19,0x00
		in	YH,RAMPZ
		out	RAMPZ,const_1

sys_check_01:	lpm	XL,Z
		rcall	sys_crcbyte
		adiw	ZL,1
		brcc	sys_check_01
sys_check_02:	elpm	XL,Z
		rcall	sys_crcbyte
		adiw	ZL,1
		cpi	ZH,0xff
		breq	sys_check_04
sys_check_03:	cpi	ZH,0x40			;skip snapshot area
		brne	sys_check_02
		ldi	ZH,0x80
		rjmp	sys_check_02
sys_check_04:	cpi	ZL,0xfc
		brne	sys_check_03
		ldi	ZL,0xfc
		ldi	ZH,0xff
		elpm	XL,Z+
		cp	XL,r16
		brne	sys_check_err
		elpm	XL,Z+
		cp	XL,r17
		brne	sys_check_err
		elpm	XL,Z+
		cp	XL,r18
		brne	sys_check_err
		elpm	XL,Z+
		cp	XL,r19
		brne	sys_check_err
		clt
		out	RAMPZ,YH
		ret

sys_check_err:	sts	fsys_sectnr0,r19
		sts	fsys_sectnr1,r18
		sts	fsys_sectnr2,r17
		sts	fsys_sectnr3,r16
		out	RAMPZ,YH
		set
		ret



sys_crcbyte:	eor	r19,XL
		ldi	YL,8
sys_crcb_01:	lsl	r16
		rol	r17
		rol	r18
		rol	r19
		brcs	sys_crcb_02
		ldi	XL,0x04
		eor	r19,XL
		ldi	XL,0xc1
		eor	r18,XL
		ldi	XL,0x1d
		eor	r17,XL
		ldi	XL,0xb7
		eor	r16,XL
sys_crcb_02:	dec	YL
		brne	sys_crcb_01
		ret