//###############################################################################
//#										#
//# UPROG2 universal programmer							#
//#										#
//# copyright (c) 2010-2016 Joerg Wolfram (joerg@jcwolfram.de)			#
//#										#
//#										#
//# This program is free software; you can redistribute it and/or		#
//# modify it under the terms of the GNU General Public License			#
//# as published by the Free Software Foundation; either version 3		#
//# of the License, or (at your option) any later version.			#
//#										#
//# This program is distributed in the hope that it will be useful,		#
//# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
//# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
//# General Public License for more details.					#
//#										#
//# You should have received a copy of the GNU General Public			#
//# License along with this library// if not, write to the			#
//# Free Software Foundation, Inc., 59 Temple Place - Suite 330,		#
//# Boston, MA 02111-1307, USA.							#
//#										#
//###############################################################################

#define _GNU_SOURCE
#include<netinet/in.h>
#include<sys/socket.h>
#include<sys/stat.h>
#include<sys/types.h>
#include<unistd.h>
#include<fcntl.h>
#include<poll.h>
#include<ncurses.h>

#include<stdio.h>
#include<string.h>
#include<stdlib.h>
#include<termios.h>
#include<unistd.h>
#include<fcntl.h>
#include<sys/ipc.h>
#include<sys/shm.h>

#include <main.h>
#include <algorithm.h>

extern devicedat valid_devices[1000];

extern void daemon_task(void);

int webserver(void)
{
	int ii,jj,kk;
	int errcode;
	int create_socket, comm_socket,flags,i;
	socklen_t addrlen;
	long bufsize = 1024*4096;
	web_buffer = malloc(bufsize);
	struct sockaddr_in address;
	struct pollfd pfd,pkb;
	int end_server = 0;
	long bidx,bptr,ll;
	char pdevice[20];
	char pcmd[80];
	int vdd=0;
	size_t sock_rdata;
	is_error=0;
	servermode=1;

	printf("Starting server at port 48512...\n"); 

	if ((create_socket = socket(AF_INET, SOCK_STREAM, 0)) > 0)
	{
		   printf("The socket was created\n");
	}

	address.sin_family = AF_INET;
	address.sin_addr.s_addr = INADDR_ANY;
	address.sin_port = htons(48512);		//this our server port

	if (bind(create_socket, (struct sockaddr *) &address, sizeof(address)) == 0)
	{
		   printf("Binding Socket\n");
	}
	else
	{
		   printf("Binding Socket failed\n");
		   exit(1);	
	}


	while(end_server==0)
	{
		errcode=0;
		hold_vdd=0;

		for(ll=0;ll<bufsize;ll++)
		{
			web_buffer[ll]=0;
		}

		if (listen(create_socket, 10) < 0)
		{
			perror("server: listen");
			exit(1);
		}

		printf("listen...\n");

		flags=fcntl(create_socket,F_GETFL,0);
//		flags |= O_NONBLOCK;
		fcntl(create_socket,F_SETFL,flags);

		pfd.fd=create_socket;
		pfd.events=POLLIN;

		pkb.fd=0;		//stdin
		pkb.events=POLLIN;

		printf("Press Enter to exit server mode...\n");

		do
		{
			i=poll(&pkb,1,100);
			if(i > 0)
			{
				end_server=1;
				close(create_socket);
				free(web_buffer);
				printf("Exiting server...\n");
				return 0;
			}
		
			i=poll(&pfd,1,100);
//			printf("POLL\n");
		}while(i==0);


		if ((comm_socket = accept(create_socket, (struct sockaddr *) &address, &addrlen)) < 0)
		{
			perror("server: accept");
			exit(1);
		}

		printf("comm_sock=%d\n",comm_socket);

		if (comm_socket > 0)
		{
			printf("The Client is connected...\n");
		}	

		sock_rdata=recv(comm_socket, web_buffer, bufsize, 0);
		
		printf("%s\n",web_buffer);

		max_post_data=strlen(web_buffer);
		printf("BLEN=%ld\n",max_post_data);
		bptr=0;
	
		for(bidx=0;bidx<(max_post_data-4);bidx++)
		{
			if ((web_buffer[bidx] == 'd') 
			&& (web_buffer[bidx+1] == 'e')
			&& (web_buffer[bidx+2] == 'v') 
			&&(web_buffer[bidx+3] == '=')) bptr=bidx;
		}
	
		pdevice[0]=0;
		ii=0;jj=0;kk=0;
	
		for(bidx=bptr+4;bidx<(bptr+23);bidx++)
		{
			if((web_buffer[bidx] != '&') && (jj == 0))
			{
				pdevice[ii]=web_buffer[bidx];
				pdevice[ii+1]=0;
				ii++;	
			}
			else
			{
				if(jj==0) kk=bidx;
				jj=bidx;
			}
	
		}
	
		bptr=kk+5;
		
		pcmd[0]=0;
		ii=0;jj=0;
	
		for(bidx=bptr;bidx<(bptr+19);bidx++)
		{
			if((web_buffer[bidx] != '&') && (jj == 0))
			{
				pcmd[ii]=web_buffer[bidx];
				pcmd[ii+1]=0;
				ii++;	
			}
			else
			{
				if(jj==0) kk=bidx;			
				jj=bidx;
			}
	
		}
	
		post_data_start=kk+7;
		
		vdd=3;
		if(strstr(pcmd,"5v")) vdd=5;
			
		printf("DEV=%s\n",pdevice);
		printf("CMD=%s\n",pcmd);				
//		printf("%s\n",web_buffer+post_data_start);		
		
		strncpy(cmd,pcmd,78);

		if(cmd[0] == 45) cmd_found=1;
		file_found=2;

		//now search for a valid device
		jj=0;
		dev_found=0;
		do
		{
			if(strncmp(pdevice,valid_devices[jj].name,20) == 0)
			{
				dev_found = 1;
				algo_nr=valid_devices[jj].algo;
				strncpy(name,valid_devices[jj].name,20);
				for(ii=0;ii<19;ii++)
				{
					param[ii]=valid_devices[jj].par[ii];
//					printf("P %2d = %08lx\n",ii,param[ii]);
				}
			}
			jj++;
		}while(strncmp("END",valid_devices[jj].name,20) != 0);
	
		if(dev_found == 0)
		{
			printf("no supported model found\n\n");
			errcode= 1;
		}

		if(cmd_found == 0)
		{
			printf("no command selected\n\n");
			errcode= 2;
		}

		errcode=read_info();
		if(errcode == 0) read_volt();
		if(errcode == 0) check_update();

		if(errcode == 0)
		{
			switch (algo_nr)
			{
				case 1:		errcode=prog_s08();		break;
				case 2:		errcode=prog_r8c();		break;
				case 3:		errcode=prog_avr();		break;
				case 4:		errcode=prog_msp430a();		break;
				case 5:		errcode=prog_msp430b();		break;
				case 6:		errcode=prog_s12xe();		break;
				case 7:		errcode=prog_s12xd();		break;
				case 8:		errcode=prog_stm8();		break;
				case 9:		errcode=prog_c2000();		break;
				case 10:	errcode=prog_dspic33();		break;
				case 11:	errcode=prog_s12xs();		break;
				case 12:	errcode=prog_nec2();		break;
				case 13:	errcode=prog_rl78();		break;
				case 14:	errcode=prog_pic16a();		break;
				case 15:	errcode=prog_pic16b();		break;
				case 16:	errcode=prog_ppcbam();		break;
				case 17:	errcode=prog_pic18a();		break;
				case 18:	errcode=prog_dspic30();		break;
				case 20:	errcode=prog_st7f();		break;
				case 21:	errcode=prog_i2c();		break;
				case 22:	errcode=prog_spiflash();	break;
				case 23:	errcode=prog_dataflash();	break;
				case 30:	errcode=prog_xc9500();		break;
				case 31:	errcode=prog_cc25xx();		break;
				case 32:	errcode=prog_psoc4();		break;
				case 33:	errcode=prog_stm32swd();	break;	//f0
				case 34:	errcode=prog_stm32swd();	break;	//f1
				case 35:	errcode=prog_stm32swd();	break;	//f2
				case 36:	errcode=prog_stm32swd();	break;	//f3
				case 37:	errcode=prog_stm32swd();	break;	//f4
				case 38:	errcode=prog_pic16a();		break;	//pic12
				case 40:	errcode=prog_atxmega();		break;

				case 98:	errcode=prog_rundev();		break;

				default:	errcode=0xaa;
						set_error("WRONG ALGORITHM",2);
						print_error();
			}
		}
		if((algo_nr < 101) && (errcode != 0x9f) && (hold_vdd != 1))
		{
			prg_comm(0xfa,0,0,0,0,0,0,0,0);	//set back to 3,3V mode
		}

		if(errcode == 0x9f)
		{
			printf("FATAL: CONNECTION TO PROGRAMMER LOST!\n");
			printf("   <<< PLEASE RESET PROGRAMMER >>>\n");
			end_server=1;
		}

		if(errcode == 0)
		{
			if((strstr(cmd,"-s5")) || (strstr(cmd,"-s3"))) 
			{		
				write(comm_socket, "HTTP/1.1 200 OK\n", 16);
				write(comm_socket, "Content-length: 355\n", 20);
				write(comm_socket, "Content-Type: text/html\n\n", 25);
				write(comm_socket, "<html><head><title>UPROG2</title></head>\n", 41);
				write(comm_socket, "<body text=\"black\" link=\"black\" vlink=\"black\" bgcolor=\"#FFFF60\">\n",65);
				write(comm_socket, "<center><h3>\n",13);
				write(comm_socket, "Device is running\n",18);
				write(comm_socket, "<br><br>\n",9);
				write(comm_socket, "<form action=\"http://localhost:48512\" method=\"post\">\n",53);
				write(comm_socket, "<input type=\"hidden\" name=\"dev\" value=\"RUNDEV\">\n",48);	
				write(comm_socket, "<input type=\"hidden\" name=\"cmd\" value=\"-s0\">\n",45);
				write(comm_socket, "<input type=\"submit\" value=\"STOP DEVICE\"><form>\n",48);
				write(comm_socket, "</body></html>\n",15);
				close(comm_socket);		
			}
			else if(strstr(cmd,"-s0"))
			{
				write(comm_socket, "HTTP/1.1 200 OK\n", 16);
				write(comm_socket, "Content-length: 255\n", 20);
				write(comm_socket, "Content-Type: text/html\n\n", 25);
				write(comm_socket, "<html><head><title>UPROG2</title></head>\n", 41);
				write(comm_socket, "<body text=\"black\" link=\"black\" vlink=\"black\" bgcolor=\"#80FF80\">\n",65);
				write(comm_socket, "<center><h3>\n",13);
				write(comm_socket, "Device stopped\n",15);
				write(comm_socket, "<br><br>\n",9);
				write(comm_socket, "<button type=\"button\"",21);
				write(comm_socket, " onclick=\"window.open(\'\',\'_self\',\'\'); window.close();\"> CLOSE TAB </button>\n",76);		
				write(comm_socket, "</body></html>\n",15);
				close(comm_socket);		
			}
			else
			{
				write(comm_socket, "HTTP/1.1 200 OK\n", 16);
				write(comm_socket, "Content-length: 460\n", 20);
				write(comm_socket, "Content-Type: text/html\n\n", 25);
				write(comm_socket, "<html><head><title>UPROG2</title></head>\n", 41);
				write(comm_socket, "<body text=\"black\" link=\"black\" vlink=\"black\" bgcolor=\"#80FF80\">\n",65);
				write(comm_socket, "<center><h3>\n",13);
				write(comm_socket, "Programming done\n",16);
				write(comm_socket, "<br><br>\n",9);
				write(comm_socket, "<button type=\"button\"",21);
				write(comm_socket, " onclick=\"window.open(\'\',\'_self\',\'\'); window.close();\"> CLOSE TAB </button>\n",76);		
				write(comm_socket, "<br><br>\n",9);
				write(comm_socket, "<form action=\"http://localhost:48512\" method=\"post\">\n",53);
				write(comm_socket, "<input type=\"hidden\" name=\"dev\" value=\"RUNDEV\">\n",48);	
				
				if(vdd==5)
				{
					write(comm_socket, "<input type=\"hidden\" name=\"cmd\" value=\"-s5\">\n",45);
				}
				else
				{
					write(comm_socket, "<input type=\"hidden\" name=\"cmd\" value=\"-s3\">\n",45);
				}
											
				write(comm_socket, "<input type=\"submit\" value=\"START DEVICE\"><form>\n",49);
				write(comm_socket, "</body></html>\n",15);
				close(comm_socket);
			}		
		}
		else
		{
			write(comm_socket, "HTTP/1.1 200 OK\n", 16);
			write(comm_socket, "Content-length: 339\n", 20);
			write(comm_socket, "Content-Type: text/html\n\n", 25);
			write(comm_socket, "<html><head><title>UPROG2</title></head>\n", 41);
			write(comm_socket, "<body text=\"black\" link=\"black\" vlink=\"black\" bgcolor=\"#FF8080\">\n",65);
			write(comm_socket, "<center><h3>\n",13);
			write(comm_socket, error_line,99);
			write(comm_socket, "<br><br>\n",9);
			write(comm_socket, "<button type=\"button\"",21);
			write(comm_socket, " onclick=\"window.open(\'\',\'_self\',\'\'); window.close();\"> CLOSE TAB </button>\n",76);		
			write(comm_socket, "</body></html>\n",15);
			close(comm_socket);		
		}		
	}

	return 0;
}
		
		
