//###############################################################################
//#										#
//#										#
//#										#
//# copyright (c) 2010-2016 Joerg Wolfram (joerg@jcwolfram.de)			#
//#										#
//#										#
//# This program is free software; you can redistribute it and/or		#
//# modify it under the terms of the GNU General Public License			#
//# as published by the Free Software Foundation; either version 3		#
//# of the License, or (at your option) any later version.			#
//#										#
//# This program is distributed in the hope that it will be useful,		#
//# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
//# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
//# General Public License for more details.					#
//#										#
//# You should have received a copy of the GNU General Public			#
//# License along with this library// if not, write to the			#
//# Free Software Foundation, Inc., 59 Temple Place - Suite 330,		#
//# Boston, MA 02111-1307, USA.							#
//#										#
//###############################################################################

#include <main.h>

//------------------------------------------------------------------------------
// write S19 file
//------------------------------------------------------------------------------
int write_s19(long adr1,long len)
{
	int blocks,csum,i,j;
	unsigned int addr;

//	printf("ADDR = %06X\n",adr1);
//	printf("LEN  = %06X\n",len);

	datei = fopen (sfile, "w+");
	addr=adr1;

	if (datei != NULL)
	{
		fprintf(datei,"S00441424335\n");
		blocks=((len)/32);
		if(blocks==0) blocks=1;
		for(i=0;i<blocks;i++)
		{
			csum=0x23;		//byte count
			csum+=((addr >> 8) & 0xff);
			csum+=((addr >> 0) & 0xff);
			fprintf(datei,"S123%04X",addr);
			for(j=0;j<32;j++)
			{
				fprintf(datei,"%02X",memory[addr+j+ROFFSET] & 0xff);
				csum+=memory[addr+j+ROFFSET] & 0xff;
			}
			csum=255-(csum & 255);
			fprintf(datei,"%02X\n",csum);
			addr+=32;
		}
		fclose (datei);
		return 0;
	}
	else
	{
		return 1;
	}
}

//------------------------------------------------------------------------------
// write S28 file
//------------------------------------------------------------------------------
int write_s29(long adr1,long len)
{
	int blocks,csum,i,j;
	unsigned long addr;

	datei = fopen (sfile, "w+");
	addr=adr1;

	if (datei != NULL)
	{
		fprintf(datei,"S00441424335\n");
		blocks=((len)/32);
		if(blocks==0) blocks=1;
		for(i=0;i<blocks;i++)
		{
			csum=0x24;		//byte count
			csum+=((addr >> 16) & 0xff);
			csum+=((addr >> 8) & 0xff);
			csum+=((addr >> 0) & 0xff);
			fprintf(datei,"S224%06lX",addr);
			for(j=0;j<32;j++)
			{
				fprintf(datei,"%02X",memory[addr+j+ROFFSET]);
				csum+=memory[addr+j+ROFFSET];
			}
			csum=255-(csum & 255);
			fprintf(datei,"%02X\n",csum);
			addr+=32;
		}
		fclose (datei);
		return 0;
	}
	else
	{
		return 1;
	}
}


//------------------------------------------------------------------------------
// write S37 file
//------------------------------------------------------------------------------
int write_s39(long adr1,long len)
{
	int blocks,csum,i,j;
	unsigned long addr;

	datei = fopen (sfile, "w+");
	addr=adr1;

	if (datei != NULL)
	{
		fprintf(datei,"S00441424335\n");
		blocks=((len)/32);
		if(blocks==0) blocks=1;
		for(i=0;i<blocks;i++)
		{
			csum=0x25;		//byte count
			csum+=((addr >> 24) & 0xff);
			csum+=((addr >> 16) & 0xff);
			csum+=((addr >> 8) & 0xff);
			csum+=((addr >> 0) & 0xff);
			fprintf(datei,"S325%08lX",addr);
			for(j=0;j<32;j++)
			{
				fprintf(datei,"%02X",memory[addr+j+ROFFSET]);
				csum+=memory[addr+j+ROFFSET];
			}
			csum=255-(csum & 255);
			fprintf(datei,"%02X\n",csum);
			addr+=32;
		}
		fclose (datei);
		return 0;
	}
	else
	{
		return 1;
	}
}


//------------------------------------------------------------------------------
// write intel hex file
//------------------------------------------------------------------------------
int write_ihex(long adr1,long len)
{
//	FILE *datei;
	char line[2000];
	char dbyte[50];
	int blocks,csum,i,j;
	long addr;
	long offset;

	datei = fopen (sfile, "w+");
	addr=adr1;
	offset=-1;

	if (datei != NULL)
	{
		blocks=((len)/32);
		if(blocks==0) blocks=1;
		for(i=0;i<blocks;i++)
		{
			if(((addr >> 16) & 0xffff) != offset)
			{
				csum=4;
				offset=(addr >> 16) & 0xffff;
				fprintf(datei,":02000002");
				csum=csum+(offset & 0xff)+((offset >> 8) & 0xff);
				fprintf(datei,"%04lX",offset & 0xffff);
				csum=256-(csum & 255);
				fprintf(datei,"%02X\n",csum & 0xff);
			}
			csum=0x20+(addr & 0xff)+((addr >> 8) & 0xff);
			fprintf(datei,":20%04lX00",addr & 0xffff);

			for(j=0;j<32;j++)
			{
				fprintf(datei,"%02X",memory[addr+j+ROFFSET+(offset << 16)]);
				strncat(line,dbyte,2);
				csum+=memory[addr+j+ROFFSET+(offset << 16)];
			}
			csum=256-(csum & 255);
			fprintf(datei,"%02X\n",csum & 0xff);
			addr+=32;
		}
		fprintf(datei,":00000001FF\n");
		fclose (datei);
		return 0;
	}
	else
	{
		return 1;
	}
}


//------------------------------------------------------------------------------
// open intel hex file for block writing
//------------------------------------------------------------------------------
int write_ihex_open()
{
	datei = fopen (sfile, "w+");
	if (datei != NULL)
	{
		return 0;
	}
	else
	{
		return 1;
	}
}

//------------------------------------------------------------------------------
// write block to intel hex file
//------------------------------------------------------------------------------
int write_ihex_block(long adr1,long len)
{
//	FILE *datei;
	int blocks,csum,i,j,llen;
	long addr;
	long offset;


	addr=adr1;
	offset=-1;
	llen=16;
	if(len < llen) llen=len;

	if (datei != NULL)
	{
		printf("Block %08lX:%04lX\n",adr1,len);
		blocks=((len)/llen);
		if(blocks==0) blocks=1;
		for(i=0;i<blocks;i++)
		{
			if(((addr >> 16) & 0xffff) != offset)
			{
				csum=4;
				offset=(addr >> 16) & 0xffff;
				fprintf(datei,":02000004");
				csum=csum+(offset & 0xff)+((offset >> 8) & 0xff);
				fprintf(datei,"%04lX",offset & 0xffff);
				csum=256-(csum & 255);
				fprintf(datei,"%02X\n",csum & 0xff);
			}
			csum=llen+(addr & 0xff)+((addr >> 8) & 0xff);
			fprintf(datei,":%02X%04lX00",llen,addr & 0xffff);

			for(j=0;j<llen;j++)
			{
				fprintf(datei,"%02X",memory[addr+j+ROFFSET]);
				csum+=memory[addr+j+ROFFSET];
			}
			csum=256-(csum & 255);
			fprintf(datei,"%02X\n",csum & 0xff);
			addr+=llen;
		}
		printf("Block %08lX:%04lX\n",adr1,len);
		return 0;
	}
	else
	{
		return 1;
	}
}

//------------------------------------------------------------------------------
// close intel hex file
//------------------------------------------------------------------------------
int write_ihex_close()
{
	if (datei != NULL)
	{
		fprintf(datei,":00000001FF\n");
		fclose (datei);
		return 0;
	}
	else
	{
		return 1;
	}
}

//------------------------------------------------------------------------------
// open file for block writing
//------------------------------------------------------------------------------
int writeblock_open()
{
	datei = fopen (sfile, "w+");
	if (datei != NULL)
	{
		if(file_mode == 0)	//srec
		{
			fprintf(datei,"S00441424335\n");
		}
		return 0;

	}
	else
	{
		printf("!!! CANNOT WRITE FILE !!!\n");
		return 1;
	}
}


//------------------------------------------------------------------------------
// close block file
//------------------------------------------------------------------------------
int writeblock_close()
{
	if (datei != NULL)
	{
		if(file_mode == 1)	//ihex
		{
			fprintf(datei,":00000001FF\n");
		}
		fclose (datei);
		return 0;
	}
	else
	{
		return 1;
	}
}

//------------------------------------------------------------------------------
// write block
//------------------------------------------------------------------------------
int writeblock_data(unsigned long start_addr, unsigned long block_len,unsigned long dest_addr)
{
	int csum,j;
	unsigned int llen;
	unsigned long blen=block_len;
	unsigned long daddr=dest_addr;
	unsigned long addr=start_addr;	
	long offset=-1;
	
	if (datei != NULL)
	{
		if(file_mode == 1)	//ihex 
		{
			while(blen > 0)
			{
				//set extended linear address record
				if(((daddr >> 16) & 0xffff) != offset)
				{
					csum=6;
					offset=(daddr >> 16) & 0xffff;		//our new offset
					fprintf(datei,":02000004");
					csum=csum+(offset & 0xff)+((offset >> 8) & 0xff);
					fprintf(datei,"%04lX",offset & 0xffff);
					csum=256-(csum & 255);
					fprintf(datei,"%02X\n",csum & 0xff);
				}
				//write data
				llen=32;
				if(blen < llen) llen=blen;
				
				csum=llen+(daddr & 0xff)+((daddr >> 8) & 0xff);
				fprintf(datei,":%02X%04lX00",llen,daddr & 0xffff);

				for(j=0;j<llen;j++)
				{
					fprintf(datei,"%02X",memory[addr+j+ROFFSET]);
					csum+=memory[addr+j+ROFFSET];
				}
				csum=256-(csum & 255);
				fprintf(datei,"%02X\n",csum & 0xff);
				addr+=llen;
				daddr+=llen;
				blen-=llen;		
			}		
		
		}
		else
		{
			while(blen > 0)
			{
				//write data
				llen=32;
				if(blen < llen) llen=blen;
				
				csum=0x25;		//byte count
				csum+=((daddr >> 24) & 0xff);
				csum+=((daddr >> 16) & 0xff);
				csum+=((daddr >> 8) & 0xff);
				csum+=((daddr >> 0) & 0xff);
				fprintf(datei,"S325%08lX",daddr);
				for(j=0;j<llen;j++)
				{
					fprintf(datei,"%02X",memory[addr+j+ROFFSET]);
					csum+=memory[addr+j+ROFFSET];
				}
				csum=255-(csum & 255);
				fprintf(datei,"%02X\n",csum);
				addr+=llen;
				daddr+=llen;
				blen-=llen;
			}		
		
		
		}

		return 0;	//write OK
	}
	else
	{
		return 1;	//write failed
	}
}

