;################################################################################
;#										#
;# UPROG2 universal programmer for linux					#
;#										#
;# copyright (c) 2012-2016 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 2		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
; fast init
;------------------------------------------------------------------------------
spiflash_init:		call	api_resetptr
			call	spi3_init	
			jmp	main_loop_ok
			
spiflash_exit:		call	spi_exit
			jmp	main_loop_ok


;------------------------------------------------------------------------------
; read memory
; PAR1	=	ADDRL
; PAR2	=	ADDRM
; PAR3	=	ADDRH
; PAR4	=	256bytes-blocks
;------------------------------------------------------------------------------
spiflash_read:		call	api_resetptr
		;	rcall	spiflash_wready

			call	spi_active
			
			ldi	XL,0x03		;READ
			call	spi3_byte
			
			mov	XL,r18		;AH
			call	spi3_byte
			mov	XL,r17		;AM
			call	spi3_byte
			mov	XL,r16		;AL
			call	spi3_byte
						
			ldi	r24,0
			mov	r25,r19		;size
			
spiflash_read_1:	call	spi3_zerobyte
			call	api_buf_bwrite
			sbiw	r24,1
			brne	spiflash_read_1
			
			call	spi_inactive
			jmp	main_loop_ok

;------------------------------------------------------------------------------
; write 
; PAR1	=	ADDRL
; PAR2	=	ADDRM
; PAR3	=	ADDRH
; PAR4	=	256bytes-blocks
;------------------------------------------------------------------------------
spiflash_write:		call	api_resetptr
spiflash_write_1:	rcall	spiflash_wren	;write enable
					
			call	spi_active

			ldi	XL,0x02		;WRITE
			call	spi3_byte
			
			mov	XL,r18		;AH
			call	spi3_byte
			mov	XL,r17		;AM
			call	spi3_byte
			mov	XL,r16		;AL
			call	spi3_byte

			ldi	r24,0		;256 bytes
			
spiflash_write_2:	call	api_buf_bread
			call	spi3_byte
			dec	r24
			brne	spiflash_write_2

			call	spi_inactive
			
			rcall	spiflash_wready3	
			dec	r19
			brne	spiflash_write_1
			jmp	main_loop_ok
			
;------------------------------------------------------------------------------
; bulk erase
; PAR3/4 timeout in 10ms steps
;------------------------------------------------------------------------------
spiflash_erase_bulk:	rcall	spiflash_wren		;write enable
			rcall	spiflash_wready

			ldi	XL,0xc7
			rcall	spiflash_sbyte
				
spiflash_erase_bulk1:	movw	ZL,r18
			rcall	spiflash_wready2	
			jmp	main_loop_ok

;------------------------------------------------------------------------------
; bulk erase
; PAR4 = bank
;------------------------------------------------------------------------------
spiflash_set_bank:	call	spi_active
			ldi	XL,0x17			;set bank
			call	spi3_byte
			mov	XL,r19			;bank no
			andi	XL,0x7f			;24 bit adressing mode
			call	spi3_byte
			call	spi_inactive
			jmp	main_loop_ok

;------------------------------------------------------------------------------
; get status
; PAR1 = num of data
; PAR2 = cmd
;------------------------------------------------------------------------------
spiflash_getstat:	call	api_resetptr
			call	spi_active
			mov	XL,r17			;CMD
			call	spi3_byte
			
spiflash_getstat_1:	call	spi3_zerobyte
			call	api_buf_bwrite
			dec	r16
			brne	spiflash_getstat_1
			
			call	spi_inactive
			jmp	main_loop_ok

;------------------------------------------------------------------------------
; set status
; PAR1 = num of data
; PAR2 = cmd
; PAR3/4 timeout in 10ms steps
;------------------------------------------------------------------------------
spiflash_setstat:	rcall	spiflash_wren		;write enable
			call	spi_active
			mov	XL,r17			;bulk erase cmd
			call	spi3_byte
			
spiflash_setstat_1:	call	api_buf_bread
			call	spi3_byte
			dec	r16
			brne	spiflash_setstat_1
			call	spi_inactive
			
			movw	ZL,r18
			rcall	spiflash_wready2	
			jmp	main_loop_ok


;------------------------------------------------------------------------------
; subroutines
;------------------------------------------------------------------------------
spiflash_wren:		call	spi_active
			ldi	XL,0x06			;WREN cmd
			call	spi3_byte
			jmp	spi_inactive
				

spiflash_wrdis:		call	spi_active
			ldi	XL,0x04			;WRDIS cmd
			call	spi3_byte
			jmp	spi_inactive


			;wait for ready
spiflash_wready:	call	spi_active
			ldi	XL,0x05			;get status
			call	spi3_byte
spiflash_wready_1:	call	spi3_zerobyte
			andi	XL,0x01
			brne	spiflash_wready
			jmp	spi_inactive
								
				
			;wait for ready with timeout
spiflash_wready2:	call	spi_active
			ldi	XL,0x05			;get status
			call	spi3_byte
spiflash_wready2_1:	call	spi3_zerobyte
			andi	XL,0x01
			breq	spiflash_wready2_2
			push	ZL
			push	ZH
			ldi	ZL,10
			ldi	ZH,0
			call	api_wait_ms
			pop	ZH
			pop	ZL
			sbiw	ZL,1
			brne	spiflash_wready2_1
			call	spi_inactive
			pop	r16			;kill stack
			pop	r16
			ldi	r16,0x41		;timeout
			jmp	main_loop
			
spiflash_wready2_2:	jmp	spi_inactive

			;wait for ready with fast timeout
spiflash_wready3:	ldi	ZL,0
			ldi	ZH,0
			call	spi_active
			ldi	XL,0x05			;get status
			call	spi3_byte
spiflash_wready3_1:	call	spi3_zerobyte
			andi	XL,0x01
			breq	spiflash_wready3_2
			sbiw	ZL,1
			brne	spiflash_wready3_1
			call	spi_inactive
			pop	r16			;kill stack
			pop	r16
			ldi	r16,0x41		;timeout
			jmp	main_loop
			
spiflash_wready3_2:	jmp	spi_inactive
			

spiflash_sbyte:		call	spi_active
			call	spi3_byte
			jmp	spi_inactive
